<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/admin/admin_field_web.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/sendrequest/send.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/middlelog/middlelog.php';

class API_DOMAIN_ADMIN
{
    public static function SendDNSSecRequest($domain, $id){
        $actionUrl = "api/";
        $postededata["action"]   = "dns_dnssec";
        $postededata["domainID"] = $id;
        $domain=Punycode::encodeHostName($domain);
        $postededata["domain"]   = $domain;

        $apiOut = SENDAPI::SendToAPI($actionUrl, $postededata);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return $postededata;
    }
    public static function SendDomainlist($domainlist){
        $actionUrl = "api/whois-domain-list/";
        $postededata["domainlist"] =  $domainlist;
        $postededata["action"] =  "getnslist";
        $postededata["domain"] =  "list";
        $apiOut = MAINCDNQUEUE::SendToAPI($actionUrl, $postededata,'');
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);
        return $postededata;
    }
    public static function SendDeleteDNSSecRequest($domain){
        $actionUrl = "api/";
        $postededata["action"] = "dns_delsec";
        $domain=Punycode::encodeHostName($domain);
        $postededata["domain"] = $domain;

        $apiOut = SENDAPI::SendToAPI($actionUrl, $postededata);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return $postededata;
    }
    public static function SendRequestToCloudflare($domain, $domainid, $hash){
        $actionUrl = "api/";
        $postededata["action"] = "cloudflare";
        $postededata["did"] = $domainid;
        $domain=Punycode::encodeHostName($domain);
        $postededata["domain"] =strtolower( $domain );
        $postededata["dtoken"] = $hash;

        $apiOut = SENDAPI::SendToAPI($actionUrl, $postededata);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return $postededata;
    }
    public static function GetNsRecord($domain){
        $actionUrl = "api/site/getns/";
        $domain=Punycode::encodeHostName($domain);
        $postededata["domain"] = strtolower($domain);
        $postededata["action"] = strtolower($domain);
        $apiout=MAINCDNQUEUE::SendToAPI($actionUrl, $postededata,"");
        return $apiout;
    }
    public static function checkDomainAvalibity($domain){
        $actionUrl = "api/site/check-domain/";
        $postededata["domain"] = strtolower(Punycode::encodeHostName($domain));
        $apiout=MAINCDNQUEUE::SendToAPI($actionUrl, $postededata,"");
        return $apiout;
    }
    public static function GetBandwidth($domain, $timerange){
        $actionUrl = "api/timerangetotals/";
        $postededata["domainlist"] = strtolower(Punycode::encodeHostName($domain));
        $postededata["domain"] = strtolower(Punycode::encodeHostName($domain));
        $postededata["timerange"] =  $timerange;
        $postededata["action"] = strtolower(Punycode::encodeHostName($domain));
        $apiout=MAINCDNQUEUE::SendLOGAPI($actionUrl, $postededata,"");
        return $apiout;
    }
    public static function SENDToAPIDig($domain, $domainid){
        $actionUrl = "api/site/getrecords/";
        $postededata["action"] = "dig";
        $postededata["domainID"] = $domainid;
        $domain=Punycode::encodeHostName($domain);
        $postededata["domain"] =  strtolower($domain);

        MAINCDNQUEUE::SendToAPI($actionUrl, $postededata,"");
        return $postededata;
    }
    public static function RunAddAPI1($domain){
        // DOMAINNSRECORD_ADMIN::GenerateDNSFile($domain);
        $actionUrl = "api/";
        $postededata["action"] = "dns_add";
        $domain=Punycode::encodeHostName($domain);
        $postededata["domain"] =  strtolower($domain);
        $postededata["url"] = $GLOBALS["RootFiles"] . "/dnsfiles/" . $domain;
        $apiOut = SENDAPI::SendToAPIUploadFileDomain($actionUrl, $postededata);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return  $postededata;
    }
    public static function RunCheckFile($domain){
        // DOMAINNSRECORD_ADMIN::GenerateDNSFile($domain);
        $actionUrl = "api/site/check-zone/";
        $domain=Punycode::encodeHostName($domain);
        $postededata["domain"] =  strtolower($domain);
        $postededata["url"] = $GLOBALS["RootFiles"] . "/userdns/" . $domain;
        $apiOut = MAINCDNQUEUE::SendToAPIUploadFileDomain($actionUrl, $postededata);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);
        // $apiOut=substr($apiOut, 0, strlen($apiOut) - 2);
        return  $apiOut;
    }
    public static function RunAddClusterDNS1($domain){
        $domain=Punycode::encodeHostName($domain);
        $actionUrl = "api/";
        $postededata["action"] = "dns_distributed";
        $postededata["domain"] = strtolower($domain);
        // $postededata["url"] = $GLOBALS["RootFiles"] . "/dnsfiles/" . $domain.".json";
        // $apiOut = SENDAPI::SendToAPIUploadFileDomain($actionUrl, $postededata);
        // $cljs = json_encode($postededata);
        // str_replace("'", "\'", $cljs);
        if(!file_exists($GLOBALS["RootFiles"] . "/dnsfiles/" . $domain . ".json")){
            return true;
        }
        $p = file_get_contents($GLOBALS["RootFiles"] . "/dnsfiles/" . $domain . ".json");
        $postededata["params"] = $p;
        $apiOut = SENDAPI::SendToAPI($actionUrl, $postededata);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl, $apiOut);

        return  $postededata;
    }
    public static function RunDeleteGeoAPI($domain){
        $actionUrl = "api/";
        $postededata["action"] = "dns_delgeo";
        $postededata["domain"] = strtolower($domain);
        $apiOut = SENDAPI::SendToAPI($actionUrl, $postededata);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl, $apiOut);

        return  $postededata;

    }
    public static function RunAddAPI($domain){
        // DOMAINNSRECORD_ADMIN::GenerateDNSFile($domain);
        // $actionUrl = "api/";
        // $postededata["action"] = "dns_add";
        // $postededata["domain"] = $domain;
        // $postededata["url"] = $GLOBALS["RootFiles"] . "/dnsfiles/" . $domain;
        // $apiOut = SENDAPI::SendToAPIUploadFileDomain($actionUrl, $postededata);
        // $cljs = json_encode($postededata);
        // str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);
        // return  $postededata;
    }
    public static function RunAddClusterDNS($domain){
        // $actionUrl = "api/";
        // $postededata["action"] = "dns_distributed";
        // $postededata["domain"] = $domain;
        // // $postededata["url"] = $GLOBALS["RootFiles"] . "/dnsfiles/" . $domain.".json";
        // // $apiOut = SENDAPI::SendToAPIUploadFileDomain($actionUrl, $postededata);
        // // $cljs = json_encode($postededata);
        // // str_replace("'", "\'", $cljs);
        // $p = file_get_contents($GLOBALS["RootFiles"] . "/dnsfiles/" . $domain . ".json");
        // $postededata["params"] = $p;
        // $apiOut = SENDAPI::SendToAPI($actionUrl, $postededata);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl, $apiOut);
        // return  $postededata;
    }
    public static function RunUpdateAPI($domain){
        $actionUrl = "api/";
        $postededata["action"] = "dns_update";
        $postededata["domain"] = strtolower($domain);
        $postededata["url"] = $GLOBALS["RootFiles"] . "/dnsfiles/" . $domain;
        $apiOut=SENDAPI::SendToAPIUploadFileDomain($actionUrl, $postededata);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);

        return $apiOut;
    }
    public static function RunDeleteDomain($domain){
        $actionUrl = "api/";
        $postededata["action"] = "dns_delete";
        $postededata["domain"] = strtolower($domain);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        $apiOut=SENDAPI::SendToAPI($actionUrl, $postededata);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);
        $actionUrl = "api/";
        $postededata["action"] = "reweb_all";
        $postededata["domain"] = strtolower($domain);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        $apiOut=SENDAPI::SendToAPI($actionUrl, $postededata);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);
        return $apiOut;
    }
    public static function AddRecord($domain,$content){
        $actionUrl="api/";
        $postededata["action"]="dns_recordadd";
        $postededata["domain"]=str_replace("*","starwildcarddomain",Punycode::encodeHostName($domain)  );
        $postededata["record"]=$content;
        $apiOut= SENDAPI::SendCDNAPI($actionUrl,$postededata);
        return $apiOut;
    }
    public static function UpdateRecord($domain,$content,$before){
        $actionUrl="api/";
        $postededata["action"]="dns_recordedit";
        $postededata["domain"]=str_replace("*","starwildcarddomain",Punycode::encodeHostName($domain)  );
        $postededata["record"]=$content;
        $postededata["before"]=$before;
        $apiOut= SENDAPI::SendCDNAPI($actionUrl,$postededata);
        return $apiOut;
    }
    public static function DeleteRecord($domain,$content ){
        $actionUrl="api/";
        $postededata["action"]="dns_recorddelete";
        $postededata["domain"]=str_replace("*","starwildcarddomain",Punycode::encodeHostName($domain)  );
        $postededata["record"]=$content;
        $apiOut= SENDAPI::SendCDNAPI($actionUrl,$postededata);
        return $apiOut;
    }
    public static function CreateZone($domain,$content){
        $actionUrl="api/";
        $postededata["action"]="dns_createzone";
        $postededata["domain"]=str_replace("*","starwildcarddomain",Punycode::encodeHostName($domain)  );
        $postededata["record"]=$content;
        $apiOut= SENDAPI::SendCDNAPI($actionUrl,$postededata);
        return $apiOut;
    }
    public static function DigLookup($domain){
        $actionUrl="api/site/nslookup/";
        $postededata["domain"]=str_replace("*","starwildcarddomain",Punycode::encodeHostName($domain));
        $apiOut= MAINCDNQUEUE::SendCDNAPI($actionUrl,$postededata,"");
        return $apiOut;
    }
}
