<?php

namespace Themento\Admin;

use Themento\Admin\Config_Setting;
use Themento\Admin\Admin_Helper;
use Themento\Admin\Main_Settings;
use Themento\Admin\FlashMessage;

class Menu_Settings extends Main_Settings {

    private $config_setting;
    private $admin_helper;
    private $main_setting;

    public function __construct() {
        $this->config_setting = new Config_Setting;
        $this->admin_helper = new Admin_Helper;
        $this->main_setting = new Main_Settings;
    }

    public function Main_options() {
        $this->Save_Change();
        ?>
            <div class="tmt-main-option-theme flex justify-content-between">
                <aside class="tmt-main-sidebar-options">
                    <div class="logo">
                        <svg version="1.0" xmlns="http://www.w3.org/2000/svg" width="398" height="105" viewBox="0 0 398 105"><g transform="translate(0.000000,105.000000) scale(0.100000,-0.100000)" stroke="none">
                            <path d="M721 1038 c-35 -18 -61 -82 -50 -122 17 -63 87 -94 142 -65 27 15 56 50 57 69 0 8 9 1 19 -16 43 -70 112 -85 161 -35 36 35 46 73 30 110 -17 42 -43 62 -87 68 -44 6 -88 -22 -104 -65 l-10 -26 -18 30 c-10 16 -25 35 -33 42 -23 19 -79 24 -107 10z M1390 1021 c-16 -16 -32 -40 -36 -55 -14 -57 41 -126 100 -126 41 0 71 22 95 68 19 36 19 38 0 74 -38 74 -108 91 -159 39z M2532 1025 c-45 -38 -55 -75 -31 -123 43 -86 152 -82 189 8 l13 32 12 -30 c17 -38 61 -72 96 -72 36 0 95 51 102 88 22 116 -148 170 -193 62 -16 -38 -22 -37 -38 0 -15 34 -57 60 -96 60 -13 0 -38 -11 -54 -25z M3430 1039 c-252 -42 -434 -294 -392 -541 41 -235 263 -422 485 -406 l42 3 5 310 c5 309 5 311 31 360 36 70 97 107 191 114 l71 6 -40 36 c-105 95 -258 140 -393 118z m-55 -204 c-19 -25 -37 -62 -40 -83 -4 -20 -8 -42 -10 -49 -6 -18 -40 -4 -85 34 -42 36 -62 68 -74 116 l-6 27 125 0 125 0 -35 -45z m244 22 c-43 -29 -77 -79 -91 -134 l-10 -43 -69 0 -69 0 0 32 c0 43 35 112 72 143 27 22 38 25 115 25 l86 0 -34 -23z M2017 909 c-59 -14 -128 -53 -172 -97 -22 -23 -92 -131 -155 -241 -102 -178 -133 -222 -147 -207 -2 2 6 32 18 67 40 120 13 264 -68 358 l-29 34 -46 -82 c-46 -80 -46 -82 -32 -116 38 -92 1 -194 -89 -241 -27 -14 -217 -26 -217 -14 0 3 9 30 21 60 33 85 30 181 -8 261 -16 35 -42 79 -58 97 l-28 34 -48 -82 c-44 -77 -46 -83 -33 -108 20 -38 17 -119 -5 -169 -26 -57 -93 -96 -163 -94 -28 0 -52 2 -54 4 -2 2 4 25 12 52 56 184 -49 390 -231 451 -70 24 -175 22 -247 -5 -63 -24 -147 -94 -184 -153 -59 -94 -67 -231 -20 -335 26 -56 119 -163 143 -163 7 0 52 26 99 57 l85 57 -48 18 c-144 54 -181 218 -70 315 71 62 160 67 236 13 48 -35 68 -71 74 -130 6 -57 -8 -104 -41 -140 -15 -16 -108 -84 -207 -151 -184 -125 -225 -156 -225 -171 0 -4 62 -8 139 -8 l139 0 88 60 89 59 80 -10 c109 -14 210 -6 277 24 54 24 55 24 81 5 33 -24 116 -36 227 -34 66 2 100 8 150 29 58 24 66 25 81 11 43 -39 160 -49 217 -20 43 23 63 50 182 256 62 107 122 205 134 218 50 55 150 71 222 36 149 -74 129 -288 -32 -341 -88 -30 -214 35 -231 119 -3 16 -9 28 -13 28 -5 0 -21 -24 -38 -52 -16 -29 -39 -70 -51 -90 l-22 -37 42 -45 c103 -113 277 -144 423 -76 l45 22 29 -22 c40 -30 91 -39 202 -37 86 2 102 5 162 35 178 87 259 297 184 476 -20 48 -77 127 -87 121 -4 -3 -26 -38 -49 -77 -41 -71 -41 -74 -29 -112 17 -51 15 -125 -4 -162 -35 -68 -110 -103 -219 -104 -43 0 -78 1 -78 3 0 1 10 27 22 57 30 77 30 185 -1 262 -25 63 -94 147 -153 184 -73 46 -183 64 -271 43z M3823 670 c-47 -19 -53 -53 -53 -280 0 -115 4 -210 9 -210 18 0 112 108 142 163 41 77 59 146 59 227 0 107 -2 110 -74 109 -33 0 -71 -4 -83 -9z"/></g>
                        </svg>
                    </div>
                    <ul class="tmt-main-menu">
                        <li id="elementor-element" class="tmt-menu-item active flex align-items-center">
                            <svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><path d="M 5 5 L 5 27 L 27 27 L 27 5 L 5 5 z M 7 7 L 25 7 L 25 25 L 7 25 L 7 7 z M 11 11 L 11 21 L 13 21 L 13 11 L 11 11 z M 15 11 L 15 13 L 21 13 L 21 11 L 15 11 z M 15 15 L 15 17 L 21 17 L 21 15 L 15 15 z M 15 19 L 15 21 L 21 21 L 21 19 L 15 19 z"/></svg><?php _e('Elementor Element', text_domain) ?>
                        </li>
                        <li id="theme-config" class="tmt-menu-item flex align-items-center">
                            <svg width="24px" height="24px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><rect x="0" fill="none" width="24" height="24"/><g><path d="M4 6c-1.105 0-2 .895-2 2v12c0 1.1.9 2 2 2h12c1.105 0 2-.895 2-2H4V6zm16-4H8c-1.105 0-2 .895-2 2v12c0 1.105.895 2 2 2h12c1.105 0 2-.895 2-2V4c0-1.105-.895-2-2-2zm-5 14H8V9h7v7zm5 0h-3V9h3v7zm0-9H8V4h12v3z"/></g></svg><?php _e('Theme Config', text_domain) ?>
                        </li>
                        <li id="post-type" class="tmt-menu-item flex align-items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"width="512px" height="512px" viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve"><path d="M447.146,8.772H214.992c-30.919,0-56.071,25.151-56.071,56.071v58.297h87.314V58.299h200.911 c3.614,0,6.545,2.936,6.545,6.545v232.155c0,3.613-2.931,6.545-6.545,6.545h-58.293v49.525h58.293 c30.926,0,56.072-25.147,56.072-56.07V64.844C503.219,33.924,478.072,8.772,447.146,8.772z M299.762,156.158H67.625c-30.924,0-56.071,25.151-56.071,56.07v232.156c0,30.923,25.147,56.07,56.071,56.07h232.137 c30.924,0,56.071-25.147,56.071-56.07V212.229C355.833,181.31,330.686,156.158,299.762,156.158z M306.306,444.385 c0,3.612-2.931,6.544-6.544,6.544H98.818V205.685h200.943c3.613,0,6.544,2.936,6.544,6.544V444.385z"/></svg><?php _e('Post Type', text_domain) ?>
                        </li>
                        <li id="main-setting" class="tmt-menu-item flex align-items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 458.317 458.317" style="enable-background:new 0 0 458.317 458.317;" xml:space="preserve"><path d="M446.185,179.159h-64.768c-2.536-7.702-5.636-15.15-9.26-22.29l45.818-45.818c4.737-4.737,4.737-12.416,0-17.152 L364.416,40.34c-4.737-4.737-12.416-4.737-17.152,0l-45.818,45.818c-7.14-3.624-14.587-6.724-22.289-9.26V12.131 c0.001-6.699-5.429-12.129-12.128-12.129h-75.743c-6.698,0-12.129,5.43-12.129,12.128v64.768 c-7.702,2.535-15.149,5.636-22.29,9.26L111.05,40.341c-4.737-4.737-12.416-4.737-17.152,0L40.339,93.9 c-4.737,4.736-4.737,12.416,0,17.152l45.817,45.817c-3.624,7.14-6.725,14.588-9.26,22.29H12.129C5.43,179.159,0,184.59,0,191.288 v75.743c0,6.698,5.43,12.128,12.129,12.128h64.768c2.536,7.702,5.636,15.149,9.26,22.29L40.34,347.266 c-4.737,4.736-4.737,12.416,0,17.152l53.559,53.559c4.737,4.736,12.416,4.736,17.152,0l45.817-45.817 c7.14,3.624,14.587,6.725,22.29,9.26v64.768c0,6.698,5.43,12.128,12.129,12.128h75.743c6.698,0,12.129-5.43,12.129-12.128v-64.768 c7.702-2.535,15.149-5.636,22.289-9.26l45.818,45.817c4.737,4.736,12.416,4.736,17.152,0l53.559-53.559 c4.737-4.737,4.737-12.416,0-17.152l-45.817-45.817c3.624-7.14,6.724-14.587,9.26-22.289h64.768 c6.698,0,12.129-5.43,12.129-12.128v-75.743C458.314,184.59,452.884,179.159,446.185,179.159z M229.157,289.542 c-33.349,0-60.384-27.035-60.384-60.384s27.035-60.384,60.384-60.384s60.384,27.035,60.384,60.384 S262.506,289.542,229.157,289.542z"/></svg><?php _e('Main Setting', text_domain) ?>
                        </li>
                        <li id="login-setting" class="tmt-menu-item flex align-items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 330 330" style="enable-background:new 0 0 330 330;" xml:space="preserve"><path d="M305,149.998H121.215l44.392-44.392c5.858-5.858,5.858-15.355,0-21.213c-5.857-5.858-15.355-5.858-21.213,0l-69.998,69.998 c-5.858,5.857-5.858,15.355,0,21.213l69.998,70.002c2.929,2.929,6.767,4.394,10.606,4.394c3.838-0.001,7.678-1.465,10.606-4.393 c5.857-5.858,5.858-15.355,0-21.213l-44.394-44.396H305c8.284,0,15-6.716,15-15C320,156.714,313.284,149.998,305,149.998z M155,300H40V30h115c8.284,0,15-6.716,15-15s-6.716-15-15-15H25c-8.284,0-15,6.716-15,15v300c0,8.284,6.716,15,15,15h130 c8.284,0,15-6.716,15-15S163.284,300,155,300z"/></svg><?php _e('Login Setting', text_domain) ?>
                        </li>
                        <li id="custom-font-setting" class="tmt-menu-item flex align-items-center">
                            <svg width="512px" height="512px" viewBox="0 0 512 512" xmlns="http://www.w3.org/2000/svg"><path d="M221.631,109,109.92,392h58.055l24.079-61H319.946l24.079,61H402.08L290.369,109ZM213.37,277,256,169l42.63,108Z M16,496H496V16H16ZM48,48H464V464H48Z" /></svg><?php _e('Custom Fonts', text_domain) ?>
                        </li>
                        <li id="custom-code-setting" class="tmt-menu-item flex align-items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="35.033px" height="35.033px" viewBox="0 0 35.033 35.033" style="enable-background:new 0 0 35.033 35.033;" xml:space="preserve"><path d="M11.811,10.535l-6.983,6.984l6.983,6.981c0.78,0.781,0.78,2.048,0,2.828c-0.392,0.392-0.901,0.586-1.414,0.586 c-0.513,0-1.022-0.194-1.414-0.586l-8.397-8.396C0.211,18.558,0,18.049,0,17.519c0-0.529,0.211-1.039,0.586-1.414l8.397-8.398 c0.781-0.78,2.047-0.78,2.828,0C12.591,8.488,12.591,9.752,11.811,10.535z M34.447,16.104l-8.396-8.398 c-0.781-0.78-2.047-0.78-2.828,0c-0.781,0.781-0.781,2.047,0,2.828l6.982,6.984L23.223,24.5c-0.781,0.781-0.781,2.048,0,2.828 c0.392,0.392,0.902,0.586,1.414,0.586s1.023-0.194,1.414-0.586l8.396-8.396c0.375-0.375,0.586-0.884,0.586-1.414 C35.033,16.99,34.822,16.479,34.447,16.104z M21.012,3.831c-1.076-0.277-2.161,0.373-2.435,1.441l-6,23.498 c-0.272,1.07,0.373,2.16,1.442,2.434c0.167,0.043,0.334,0.063,0.497,0.063c0.894,0,1.706-0.603,1.937-1.505l6-23.498 C22.727,5.193,22.081,4.104,21.012,3.831z"/></svg><?php _e('Custom Code', text_domain) ?>
                        </li>
                    </ul>
                </aside>
                <main class="tmt-main-content-options">
                    <?php echo FlashMessage::get(); ?>
                    <form action="" method="POST" id="setting-form">
                        <div class="content-tab elementor-element-options">
                            <?php $this->main_setting->Elementor_Elements(); ?>
                        </div>
                        <div class="content-tab theme-config-options">
                            <?php $this->main_setting->Theme_config(); ?>
                        </div>
                        <div class="content-tab post-type-options">
                            <?php $this->main_setting->Post_type(); ?>
                        </div>
                        <div class="content-tab main-setting-options">
                            <?php $this->main_setting->General_Settings(); ?>
                        </div>
                        <div class="content-tab login-setting-options">
                            <?php $this->main_setting->Login_Settings(); ?>
                        </div>
                        <div class="content-tab custom-font-setting-options">
                            <?php $this->main_setting->Custom_Font_Settings(); ?>
                        </div>
                        <div class="content-tab custom-code-setting-options">
                            <?php $this->main_setting->Custom_Code_Settings(); ?>
                        </div>

                        <div class="form-row">
                            <button type="submit" class="button tmt-submit" name="SaveSetting"><?php _e('Save Change', text_domain); ?></button>
                        </div>
                    </form>
                </main>
            </div>
        <?php
    }

    public function Save_Change() {
        if(isset($_POST['SaveSetting'])) {

            $elements = $this->config_setting->Elementor_Elements();
            foreach($elements as $element) {
                $id = $element['id'];
                $tmt_modules_option["$id"] = isset($_POST["$id"]);
            }
            update_option('tmt_active_modules_option', $tmt_modules_option);


            $settings = $this->config_setting->Theme_configs();
            foreach($settings as $setting) {
                $name = $setting['name'];
                $tmt_theme_config_option["$name"] = intval($_POST["$name"]);
            }
            update_option('tmt_theme_config_option', $tmt_theme_config_option);

            $post_types = get_option('tmt_main_option', [] );
            $cpt_name = $post_types['post-type']['slug'];
            $cpt_label = $_POST['cpt-label'];
            $cpt_singular = $_POST['cpt-singular'];
            if(isset($_POST['cpt-change-slug'])) {
                $cpt_new_name = $_POST['cpt-name'];
                $post_type = $this->admin_helper->convert_post_type_posts($cpt_name,$cpt_new_name);
                $cpt_name = $_POST['cpt-name'];
            }
            $tx_cat_name = $post_types['taxonomy']['cat-slug'];
            if(isset($_POST['tx-cat-change-slug'])) {
                $tx_cat_new_name = $_POST['tx-cat-name'];
                $post_type = $this->admin_helper->convert_taxonomy_terms($tx_cat_name,$tx_cat_new_name);
                $tx_cat_name = $_POST['tx-cat-name'];
            }
            $tx_tag_name = $post_types['taxonomy']['tag-slug'];
            if(isset($_POST['tx-tag-change-slug'])) {
                $tx_tag_new_name = $_POST['tx-tag-name'];
                $post_type = $this->admin_helper->convert_taxonomy_terms($tx_tag_name,$tx_tag_new_name);
                $tx_tag_name = $_POST['tx-tag-name'];
            }
            
            $custom_css = $this->TMT_Code_Validator($_POST['tmt-custom-css']);
            $custom_js = $this->TMT_Code_Validator($_POST['tmt-custom-js']);
            $before_head = $this->TMT_Code_Validator($_POST['tmt-custom-before-head']);
            $before_body = $this->TMT_Code_Validator($_POST['tmt-custom-before-body']);
            $main_options = [
                'login-settings' => [
                    'login-logo'                    => sanitize_url($_POST['login-logo']),
                    'login-bg'                      => sanitize_url($_POST['login-bg']),
                    'login-color-bg'                => sanitize_text_field($_POST['login-color-bg']),
                    'login-color-link'              => sanitize_text_field($_POST['login-color-link']),
                    'login-bg-color-submit'         => sanitize_text_field($_POST['login-bg-color-submit']),
                    'login-color-submit'            => sanitize_text_field($_POST['login-color-submit']),
                    'login-bg-color-submit-hover'   => sanitize_text_field($_POST['login-bg-color-submit-hover']),
                    'login-color-submit-hover'      => sanitize_text_field($_POST['login-color-submit-hover']),
                ],
                'codes-settings' => [
                    'custom-css'            => $custom_css,
                    'custom-js'             => $custom_js,
                    'custom-before-head'    => $before_head,
                    'custom-before-body'    => $before_body,
                ],
                'post-type' => [
                    'slug'              => sanitize_text_field($cpt_name),
                    'name'              => sanitize_text_field($cpt_label),
                    'singular'          => sanitize_text_field($cpt_singular),
                    'disable-archive'   => isset($_POST['disable-archive']),
                ],
                'taxonomy' => [
                    'cat-slug'  => sanitize_text_field($tx_cat_name),
                    'tag-slug'  => sanitize_text_field($tx_tag_name),
                ],
            ];

            $settings = $this->config_setting->General_Settings();
            foreach($settings as $id => $setting) {
                $type = $setting['type'];
                $value = isset($_POST[$id]) ? $_POST[$id] : false;
                if($value) {
                    $content = $this->TMT_Type_To_Render($value, $type);
                    if($content) {
                        $main_options['general-settings'][$id] = $content;
                    }
                }
            }
            
            $main_options['general-settings']['ltr-font'] = sanitize_text_field($_POST['ltr-font']);

            $fonts = $_POST['fonts'];
            if(!empty($fonts)) {
                foreach($fonts as $custom_font) {
                    $main_options['fonts'][] = [
                        'weight'    => sanitize_text_field($custom_font['weight']),
                        'woff'      => sanitize_url($custom_font['woff']),
                        'woff2'     => sanitize_url($custom_font['woff2']),
                        'ttf'       => sanitize_url($custom_font['ttf']),
                        'svg'       => sanitize_url($custom_font['svg']),
                        'eot'       => sanitize_url($custom_font['eot']),
                    ];
                }
            }

            update_option('tmt_main_option', $main_options);

            do_action('tmt_update_custom_styles');

            $message = __('Settings updated successfully.', text_domain);
            $this->start_session();
            FlashMessage::add($message);
            $this->end_session();
        }
    }

    private function TMT_Type_To_Render($value,$type) {
        switch ($type) {
            case 'text':
            case 'select':
            case 'color':
                $value = sanitize_text_field($value);
                break;
            case 'textarea':
                $value = sanitize_textarea_field($value);
                break;
            case 'select2':
                $value = $value;
            break;
            case 'image-uploader':
            case 'url':
                $value = sanitize_url($value);
                break;
            case 'checkbox':
                $value = isset($value);
                break;
            case 'repeater':
                $value = $value;
                break;
            case 'editor':
                $value = $this->TMT_Code_Validator($value);
                break;
        }

        return $value;
    }

    private function TMT_Code_Validator($code) {
        return str_replace( array('\'', '\"'), '"', $code);
    }

    public function start_session() {
		if(!session_id()) {
			session_start();
		}
	}

	public function end_session() {
		session_write_close();
	}
}
