<?php

namespace Themento\Admin;

use Themento\Fonts\TMT_Fonts;
use Themento\Admin\Config_Setting;
use Themento\Admin\Admin_Helper;

class Main_Settings {

    private $config_setting;
    private $admin_helper;

    public function __construct() {
        $this->config_setting = new Config_Setting;
        $this->admin_helper = new Admin_Helper;
    }

    protected function Elementor_Elements() {
        $modules = get_option( 'tmt_active_modules_option', [] );
        ?>
        <div class="flex flex-wrap">
        <?php
            $elements = $this->config_setting->Elementor_Elements();
            foreach($elements as $element) {
                $id = $element['id'];
                $width = 'w33';
                $title = __('Element', text_domain) . ' ' . $element['label'];
                $class = $element['category'];
                $value = !empty($modules[$id]) ? $modules[$id] : '';
                echo $this->admin_helper->TMT_Checkbox($id, $title, $value, $class, $width);
            }
        ?>
        </div>

        <script type="text/javascript">
            jQuery(document).ready(function ($) {
                $('.elementor-element-options .field-checkbox.general').eq(0).before('<h3><?php _e('General Element', text_domain); ?></h3>');
                $('.elementor-element-options .field-checkbox.shop').eq(0).before('<h3><?php _e('Shop Element', text_domain); ?></h3>');
                $('.elementor-element-options .field-checkbox.single').eq(0).before('<h3><?php _e('Single Element', text_domain); ?></h3>');
            });
        </script>
        <?php
    }

    protected function Theme_config() {
        $theme_config = get_option( 'tmt_theme_config_option', [] );
        $settings = $this->config_setting->Theme_configs();
        foreach($settings as $setting) {
            $id = $setting['name'];
            $selected = $theme_config[$id];
            $width = 'w100';
            $parrent = '';
            $title = sprintf( __( 'Choose a %s Template : ', text_domain ), $setting['label'] );
            $array = $this->admin_helper->TMT_Get_Elementor_Library();
            echo $this->admin_helper->TMT_Select($id, $title, $array, $selected, $parrent, $width);
        }
    }

    public function Post_type() {
        $settings = $this->config_setting->Post_Type();
        foreach($settings as $id => $setting) {
            echo $this->admin_helper->TMT_Type_To_Function($id,$setting);
        }
    }

    protected function General_Settings() {
        echo '<div class="general-settings flex flex-wrap">';
            $settings = $this->config_setting->General_Settings();
            foreach($settings as $id => $setting) {
                echo $this->admin_helper->TMT_Type_To_Function($id,$setting);
            }
        echo '</div>';
    }

    protected function Login_Settings() {
        echo '<div class="general-settings flex flex-wrap">';
            $settings = $this->config_setting->Login_Settings();
            foreach($settings as $id => $setting) {
                echo $this->admin_helper->TMT_Type_To_Function($id,$setting);
            }
        echo '</div>';
    }

    protected function Custom_Font_Settings() {

        $main_option = get_option('tmt_main_option', [] );

        $GFonts = new TMT_Fonts;
        $Google_Fonts = $GFonts->Google_Fonts();
        $GCurrentFont = TMT_Get_Setting('general-settings', 'ltr-font');
        echo "<h3>" . __('Google Font', text_domain) . ' (' . __('LTR', text_domain) . ') ' . "</h3>"
        . "<select name='ltr-font' class='font-item font-item-weight'>";
            foreach($Google_Fonts as $Font) {
                echo "<option ". ($GCurrentFont == $Font ? ' selected' : '') ." value='$Font'>$Font</option>";
            }
        echo "</select>";

        $fonts = $main_option['fonts'];
        echo "<h3>" . __('Custom Fonts', text_domain) . ' (' . __('RTL', text_domain) . ') ' . "</h3>"
        . "<div class='tmt-main-fonts'>"
            . "<div class='tmt-main-items'>";
                $i = -1;
                if(!empty($fonts)) {
                    foreach($fonts as $custom_font) {
                        $i++;
                        $weight = $custom_font['weight'];
                        $woff = $custom_font['woff'];
                        $woff2 = $custom_font['woff2'];
                        $ttf = $custom_font['ttf'];
                        $svg = $custom_font['svg'];
                        $eot = $custom_font['eot'];

                        echo "<div id='tmt-font-item-$i' class='tmt-font-item weight'>"
                            . "<select name='fonts[$i][weight]' class='font-item font-item-weight'>";
                                $weights = $this->config_setting->Font_Weight_Array();
                                foreach($weights as $id => $value) {
                                    echo "<option ". ($weight == $id ? ' selected' : '') ." value='$id'>$value</option>";
                                }
                            echo "</select>"
                            . "<div class='font-item woff'>"
                                . "<button class='button font-item-woff tmt-upload-fonts'>". __('Upload', text_domain) . 'WOFF' ."</button>"
                                . "<input value='". (!empty($woff) ? esc_url($woff) : '') ."' type='text' class='tmt-font-url' name='fonts[$i][woff]' />"
                            . "</div>"
                            . "<div class='font-item woff2'>"
                                . "<button class='button font-item-woff2 tmt-upload-fonts'>". __('Upload', text_domain) . 'WOFF2' ."</button>"
                                . "<input value='". (!empty($woff2) ? esc_url($woff2) : '') ."' type='text' class='tmt-font-url' name='fonts[$i][woff2]' />"
                            . "</div>"
                            . "<div class='font-item ttf'>"
                                . "<button class='button font-item-ttf tmt-upload-fonts'>". __('Upload', text_domain) . 'TTF' ."</button>"
                                . "<input value='". (!empty($ttf) ? esc_url($ttf) : '') ."' type='text' class='tmt-font-url' name='fonts[$i][ttf]' />"
                            . "</div>"
                            . "<div class='font-item svg'>"
                                . "<button class='button font-item-svg tmt-upload-fonts'>". __('Upload', text_domain) . 'SVG' ."</button>"
                                . "<input value='". (!empty($svg) ? esc_url($svg) : '') ."' type='text' class='tmt-font-url' name='fonts[$i][svg]' />"
                            . "</div>"
                            . "<div class='font-item eot'>"
                                . "<button class='button font-item-eot tmt-upload-fonts'>". __('Upload', text_domain) . 'EOT' ."</button>"
                                . "<input value='". (!empty($eot) ? esc_url($eot) : '') ."' type='text' class='tmt-font-url' name='fonts[$i][eot]' />"
                            . "</div>"
                        . "</div>";
                    }
                } else {
                    echo "<div id='tmt-font-item-0' class='tmt-font-item weight'>"
                        . "<select name='fonts[0][weight]' class='font-item font-item-weight'>";
                            $weights = $this->config_setting->Font_Weight_Array();
                            foreach($weights as $id => $weight) {
                                echo "<option value='$id'>$weight</option>";
                            }
                        echo "</select>"
                        . "<div class='font-item woff'>"
                            . "<button class='button font-item-woff tmt-upload-fonts'>". __('Upload', text_domain) . 'WOFF' ."</button>"
                            . "<input type='text' class='tmt-font-url' name='fonts[0][woff]' />"
                        . "</div>"
                        . "<div class='font-item woff2'>"
                            . "<button class='button font-item-woff2 tmt-upload-fonts'>". __('Upload', text_domain) . 'WOFF2' ."</button>"
                            . "<input type='text' class='tmt-font-url' name='fonts[0][woff2]' />"
                        . "</div>"
                        . "<div class='font-item ttf'>"
                            . "<button class='button font-item-ttf tmt-upload-fonts'>". __('Upload', text_domain) . 'TTF' ."</button>"
                            . "<input type='text' class='tmt-font-url' name='fonts[0][ttf]' />"
                        . "</div>"
                        . "<div class='font-item font-item-svg svg'>"
                            . "<button class='button tmt-upload-fonts'>". __('Upload', text_domain) . 'SVG' ."</button>"
                            . "<input type='text' class='tmt-font-url' name='fonts[0][svg]' />"
                        . "</div>"
                        . "<div class='font-item font-item-eot eot'>"
                            . "<button class='button tmt-upload-fonts'>". __('Upload', text_domain) . 'EOT' ."</button>"
                            . "<input type='text' class='tmt-font-url' name='fonts[0][eot]' />"
                        . "</div>"
                    . "</div>";
                }
            echo "</div>"

            . "<div class='tmt-main-font-btn flex flex-wrap align-items-center justify-content-between'>"
                . "<button type='button' class='tmt-font-btn' id='add-new-font-item'>". __('Add New Font', text_domain) ."</button>"
                . "<button type='button' class='tmt-font-btn' id='remove-font-item'>". __('Remove Font Item', text_domain) ."</button>"
            . "</div>"
        . "</div>";
    }

    protected function Custom_Code_Settings() {

        $category = 'codes-settings';

        $css = TMT_Get_Setting($category, 'custom-css');
        $js = TMT_Get_Setting($category, 'custom-js');
        $head = TMT_Get_Setting($category, 'custom-before-head');
        $body = TMT_Get_Setting($category, 'custom-before-body');

        echo "<div class='tmt-main-codes flex flex-wrap justify-content-between'>"
            . "<div class='tmt-css-codes'>"
                . "<h3>". __('Custom Css', text_domain) ."</h3>"
                . "<textarea name='tmt-custom-css' id='tmt-custom-css' rows='15'>". (!empty($css) ? esc_html($css) : '' ) ."</textarea>"
            . "</div>"
            . "<div class='tmt-js-codes'>"
                . "<h3>". __('Custom Js', text_domain) ."</h3>"
                . "<textarea name='tmt-custom-js' id='tmt-custom-js' rows='15'>". (!empty($js) ? esc_html($js) : '' ) ."</textarea>"
            . "</div>"
            . "<div class='tmt-before-head-codes'>"
                . "<h3>". __('Custom Code Before Head', text_domain) ."</h3>"
                . "<textarea name='tmt-custom-before-head' id='tmt-custom-before-head' rows='15'>". (!empty($head) ? esc_html($head) : '' ) ."</textarea>"
            . "</div>"
            . "<div class='tmt-before-body-codes'>"
                . "<h3>". __('Custom Code Before body', text_domain) ."</h3>"
                . "<textarea name='tmt-custom-before-body' id='tmt-custom-before-body' rows='15'>". (!empty($body) ? esc_html($body) : '' ) ."</textarea>"
            . "</div>"
        . "</div>";
    }
}