jQuery(document).ready(function ($) {
    $('.tmt-main-sidebar-options .tmt-main-menu li').click(function(){
        var id = $(this).attr('id');
        $('.tmt-main-sidebar-options .tmt-main-menu li').removeClass('active');
        $(this).addClass('active');
        $('.tmt-main-option-theme .tmt-main-content-options .content-tab').hide();
        $('.' + id + '-options').show(200);
    });

	function replaceDiacritics(s) {
		var diacritics = [
			/[\300-\306]/g, /[\340-\346]/g,  // A, a
			/[\310-\313]/g, /[\350-\353]/g,  // E, e
			/[\314-\317]/g, /[\354-\357]/g,  // I, i
			/[\322-\330]/g, /[\362-\370]/g,  // O, o
			/[\331-\334]/g, /[\371-\374]/g,  // U, u
			/[\321]/g, /[\361]/g, // N, n
			/[\307]/g, /[\347]/g  // C, c
		];

		var chars = ['A', 'a', 'E', 'e', 'I', 'i', 'O', 'o', 'U', 'u', 'N', 'n', 'C', 'c'];

		for (var i = 0; i < diacritics.length; i++) {
			s = s.replace(diacritics[i], chars[i]);
		}

		return s;
	}

    $('#cpt-name.tmt-field input').keyup(function(){
        var val, original_val;
		val = original_val = $(this).val();
        var val = $(this).val();
        val = val.replace(/ /g, "_");
        val = val.toLowerCase();
        val = replaceDiacritics(val);
        if ( val !== original_val ) {
            $(this).prop('value', val);
        }

		$('#cpt-name.tmt-field .tmt-label p').hide();
		$('.tmt-main-content-options .form-row button.tmt-submit').removeAttr('disabled');
		if(tmt_post_types_object.get_post_types.hasOwnProperty(val) == true) {
            $('#cpt-name.tmt-field .tmt-label p').show();
			$('.tmt-main-content-options .form-row button.tmt-submit').attr('disabled', '');
        }
    });
	
	$(".checkbox-sluge-exists").each(function() {
		var id = $(this).find('input'),
		target = id.attr('data-target');
		$(id).change(function() {
			$('#' + target + ' input').attr('disabled', '');
			if(this.checked) {
				$('#' + target + ' input').removeAttr('disabled');
			}
		});
	});

	$('#tx-cat-name.tmt-field input').keyup(function(){
        var val, original_val;
		val = original_val = $(this).val();
        var val = $(this).val();
        val = val.replace(/ /g, "_");
        val = val.toLowerCase();
        val = replaceDiacritics(val);
        if ( val !== original_val ) {
            $(this).prop('value', val);
        }

		$('#tx-cat-name.tmt-field .tmt-label p').hide();
		$('.tmt-main-content-options .form-row button.tmt-submit').removeAttr('disabled');
		if(tmt_taxonomies_object.get_taxonomies.hasOwnProperty(val) == true) {
			$('#tx-cat-name.tmt-field .tmt-label p').show();
			$('.tmt-main-content-options .form-row button.tmt-submit').attr('disabled', '');
        }
    });

	$('#tx-tag-name.tmt-field input').keyup(function(){
        var val, original_val;
		val = original_val = $(this).val();
        var val = $(this).val();
        val = val.replace(/ /g, "_");
        val = val.toLowerCase();
        val = replaceDiacritics(val);
        if ( val !== original_val ) {
            $(this).prop('value', val);
        }

		$('#tx-tag-name.tmt-field .tmt-label p').hide();
		$('.tmt-main-content-options .form-row button.tmt-submit').removeAttr('disabled');
		if(tmt_taxonomies_object.get_taxonomies.hasOwnProperty(val) == true) {
			$('#tx-tag-name.tmt-field .tmt-label p').show();
			$('.tmt-main-content-options .form-row button.tmt-submit').attr('disabled', '');
        }
    });

	$(".has-condition input[type='checkbox']").change(function() {
		var id = $(this).attr('id');
		if(this.checked) {
			$('.condition-' + id).addClass('tmt-show-field');
		} else {
			$('.condition-' + id).removeClass('tmt-show-field');
		}
	});

	function tmt_image_uploader($class) {
		var uploader,
		metaBox = $($class),
		addImgLink = metaBox.find('.field-upload-img'),
		delImgLink = metaBox.find( '.field-delete-img'),
		imgContainer = metaBox.find( '.field-img-container'),
		imgURLInput = metaBox.find( '.field-img-url' );
		addImgLink.on( 'click', function( event ){
            event.preventDefault();
            if ( uploader ) {uploader.open();return;}

            uploader = wp.media({
                library: {type: 'image'},
                multiple: false,
            });

            uploader.on( 'select', function() {
                var attachment = uploader.state().get('selection').first().toJSON();
                imgContainer.empty().append( '<img src="'+attachment.url+'" alt="" style="max-width:100%;"/>' );
                imgURLInput.val( attachment.url );
                delImgLink.removeClass( 'hidden' );
            });

            uploader.open();
		});

		delImgLink.on( 'click', function( event ){
            event.preventDefault();
            imgContainer.html( '' );
            delImgLink.addClass( 'hidden' );
            imgURLInput.val( '' );
		});
	}

    $('.field-image-uploader').each(function () {
        var id = $(this).attr("id");
        tmt_image_uploader('#' + id);
    });

	$('.color-picker').wpColorPicker();

	function font_upload(button_class,type) {
		'use strict';
		jQuery(function($){
			var frame
			
			jQuery('body').on( 'click', button_class, function( event ){
			var display_field = jQuery(this).parent().children('input:text');
			  event.preventDefault();
			  
			  if ( frame ) {
				frame.open();
				return;
			  }
			  
			  frame = wp.media({
				frame: 'select',
				library: {
					order: 'DESC',
					type: type,
				},
				multiple: false
			  });
		  
			  frame.on( 'select', function() {
				var attachment = frame.state().get('selection').first().toJSON();
				display_field.val(attachment.url);
				display_field.trigger('change');
			  });
		  
			  frame.open(button_class);
			});
		  
		  });
	
	}
	
	const cars = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
	for (let i = 0; i < cars.length; i++) {
		font_upload('#tmt-font-item-'+ i +' .font-item-woff','application/x-font-woff');
		font_upload('#tmt-font-item-'+ i +' .font-item-woff2','application/x-font-woff2');
		font_upload('#tmt-font-item-'+ i +' .font-item-ttf','application/x-font-ttf');
		font_upload('#tmt-font-item-'+ i +' .font-item-svg','image/svg+xml');
		font_upload('#tmt-font-item-'+ i +' .font-item-eot','application/vnd.ms-fontobject');
	} 
	
	$('#add-new-font-item').click(function(){
		var id = $('.tmt-font-item').size(),
		field = $('.tmt-font-item:first-child').clone( true, true );

		field.attr('id', 'tmt-font-item-' + id);

		field.find('.weight').val('normal');
		field.find('.tmt-font-url').val('');
		field.find('.weight .tmt-font-url').attr('name','fonts['+ id +'][weight]');
		field.find('.woff .tmt-font-url').attr('name','fonts['+ id +'][woff]');
		field.find('.woff2 .tmt-font-url').attr('name','fonts['+ id +'][woff2]');
		field.find('.ttf .tmt-font-url').attr('name','fonts['+ id +'][ttf]');
		field.find('.svg .tmt-font-url').attr('name','fonts['+ id +'][svg]');
		field.find('.eot .tmt-font-url').attr('name','fonts['+ id +'][eot]');

		$('.tmt-main-fonts .tmt-main-items').append(field);
	});

	

	$(".tmt-item-checkbox-select input[type='checkbox']").change(function() {
		if(this.checked) {
			$(this).parents('.tmt-item-checkbox-select').addClass('show-preloader-item');
			$(this).parents('.tmt-item-checkbox-select').siblings('.preloader-logo').addClass('show-preloader-item');
		} else {
			$(this).parents('.tmt-item-checkbox-select').removeClass('show-preloader-item');
			$(this).parents('.tmt-item-checkbox-select').siblings('.preloader-logo').removeClass('show-preloader-item');
		}
	});

	$('#remove-font-item').click(function(){
		$('.tmt-font-item:not(:first-child):last-child').remove();
	});
});