<?php

/** no direct access **/
if (!defined('ABSPATH'))
	exit;

// add plugin's meta box
add_action('add_meta_boxes', 'scrapes_add_meta_box');
add_action('save_post', 'save_scrapes_metabox');

function save_scrapes_metabox($post_id)
{
	if(isset($_POST['dont_update_by_scrapes'])) 
	{
		update_post_meta($post_id, '_dont_update_post_scrape', $_POST['dont_update_by_scrapes']);
	} else {
		update_post_meta($post_id, '_dont_update_post_scrape', '');
	}
}

function scrapes_add_meta_box()
{
	$post_types = scrapes_get_post_types();
	
	foreach($post_types as $post_type) {
		add_meta_box(
			'scrapes_meta_box_function',
			__('Scrapes Information For This Post', 'ol-scrapes'),
			'scrapes_meta_box_content',
			$post_type
		);
	}	
}

function scrapes_meta_box_content($post)
{
	$dont_update_post = get_post_meta($post->ID, '_dont_update_post_scrape', true);
	$scrape_id = get_post_meta($post->ID, '_scrape_task_id', true);
	$scrape_type = get_post_meta($scrape_id, 'scrape_type', true);
	$request_type = get_post_meta($scrape_id, 'scrape_selector', true);
	$auto_update = get_post_meta($scrape_id, 'scrape_on_unique', true);
	$ai_models = get_post_meta($scrape_id, 'scrape_ai_model_enable', true);
	$status_update = false;
	if($auto_update == 'update' || $auto_update == 'special' || $auto_update == 'update_old_posts') {
		$status_update = true;
	}
	
	$args = array(
		'single'=> __('Single', 'ol-scrapes'),
		'list'  => __('Serial', 'ol-scrapes'),
		'feed'  => __('Feed', 'ol-scrapes')
	);
	
	if( !empty($scrape_type) ) {
		?>
		<table class="scrape_table">
			<tr><td><b><?php echo _e('Scrape ID:', 'ol-scrapes'); ?></b></td><td><?php echo $scrape_id; ?></td></tr>
			<tr><td><b><?php echo _e('Scrape Type:', 'ol-scrapes'); ?></b></td><td><?php foreach($args as $key => $value) { if($key == $scrape_type) echo $value;} ?></td></tr>
			<tr><td><b><?php echo _e('Request Type:', 'ol-scrapes'); ?></b></td><td><?php echo $request_type; ?></td></tr>
			<tr><td><b><?php echo _e('Auto Update:', 'ol-scrapes'); ?></b></td><td><?php $status_update ? _e('Active', 'ol-scrapes') : _e('Inactive', 'ol-scrapes'); ?></td></tr>
			<tr><td><b><?php echo _e('AI Models', 'ol-scrapes'); ?>:</b></td><td><?php $ai_models == 'on' ? _e('Active', 'ol-scrapes') : _e('Inactive', 'ol-scrapes'); ?></td></tr>
		</table>
		<?php if($status_update) : ?>
		<input value="on" type="checkbox" name="dont_update_by_scrapes" id="dont_update_by_scrapes" <?php if(!empty($dont_update_post)) echo 'checked="checked"'; ?>>
		<label for="dont-update-scrapes"><?php echo _e('Disable updating of this post by Scrape', 'ol-scrapes'); ?></label>		
		<?php endif; ?>
		<?php
	} elseif( !empty($scrape_id) ) {
		echo _e('Scrape of this post is not available. It seems that the scrape or its information has been deleted.', 'ol-scrapes');
	} else {
		echo _e('This is not an automatically generated post by scrapes.', 'ol-scrapes');
	}
}

function scrapes_get_post_types() 
{
	$post_types = get_post_types(array('public' => true));
	if (($key = array_search('scrape', $post_types)) !== false) { unset($post_types[$key]); }
	if (($key = array_search('attachment', $post_types)) !== false) { unset($post_types[$key]); }
	if ( ! is_array( $post_types ) ) {
		return array();
	}
	return $post_types;
}