<?php

/** no direct access **/
if (!defined('ABSPATH'))
	exit;

/**
 * Bargwp Translate Month class
 * @author Bargwp <info@bargwp.com>
 */
 
class Trnslt_Month {
	
	public static function translate_months($str) {
		$languages = array(
			"fa" => array(
				"فروردین", "اردیبهشت", "خرداد", "تیر", "مرداد", "شهریور", "مهر", "آبان", "آذر", "دی", "بهمن", "اسفند"
			), "en" => array(
				"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"
			), "fr" => array(
				"Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Août", "Septembre", "Octobre", "Novembre", "Décembre"
			), "tr" => array(
				"Ocak", "Şubat", "Mart", "Nisan", "Mayıs", "Haziran", "Temmuz", "Ağustos", "Eylül", "Ekim", "Kasım", "Aralık"
			), "nl" => array(
				"Januari", "Februari", "Maart", "April", "Mei", "Juni", "Juli", "Augustus", "September", "Oktober", "November", "December"
			), "id" => array(
				"Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"
			), "pt-br" => array(
				"Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"
			)
		);
		
		$languages_abbr = $languages;
		
		foreach ($languages_abbr as $locale => $months) {
			$languages_abbr[$locale] = array_map(array(__CLASS__, 'month_abbr'), $months);
		}
		
		foreach ($languages as $locale => $months) {
			$str = str_ireplace($months, $languages["en"], $str);
		}
		foreach ($languages_abbr as $locale => $months) {
			$str = str_ireplace($months, $languages_abbr["en"], $str);
		}
		
		if(strpos($str, 'SepJulber') !== false) {
			$str = str_replace('SepJulber', 'September', $str);
		}		
		
		return $str;
	}
	
	public static function month_abbr($month) {
		return mb_substr($month, 0, 3);
	}	
}