<?php

/** no direct access **/
if (!defined('ABSPATH'))
	exit;

/**
 * Bargwp Required Functions class
 * @author Bargwp <info@bargwp.com>
 */
 
class Scrapes_Required_Functions {

	/**
     * Instance of this class. This is a singleton class
     */
	private static $instance = NULL;    
	
	/**
     * Getting instance. This Class is a singleton class
     * @return static
     */	
    public static function instance() {
        // Get an instance of Class
        if(!self::$instance) self::$instance = new self();
        
        // Return the instance
        return self::$instance;
	}
	
	public function trimmed_templated_value($prefix, &$meta_vals, &$xpath, $post_date, $save_post_date_jalali, $url, $meta_input, $rss_item = null) {
		global $wpdb, $postid;
		$value = '';
		if (isset($meta_vals[$prefix]) || isset($meta_vals[$prefix . "_type"])) {
			if (isset($meta_vals[$prefix . "_type"]) && $meta_vals[$prefix . "_type"][0] == 'feed') {
				$value = $rss_item['post_title'];
				if ($meta_vals['scrape_spin_enable'][0]) {
				    $value = $this->spin_content_with_thebestspinner($meta_vals['scrape_spin_email'], $meta_vals['scrape_spin_password'], $value);
                }
				if ($meta_vals['scrape_translate_enable'][0]) {
					if (class_exists('TS_Translate')) {

						if($prefix == 'scrape_excerpt') {
							$chk_section = !empty($meta_vals['scrape_translate_excerpt'][0]);							
						} else {
							$chk_section = !empty($meta_vals['scrape_translate_title'][0]);
						}
						$section_type = isset($meta_vals['scrape_translate_sections'][0]) ? $meta_vals['scrape_translate_sections'][0] : 'all_sections';
					    
						if($chk_section || $section_type == 'all_sections')
						{
							$value = TS_Translate::translate($meta_vals['scrape_translate_source'][0], $meta_vals['scrape_translate_target'][0], $value);
							OL_Scrapes::write_log("translated $prefix : $value");
						}
					}
				}
			} else {
				if (!empty($meta_vals[$prefix][0])) {
					$node = $xpath->query($meta_vals[$prefix][0]);
					if ($node->length) {
						if (!empty($meta_vals['scrape_excerpt_allowhtml'][0]) && $prefix == 'scrape_excerpt') {
							$node = $node->item(0);
							$value = $node->ownerDocument->saveXML($node);
						} else {
							$value = $node->item(0)->nodeValue;
						}
						OL_Scrapes::write_log($prefix . " : " . $value);
                        if ($meta_vals['scrape_spin_enable'][0]) {
                            $value = $this->spin_content_with_thebestspinner($meta_vals['scrape_spin_email'][0], $meta_vals['scrape_spin_password'][0], $value);
                        }
						if ($meta_vals['scrape_translate_enable'][0]) {
							if (class_exists('TS_Translate')) {
								
								if($prefix == 'scrape_excerpt') {
									$chk_section = !empty($meta_vals['scrape_translate_excerpt'][0]);							
								} else {
									$chk_section = !empty($meta_vals['scrape_translate_title'][0]);
								}
								$section_type = isset($meta_vals['scrape_translate_sections'][0]) ? $meta_vals['scrape_translate_sections'][0] : 'all_sections';
								
								if($chk_section || $section_type == 'all_sections')
								{									
									$value = TS_Translate::translate($meta_vals['scrape_translate_source'][0], $meta_vals['scrape_translate_target'][0], $value);
								}
							}
						}
						OL_Scrapes::write_log("translated $prefix : $value");
						
					} else {
						$value = '';
						OL_Scrapes::write_log("URL: " . $url . " XPath: " . $meta_vals[$prefix][0] . " returned empty for $prefix", true);
					}
				} else {
					$value = '';
				}
			}
			
			if (!empty($meta_vals[$prefix . '_regex_status'][0])) {
				$regex_finds = unserialize($meta_vals[$prefix . '_regex_finds'][0]);
				$regex_replaces = unserialize($meta_vals[$prefix . '_regex_replaces'][0]);
				if (!empty($regex_finds)) {
					$regex_combined = array_combine($regex_finds, $regex_replaces);
					foreach ($regex_combined as $regex => $replace) {
						OL_Scrapes::write_log("$prefix before regex: " . $value);
						$value = preg_replace("/" . str_replace("/", "\/", $regex) . "/isu", $replace, $value);
						OL_Scrapes::write_log("$prefix after regex: " . $value);
					}
				}
			}
		}
		if (isset($meta_vals[$prefix . '_template_status']) && !empty($meta_vals[$prefix . '_template_status'][0])) {
			$template = $meta_vals[$prefix . '_template'][0];
			OL_Scrapes::write_log($prefix . " : " . $template);
			$value = str_replace("[scrape_value]", $value, $template);
			if(class_exists('TS_Options')) {
				if(function_exists('wp_date')) {			
					$value = str_replace("[scrape_date]", $save_post_date_jalali, $value);
				}
			} else {
				$value = str_replace("[scrape_date]", $post_date, $value);
			}
			$value = str_replace("[scrape_url]", $url, $value);
			
			preg_match_all('/\[scrape_meta name="([^"]*)"\]/', $value, $matches);
			
			$full_matches = $matches[0];
			$name_matches = $matches[1];
			if (!empty($full_matches)) {
				$combined = array_combine($name_matches, $full_matches);
				
				foreach ($combined as $meta_name => $template_string) {
					$val = $meta_input[$meta_name];
					$value = str_replace($template_string, $val, $value);
				}
			}
			
			
			if (preg_match('/\[scrape_chatgpt prompt="(.*?)"\]/is', $value, $matches)) {
				$full_text = $matches[0];
				$text = $matches[1];
				if( empty($meta_vals['scrape_custom_fields']) ) {
					$post_type = $meta_vals['scrape_post_type'][0];
					$sql = $wpdb->prepare("SELECT ID " . "FROM $wpdb->posts p LEFT JOIN $wpdb->postmeta pm ON pm.post_id = p.ID " . "WHERE pm.meta_value = %s AND pm.meta_key = '_scrape_original_url' " . "	AND p.post_type = %s " . " AND p.post_status <> 'trash'", $url, $post_type);
					$postid = $wpdb->get_var($sql);	
					OL_Scrapes::write_log("$prefix post id checked aimodel: " . $postid);
				}
				if(empty($postid) || ($meta_vals['scrape_on_unique'][0] != "skip" && $meta_vals['scrape_on_unique'][0] != "special")) {
					$calculated = $this->ai_model_prompt($meta_vals['scrape_ai_model_service'][0], $text, $meta_vals['scrape_ai_model_service_apikey'][0], false);
					$value = str_replace($full_text, $calculated, $value);
				} else {
					if(!empty($postid) && $prefix == 'scrape_title') {
						$post_title = get_the_title( $postid );
						$value = !empty($post_title) ? $post_title : '';
					}
				}
			}			
			
			OL_Scrapes::write_log("after template replacements: " . $value);
		}
		return trim($value);
	}	

    public function spin_content_with_thebestspinner($email, $password, $content) {

        $output = wp_remote_post('http://thebestspinner.com/api.php', array(
                'method' => 'POST',
                'timeout' => 60,
                'redirection' => 5,
                'httpversion' => '1.0',
                'blocking' => true,
                'headers' => array(),
                'body' => array(
                    'action' => 'authenticate',
                    'format' => 'php',
                    'username' => $email,
                    'password' => $password,
                    'rewrite' => 1
                ),
                'cookies' => array()
            )
        );

        $output = unserialize($output);

        OL_Scrapes::write_log('best spinner result ' . $output);
        if ($output['success'] == true) {
            $content = wp_remote_post('http://thebestspinner.com/api.php', array(
                    'method' => 'POST',
                    'timeout' => 60,
                    'redirection' => 5,
                    'httpversion' => '1.0',
                    'blocking' => true,
                    'headers' => array(),
                    'body' => array(
                        'session' => $output['session'],
                        'format' => 'php',
                        'text' => $content,
                        'action' => 'rewriteText'
                    ),
                    'cookies' => array()
                )
            );
        }
        return $content;
    }

	public function scrape_json_from_body($body_json, $value)
	{
		$doc = new DOMDocument;
		$doc->preserveWhiteSpace = false;
		@$doc->loadHTML('<?xml encoding="utf-8" ?>' . $body_json);
		
		$xpath = new DOMXPath($doc);
		$json_xpath = $value . "//text()";
		$node = $xpath->query($json_xpath);
		
		return $node;
	}
	
	public function get_value_from_json($json, $attr, $gallery = false)
	{
		if( $gallery )
		{
			if( is_array($json) )
			{
				return $json;
			}
			
			preg_match_all('/"'.$attr.'[":\s]+([^"]*)"/', $json, $matches);
			$gallery_img = array_unique($matches[1]);
			
			return $gallery_img;
		}
		
		$obj = json_decode($json, true);

		$exp = explode(':', $attr);
		$value = '';

		if( !is_null($obj) )
		{
			for($i = 0; $i < count($exp); $i++ ) {
				
				if( is_array($value) )
				{
					$obj = $value;
				}
						
				if( isset($obj[$exp[$i]]) && !is_array($obj[$exp[$i]]) )
				{
					$value = $obj[$exp[$i]];
					break;
				}
				elseif( isset($obj[$exp[$i]]) && is_array($obj[$exp[$i]]) )
				{
					$value = $obj[$exp[$i]];
				}
				elseif($i == count($exp) - 1 && is_array($value) )
				{
					$value = '';
				}				
			}
			
			return $value;
		}		
		else
		{
			return $json;
		}
	}
	
	public function create_meta_box_from_attr($meta, $attrs = '', $xpath = '', $xp_attr = '')
	{
		if( !empty($attrs) && !empty($xpath) )
		{
			$nodes = $xpath->query($xp_attr);
			$meta_box = array();
			
			if($nodes->length)
			{
				foreach($nodes as $attr) {
					$meta_box[] = trim($attr->getAttribute($attrs));
				}
			}
			
			return $meta_box;
		}
		
		preg_match_all('/(?<=>)\n*([^<]+)/', $meta, $matches);
		$meta_box = array_filter(array_map('trim', $matches[1]));
		$meta_box = array_unique($meta_box);
		$meta_box = array_values($meta_box);

		return $meta_box;
	}
	
	public function scrape_update_special($meta_vals, $meta_input, $ID, $woo_active, $attibutes, $meta_box)
	{
		$meta_price = '';
		$meta_regprice = '';
		$meta_salprice = '';
		$meta_stock = '';
		$meta_manstock = '';
		$meta_stastock = '';
		$mnswmc_price = '';
		$mnswmc_sale = '';
		$mnswmc_currency = '';		
		
		if( !empty($meta_vals['scrape_update_price'][0]) ) {
			$meta_price = isset($meta_input['_price']) ? $meta_input['_price'] : '';
			$meta_regprice = isset($meta_input['_regular_price']) ? $meta_input['_regular_price'] : '';
			$meta_salprice = isset($meta_input['_sale_price']) ? $meta_input['_sale_price'] : '';
			$mnswmc_price = isset($meta_input['_mnswmc_regular_price']) ? $meta_input['_mnswmc_regular_price'] : '';
			$mnswmc_sale = isset($meta_input['_mnswmc_sale_price']) ? $meta_input['_mnswmc_sale_price'] : '';
			$mnswmc_currency = isset($meta_input['_mnswmc_currency_id']) ? $meta_input['_mnswmc_currency_id'] : '';			
		}
		if( !empty($meta_vals['scrape_update_stock'][0]) ) {
			$meta_stock = isset($meta_input['_stock']) ? $meta_input['_stock'] : '';
			$meta_manstock = isset($meta_input['_manage_stock']) ? $meta_input['_manage_stock'] : '';
			$meta_stastock = isset($meta_input['_stock_status']) ? $meta_input['_stock_status'] : '';
		}
		
		$update_meta = array(
			'_regular_price'       => $meta_regprice,
			'_price'               => $meta_price,
			'_sale_price'          => $meta_salprice,
			'_stock_status' 	   => $meta_stastock,
			'_stock'               => $meta_stock,
			'_manage_stock'        => $meta_manstock,
			'_mnswmc_regular_price'=> $mnswmc_price,
			'_mnswmc_sale_price'   => $mnswmc_sale,
			'_mnswmc_currency_id'  => $mnswmc_currency			
		);
		if( !empty($update_meta) ) {
		
			foreach( $update_meta as $key_meta => $value_meta ) {
			
				if( !empty($value_meta) ) {						
					update_post_meta($ID, $key_meta, $value_meta);

					if( $woo_active )
					{
						if( !empty($meta_vals['scrape_update_attr'][0]) )
						{
							if (array_key_exists('_product_attributes', $meta_input)) {
								if(class_exists('TS_Options')) {
									if( !empty($meta_vals['scrape_product_variable'][0]) ) {
										if( !empty($meta_box) ) {
											wp_set_object_terms($ID, 'variable','product_type');
										} else {
											wp_set_object_terms($ID, 'simple','product_type');
										}
									}
									$gallery_images = array();
									TS_Options::ts_create_product_variation( $attibutes, $ID, $meta_input, $meta_box, $gallery_images );
								}					
							}
						} else {						
							$prduct = wc_get_product($ID);
							if( $prduct->is_type( 'variable' ) )
							{
								$product_variation = $prduct->get_available_variations();
								if( !empty($product_variation) )
								{
									foreach($product_variation as $keyvar) {
										
										update_post_meta($keyvar['variation_id'], $key_meta, $value_meta);
										wc_delete_product_transients( $keyvar['variation_id'] );
									}
								}
							}
						}						
					}
				} else {
					delete_post_meta($ID, $key_meta);
				}
			}
			
			if( function_exists('mnswmc_update_product_obj_price') ) {
				mnswmc_update_product_obj_price($ID);
			}			
			OL_Scrapes::write_log("Special update done!");
		}		
	}
	
	public function show_status_column($column_name, $post_ID) {
		clean_post_cache($post_ID);
		$post_status = get_post_status($post_ID);
		$post_title = get_post_field('post_title', $post_ID);
		$scrape_status = get_post_meta($post_ID, 'scrape_workstatus', true);
		$run_limit = get_post_meta($post_ID, 'scrape_run_limit', true);
		$run_count = get_post_meta($post_ID, 'scrape_run_count', true);
		$run_unlimited = get_post_meta($post_ID, 'scrape_run_unlimited', true);
		$css_class = '';
		$status = '';
		
		if ($post_status == 'trash' || $scrape_status == 'deactivated') {
			$status = __("Deactivated", "ol-scrapes");
			$css_class = "deactivated";
		} else {
			if ($run_count == 0 && $scrape_status == 'waiting') {
				$status = __("Preparing", "ol-scrapes");
				$css_class = "preparing";
			} else {
				if ((!empty($run_unlimited) || $run_count < $run_limit) && $scrape_status == 'waiting') {
					$status = __("Waiting next run", "ol-scrapes");
					$css_class = "wait_next";
				} else {
					if (((!empty($run_limit) && $run_count < $run_limit) || (!empty($run_unlimited))) && $scrape_status == 'running') {
						$status = __("Running", "ol-scrapes");
						$css_class = "running";
					} elseif(!empty($run_limit) && $run_count == $run_limit && $scrape_status == 'running') {
							$status = __("Running", "ol-scrapes");
							$css_class = "running";
					} else {
						if (empty($run_unlimited) && $run_count == $run_limit && $scrape_status == 'waiting') {
							$status = __("Complete", "ol-scrapes");
							$css_class = "complete";
						}
					}
				}
			}
		}
		
		if ($column_name == 'status') {
			echo "<span class='ol_status ol_status_$css_class'>" . $status . "</span>";
		}
		
		if ($column_name == 'name') {
			echo "<p><strong><a href='" . get_edit_post_link($post_ID) . "'>" . $post_title . "</a></strong></p>" . "<p><span class='id'>ID: " . $post_ID . "</span></p>";
		}
		
		if ($column_name == 'schedules') {
			$last_run = get_post_meta($post_ID, 'scrape_start_time', true) != "" ? get_post_meta($post_ID, 'scrape_start_time', true) : __("None", "ol-scrapes");
			$last_complete = get_post_meta($post_ID, 'scrape_end_time', true) != "" ? get_post_meta($post_ID, 'scrape_end_time', true) : __("None", "ol-scrapes");
			$last_scrape = get_post_meta($post_ID, 'scrape_last_scrape', true) != "" ? get_post_meta($post_ID, 'scrape_last_scrape', true) : __("None", "ol-scrapes");
			$count_posts = get_post_meta($post_ID, 'scrape_count_post', true) != "" ? get_post_meta($post_ID, 'scrape_count_post', true) : 0;
			$run_count_progress = $run_count;
			if ($run_unlimited == "") {
				$run_count_progress .= " / " . $run_limit;
			}
			
			$offset = get_option('gmt_offset') * 3600;
			$date = date("Y-m-d H:i:s", wp_next_scheduled("scrape_event", array($post_ID)) + $offset);
			if (strpos($date, "1970-01-01") !== false) {
				$date = __("No Schedule", "ol-scrapes");
			}
			echo "<p><label>" . __("Last Run:", "ol-scrapes") . "</label> <span>" . $last_run . "</span></p>" . "<p><label>" . __("Last Complete:", "ol-scrapes") . "</label> <span>" . $last_complete . "</span></p>" . "<p><label>" . __("Last Scrape:", "ol-scrapes") . "</label> <span>" . $last_scrape . "</span></p>" . "<p><label>" . __("Next Run:", "ol-scrapes") . "</label> <span>" . $date . "</span></p>" . "<p><label>" . __("Total Run:", "ol-scrapes") . "</label> <span>" . $run_count_progress . "</span></p>" . "<p><label>" . __("Count Post:", "ol-scrapes") . "</label> <span>" . $count_posts . "</span></p>";
		}
		if ($column_name == "actions") {
			$nonce = wp_create_nonce('scrape_custom_action');
			$untrash = wp_create_nonce('untrash-post_' . $post_ID);
			echo ($post_status != 'trash' ? "<a href='" . get_edit_post_link($post_ID) . "' class='button edit'><i class='icon ion-android-create'></i>" . __("Edit", "ol-scrapes") . "</a>" : "") . (($post_status != 'trash' && $scrape_status != 'deactivated') ? "<a href='" . admin_url("edit.php?post_type=scrape&scrape_id=$post_ID&_wpnonce=$nonce&scrape_action=start_scrape") . "' class='button run ol_status_" . $css_class . "'><i class='icon ion-play'></i>" . __("Run", "ol-scrapes") . "</a>" : "") . (($post_status != 'trash' && $scrape_status != 'deactivated') ? "<a href='" . admin_url("edit.php?post_type=scrape&scrape_id=$post_ID&_wpnonce=$nonce&scrape_action=stop_scrape") . "' class='button stop ol_status_" . $css_class . "'><i class='icon ion-pause'></i>" . __("Pause", "ol-scrapes") . "</a>" : "") . ($post_status != 'trash' ? "<br><a href='" . admin_url("edit.php?post_type=scrape&scrape_id=$post_ID&_wpnonce=$nonce&scrape_action=duplicate_scrape") . "' class='button duplicate'><i class='icon ion-android-add-circle'></i>" . __("Copy", "ol-scrapes") . "</a>" : "") . ($post_status != 'trash' ? "<a href='" . get_delete_post_link($post_ID) . "' class='button trash'><i class='icon ion-trash-b'></i>" . __("Trash", "ol-scrapes") . "</a>" : "<a href='" . admin_url('post.php?post=' . $post_ID . '&action=untrash&_wpnonce=' . $untrash) . "' class='button restore'><i class='icon ion-forward'></i>" . __("Restore", "ol-scrapes") . "</a>");
		}
	}

	public function ajax_tasks() {
		$all_tasks = get_posts(array(
			'numberposts' => -1, 'post_type' => 'scrape', 'post_status' => 'publish'
		));
		
		$array = array();
		foreach ($all_tasks as $task) {
			$post_ID = $task->ID;
			
			clean_post_cache($post_ID);
			$post_status = get_post_status($post_ID);
			$scrape_status = get_post_meta($post_ID, 'scrape_workstatus', true);
			$run_limit = get_post_meta($post_ID, 'scrape_run_limit', true);
			$run_count = get_post_meta($post_ID, 'scrape_run_count', true);
			$run_unlimited = get_post_meta($post_ID, 'scrape_run_unlimited', true);
			$status = '';
			$css_class = '';
			
			if ($post_status == 'trash' || $scrape_status == 'deactivated') {
				$status = __("Deactivated", "ol-scrapes");
				$css_class = "deactivated";
			} else {
				if ($run_count == 0 && $scrape_status == 'waiting') {
					$status = __("Preparing", "ol-scrapes");
					$css_class = "preparing";
				} else {
					if ((!empty($run_unlimited) || $run_count < $run_limit) && $scrape_status == 'waiting') {
						$status = __("Waiting next run", "ol-scrapes");
						$css_class = "wait_next";
					} else {
						if (((!empty($run_limit) && $run_count < $run_limit) || (!empty($run_unlimited))) && $scrape_status == 'running') {
							$status = __("Running", "ol-scrapes");
							$css_class = "running";
						
						} elseif(!empty($run_limit) && $run_count == $run_limit && $scrape_status == 'running') {
							$status = __("Running", "ol-scrapes");
							$css_class = "running";
						} else {
							if (empty($run_unlimited) && $run_count == $run_limit && $scrape_status == 'waiting') {
								$status = __("Complete", "ol-scrapes");
								$css_class = "complete";
							}
						}
					}
				}
			}
			
			$last_run = get_post_meta($post_ID, 'scrape_start_time', true) != "" ? get_post_meta($post_ID, 'scrape_start_time', true) : __("None", "ol-scrapes");
			$last_complete = get_post_meta($post_ID, 'scrape_end_time', true) != "" ? get_post_meta($post_ID, 'scrape_end_time', true) : __("None", "ol-scrapes");
			$last_scrape = get_post_meta($post_ID, 'scrape_last_scrape', true) != "" ? get_post_meta($post_ID, 'scrape_last_scrape', true) : __("None", "ol-scrapes");
			$count_posts = get_post_meta($post_ID, 'scrape_count_post', true) != "" ? get_post_meta($post_ID, 'scrape_count_post', true) : 0;
			$run_count_progress = $run_count;
			if ($run_unlimited == "") {
				$run_count_progress .= " / " . $run_limit;
			}
			$offset = get_option('gmt_offset') * 3600;
			$date = date("Y-m-d H:i:s", wp_next_scheduled("scrape_event", array($post_ID)) + $offset);
			if (strpos($date, "1970-01-01") !== false) {
				$date = __("No Schedule", "ol-scrapes");
			}
			$array[] = array(
				$task->ID, $css_class, $status, $last_run, $last_complete, $date, $run_count_progress, $last_scrape, $count_posts
			);
		}
		
		echo json_encode($array);
		wp_die();
	}

	public function scrape_round_price($number, $round, $type, $side)
	{
		if(empty($number)) {
			return $number;
		}
		
		switch ($type) {
			case 'zero':

				if ($side == 'close') {
					$number = $round * round($number / $round);
				} elseif ($side == 'up') {
					$number = $round * ceil($number / $round);
				} elseif ($side == 'down') {
					$number = $round * floor($number / $round);
				}
				break;

			case 'nine':

				if ($side == 'close') {
					$number = ($round * 10 * round($number / ($round * 10))) - 1;
				} elseif ($side == 'up') {
					$number = ($round * 10 * ceil($number / ($round * 10))) - 1;
				} elseif ($side == 'down') {
					$number = ($round * 10 * floor($number / ($round * 10))) - 1;
				}
				break;

			case 'hybrid':

				if ($side == 'close') {
					$number = ($round * 10 * round($number / ($round * 10))) - $round;
				} elseif ($side == 'up') {
					$number = ($round * 10 * ceil($number / ($round * 10))) - $round;
				} elseif ($side == 'down') {
					$number = ($round * 10 * floor($number / ($round * 10))) - $round;
				}
				break;

			default:
				break;
		}

		return $number;
	}

	public function export_scrape($post_id)
	{
		$data = new stdClass();
		
        // Post Data
        $data->ID = $post_id;
        $data->title = get_the_title($post_id);

        // All Post Data
        $post = get_post($post_id);
        $data->post = $post;

        // All Meta Data
        $meta = get_post_meta($post_id);
        $data->meta = $meta;

		return $data;
	}
	
	public function get_scrape_fields()
	{
		$fields = array(
			'scrape_type',
			'scrape_selector',
			'scrape_google_script_url',
			'scrape_timeout_render',
			'scrape_puppeteer_api_key',
			'scrape_url',
			'scrape_url_single',
			'scrape_listitem',
			'scrape_exact_match',
			'scrape_tags_script',
			'scrape_nextpage',
			'scrape_nextpage_innerhtml',
			'scrape_nextpage_type',
			'scrape_next_page_url_parameters_names',
			'scrape_next_page_url_parameters_values',
			'scrape_next_page_url_parameters_increments',
			'scrape_post_type',
			'scrape_product_type',
			'scrape_categoryxpath_tax',
			'scrape_reader_mode',
			'scrape_tags',
			'scrape_tags_custom',
			'scrape_tags_separator',
			'scrape_tags_type',
			'scrape_tags_regex_status',
			'scrape_tags_regex_finds',
			'scrape_tags_regex_replaces',
			'scrape_featured',
			'scrape_featured_type',
			'scrape_featured_template',
			'scrape_featured_template_status',
			'scrape_featured_regex_status',
			'scrape_featured_regex_finds',
			'scrape_featured_regex_replaces',
			'scrape_featured_gallery',
			'scrape_featured_dont_update',			
			'scrape_custom_fields',
			'scrape_author',
			'scrape_status',
			'scrape_post_password',
			'scrape_change_status',			
			'scrape_date_type',
			'scrape_date_regex_status',	
			'scrape_date_regex_finds',
			'scrape_date_regex_replaces',
			'scrape_date_custom',
			'scrape_date_dont_update',
			'scrape_comment',
			'scrape_unique_type',
			'scrape_unique_title',
			'scrape_unique_content',
			'scrape_unique_url',			
			'scrape_unique_custom',
			'scrape_on_unique',
			'scrape_filters_fields',
			'scrape_filters_operators',
			'scrape_filters_values',
			'scrape_cron_type',
			'scrape_post_limit',
			'scrape_run_limit',
			'scrape_first_run_time',
			'scrape_recurrence',
			'scrape_run_type',
			'scrape_timeout',
			'scrape_waitpage',
			'scrape_stop_running',
			'scrape_onerror',
			'scrape_category',
			'scrape_post_unlimited',
			'scrape_run_unlimited',
			'_edit_lock',
			'scrape_finish_repeat_enabled',
			'scrape_title',			
			'scrape_title_template_status',
			'scrape_title_template',
			'scrape_title_regex_status',
			'scrape_title_regex_finds',
			'scrape_title_regex_replaces',
			'scrape_title_dont_update',
			'scrape_content_type',
			'scrape_template_status',
			'scrape_template',			
			'scrape_content_regex_status',
			'scrape_content_regex_finds',
			'scrape_content_regex_replaces',
			'scrape_allowhtml',
			'scrape_download_images',
			'scrape_excerpt',
			'scrape_excerpt_type',			
			'scrape_excerpt_regex_status',
			'scrape_excerpt_regex_finds',
			'scrape_excerpt_regex_replaces',
			'scrape_excerpt_template_status',
			'scrape_excerpt_template',
			'scrape_excerpt_allowhtml',
			'scrape_excerpt_dont_update',
			'scrape_translate_enable',
			'scrape_translate_source',
			'scrape_translate_target',
			'scrape_spin_enable',
			'scrape_spin_email',
			'scrape_spin_password',
			'scrape_ai_model_enable',
			'scrape_ai_model_service',
			'scrape_ai_model_service_apikey',			
			'scrape_dont_update',
			'scrape_watermark_images',
			'scrape_external_image',
			'scrape_data_src_images',
			'scrape_product_variable',
			'scrape_delete_all_links',
			'scrape_update_price',
			'scrape_update_stock',
			'scrape_update_attr',
			'scrape_existing_fields',
			'scrape_rounding_enable',
			'scrape_rounding_price',
			'scrape_rounding_type',
			'scrape_rounding_side',
			'scrape_translate_sections',
			'scrape_translate_title',
			'scrape_translate_content',
			'scrape_translate_excerpt',
			'scrape_translate_taxonomy',
			'scrape_translate_tags',
			'scrape_translate_fields',
			'scrape_single_fields',
			'scrape_workstatus',
			'scrape_run_count',
			'scrape_continue_type',
			'scrape_sync_run',
			'scrape_start_time',
			'scrape_end_time',
			'scrape_last_scrape',
			'scrape_task_id',
			'scrape_stillworking',
			'scrape_run_time',
			'scrape_queue',
			'scrape_nonce',
			'scrape_last_items',
			'scrape_last_url',
			'scrape_count_post',
			'scrape_page_no'
		);
		
		return $fields;
	}
	
	public function csv_convert($post_ids)
	{
		$columns = array('ID', 'Title');
		
		// Scrapes Fields
		$fields = $this->get_scrape_fields();
		
		foreach($fields as $colmn) {
			$columns[] = stripslashes($colmn);
		}
		
		$output = fopen('php://output', 'w');
		fputcsv($output, $columns);			

		foreach($post_ids as $post_id) {
			
			$data = $this->export_scrape((int) $post_id);
			
			$scrape = array(
				$post_id,
				$data->title
			);
			
			foreach($fields as $field) {
				
				$scrape[] = isset($data->meta[$field][0]) ? $data->meta[$field][0] : '';
			}
			
			fputcsv($output, $scrape);
		}		
	}
	
	public function xml_convert($data)
	{
        // Creating SimpleXMLElement object
        $xml = new SimpleXMLElement('<?xml version="1.0" encoding="' . get_bloginfo( 'charset' ) . '"?><scrapes></scrapes>');
        
        // Convert array to xml
        $this->array_to_xml($data['scrapes'], $xml);
        
        // Return XML String
        return $xml->asXML();		
	}
	
    public function array_to_xml($data, &$xml)
    {
        foreach($data as $key=>$value)
        {
            if(is_numeric($key)) $key = 'item';

            if(is_array($value))
            {
                $subnode = $xml->addChild($key);
                $this->array_to_xml($value, $subnode);
            }
            elseif(is_object($value))
            {
                $subnode = $xml->addChild($key);
                $this->array_to_xml($value, $subnode);
            }
            else
            {
                $xml->addChild($key, htmlspecialchars($value));
            }
        }
    }

	public function import_start($type)
	{
		$feed_file = $_FILES['feed'];
		
        // File is not uploaded
        if(!isset($feed_file['name']) or (isset($feed_file['name']) and trim($feed_file['name']) == '')) return array('success' => 0, 'message' => __('Please upload the file.', 'ol-scrapes'));

        // File Type is not valid
        if( $type == 'xml' )
		{
			if(!isset($feed_file['type']) or (isset($feed_file['type']) and !in_array(strtolower($feed_file['type']), array('text/xml')))) return array('success' => 0, 'message' => __('The file type should be XML.', 'ol-scrapes'));
		} 
		else
		{
			if(!isset($feed_file['type']) or (isset($feed_file['type']) and !in_array(strtolower($feed_file['type']), array('text/csv', 'application/vnd.ms-excel')))) return array('success' => 0, 'message' => __('The file type should be CSV.', 'ol-scrapes'));
		}

        // Upload the File
        $upload_dir = wp_upload_dir();

        $target_path = $upload_dir['basedir'].'/'.basename($feed_file['name']);
        $uploaded = move_uploaded_file($feed_file['tmp_name'], $target_path);

        // Error on Upload
        if(!$uploaded) return array('success' => 0, 'message' => __("An error occurred during the file upload! Please check permissions!", 'ol-scrapes'));

        // Import
        $this->import_do($target_path);

        // Delete File
        unlink($target_path);

        return array('success' => 1, 'message' => __('The scrapes are imported successfully!', 'ol-scrapes'));		
	}
	
	public function import_do($feed)
	{
        // Increase the resources
        @ini_set('memory_limit', '1024M');
        @ini_set('max_execution_time', 300);

		$ex = explode('.', $feed);
		$extension = end($ex);
       
        if(strtolower($extension) == 'xml')
        {
			$xml_string = str_replace(':i:', 'iii', $this->file_read($feed));
			
			$XML = simplexml_load_string($xml_string);
			if($XML === false) return false;
			
            foreach($XML->children() as $scrape)
            {
				$scrape_id = (int) $scrape->ID;
				
                // Scrape Data
                $post_title = (string) $scrape->title;
				$post_meta = $scrape->meta;
				$meta_input = array();
				
				foreach($post_meta as $meta)
				{
					foreach($meta as $key => $value) {
						$meta_key = (string) $key;
						$meta_value = (string) $value->item;
						$meta_input[$meta_key] = $meta_value;
					}
				}
				
				// Insert the scrape
				$post_id = wp_insert_post(array(
					'post_title' => $post_title,
					'post_type' => 'scrape',				
					'post_status' => 'publish'
				));
				
				foreach($meta_input as $key => $value) 
				{					
					$value = maybe_unserialize( $value );
					update_post_meta($post_id, $key, wp_slash($value));
				}
			}
		}
		elseif(strtolower($extension) == 'csv')
		{			
			if(($handle = fopen($feed, 'r')) !== false)
			{
				$keys = fgetcsv($handle);
				while(($data = fgetcsv($handle)) !== false)
				{
					// Insert the scrape
					$post_id = wp_insert_post(array(
						'post_title' => $data[1],
						'post_type' => 'scrape',				
						'post_status' => 'publish'
					));
					
					for ($i = 2; $i <= count($keys) - 1; $i++) {
						$meta_key = $keys[$i];
						$meta_value = maybe_unserialize($data[$i]);
						update_post_meta($post_id, $meta_key, wp_slash($meta_value));
					}									
				}				
			}
		}
	}
	
	public function file_read($filename)
	{
		// Initialise variables.
		$fh = fopen($filename, 'rb');
		
		if(false === $fh) return false;

		clearstatcache();

		if($fsize = @filesize($filename))
		{
			$data = fread($fh, $fsize);
			
			fclose($fh);
			return $data;
		}
		else
		{
			fclose($fh);
			return false;
		}		
	}
	
	public function ai_model_prompt($service, $prompt_string, $api_key, $return_html, $post_id='') {
		global $aimodel;

		$prompt_count = $this->increment_site_transient('scrapes_ai_model_count_' . OL_Scrapes::$task_id);
		$api_key = explode("\n", $api_key);
		$api_key = trim($api_key[$prompt_count % count($api_key)]);		

		OL_Scrapes::write_log('prompt string: ' . $prompt_string);
		OL_Scrapes::write_log($api_key);
		OL_Scrapes::write_log($return_html);

		if($service == 'openai_chatgpt' || $service == 'aimlapi_chatgpt') {
			$api_url = $service == 'openai_chatgpt' ? 'https://api.openai.com/v1/chat/completions' : 'https://api.aimlapi.com/chat/completions';
			OL_Scrapes::write_log('ChatGPT prompt sent.');
			$response = wp_remote_retrieve_body(wp_remote_post(
				$api_url,
				array(
					'headers' => array(
						'Authorization' => 'Bearer ' . $api_key,
						'Content-Type' => 'application/json'
					),
					'body' => json_encode(array(
						'model' => 'gpt-4-turbo',
						'messages' => array(
							array(
								'role' => 'user', 
								'content'=> $prompt_string
							)
						)
					)),
					'timeout' => 300
				)
			));

			if(trim($response) == '') {
				OL_Scrapes::write_log('ChatGPT error empty string is returned ', 'error');
				return $prompt_string;
			}
			
			OL_Scrapes::write_log($response);
			$response = json_decode($response);
        	if(isset($response->error)) {
				OL_Scrapes::write_log($response->error->message, 'error');
				return $prompt_string;				
			} else {
				if(isset($response->choices[0])) {
					$response = $response->choices[0]->message->content;
					if(!empty($post_id)) {
						update_post_meta($post_id, 'scrape_chenge_aimodel', 'yes');
						OL_Scrapes::write_log('ChatGPT update meta post id: ' . $post_id);
					} else {
						$aimodel = true;
					}
				} else {
					OL_Scrapes::write_log($response->message, 'error');
					return $prompt_string;
				}
			}
		}

		if (!$return_html) {
			$response = wp_strip_all_tags($response);
		}
		return $response;
	}

	public function increment_site_transient($name) {
		$transient = get_site_transient($name);
		if($transient === false) {
			set_site_transient($name, 1);
			return 1;
		} else {
			$transient++;
			set_site_transient($name, $transient);
			return $transient;
		}
	}

	public function admin_custom_posts_filters() {
		global $pagenow, $post_type;
		
		$value1 = '';
		$value2 = '';
		$value3 = '';
		$value4 = '';
		
		if( $post_type == 'scrape' || $post_type == 'attachment') {
			return;
		}
		
		if( $pagenow == 'edit.php' ) {
			
			if( isset( $_GET['filter_posts_update'] ) ) {

				switch( $_GET['filter_posts_update'] ) {

					case 'posts_older_updated':
						$value1 = ' selected';
						break;
					case 'posts_newer_updated':
						$value2 = ' selected';
						break;
					case 'chenged_by_aimodel':
						$value3 = ' selected';
						break;
					case 'without_by_aimodel':
						$value4 = ' selected';
						break;						
				}
			}  

			echo '<select name="filter_posts_update">';

			echo '<option value>'. __('Scrapes', 'ol-scrapes') .'</option>';
			echo '<option value="posts_older_updated" ' . $value1 . '>'. __('Older Updated', 'ol-scrapes') .'</option>';
			echo '<option value="posts_newer_updated" ' . $value2 . '>'. __('Newer Updated', 'ol-scrapes') .'</option>';
			echo '<option value="chenged_by_aimodel" ' . $value3 . '>'. __('Chenged by Aimodel', 'ol-scrapes') .'</option>';
			echo '<option value="without_by_aimodel" ' . $value4 . '>'. __('Without by Aimodel', 'ol-scrapes') .'</option>';

			echo '</select>';
		}		
	}
	
	public function apply_custom_posts_filters( $query ) {
		global $pagenow, $post_type;

		if( $post_type == 'scrape' || $post_type == 'attachment') {
			return;
		}
		
		if ( $query->is_admin && $pagenow == 'edit.php' && isset( $_GET['filter_posts_update'] ) && $_GET['filter_posts_update'] != '' ) {

			switch( $_GET['filter_posts_update'] ) {

				case 'posts_older_updated':
					$query->set('meta_key', 'scrape_update_time');
					$query->set('orderby', 'meta_value');
					$query->set('order', 'ASC');
					break;

				case 'posts_newer_updated':
					$query->set('meta_key', 'scrape_update_time');
					$query->set('orderby', 'meta_value');
					$query->set('order', 'DESC');
					break;
					
				case 'chenged_by_aimodel':
					$query->set('meta_query', array(
						array(
							'key' => 'scrape_chenge_aimodel',
							'value' => 'yes',
							'compare' => '='
						)
					));
					$query->set('orderby', 'date');
					$query->set('order', 'DESC');
					break;

				case 'without_by_aimodel':
					$query->set('meta_query', array(
						array(
							'key' => 'scrape_chenge_aimodel',
							'compare' => 'NOT EXISTS'
						)
					));
					$query->set('orderby', 'date');
					$query->set('order', 'DESC');
					break;					
			}		
		}		
	}
}