<?php

/** no direct access **/
if (!defined('ABSPATH'))
	exit;

/**
 * Bargwp External Image class
 * @author Bargwp <info@bargwp.com>
 */

class Scrape_External_Images {
	
	/**
     * Instance of this class. This is a singleton class
     */
	private static $instance = NULL;    
	
	/**
     * Getting instance. This Class is a singleton class
     * @return static
     */	
    public static function instance() {
        // Get an instance of Class
        if(!self::$instance) self::$instance = new self();
        
        // Return the instance
        return self::$instance;
	}	
	
	public function img_js_resize() {
		wp_enqueue_script("ol_img_resize", plugins_url("assets/js/ext-image.js", dirname(__FILE__)), null, OL_VERSION);
	}
	
	public function main_query_attachments($where, \WP_Query $q) {
		global $wpdb;
		if (is_admin() && $q->is_main_query())
			$where .= ' AND ' . $wpdb->prefix . 'posts.post_author <> ' . OL_AUTHOR . ' ';
		else
			$where .= ' AND (' . $wpdb->prefix . 'posts.post_author <> ' . OL_AUTHOR . ' OR  (' . $wpdb->prefix . 'posts.post_author = ' . OL_AUTHOR . ' AND EXISTS (SELECT 1 FROM ' . $wpdb->prefix . 'postmeta WHERE ' . $wpdb->prefix . 'postmeta.post_id = ' . $wpdb->prefix . 'posts.id AND ' . $wpdb->prefix . 'postmeta.meta_key = "_wp_attachment_metadata")))';
		return $where;
	}	
	
	public function scp_replace_attachment_url($att_url, $att_id) {
		if ( $att_url ) {
			return $this->scp_process_url($att_url, $att_id);
		}
		
		return $att_url;
	}

	public function scp_process_url($att_url, $att_id) {
		if (!$att_id)
			return $att_url;

		$att_post = get_post($att_id);

		if (!$att_post)
			return $att_url;

		// jetpack	
		preg_match("/^http[s]*:\/\/[i][0-9][.]wp.com\//", $att_url, $matches);
		if ($matches)
			return $this->scp_process_external_url($att_url, $att_id);

		// internal
		if ($att_post->post_author != OL_AUTHOR)
			return $att_url;

		$url = $att_post->guid;

		$this->scp_fix_legacy($url, $att_id);

		return $this->scp_process_external_url($url, $att_id);
	}

	public function scp_process_external_url($url, $att_id) {
		$post_id = get_post($att_id)->post_parent;

		if (!$post_id)
			return $url;

		$post_thumbnail_id = get_post_thumbnail_id($post_id);
		$post_thumbnail_id = $post_thumbnail_id ? $post_thumbnail_id : get_term_meta($post_id, 'thumbnail_id', true);
		$featured = $post_thumbnail_id == $att_id ? 1 : 0;

		if (!$featured)
			return $url;

		// avoid duplicated call
		if (isset($_POST[$url]))
			return $url;

		$parameters = array();
		$parameters['att_id'] = $att_id;
		$parameters['post_id'] = $post_id;
		$parameters['featured'] = $featured;

		$_POST[$url] = $parameters;
		return $url;
	}	

	public function scp_fix_legacy($url, $att_id) {
		if (strpos($url, ';') === false)
			return;
		$att_url = get_post_meta($att_id, '_wp_attached_file');
		$att_url = is_array($att_url) ? $att_url[0] : $att_url;
		if ($this->scp_starts_with($att_url, ';http') || $this->scp_starts_with($att_url, ';/'))
			update_post_meta($att_id, '_wp_attached_file', $url);
	}

	public function scp_starts_with($text, $substr) {
		return substr($text, 0, strlen($substr)) === $substr;
	}	
	
	public static function thumbnail_url_external_save( $pid, $url, $alt, $featured = true ) {
		
		if( $featured ) {
			if ( ! empty( $url ) ) {
				update_post_meta( $pid, '_ol_thumbnail_ext_url', esc_url($url) );
				if ( ! get_post_meta( $pid, '_thumbnail_id', TRUE ) ) {
					update_post_meta( $pid, '_thumbnail_id', 'by_url' );
				}
			} elseif ( get_post_meta( $pid, '_ol_thumbnail_ext_url', TRUE ) ) {
				delete_post_meta( $pid, '_ol_thumbnail_ext_url' );
				if ( get_post_meta( $pid, '_thumbnail_id', TRUE ) === 'by_url' ) {
					delete_post_meta( $pid, '_thumbnail_id' );
				}
			}
		}
		
		return self::save_url_to_thumbnail( $pid, $alt, $featured, $url );
				
	}	
	
	public static function save_url_to_thumbnail( $post_id, $alt, $featured, $url ) {
        global $wpdb;
		$posts = $wpdb->prefix . 'posts';
		
        if( $featured ) {
			$att_id = get_post_thumbnail_id($post_id);
			$url = get_post_meta( $post_id, '_ol_thumbnail_ext_url', TRUE );
		} else {
			global $wpdb;
			$query = $wpdb->prepare("SELECT ID FROM ".$wpdb->prefix."posts WHERE post_type='attachment' AND guid='%s'", $url );
			$att_id = $wpdb->get_var($query);			
		}
		
		// update
		if (! empty( $att_id )) {
			update_post_meta($att_id, '_wp_attached_file', $url);
			update_post_meta($att_id, '_wp_attachment_image_alt', $alt);
			$wpdb->update($posts, $set = array('post_title' => $alt, 'guid' => $url), $where = array('id' => $att_id), null, null);
		}
		// insert
		else {
			$value = self::get_formatted_value($url, $alt, $post_id);
			self::insert_attachment_by($value);
			$att_id = $wpdb->insert_id;
			if( $featured ) {
				update_post_meta($post_id, '_thumbnail_id', $att_id);
			}
			update_post_meta($att_id, '_wp_attached_file', $url);
			update_post_meta($att_id, '_wp_attachment_image_alt', $alt);
		}
		
		return $att_id;
	}
	
    public static function get_formatted_value($url, $alt, $post_parent) {
        $author = 77777;
		return "(" . $author . ", '" . $url . "', '" . str_replace("'", "", $alt) . "', 'image/jpeg', 'attachment', 'inherit', '" . $post_parent . "', now(), now(), now(), now(), '', '', '', '', '')";
    }

    public static function insert_attachment_by($value) {
        global $wpdb;
		$posts = $wpdb->prefix . 'posts';
		$wpdb->get_results("
            INSERT INTO " . $posts . " (post_author, guid, post_title, post_mime_type, post_type, post_status, post_parent, post_date, post_date_gmt, post_modified, post_modified_gmt, post_content, post_excerpt, to_ping, pinged, post_content_filtered) 
            VALUES " . str_replace('\\', '', $value));
    }	
}