<?php

/** no direct access **/
if (!defined('ABSPATH'))
	exit;

/**
 * Bargwp Admin js css class
 * @author Bargwp <info@bargwp.com>
 */
 
class Scrape_Admin_CssJs {

	/**
     * Instance of this class. This is a singleton class
     */
	private static $instance = NULL;    
	
	/**
     * Getting instance. This Class is a singleton class
     * @return static
     */	
    public static function instance() {
        // Get an instance of Class
        if(!self::$instance) self::$instance = new self();
        
        // Return the instance
        return self::$instance;
	}
	
	public function init_admin_js_css($hook_suffix) {
		wp_enqueue_style("ol_menu_css", plugins_url("assets/css/menu.css", dirname(__FILE__)), null, OL_VERSION);
		
		if (is_object(get_current_screen()) && get_current_screen()->post_type == "scrape") {
			if (in_array($hook_suffix, array('post.php', 'post-new.php'))) {
				wp_enqueue_script("ol_fix_jquery", plugins_url("assets/js/fix_jquery.js", dirname(__FILE__)), null, OL_VERSION);
				wp_enqueue_script("ol_jquery", plugins_url("libraries/jquery-2.2.4/jquery-2.2.4.min.js", dirname(__FILE__)), null, OL_VERSION);
				wp_enqueue_script("ol_jquery_ui", plugins_url("libraries/jquery-ui-1.12.1.custom/jquery-ui.min.js", dirname(__FILE__)), null, OL_VERSION);
				wp_enqueue_script("ol_bootstrap", plugins_url("libraries/bootstrap-3.3.7-dist/js/bootstrap.min.js", dirname(__FILE__)), null, OL_VERSION);
				wp_enqueue_script("ol_angular", plugins_url("libraries/angular-1.5.8/angular.min.js", dirname(__FILE__)), null, OL_VERSION);
				wp_register_script("ol_main_js", plugins_url("assets/js/main.js", dirname(__FILE__)), null, OL_VERSION);
				$translation_array = array(
					'plugin_path' => plugins_url(),
					'media_library_title' => __('Featured image', 'ol-scrapes'),
					'name' => __('Name', 'ol-scrapes'),
					'eg_name' => __('e.g. name', 'ol-scrapes'),
					'eg_value' => __('e.g. value', 'ol-scrapes'),
					'eg_1' => __('e.g. 1', 'ol-scrapes'),
					'value' => __('Value', 'ol-scrapes'),
					'increment' => __('Increment', 'ol-scrapes'),
					'xpath_placeholder' => __("e.g. //div[@id='bargwp']", 'ol-scrapes'),
					'enter_valid' => __("Please enter a valid value.", 'ol-scrapes'),
					'attribute' => __("Attribute", "ol-scrapes"),
					'eg_href' => __("e.g. href", "ol-scrapes"),
					'eg_scrape_value' => __("e.g. [scrape_value]", "ol-scrapes"),
					'template' => __("Template", "ol-scrapes"),
					'btn_value' => __("value", "ol-scrapes"),
					'btn_calculate' => __("calculate", "ol-scrapes"),
					'btn_date' => __("date", "ol-scrapes"),
					'btn_custom_field' => __("custom field", "ol-scrapes"),
					'btn_source_url' => __("source url", "ol-scrapes"),
					'btn_product_url' => __("product url", "ol-scrapes"),
					'btn_cart_url' => __("cart url", "ol-scrapes"),
					'btn_chatgpt' => __("chatgpt", "ol-scrapes"),
					'add_new_replace' => __("Add new find and replace rule", "ol-scrapes"),
					'enable_template' => __("Enable template", "ol-scrapes"),
					'enable_find_replace' => __("Enable find and replace rules", "ol-scrapes"),
					'find' => __("Find", "ol-scrapes"),
					'replace' => __("Replace", "ol-scrapes"),
					'eg_find' => __("e.g. find", "ol-scrapes"),
					'eg_replace' => __("e.g. replace", "ol-scrapes"),
					'select_taxonomy' => __("Please select a taxonomy", "ol-scrapes"),
					'source_url_not_valid' => __("Source URL is not valid.", "ol-scrapes"),
					'post_item_not_valid' => __("Post item is not valid.", "ol-scrapes"),
					'item_not_link' => __("Selected item is not a link", "ol-scrapes"),
					'item_not_image' => __("Selected item is not an image", "ol-scrapes"),
					'allow_html_tags' => __("Allow HTML tags", "ol-scrapes"),
					'Operator' => __("Operator", "ol-scrapes"),
					'Contains' => __("Contains", "ol-scrapes"),
					'Does_not_contain' => __("Does not contain", "ol-scrapes"),
					'Exists' => __("Exists", "ol-scrapes"),
					'Not_exists' => __("Not exists", "ol-scrapes"),
					'Equal_to' => __("Equal_to", "ol-scrapes"),
					'Not_equal_to' => __("Not_equal_to", "ol-scrapes"),
					'Greater_than' => __("Greater_than", "ol-scrapes"),
					'Less_than' => __("Less than", "ol-scrapes"),
					'Field' => __("Field", "ol-scrapes"),
					'Title' => __("Title", "ol-scrapes"),
					'Content' => __("Content", "ol-scrapes"),
					'Excerpt' => __("Excerpt", "ol-scrapes"),
					'Featured_image' => __("Featured image", "ol-scrapes"),
					'Date' => __("Date", "ol-scrapes"),
					'enable_dont_update' => __("Do Not update", "ol-scrapes"),
					'Taxonomy' => __("Taxonomy", "ol-scrapes"),
					'Please_select_a_taxonomy' => __("Please select a taxonomy", "ol-scrapes"),
					'separator' => __("Separator", "ol-scrapes"),
					'eg_comma' => __("e.g. ,", "ol-scrapes"),
					'btn_affiliate' => __("affiliate", "ol-scrapes"),
					'get_json_info' => __("Get Json info", "ol-scrapes"),
					'enable_hierarchally' => __("Enable hierarchally", "ol-scrapes"),
					'download_file' => __("Download file (pdf, mp3, wav, ...)", "ol-scrapes")
				);
				wp_localize_script('ol_main_js', 'translate', $translation_array);
				wp_enqueue_script('ol_main_js');
				wp_enqueue_style("ol_main_css", plugins_url("assets/css/main.css", dirname(__FILE__)), null, OL_VERSION);				
				if (is_rtl()) {
					wp_enqueue_style("ol_rtl_css", plugins_url("assets/css/rtl.css", dirname(__FILE__)), null, OL_VERSION);
				}				
				wp_enqueue_media();
			}
			if (in_array($hook_suffix, array('edit.php'))) {
				wp_enqueue_script("ol_view_js", plugins_url("assets/js/view.js", dirname(__FILE__)), null, OL_VERSION);
				wp_enqueue_style("ol_view_css", plugins_url("assets/css/view.css", dirname(__FILE__)), null, OL_VERSION);
				if (is_rtl()) {
					wp_enqueue_style("view_rtl_css", plugins_url("assets/css/view-rtl.css", dirname(__FILE__)), null, OL_VERSION);
				}
			}
		}
		if (in_array($hook_suffix, array("scrape_page_scrapes-support"))) {
			wp_enqueue_script("ol_fix_jquery", plugins_url("assets/js/fix_jquery.js", dirname(__FILE__)), null, OL_VERSION);
			wp_enqueue_script("ol_jquery", plugins_url("libraries/jquery-2.2.4/jquery-2.2.4.min.js", dirname(__FILE__)), null, OL_VERSION);
			wp_enqueue_script("ol_jquery_ui", plugins_url("libraries/jquery-ui-1.12.1.custom/jquery-ui.min.js", dirname(__FILE__)), null, OL_VERSION);
			wp_enqueue_script("ol_bootstrap", plugins_url("libraries/bootstrap-3.3.7-dist/js/bootstrap.min.js", dirname(__FILE__)), null, OL_VERSION);
			wp_enqueue_script("ol_angular", plugins_url("libraries/angular-1.5.8/angular.min.js", dirname(__FILE__)), null, OL_VERSION);
			wp_enqueue_script("ol_settings_js", plugins_url("assets/js/settings.js", dirname(__FILE__)), null, OL_VERSION);
			wp_enqueue_style("ol_settings_css", plugins_url("assets/css/settings.css", dirname(__FILE__)), null, OL_VERSION);
			wp_enqueue_style("ol_support_css", plugins_url("assets/css/support.css", dirname(__FILE__)), null, OL_VERSION);
			wp_enqueue_script("ol_lity_js", plugins_url("assets/js/lity.min.js", dirname(__FILE__)), null, OL_VERSION);
			wp_enqueue_style("ol_lity_css", plugins_url("assets/css/lity.min.css", dirname(__FILE__)), null, OL_VERSION);
			if(is_rtl()) {
				wp_enqueue_style("ol_support_rtl", plugins_url("assets/css/support-rtl.css", dirname(__FILE__)), null, OL_VERSION);
			}
		}
		if (in_array($hook_suffix, array("scrape_page_import-export"))) {
			wp_enqueue_style("import_export_css", plugins_url("assets/css/import-export.css", dirname(__FILE__)), null, OL_VERSION);
		}
	}	
}