<?php
/*******************************************************************************
*  Title: PHP Link Manager
*  Version: 1 @ June 18, 2010
*  Author: Saeed Fard
*  Website: http://www.phpjunkyard.com
*  Persian translator: Saeed Fard
*  Persian support website: http://Saeed-Fard.com
*  This Script Downloaded in www.yekWeb.com (Saeed Fard)
********************************************************************************
*  COPYRIGHT NOTICE
*  Copyright 2004-2009 Klemen Stirn. All Rights Reserved.
*
*  This script may be used and modified free of charge by anyone
*  AS LONG AS COPYRIGHT NOTICES AND ALL THE COMMENTS REMAIN INTACT.
*  By using this code you agree to indemnify Klemen Stirn from any
*  liability that might arise from it's use.
*
*  Selling the code for this program, in part or full, without prior
*  written consent is expressly forbidden. Using this code, in part or full,
*  to create competing scripts or products is expressly forbidden.
*
*  Obtain permission before redistributing this software over the Internet
*  or in any other medium. In all cases copyright and header must remain
*  intact. This Copyright is in full effect in any country that has
*  International Trade Agreements with the United States of America or
*  with the European Union.
*
*  Removing any of the copyright notices without purchasing a license
*  is illegal! To remove PHPJunkyard copyright notice you must purchase a
*  license for this script. For more information on how to obtain a license
*  please visit the site below:
*  http://www.phpjunkyard.com/copyright-removal.php
*******************************************************************************/

define('IN_SCRIPT',1);
require('settings.php');
include_once('gettext.php');
ini_set('user_agent', 'LinkMan '.$settings['verzija'].' by http://www.phpjunkyard.com');

/* Accepting any more links? */
$lines = @file($settings['linkfile']);
if (count($lines)>$settings['max_links'])
{
    problem(t('We are not accepting any more links at the moment. We appologize for the inconvenience!'));
}

/* Check user input */
$name  = pj_input($_POST['name'],t('Please enter your name!'));
$email = pj_input($_POST['email'],t('Please enter your e-mail address!'));
if (!preg_match('/([\w\-]+\@[\w\-]+\.[\w\-]+)/',$email))
{
    problem(t('Please enter a valid e-mail address!'));
}
$title = pj_input($_POST['title'],t('Please enter the title (name) of your website!'));
if (mb_strlen($title,"utf-8")>50)
{
    problem(t('Title is too long! Limit website title to 50 chars!'));
}

$url   = pj_input($_POST['url'],t('Please enter the URL of your website!'));


$recurl = pj_input($_POST['recurl'],t('Please enter the url where a reciprocal link to our site is placed!'));


/* Compare URL and Reciprocal page URL */
$parsed_url = parse_url($url);
$parsed_rec = parse_url($recurl);
if ($parsed_url['host'] != $parsed_rec['host'])
{
    problemt(t('The reciprocal link must be placed under the same (sub)domain as your link is!'));
}

$url    = str_replace('&amp;','&',$url);
$recurl = str_replace('&amp;','&',$recurl);

$description = pj_input($_POST['description'],t('Please write a short description of your website!'));
if (mb_strlen($description,"utf-8")>200)
{
    problem(t('Description is too long! Description of your website is limited to 200 chars!'));
}

/* Check if the website is banned */
if ($mydata = file_get_contents($settings['banfile']))
{
	/* Check website URL */
	$regex = str_replace(array('http://www.','http://'),'http://(www\.)?',$url);
	$regex = preg_replace('/index\.[^\/]+$/','',$regex);
	$regex = str_replace('/','\/',rtrim($regex,'/'));
	$regex = '/'.$regex.'\/?(index\.[^\/]+)?/i';
	if (preg_match($regex,$mydata))
	{
		problem(t('This website has been permanently banned from our link exchange!'));
	}

	/* Check reciprocal link URL */
	$regex = str_replace(array('http://www.','http://'),'http://(www\.)?',$recurl);
	$regex = preg_replace('/index\.[^\/]+$/','',$regex);
	$regex = str_replace('/','\/',rtrim($regex,'/'));
	$regex = '/'.$regex.'\/?(index\.[^\/]+)?/i';
	if (preg_match($regex,$mydata))
	{
		problem(t('This website has been permanently banned from our link exchange!'));
	}

	unset($mydata);
}

/* Check title and description for possible spam problems */
if (!isset($settings['verzija'])) 
{
die('This code cannot be used outside LinkMan from www.phpjunkyard.com');
}
function pj_checkHTML($html) 
{
    $html = strtolower($html);
	$spam_words_hard = pj_spam_words_hard();    
	foreach ($spam_words_hard as $sw) {        
	if (strpos($html,$sw)!==false) 
	{            
	return false;        
	}    
	}    
	return true;
	}
	function pj_checkTitleDesc($title, $desc, $url, $super) 
	{    
	$title = strtolower($title);    
	$desc  = strtolower($desc);    
	$superlatives    = pj_superlatives();    
	$spam_words_soft = pj_spam_words_soft();    
	$spam_words_hard = pj_spam_words_hard();    
	if ($super) 
	{        
	foreach ($superlatives as $sw) 
	{            
	if (strpos($title,$sw)!==false || strpos($desc,$sw)!==false) 
	{                
	return 'superlatives';            
	}        
	}    
	}    
	foreach ($spam_words_hard as $sw) 
	{        
	if (strpos($title,$sw)!==false || strpos($desc,$sw)!==false) 
	{            
	return 'text';        
	}        
	if (strpos($url,$sw)!==false) 
	{            
	return 'url';        
	}    
	}    
	$myscore = 0;    
	foreach ($spam_words_soft as $sw) 
	{        
	if (strpos($title,$sw)!==false || strpos($desc,$sw)!==false) 
	{            
	$myscore+=50;        
	}    
	}    
	if ($myscore > 100) 
	{        
	return 'text';    
	}    
	return true;
	}
	function pj_spam_words_hard() 
	{    
	return array(    'adipex','advicer','baccarrat','blackjack','bllogspot','booker','byob','carbohydrate','car-rental-e-site','car-rentals-e-site',    'carisoprodol','casino','casinos','cialis ','coolcoolhu','coolhu','credit-report-4u','cwas ','cyclen','cyclobenzaprine',    'dating-e-site','day-trading','debt','debt-consolidation-consultant','drug','discreetordering','duty-free','dutyfree','equityloans','financing',    'fioricet','flowers-leading-site','freenet-shopping','freenet','gambling','gay','health-insurancedeals-4u','homeequityloans','homefinance',    'holdem','holdempoker','holdemsoftware','holdemtexasturbowilson','hotel-dealse-site','hotele-site','hotelse-site','incest',    'insurance-quotesdeals-4u','insurancedeals-4u','jrcreations','levitra','loan','macinstruct','mortgage-4-u','mortgagequotes','online-gambling',    'onlinegambling-4u','ottawavalleyag','ownsthis','palm-texas-holdem-game','paxil','penis','pharmacy','phentermine','poker','poker-chip',    'rental-car-e-site','roulette','sex','shemale','slot-machine',    'texas-holdem','thorcarlson','top-site','top-e-site','tramadol','trim-spa','ultram','valeofglamorganconservatives','viagra',    'vioxx','xanax','zolus ','replica'    );
	}
	function pj_spam_words_soft() 
	{    
	return array(    'affordable','ambien','bargain','buy','chatroom','cheap','insurance','investment','poze',    'pre-approved','soma','taboo','teen','wholesale'    );
	}
	function pj_superlatives() 
	{    
	return array(    'ablest','achiest','acutest','airworthiest','airiest','amplest','angriest','aptest','artiest','ashiest',    'worst','baggiest','baldest','balkiest','balmiest','barest','battiest','beadiest','beastliest','beefiest','best',    'biggest','bitterest','blackest','blandest','blankest','bleakest','bleariest','blindest','blithest','blondest',    'bloodthirstiest','bloodiest','blotchiest','blowziest','bluest','bluntest','blurriest','boggiest','boldest','bonniest',    'boniest','bossiest','botchiest','bounciest','brainiest','brambliest','brashest','brassiest','brattiest','bravest',    'brawniest','breathiest','breeziest','briefest','brightest','briniest','briskest','bristliest','broadest','broodiest',    'brownest','bruskest','bubbliest','bulgiest','bulkiest','bumpiest','bunchiest','burliest','bushiest','busiest',    'cagiest','calmest','campiest','canniest','catchiest','cattiest','chalkiest','chanciest','chastest','chattiest',    'cheapest','cheekiest','cheeriest','cheesiest','chewiest','chilliest','chintziest','choicest','choosiest','choppiest',    'chubbiest','chummiest','chunkiest','civilest','clammiest','classiest','cleanest','cleanliest','clearest','cleverest',    'clingiest','cliquiest','cloddiest','closest','cloudiest','clumpiest','clumsiest','coarsest','coldest','comeliest',    'comfiest','commonest','coolest','corkiest','corniest','costliest','coyest','coziest','crabbiest','crackliest',    'craftiest','craggiest','crankiest','crassest','crawliest','craziest','creakiest','creamiest','creepiest','crinkliest',    'crispest','crispiest','croakiest','crossest','croupiest','cruelest','crummiest','crunchiest','crustiest','cuddliest',    'curliest','curtest','curviest','cushiest','cutest','daffiest','daftest','daintiest','dampest','dandiest',    'dankest','darkest','deadest','deadliest','deafest','dearest','deepest','deftest','demurest','densest',    'dewiest','diciest','dimmest','dingiest','dippiest','direst','dirtiest','dizziest','dopiest','dottiest',    'doughtiest','doughiest','dowdiest','downiest','drabbest','draftiest','dreamiest','dreariest','dressiest','droopiest',    'drowsiest','driest','duckiest','dullest','dumbest','dumpiest','duskiest','dustiest','earliest','earthiest',    'easiest','edgiest','eeriest','emptiest','faintest','fairest','falsest','fanciest','farthest','furthest',    'fastest','fattest','fattiest','faultiest','feeblest','fewest','fiercest','fieriest','filmiest','filthiest',    'finest','firmest','fishiest','fittest','flabbiest','flakiest','flashiest','flattest','fleeciest','fleetest',    'flightiest','flimsiest','flippest','floppiest','fluffiest','foamiest','foggiest','folksiest','fondest','foolhardiest',    'foulest','foxiest','frailest','frankest','freakiest','freest','freshest','friendliest','frizziest','frostiest',    'frothiest','frumpiest','fullest','funkiest','funniest','furriest','fussiest','fuzziest','gabbiest','gamest',    'gamiest','gaudiest','gauntest','gauziest','gawkiest','gentlest','germiest','ghastliest','giddiest','gladdest',    'glairiest','glassiest','gleamiest','glibbest','gloomiest','glossiest','gluiest','glummest','godliest','best',    'goodliest','gooiest','goofiest','goriest','goutiest','grabbiest','grainiest','grandest','grassiest','gravest',    'grayest','greasiest','greatest','greediest','greenest','greyest','grimmest','grimiest','grippiest','gripiest',    'grisliest','grittiest','grizzliest','groggiest','grooviest','grossest','grouchiest','grubbiest','gruffest','grumpiest',    'grungiest','guiltiest','gummiest','gushiest','gustiest','gutsiest','hairiest','hammiest','handsomest','handiest',    'happiest','hardest','hardiest','harshest','hastiest','haughtiest','haziest','headiest','healthiest','heartiest',    'heaviest','heftiest','highest','hippest','hoarsest','hokiest','holiest','homeliest','homiest','hottest',    'huffiest','hugest','humblest','hungriest','huskiest','ickiest','iciest','idlest','illest','inkiest',    'itchiest','jauntiest','jazziest','jerkiest','jolliest','jounciest','juiciest','jumpiest','keenest','kindest',    'kindliest','kingliest','knobbiest','knottiest','kookiest','laciest','lamest','lankest','lankiest','largest',    'latest','laxest','laziest','leafiest','leakiest','leanest','leeriest','lengthiest','lightest','likeliest',    'lintiest','lithest','littlest','liveliest','loamiest','loftiest','loneliest','longest','looniest','loosest',    'lordliest','loudest','lousiest','loveliest','lowest','lowliest','luckiest','lumpiest','maddest','mangiest',    'manliest','marshiest','maturest','mealiest','meanest','measliest','meatiest','meekest','mellowest','merest',    'merriest','messiest','mightiest','mildest','milkiest','mintiest','minutest','mistiest','moistest','moldiest',    'moodiest','mopiest','mossiest','mouldiest','mousiest','mouthiest','muckiest','muddiest','muggiest','murkiest',    'mushiest','mustiest','naivest','narrowest','nastiest','nattiest','naughtiest','nearest','neatest','neediest',    'nerviest','newest','newsiest','nicest','niftiest','nimblest','nippiest','noblest','noisiest','nosiest',    'numbest','nuttiest','obscurest','oddest','oiliest','eldest','oldest','ooziest','palest','palmiest',    'paltriest','pastiest','patchiest','pearliest','pebbliest','peppiest','perkiest','pertest','peskiest','pettiest',    'phlegmiest','phoniest','pickiest','piggiest','pimpliest','pinkest','pithiest','plainest','pluckiest','plumpest',    'plumiest','plushest','pointiest','pokiest','politest','poorest','porkiest','portliest','poshest','prettiest',    'prickliest','primmest','prissiest','profoundest','prosiest','proudest','pudgiest','puffiest','pulpiest','punchiest',    'puniest','purest','pushiest','quaintest','quakiest','queasiest','quickest','quietest','quirkiest','rainiest',    'rangiest','rankest','rarest','raspiest','rattiest','rawest','readiest','realest','reddest','reediest',    'remotest','richest','ripest','riskiest','ritziest','rockiest','roomiest','rosiest','rottenest','roughest',    'rowdiest','ruddiest','rudest','runniest','runtiest','rustiest','saddest','safest','sagest','saggiest',    'saintliest','saltiest','sandiest','sanest','sappiest','sassiest','sauciest','scabbiest','scaliest','scantiest',    'scarcest','scariest','schmaltziest','scraggliest','scrappiest','scratchiest','scrawniest','screechiest','scrimpiest','scrubbiest',    'scruffiest','scurviest','securest','seemliest','severest','shabbiest','shadiest','shaggiest','shakiest','shallowest',    'shapeliest','sharpest','shiftiest','shiniest','shoddiest','shortest','showiest','shrewdest','shrillest','shyest',    'sickest','sickliest','sightliest','silkiest','silliest','siltiest','simplest','sincerest','sketchiest','skinniest',    'slangiest','slaphappiest','sleekest','sleepiest','sleetiest','slenderest','slickest','slightest','slimmest','slimiest',    'slipperiest','sloppiest','sloshiest','slouchiest','slowest','sludgiest','slushiest','sliest','slyest','smallest',    'smartest','smeariest','smelliest','smoggiest','smokiest','smoothest','smudgiest','smuggest','snakiest','snappiest',    'snarliest','sneakiest','sneeziest','snidest','snippiest','snobbiest','snoopiest','snootiest','snowiest','snuggest',    'soapiest','soberest','softest','soggiest','solidest','soonest','sootiest','soppiest','sorest','sorriest',    'soundest','soupiest','sourest','sparest','sparsest','speediest','spiciest','spiffiest','spikiest','spindliest',    'spiniest','splashiest','splotchiest','spongiest','sportiest','spottiest','sprightliest','springiest','spriest','spryest',    'spunkiest','squabbiest','squarest','squashiest','squattiest','squeakiest','squirmiest','stagiest','staidest','stalest',    'starchiest','starkest','starriest','stateliest','steadiest','stealthiest','steamiest','steeliest','steepest','sternest',    'stickiest','stiffest','stillest','stingiest','stinkiest','stockiest','stodgiest','stoniest','stormiest','stoutest',    'straggliest','straightest','strangest','streakiest','stretchiest','strictest','stringiest','strongest','stubbornest','stubbiest',    'stuffiest','stumpiest','stupidest','sturdiest','sudsiest','sulkiest','sultriest','sunniest','supplest','surest',    'surliest','sveltest','swampiest','swankiest','swarthiest','sweatiest','sweetest','swiftest','tackiest','talkiest',    'tallest','tamest','tannest','tangiest','tardiest','tartest','tastiest','tautest','tawdriest','tawniest',    'teariest','teeniest','tensest','tersest','testiest','tetchiest','thickest','thinnest','thirstiest','thorniest',    'threadiest','thriftiest','throatiest','tidiest','tightest','tinniest','tiniest','tipsiest','toothiest','touchiest',    'toughest','trendiest','trickiest','trimmest','tritest','truest','trustiest','twangiest','tweediest','ugliest',    'unhealthiest','unruliest','vaguest','vilest','wackiest','wannest','warmest','wartiest','wariest','waviest',    'waxiest','weakest','wealthiest','weariest','weediest','weepiest','weightiest','weirdest','wettest','wheeziest',    'whiniest','whitest','widest','wildest','wiliest','windiest','wintriest','wiriest','wisest','wispiest',    'wittiest','wobbliest','woodsiest','woodiest','woolliest','wooziest','wordiest','worldliest','wormiest','worthiest',    'wriggliest','wriest','yeastiest','youngest','yummiest','zaniest','zippiest'    );}

if ($settings['spam_filter'])
{
    $test = pj_checkTitleDesc($title, $description, $url, $settings['superlatives']);
    if ($test === true)
    {
        $test = '';
    }
    elseif ($test == 'superlatives')
    {
        problem(t('Don\'t use superlatives (words like best, biggest, cheapest, largest) in title and description!'));
    }
    elseif ($test == 'text')
    {
        problem(t('Your link failed SPAM test, we are forced to reject it.'));
    }
    elseif ($test == 'url')
    {
        problem(t('Your link failed SPAM test, we are forced to reject it.'));
    }
}

if ($settings['autosubmit'])
{
    session_start();
    if (empty($_SESSION['checked']))
    {
        $_SESSION['checked']  = 'N';
        $_SESSION['secnum']   = rand(10000,99999);
        $_SESSION['checksum'] = $_SESSION['secnum'].$settings['filter_sum'].date('dmy');
    }
    if ($_SESSION['checked'] == 'N')
    {
        print_secimg();
    }
    elseif ($_SESSION['checked'] == $settings['filter_sum'])
    {
        $_SESSION['checked'] = 'N';
        $secnumber = pj_isNumber($_POST['secnumber']);
        if(empty($secnumber))
        {
            print_secimg(1);
        }
        if (!check_secnum($secnumber,$_SESSION['checksum']))
        {
            print_secimg(2);
        }
    }
    else
    {
        problem(t('Internal script error. Wrong session parameters!'));
    }
}

/* Check for duplicate links */
if ($settings['block_duplicates'])
{
    $mydata = file_get_contents($settings['linkfile']);

    /* Check website URL */
    $regex = str_replace(array('http://www.','http://'),'http://(www\.)?',$url);
    $regex = preg_replace('/index\.[^\/]+$/','',$regex);
    $regex = str_replace('/','\/',rtrim($regex,'/'));
    $regex = '/'.$regex.'\/?(index\.[^\/]+)?\s/i';
    if (preg_match($regex,$mydata))
    {
        problem(t('Please don\'t submit the same website more than once or we will be forced to delete all your links!'));
    }

    /* Check reciprocal link URL */
    $regex = str_replace(array('http://www.','http://'),'http://(www\.)?',$recurl);
    $regex = preg_replace('/index\.[^\/]+$/','',$regex);
    $regex = str_replace('/','\/',rtrim($regex,'/'));
    $regex = '/'.$regex.'\/?(index\.[^\/]+)?\s/i';
    if (preg_match($regex,$mydata))
    {
        problem(t('Please don\'t submit multiple websites with the same reciprocal link URL or we will be forced to delete all your links!'));
    }

    unset($mydata);
}

/* Get HTML code of the reciprocal link URL */
$html = @file_get_contents($recurl) or problem(t('Can\'t open remote URL!'));
$html = strtolower($html);
$site_url = strtolower($settings['site_url']);

/* Block links with the meta "robots" noindex or nofollow tags? */
if ($settings['block_meta_rob']==1 && preg_match('/<meta([^>]+)(noindex|nofollow)(.*)>/siU',$html,$meta))
{
    problem(
        t('Please don\'t place the reciprocal link to a page with the meta robots noindex or nofollow tag:<br />').
        htmlspecialchars($meta[0])
    );
}

$found    = 0;
$nofollow = 0;

if (preg_match_all('/<a\s[^>]*href=([\"\']??)([^" >]*?)\\1([^>]*)>/siU', $html, $matches, PREG_SET_ORDER)) {
    foreach($matches as $match)
    {
        if ($match[2] == $settings['site_url'] || $match[2] == $settings['site_url'].'/')
        {
            $found = 1;
            if (strstr($match[3],'nofollow'))
            {
                $nofollow = 1;
            }
            break;
        }
    }
}

if ($found == 0)
{
    problem(str_replace("%recurl%",$recurl,str_replace("%site_url%",$settings['site_url'],t('Our URL (<a href="%site_url%">%site_url%</a>) wasn\'t found on your reciprocal links page (<a href="%recurl%">%recurl%</a>)!<br><br>Please make sure you place this exact URL on your links page before submitting your link!'))));
}

/* Block links with rel="nofollow" attribute? */
if ($settings['block_nofollow'] && $nofollow == 1)
{
    problem(t('Please don\'t use rel=&quot;nofollow&quot; link attribute for the reciprocal link!'));
}

/* Check Google PageRank */
if ($settings['show_pr'] || $settings['min_pr'] || $settings['min_pr_rec'])
{
    require('pagerank.php');
    $pr = getpr($url);
    $pr = empty($pr) ? 0 : $pr;

    if ($settings['min_pr'] && ($pr < $settings['min_pr']))
    {
        problem(str_replace("%min_pr%",$settings['min_pr'],t('Unfortunately we accept only websites with Google PageRank %min_pr%/10 or higher. Please try submitting your website again in a few months.')));
    }

    if ($settings['min_pr_rec'])
    {
        $pr_rec = getpr($recurl);
        $pr_rec = empty($pr_rec) ? 0 : $pr_rec;
        if ($pr_rec < $settings['min_pr_rec'])
        {
            problem(str_replace("%min_pr_rec%",$settings['min_pr_rec'],str_replace("%site_url%",$settings['site_url'],t('Please place the reciprocal link to <a href="%site_url%">%site_url%</a> on a page with Google PageRank %min_pr_rec%/10 or higher.'))));
        }
    }
}

$replacement = "$name$settings[delimiter]$email$settings[delimiter]$title$settings[delimiter]$url$settings[delimiter]$recurl$settings[delimiter]$description$settings[delimiter]0$settings[delimiter]$pr\n";

/* Approve manually */
if ($settings['man_approval'])
{
	$tmp = str_replace('www.','',strtolower($parsed_url['host']));
    $tmp = md5($tmp.$settings['filter_sum']);
    $tmp_file = 'apptmp/'.$tmp.'.txt';

    if (file_exists($tmp_file))
    {
    	problem(t('This link is already pending approval!'));
    }

	$fp = fopen($tmp_file,'w') or problem(t('Couldn\'t open temporary file for writing! Please CHMOD the apptmp folder to 777 (rwxrwxrwx)!'));
	flock($fp, LOCK_EX);
	fputs($fp,$replacement);
	flock($fp, LOCK_UN);
	fclose($fp);

$message = '
<html>
<body dir="rtl">
<font face="Tahoma, Arial, Helvetica, sans-serif" size="2">
'.
str_replace("%site-url%",$settings[site_url],str_replace("%name%",$name,str_replace("%email%",$email,str_replace("%url%",$url,str_replace("%recurl",$recurl,str_replace("%title%",$title,str_replace("%description%",$description,str_replace("%url_approval%",$settings[url_approval],str_replace("%tmp%",$tmp,t("Hello,<br /><br />A new link is awaiting approval for your links page at %site-url%<br /><br />Link details:<br /><br />Name: %name%<br />E-mail: %email%<br />URL: %url%<br />Reciprocal link: %recurl%<br />Title: %title%<br />Description:<br />%description%<br /><br />To APPROVE the link visit this URL:<br />%url_approval%?id=%tmp%&approve=1<br /><br />To REJECT the link visit this URL:<br />%url_approval%?id=%tmp%&approve=0<br /><br />End of message")))))))))).
'</font>
</body>
</html>
';
    $headers  = "MIME-Version: 1.0\n";
    $headers .= "Content-type: text/html; charset=utf-8\n";    
	$headers .= "From: $name <$email>\n";
	$headers .= "Reply-To: $name <$email>\n";
	mail($settings['admin_email'],t('New link waiting approval'),$message,$headers);

	require_once('header.php');
	?>
	<p align="center"><b><?php echo t("Your link submitted for approval!"); ?></b></p>
	<p>&nbsp;</p>
	<p align="center"><?php echo t("Thank you, your link has been submitted for approval and will appear on the links page once approved by the administrator!"); ?></p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p align="center"><a href="<?php echo $settings['site_url']; ?>"><?php echo t("Back to the main page") ?></a></p>
	<?php
	require_once('footer.php');
	exit();

}
/* Approve automatically */
else
{
	if ($settings['add_to'] == 0)
	{
	    /* Make sure new link is added after any featured ones */
		$i = 0;
        $was_added = 0;
		foreach ($lines as $thisline)
		{
			list($name2,$email2,$title2,$url2,$recurl2,$description2,$featured2,$pr2)=explode($settings['delimiter'],$thisline);
			$featured2 = $featured2 ? 1 : 0;
			if ($featured2 == 0)
			{
				$lines[$i] = $replacement . $thisline;
                $was_added = 1;
				break;
			}
			$i++;
		}

        if ($was_added)
        {
			$replacement = implode('',$lines);
		    $fp = fopen($settings['linkfile'],'w') or problem(t('Couldn\'t open links file for writing! Please CHMOD all txt files to 666 (rw-rw-rw)!'));
		    flock($fp, LOCK_EX);
		    fputs($fp,$replacement);
		    flock($fp, LOCK_UN);
		    fclose($fp);
        }
		else
		{
		    $fp = fopen($settings['linkfile'],'a') or problem(t('Couldn\'t open links file for appending! Please CHMOD all txt files to 666 (rw-rw-rw)!'));
		    flock($fp, LOCK_EX);
		    fputs($fp,$replacement);
		    flock($fp, LOCK_UN);
		    fclose($fp);
		}
	}
	else
	{
	    $fp = fopen($settings['linkfile'],'a') or problem(t('Couldn\'t open links file for appending! Please CHMOD all txt files to 666 (rw-rw-rw)!'));
	    flock($fp, LOCK_EX);
	    fputs($fp,$replacement);
	    flock($fp, LOCK_UN);
	    fclose($fp);
	}

	if($settings['notify'] == 1)
	{
$message = '
<html>
<body dir="rtl">
<font face="Tahoma, Arial, Helvetica, sans-serif" size="2">
'.
str_replace("%description%",$description,str_replace("%title%",$title,str_replace("%recurl%",$recurl,str_replace("%url%",$url,str_replace("%email%",$email,str_replace("%name%",$name,str_replace("%site_url%",$settings[site_url],
t("Hello,<br /><br />Someone just added a new link to your links page on %site_url%<br /><br />Link details:<br /><br />Name: %name%<br />E-mail: %email%<br />URL: %url%<br />Reciprocal link: %recurl%<br />Title: %title%<br />Description:<br />%description%<br /><br />End of message")))))))).
'</font>
</body>
</html>
';
        $headers  = "MIME-Version: 1.0\n";
        $headers .= "Content-type: text/html; charset=utf-8\n";    
	    $headers .= "From: $name <$email>\n";
	    $headers .= "Reply-To: $name <$email>\n";
	    mail($settings['admin_email'],t('New link submitted'),$message,$headers);
	}

	require_once('header.php');
	?>
	<p align="center"><b><?php echo t("Your link has been added!"); ?></b></p>
	<p>&nbsp;</p>
	<p align="center"><?php echo t("Thank you, your link has been successfully added to our link exchange (try reloading our links page if you don't see your link there yet)!"); ?></p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p align="center"><a href="<?php echo $settings['site_url']; ?>"><?php echo t("Back to the main page"); ?></a></p>
	<?php
	require_once('footer.php');
	exit();
}


/*** FUNCTION ***/

function problem($problem) {
require_once('header.php');
echo '
    <p align="center"><font color="#FF0000"><b>'.t("ERROR").'</b></font></p>
    <p>&nbsp;</p>
    <p align="center">'.$problem.'</p>
    <p>&nbsp;</p>
    <p align="center"><a href="javascript:history.go(-1)">'.t("Back to the previous page").'</a></p>
';
require_once('footer.php');
exit();
}

function print_secimg($message=0) {
global $settings;
$_SESSION['checked']=$settings['filter_sum'];
require_once('header.php');
?>
<p>&nbsp;</p>

<p align="center"><b><?php echo t("Anti-SPAM check"); ?></b></p>

<div align="center"><center>
<table border="0">
<tr>
<td>
    <form action="addlink.php?<?php echo strip_tags(SID); ?>" method="POST" name="form">

    <hr/>
    <?php
    if ($message == 1)
    {
        echo '<p align="center"><font color="#FF0000"><b>'.t("Please type in the security number").'</b></font></p>';
    }
    elseif ($message == 2)
    {
        echo '<p align="center"><font color="#FF0000"><b>'.t("Wrong security number. Please try again").'</b></font></p>';
    }
    ?>

    <p><?php echo t("This is a security check that prevents automated signups of this forum (SPAM). Please enter the security number displayed below into the input field and click the continue button."); ?></p>

    <p>&nbsp;</p>

    <p><?php echo t("Security number"); ?>: <b><?php echo $_SESSION['secnum']; ?></b><br/>
    <?php echo t("Please type in the security number displayed above"); ?>:
    <input type="text" size="7" name="secnumber" maxlength="5" /></p>

    <p>&nbsp;
    <?php
    foreach ($_POST as $k=>$v)
    {
        if ($k == 'secnumber')
        {
            continue;
        }
        echo '<input type="hidden" name="'.htmlspecialchars($k).'" value="'.htmlspecialchars(stripslashes($v)).'">';
    }
    ?>
    </p>

    <p align="center"><input type="submit" value=" <?php echo t('Continue'); ?> " /></p>

    <hr/>

    </form>
</td>
</tr>
</table>
</center></div>

<p>&nbsp;</p>
<p>&nbsp;</p>

<?php
require_once('footer.php');
exit();
}

function check_secnum($secnumber,$checksum) {
    global $settings;
    $secnumber .= $settings['filter_sum'].date('dmy');
    if ($secnumber == $checksum)
    {
        unset($_SESSION['checked']);
        return true;
    }
    else
    {
        return false;
    }
}
?>
