<?php
/**
 * Developer : MahdiY
 * Web Site  : MahdiY.IR
 * E-Mail    : M@hdiY.IR
 */

class PWS_Dokan_Settings {

	public function __construct() {
		add_filter( 'dokan_get_dashboard_settings_nav', [ $this, 'dokan_get_dashboard_settings_nav' ] );
		add_action( 'dokan_settings_content', [ $this, 'dokan_settings_content' ] );
		add_action( 'wp_ajax_pws_save_dokan_shipping', [ $this, 'save_dokan_shipping' ] );
		add_action( 'wp_ajax_nopriv_pws_save_dokan_shipping', [ $this, 'save_dokan_shipping' ] );
	}

	public function dokan_get_dashboard_settings_nav( $settings_sub ) {

		$settings_sub['pws'] = [
			'title'      => 'حمل و نقل ایران',
			'icon'       => '<i class="fa fa-truck"></i>',
			'url'        => dokan_get_navigation_url( 'settings/iran-shipping' ),
			'pos'        => 72,
			'permission' => 'dokan_view_store_shipping_menu'
		];

		return $settings_sub;
	}

	public function save_dokan_shipping() {

		$seller_id = dokan_get_current_user_id();

		if ( ! $seller_id ) {
			die( 'Dont access!' );
		}

		$data = array_filter( $_POST, function( $value ) {
			return empty( $value ) || is_numeric( $value );
		} );

		update_user_meta( $seller_id, 'pws_dokan_shipping', $data );

		die();
	}

	public static function get_option( $option, $seller_id = null ) {

		if ( is_null( $seller_id ) ) {
			$seller_id = dokan_get_current_user_id();
		}

		if ( ! $seller_id ) {
			return null;
		}

		$options = get_user_meta( $seller_id, 'pws_dokan_shipping', true );

		if ( isset( $options[ $option ] ) ) {
			return $options[ $option ];
		}

		return null;
	}

	public function dokan_settings_content() {
		$settings = get_query_var( 'settings' );

		if ( 'iran-shipping' !== $settings ) {
			return;
		}

		$currency_symbol = get_woocommerce_currency_symbol();

		?>

        <div class="dokan-alert dokan-alert-success" style="display:none;">
            <p>اطلاعات شما با موفقیت ذخیره شده است.</p>
        </div>

        <div class="dokan-dashboard-content dokan-settings-content">
            <article class="dokan-settings-area">

                <form method="post" id="shipping-form" action="" class="dokan-form-horizontal" novalidate="novalidate">

                    <input type="hidden" name="action" value="pws_save_dokan_shipping">

                    <!-- Courier -->
                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label">فعالسازی پیک موتوری</label>
                        <div class="dokan-w5 dokan-text-left">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" name="courier_enable" value="1"
										<?php checked( 1, self::get_option( 'courier_enable' ) ); ?>>
                                    جهت فعالسازی پیک موتوری برای این فروشگاه کلیک کنید. </label>
                            </div>
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="courier_base">هزینه پایه (<?php echo $currency_symbol; ?>)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="courier_base" name="courier_base" class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'courier_base' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="courier_per">هزینه به ازای هر
                            کیلوگرم (<?php echo $currency_symbol; ?>)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="courier_per" name="courier_per" class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'courier_per' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="courier_minimum">حداقل خرید (<?php echo $currency_symbol; ?>)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="courier_minimum" name="courier_minimum" class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'courier_minimum' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="courier_free">آستانه حمل رایگان (<?php echo $currency_symbol; ?>)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="courier_free" name="courier_free" class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'courier_free' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="courier_dest">شهر مقصد</label>

                        <div class="dokan-w5 dokan-text-left">
                            <select class="country_to_state dokan-form-control" name="courier_dest"
                                    id="courier_dest">
								<?php

								foreach ( PWS()::states() as $state_id => $state ) {

									foreach ( PWS()::cities( $state_id ) as $city_id => $city ) {
										$selected = selected( $city_id, self::get_option( 'courier_dest' ), false );
										printf( "<option value='%d' %s>%s - %s</option>", $city_id, $selected, $state, $city );
									}

								}

								?>
                            </select>
                        </div>
                    </div>

                    <hr>

                    <!-- Forehand -->
                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label">فعالسازی پست پیشتاز</label>
                        <div class="dokan-w5 dokan-text-left">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" name="forehand_enable" value="1"
										<?php checked( 1, self::get_option( 'forehand_enable' ) ); ?>>
                                    جهت فعالسازی پست پیشتاز برای این فروشگاه کلیک کنید. </label>
                            </div>
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="forehand_extra_fixed">هزینه اضافه
                            (ثابت) (ریال)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="forehand_extra_fixed" name="forehand_extra_fixed"
                                   class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'forehand_extra_fixed' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="forehand_extra_percent">هزینه اضافه
                            (درصد)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="forehand_extra_percent" name="forehand_extra_percent"
                                   class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'forehand_extra_percent' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="forehand_minimum">حداقل خرید (<?php echo $currency_symbol; ?>)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="forehand_minimum" name="forehand_minimum" class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'forehand_minimum' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="forehand_free">آستانه حمل رایگان (<?php echo $currency_symbol; ?>)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="forehand_free" name="forehand_free" class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'forehand_free' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="forehand_source">استان مبدا</label>

                        <div class="dokan-w5 dokan-text-left">
                            <select class="country_to_state dokan-form-control" name="forehand_source"
                                    id="forehand_source">
								<?php

								foreach ( PWS()::states() as $state_id => $state ) {
									$selected = selected( $state_id, self::get_option( 'forehand_source' ), false );
									printf( "<option value='%d' %s>%s</option>", $state_id, $selected, $state );
								}

								?>
                            </select>
                        </div>
                    </div>

                    <hr>

                    <!-- Custom -->
                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label">فعالسازی پست سفارشی</label>
                        <div class="dokan-w5 dokan-text-left">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" name="custom_enable" value="1"
										<?php checked( 1, self::get_option( 'custom_enable' ) ); ?>>
                                    جهت فعالسازی پست سفارشی برای این فروشگاه کلیک کنید. </label>
                            </div>
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="custom_extra_fixed">هزینه اضافه
                            (ثابت) (ریال)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="custom_extra_fixed" name="custom_extra_fixed"
                                   class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'custom_extra_fixed' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="custom_extra_percent">هزینه اضافه
                            (درصد)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="custom_extra_percent" name="custom_extra_percent"
                                   class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'custom_extra_percent' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="custom_minimum">حداقل خرید (<?php echo $currency_symbol; ?>)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="custom_minimum" name="custom_minimum" class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'custom_minimum' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="custom_free">آستانه حمل رایگان (<?php echo $currency_symbol; ?>)</label>

                        <div class="dokan-w5 dokan-text-left">
                            <input id="custom_free" name="custom_free" class="dokan-form-control"
                                   type="number" value="<?php echo self::get_option( 'custom_free' ); ?>">
                        </div>
                    </div>

                    <div class="dokan-form-group">
                        <label class="dokan-w3 dokan-control-label" for="custom_source">استان مبدا</label>

                        <div class="dokan-w5 dokan-text-left">
                            <select class="country_to_state dokan-form-control" name="custom_source"
                                    id="custom_source">
								<?php

								foreach ( PWS()::states() as $state_id => $state ) {
									$selected = selected( $state_id, self::get_option( 'custom_source' ), false );
									printf( "<option value='%d' %s>%s</option>", $state_id, $selected, $state );
								}

								?>
                            </select>
                        </div>
                    </div>

                    <div class="dokan-form-group">

                        <div class="dokan-w4 ajax_prev dokan-text-left" style="margin-left:24%;">
                            <input type="submit" name="update_store_settings"
                                   class="dokan-btn dokan-btn-danger dokan-btn-theme" value="بروز رسانی تنظیمات">
                        </div>
                    </div>
                </form>

                <script type="text/javascript">
					(function ( $ ) {

						$('#shipping-form').submit(function () {

							let url = '<?php echo admin_url( 'admin-ajax.php' ); ?>';
							let data = $('#shipping-form').serialize();

							$.post(url, data, function ( response ) {
								$('.dokan-alert-success').show();
							});

							return false;
						});

					})(jQuery);
                </script>

                <!--settings updated content ends-->
            </article>
        </div>
		<?php
	}

}

new PWS_Dokan_Settings();
