<?php
/**
 * Developer : MahdiY
 * Web Site  : MahdiY.IR
 * E-Mail    : M@hdiY.IR
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( class_exists( 'PWS_Dokan_Method' ) ) {
	return;
} // Stop if the class already exists

class PWS_Dokan_Method extends PWS_Shipping_Method {

	const INSURANCE = 8000;

	const SERVICE = 16000;

	const TAX = 9;

	protected $package = [];

	public function __construct( $instance_id = 0 ) {

		$this->id                 = 'PWS_Dokan_Method';
		$this->instance_id        = absint( $instance_id );
		$this->method_title       = __( 'حمل و نقل ایران' );
		$this->method_description = __( 'ارسال با استفاده از پست سفارشی، پیشتاز یا پیک موتوری - دکان' );

		$this->supports = [
			'shipping-zones',
		];
	}

	public function is_available( $package = [] ): bool {
		return true;
	}

	public function rate( $label, $cost, $package ) {

		if ( $cost === false ) {
			return false;
		}

		$rate = apply_filters( 'pws_add_rate', [
			'id'    => $this->get_rate_id( $label ),
			'label' => __( $label ),
			'cost'  => $cost,
		], $package, $this );

		$this->add_rate( $rate );
	}

	public function total() {
		return $this->package['contents_cost'];
	}

	public function weight() {
		$weight = 0;

		foreach ( $this->package['contents'] as $item ) {
			$weight += wc_get_weight( $item['data']->get_weight() * $item['quantity'], 'g' );
		}

		return $weight;
	}

	public function calculate_shipping( $package = array() ) {

		$this->package = $package;

		$options = get_user_meta( $package['seller_id'], 'pws_dokan_shipping', true );

		if ( isset( $options['courier_enable'] ) && $options['courier_enable'] && $options['courier_minimum'] <= $this->total() && $package['destination']['city'] == $options['courier_dest'] ) {

			if ( $options['courier_free'] !== '' && $options['courier_free'] <= $this->total() ) {

				$this->rate( 'پیک موتوری', 0, $package );

			} else {

				$cost = intval( $options['courier_base'] );

				$cost += ceil( $this->weight() / 1000 ) * intval( $options['courier_per'] );

				$this->rate( 'پیک موتوری', $cost, $package );

			}

		}

		if ( isset( $options['forehand_enable'] ) && $options['forehand_enable'] && $options['forehand_minimum'] <= $this->total() ) {

			if ( $options['forehand_free'] !== '' && $options['forehand_free'] <= $this->total() ) {

				$this->rate( 'پست پیشتاز', 0, $package );

			} else {

				$this->rate( 'پست پیشتاز', $this->forehand( $options, $package ), $package );

			}

		}

		if ( isset( $options['custom_enable'] ) && $options['custom_enable'] && $options['custom_minimum'] <= $this->total() ) {

			if ( $options['custom_free'] !== '' && $options['custom_free'] <= $this->total() ) {

				$this->rate( 'پست سفارشی', 0, $package );

			} else {

				$this->rate( 'پست سفارشی', $this->custom( $options, $package ), $package );

			}

		}
	}

	public function forehand( $options, $package ) {
		$cost = 0;

		$weight = $this->weight();

		// Rate Table
		$rate_price['500']['in']     = 57500;
		$rate_price['500']['beside'] = 78000;
		$rate_price['500']['out']    = 84000;

		$rate_price['1000']['in']     = 74000;
		$rate_price['1000']['beside'] = 100000;
		$rate_price['1000']['out']    = 112000;

		$rate_price['2000']['in']     = 98000;
		$rate_price['2000']['beside'] = 127000;
		$rate_price['2000']['out']    = 140000;

		$rate_price['9999'] = 25000;

		$weight_indicator = '9999';

		switch ( true ) {
			case $weight <= 500:
				$weight_indicator = '500';
				break;
			case $weight > 500 && $weight <= 1000:
				$weight_indicator = '1000';
				break;
			case $weight > 1000 && $weight <= 2000:
				$weight_indicator = '2000';
				break;
		}

		$checked_state = PWS()->check_states_beside( $options['forehand_source'], $package['destination']['state'] );

		if ( $checked_state == false ) {
			return false;
		}

		// calculate
		if ( $weight_indicator != '9999' ) {
			$cost = $rate_price[ $weight_indicator ][ $checked_state ];
		} elseif ( $weight_indicator == '9999' ) {
			$cost = $rate_price['2000'][ $checked_state ] + ( $rate_price[ $weight_indicator ] * ceil( ( $weight - 2000 ) / 1000 ) );
		}

		$cost += self::INSURANCE;
		$cost += self::SERVICE;
		$cost += $cost * 9 / 100;
		$cost += $cost * floatval( $options['forehand_extra_percent'] ) / 100;
		$cost += intval( $options['forehand_extra_fixed'] );

		// Round Up
		$cost = ceil( $cost / 1000 ) * 1000;

		return PWS()->convert_currency( $cost );
	}

	public function custom( $options, $package ) {
		$cost = 0;

		$weight = $this->weight();

		// Rate Table
		$rate_price['500']['in']     = 36800;
		$rate_price['500']['beside'] = 49000;
		$rate_price['500']['out']    = 53000;

		$rate_price['1000']['in']     = 48300;
		$rate_price['1000']['beside'] = 67600;
		$rate_price['1000']['out']    = 72800;

		$rate_price['2000']['in']     = 69000;
		$rate_price['2000']['beside'] = 88000;
		$rate_price['2000']['out']    = 95000;

		$rate_price['9999'] = 10000;

		$weight_indicator = '9999';

		switch ( true ) {
			case $weight <= 500:
				$weight_indicator = '500';
				break;
			case $weight > 500 && $weight <= 1000:
				$weight_indicator = '1000';
				break;
			case $weight > 1000 && $weight <= 2000:
				$weight_indicator = '2000';
				break;
		}

		$checked_state = PWS()->check_states_beside( $options['custom_source'], $package['destination']['state'] );

		if ( $checked_state == false ) {
			return false;
		}

		// calculate
		if ( $weight_indicator != '9999' ) {
			$cost = $rate_price[ $weight_indicator ][ $checked_state ];
		} elseif ( $weight_indicator == '9999' ) {
			$cost = $rate_price['2000'][ $checked_state ] + ( $rate_price[ $weight_indicator ] * ceil( ( $weight - 2000 ) / 1000 ) );
		}

		$cost += self::INSURANCE;
		$cost += self::SERVICE;
		$cost += $cost * 9 / 100;
		$cost += $cost * floatval( $options['custom_extra_percent'] ) / 100;
		$cost += intval( $options['custom_extra_fixed'] );

		// Round Up
		$cost = ceil( $cost / 1000 ) * 1000;

		return PWS()->convert_currency( $cost );
	}
}
