<?php
$why_title = get_field('why_title', 'option');
$why_subtitle = get_field('why_subtitle', 'option');
$text = get_field('why_desc', 'option');
$image = get_field('about_image', 'option');
?>
<section class="about-section py-48" id="about">
    <div class="container-lg">
        <div class="row">
            <div class="col-12 text-center section-head">
                <?php if ($why_title) {
                    echo '<h2 class="section-title">' . $why_title . '</h2>';
                } ?>
                <?php if ($why_subtitle) {
                    echo '<span class="d-block subtitle">' . $why_subtitle . '</span>';
                } ?>
            </div>

            <div class="col-12 gray-box p-0 overflow-hidden">
                <div class="row align-items-center">
                    <div class="col-12 col-md-6 col-lg-5">
                        <?php
                        if ($text != '') {
                            ?>
                            <div class="about-content wow fadeInUp" data-wow-delay="0.5s">
                                <?php echo $text; ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="col-12 col-md-6 col-lg-7 order-md-first">
                        <div class="about-image">
                            <?php if ($image) { ?>
                                <img
                                        src="<?php echo $image['url']; ?>"
                                        width="<?php echo $image['width']; ?>"
                                        height="<?php echo $image['height']; ?>"
                                        alt="<?php echo $image['alt']; ?>"/>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
