/**
 * WordPress dependencies
 */
import { useViewportMatch } from '@wordpress/compose';
import { createInterpolateElement } from '@wordpress/element';
import { __ } from '@wordpress/i18n';

/**
 * SolidWP dependencies
 */
import { TextVariant, TextWeight } from '@ithemes/ui';

/**
 * Internal dependencies
 */
import { ProTag } from '@ithemes/security.pages.settings';
import { ExternalLink } from '@ithemes/security-style-guide';
import { StyledGetPro, StyledGetProText } from './styles';

export default function GetProMalwareScheduling() {
	const isSmall = useViewportMatch( 'small', '<' );

	return (
		<StyledGetPro href="https://go.solidwp.com/scheduled-site-scan-header-cta" target="_blank">
			<StyledGetProText
				weight={ TextWeight.HEAVY }
				variant={ TextVariant.DARK }
				text={ createInterpolateElement(
					__(
						'Level Up Your Site Scanning with <pro/>',
						'LION'
					),
					{ pro: <ProTag as="span" /> }
				) }
			/>
			{ ! isSmall && <ExternalLink /> }
		</StyledGetPro>
	);
}
