<?php
/**
 * Zhaket Smart Updater
 *
 * Plugin Name:  Zhaket Smart Updater
 * Description:  Zhaket Smart Updater, an unique tool for instant update product purchases from zhaket.com. Zhaket is difference...
 * Version:      3.0.0
 * Plugin URI:   https://landing.zhaket.com/festival/zhaket-smart-updater/
 * Author:       zhaket
 * Author URI:   https://zhaket.com
 * Requires at least: 4.6
 * Tested up to: 5.6
 * Text Domain:  zhaket-updater
 * Domain Path:  /languages/
 * Requires PHP: 5.6
 */


defined('ABSPATH') || exit ("no access");

define('ZHUPCLIENT_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('ZHUPCLIENT_PLUGIN_URL', plugin_dir_url(__FILE__));
define('ZHUPCLIENT_PLUGIN_NAME', plugin_basename(__DIR__));
define('ZHUPCLIENT_PLUGIN_ADMIN_STYLE', ZHUPCLIENT_PLUGIN_URL . 'assets/css/');
define('ZHUPCLIENT_PLUGIN_ADMIN_JS', ZHUPCLIENT_PLUGIN_URL . 'assets/js/');
define('ZHAKET_A_LINK','<a href="https://zhaket.com">zhaket.com</a>');
$zhaket_updater_ver='3.0.0';

spl_autoload_register(function ($class){
    $file=ZHUPCLIENT_PLUGIN_DIR.'inc/'.strtolower($class).'.php';
    if (file_exists($file)) require_once($file);
});

add_action('in_admin_header', array('Zhup_Admin_Notice', 'general_notice'), 2);

if (Zhup_Admin_Notice::php_version_status() && Zhup_Admin_Notice::ionCube_active()){
    require_once "vendor/autoload.php";

    ZhUpClient::instance();
    Zhup_backup::get_instance();
    Zhup_plugin_row::get_instance();
    ZhUp_installer::get_instance();
    Zhaket_options::instance();

    register_activation_hook(__FILE__, array('ZhUpClient', 'install'));
    register_deactivation_hook(__FILE__, array('ZhUpClient', 'deactivate'));

    if(!get_option('zhupclient_correct_install',false)){
        if (!get_option('zhupclient_ver',false))
            ZhUpClient::install();
        update_option('zhupclient_correct_install',true);
    }
}