<?php

CSFWPHAMRAH::createSection($prefix, array(
    'parent' => 'home-set',
    'title' => esc_html__('Scroll Menu', 'wp_hamrah'),
    'fields' => array(

        array(
            'id' => 'scrolls_menu',
            'type' => 'group',

            'title' =>  esc_html__('List of menu', 'wp_hamrah'),
            'fields' => array(
                array(
                  'id'=>'title',
                  'type'=>'text',
                    'title' =>  esc_html__('Title', 'wp_hamrah'),
                ),
                array(
                    'id'    => 'img',
                    'type'  => 'upload',
                    'title' =>  esc_html__('Image', 'wp_hamrah'),
                    'library'      => 'image',
                    'preview' => true,
                ),
                array(
                    'id'          => 'shape',
                    'type'        => 'select',
                    'title' =>  esc_html__('Shape', 'wp_hamrah'),
                    'options'     => array(
                        'flat'  => esc_html__('Flat','wp_hamrah'),
                        'circle'  => esc_html__('Circle','wp_hamrah'),
                        'radius'  => esc_html__('Round corner','wp_hamrah'),

                    ),
                ),
                array(
                    'id'          => 'type',
                    'type'        => 'select',
                    'title' =>  esc_html__('type', 'wp_hamrah'),
                    'options'     => array(
                        'no_link'  => esc_html__('Only image without link','wp_hamrah'),
                        'link'  => esc_html__('External link','wp_hamrah'),
                        'product_cat'  => esc_html__('Product category','wp_hamrah'),
                         'product'  => esc_html__('Product','wp_hamrah'),
                         'page'  => esc_html__('Page','wp_hamrah'),
                    ),
                ),
                //------------ Link --------
                array(
                    'id'          => 'val_link',
                    'type'        => 'text',
                    'title'       => esc_html__('value','wp_hamrah'),
                    'desc'=>esc_html__('The link must be entered with http or https','wp_hamrah'),
                    'validate' => 'csf_validate_url',
                    'dependency' => array( 'type', '==', 'link' )
                ),
                 
                //-------- Category product ----
                array(
                    'id'          => 'val_product_cat',
                    'type'        => 'select',
                    'title'       => esc_html__('value','wp_hamrah'),
                    'placeholder' => esc_html__('Select a category','wp_hamrah'),
                    'dependency' => array( 'type', '==', 'product_cat' ),
                    'chosen'      => true,
                    'options'     => 'categories',
                    'ajax' => true,
                    'query_args'  => array(
                        'taxonomy'  => 'product_cat',
                    ),

                ),
                 
                //-------- product ----
                array(
                    'id'          => 'val_product',
                    'type'        => 'select',
                    'title'       => esc_html__('value','wp_hamrah'),
                    'placeholder' => esc_html__('Select a Product','wp_hamrah'),
                    'dependency' => array( 'type', '==', 'product' ),
                    'chosen'      => true,
                    'options'     => 'posts',
                    'ajax' => true,
                    'query_args'  => array(
                        'post_type'  => 'product',
                    ),
                ),
                
                //-------- Page ----
                array(
                    'id'          => 'val_page',
                    'type'        => 'select',
                    'title'       => esc_html__('value','wp_hamrah'),
                    'placeholder' => esc_html__('Select a Page','wp_hamrah'),
                    'dependency' => array( 'type', '==', 'page' ),
                    'chosen'      => true,
                    'options'     => 'pages',
                    'ajax' => true,
                ),

            ),
        ),

    ),

));

