<?php
CSFWPHAMRAH::createSection($prefix, array(
    'parent' => 'home-set',
    'title' => __('Custom list', 'wp_hamrah'),
    'fields' => array(
        array(
            'id' => 'list_custom_list',
            'type' => 'group',

            'title' => esc_html__('Custom list', 'wp_hamrah'),
            'fields' => array(
                array(
                    'id' => 'title',
                    'type' => 'text',
                    'title' => esc_html__('Title', 'wp_hamrah'),
                ),
                array(
                    'id' => 'subtitle',
                    'type' => 'text',
                    'title' => esc_html__('Subtitle', 'wp_hamrah'),
                ),
                array(
                    'id' => 'design',
                    'type' => 'select',
                    'title' => esc_html__('Design', 'wp_hamrah'),
                    'options' => array(
                        '1' => esc_html__('Design 1', 'wp_hamrah'),
                        '2' => esc_html__('Design 2', 'wp_hamrah'),
                    ),
                ),
                array(
                    'id' => 'type',
                    'type' => 'select',
                    'title' => esc_html__('type', 'wp_hamrah'),
                    'options' => array(
                        'new' => esc_html__('New products', 'wp_hamrah'),
                        'best' => esc_html__('Best sell', 'wp_hamrah'),
                        'product_cat' => esc_html__('Product category', 'wp_hamrah'),
                        'product_tag' => esc_html__('Product tag', 'wp_hamrah'),
                        'product' => esc_html__('Product', 'wp_hamrah'),
                    ),
                ),

                array(
                    'id' => 'val_ns',
                    'type' => 'number',
                    'title' => esc_html__('Quantity', 'wp_hamrah'),
                    'dependency' => array('type', 'any', 'new,best'),

                ),
                array(
                    'id' => 'val_product_cat',
                    'type' => 'select',
                    'title' => esc_html__('value', 'wp_hamrah'),
                    'placeholder' => esc_html__('Select a category', 'wp_hamrah'),
                    'chosen' => true,
                    'ajax'        => true,
                    'dependency' => array('type', '==', 'product_cat'),
                    'options' => 'categories',
                    'query_args' => array(
                        'taxonomy' => 'product_cat',
                    ),

                ),
                
                
                array(
                    'id' => 'val_product_tag',
                    'type' => 'select',
                    'title' => esc_html__('value', 'wp_hamrah'),
                    'placeholder' => esc_html__('Select a Tag', 'wp_hamrah'),
                    'chosen' => true,
                    'ajax'        => true,
                    'dependency' => array('type', '==', 'product_tag'),
                    'options' => 'tags',
                    'query_args' => array(
                        'taxonomy' => 'product_tag',
                    ),

                ),
                array(
                    'id' => 'val_product',
                    'type' => 'select',
                    'title' => esc_html__('value', 'wp_hamrah'),
                    'placeholder' => esc_html__('Select a Product', 'wp_hamrah'),
                    'dependency' => array('type', '==', 'product'),
                    'chosen' => true,
                    'ajax'        => true,
                    'multiple' => true,
                    'options' => 'posts',
                    'query_args' => array(
                        'post_type' => 'product',
                    ),
                ),

            ),
        ),


    )
));

