@if(\Modules\Product\Entities\Product::whereNotNull('sale_price')->count())
    <div class="container mt-5 mb-5">
        <div class="widget-wrapper br-1 bg-theme-default">
            <div class="title-box">
                <div class="title-wrapper">
                    <h3 class="title title-line fw-bolder text-white">
                                فروش ویژه
                    </h3>
                </div>
            </div>
            @include('product::frontend.product-carousel' , [
                'nav' => 'true',
                'nav_dots' => 'true',
                'loop' => 'true',
                '_0_size_items_count' => 1,
                '_480_size_items_count' => 2,
                '_576_size_items_count' => 2,
                '_768_size_items_count' => 3,
                '_992_size_items_count' => 4,
                '_1200_size_items_count' => 5,
                 'products' => \Modules\Product\Entities\Product::whereNotNull('sale_price')->get()
                ])
        </div>
    </div>

@endif

<!--Start of Product Carousel-->
@foreach(\Modules\Main\Entities\Main::orderBy('order' , 'asc')->get() as $main)
    @if($main->is_dark)
        <section class="dark-background">
            @endif
            <div class="container mt-5 mb-5 @if(!$main->is_dark) single-product @endif">
                <div class="title-box">
                    <div class="title-wrapper">
                        <div class="iconic-title">
                            <div class="d-flex align-items-center">
                                <h3 class="title @if($main->is_dark)  text-white @endif">{{$main->title}}</h3>
                            </div>
                        </div>
                        <a href="{{route('product-category.show' , $main->category->slug)}}" type="button" class="d-flex align-items-center btn btn-default br-1 font-size-half">
                            مشاهده همه
                            <i class="fi fi-rr-arrow-small-left line-height-0"></i>
                        </a>
                    </div>
                    @include('product::frontend.product-carousel' , [
                'nav' => 'true',
                'nav_dots' => 'true',
                'loop' => 'false',
                '_0_size_items_count' => 1,
                '_480_size_items_count' => 2,
                '_576_size_items_count' => 2,
                '_768_size_items_count' => 2,
                '_992_size_items_count' => 3,
                '_1200_size_items_count' => 4,
                 'products' => get_products_from_category($main->category)
                ])
                </div>
            </div>
            @if($main->is_dark)
        </section>
    @endif
@endforeach
<!--End Of Product Carousel-->
