@component('frontend.layouts.components.page' , ['title' => 'سبد خرید'])
    @slot('breadcrumb')
        <li class="tm-breadcrumb-item">سبد خرید</li>
    @endslot
    <div class="container px-3 my-5 clearfix">
        <!-- Shopping cart table -->
        <div class="row">
            <div class="col-md-9 position-relative">
                @if(isset($productWithZeroInventory))
                    <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                        <div class="media">
                            <div class="alert-left-icon-big">
                                <span><i class="mdi mdi-alert"></i></span>
                            </div>
                            <div class="media-body">
                                <h5 class="mt-1 mb-2">خطا!</h5>
                                @foreach($productWithZeroInventory as $error)
                                    <p style="font-weight: 500">
                                        متاسفانه محصول
                                    <strong class="mb-0 text-danger fw-bold">"{{$error->title}}"</strong>
                                    به علت عدم موجودی کافی از سبد خرید شما حذف شده است. پوذش ما را برای این مورد بپذیرید
                                    </p>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif
                @include('cart::frontend.partials.content')
            </div>
            <div class="col-md-3">
                @include('cart::frontend.partials.sidebar')
            </div>
        </div>
    </div>
@endcomponent
