@component('backend.layouts.components.main',['title' => 'افزودن مجوز جدید','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">افزودن مجوز جدید</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات مجوز</h4>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <input name="name" type="text"
                           class="form-control input-rounded @error('name') is-invalid @enderror" placeholder="عنوان"
                           form="store" required value="{{old('name')}}">
                    @error('name')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
                <div class="">
                    <form action="{{route('admin.permissions.store')}}" method="post" id="store">
                        @csrf
                        @method('post')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">توضیحات</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control input-rounded" name="label"/>
                                @error('label')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif


        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.permissions.index')}}" role="button" class="btn btn-xs btn-info light"
                   title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای ایجاد پروژه جدید، روی دکمه "ساختن" کلیک کنید.
                </p>

                <div class="row">
                    <button class="btn btn-success btn-sm btn-block light"
                            onclick="document.getElementById('store').submit()">
                        <i class="fa fa-save"></i>
                        ساختن
                    </button>
                </div>
            </div>
        </div>
    </div>
    {{-- Sidebar End --}}



    {{-- Scripts --}}
@section('script')
    <script src="/backend/vendor/nestable2/js/jquery.nestable.min.js"></script>

@stop

@section('head')
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/vendor/nestable2/css/jquery.nestable.min.css') }}">
@stop
@endcomponent
