/*! Virtualizor (c) (Softaculous Ltd.) virtualizor.com/license */
/*! HAProxy JS*/
/*! Used in haproxy_theme.php, managevps_theme.php and virtualizor.js */
/*! Created On: 11 May 2017 */

var $vpses, $supported_protocols, $haproxydata, $arr_haproxy_src_ips, $servers;

var vdf_elems = ["protocol", "src_hostname", "src_port", "dest_ip", "dest_port"];
var vdf_row_cols = ["protocol", "src_hostname", "src_port", "dest_ip", "dest_port", "id", "vpsuuid", "serid"];
var is_admin;
var vdf_url;
var vdf_vpsuuid;
var vdf_serid;
var vdf_edit_ico, vdf_save_ico, vdf_delete_ico, vdf_revert_ico;
var cur_vps;

// Add search feature to select input
function add_chosen(id){
	
	// This creates chosen list;
	$('#'+id+' .virt-select').select2({width:"100%"});	
}

function listvpsforwardertbl(){//-

	var $tmp_ha = {};
	var alert_entries = {};
	for(x in $haproxydata){
		$tmp_ha[x] = {};
		
		if(is_admin != undefined){
			$tmp_ha[x]['id'] = '<span id="'+$haproxydata[x]['id']+'_id"><span class="coldat">'+$haproxydata[x]['id']+'</span></span>';
			$tmp_ha[x]['vpsuuid'] = '<span id="'+$haproxydata[x]['id']+'_vpsuuid"><span class="coldat">'+$haproxydata[x]['vpsid']+'&nbsp;('+$vpses[$haproxydata[x]['vpsuuid']]['hostname']+')</span></span>';
			$tmp_ha[x]['serid'] = '<span id="'+$haproxydata[x]['id']+'_serid"><span class="coldat">'+$servers[$haproxydata[x]['serid']]['server_name']+'</span></span>';
		}
		
		$tmp_ha[x]['protocol'] = '<span id="'+$haproxydata[x]['id']+'_protocol"><span class="coldat">'+$haproxydata[x]['protocol']+'</span></span>';
		$tmp_ha[x]['src_hostname'] = '<span id="'+$haproxydata[x]['id']+'_src_hostname"><span class="coldat">'+$haproxydata[x]['src_hostname']+'</span></span>';
		$tmp_ha[x]['src_port'] = '<span id="'+$haproxydata[x]['id']+'_src_port"><span class="coldat">'+$haproxydata[x]['src_port']+'</span></span>';
		$tmp_ha[x]['dest_ip'] = '<span id="'+$haproxydata[x]['id']+'_dest_ip"><span class="coldat">'+$haproxydata[x]['dest_ip']+'</span></span>';
		$tmp_ha[x]['dest_port'] = '<span id="'+$haproxydata[x]['id']+'_dest_port"><span class="coldat">'+$haproxydata[x]['dest_port']+'</span></span>';
		$tmp_ha[x]['actions'] = '<span class="vdf_actions" id="'+$haproxydata[x]['id']+'_vdf_actions"><span class="vdf_edit" id="'+$haproxydata[x]['id']+'_edit"><i class="'+vdf_edit_ico+'"  onclick="edit_row(this, '+$haproxydata[x]['id']+');" tooltip="{{vdf_tooltip_edit}}" ></i></span><span class="vdf_delete"><i class="'+vdf_delete_ico+'" onclick="vdf_confirm('+$haproxydata[x]['id']+');" tooltip="{{vdf_tooltip_delete}}" ></i></span></span>';
		$tmp_ha[x]['select_all'] = '<span id="'+$haproxydata[x]['id']+'_checkbox"><input type="checkbox" class="ios" name="vdf_list[]" value="'+$haproxydata[x]['id']+'"/>';
		
	}
	
	var cols = new Object();
	if(is_admin != undefined){
		cols["id"] = {"l" : "{{id}}", "centered" : true};
		cols["vpsuuid"] = {"l" : "{{vdf_vpsid}}", "centered" : true};
		cols["serid"] = {"l" : "{{vdf_serid}}", "centered" : true};
	}
	
	cols["protocol"] = {"l" : "{{vdf_proto}}", "centered" : true};
	cols["src_hostname"] = {"l" : "{{vdf_src_hname}}", "centered" : true};
	cols["src_port"] = {"l" : "{{vdf_src_port}}", "centered" : true};
	cols["dest_ip"] = {"l" : "{{vdf_dest_ip}}", "centered" : true};
	cols["dest_port"] = {"l" : "{{vdf_dest_port}}", "centered" : true};
	cols["actions"] = {"l" : "{{actions}}", "centered" : true, "class" : "tbl_actions"};
	cols["select_all"] = {"l" : '<input type="checkbox" class="select_all" name="select_all" id="select_all" onclick=\"vdf_select_all();\" />', "centered" : true};

	// Form the TABLE
	table({'id' : 'vdf_tbl_div', 'tid' : 'vps_forwarders_tbl', "width" : '100%'}, cols, $tmp_ha);
	apply_data_table('vps_forwarders_tbl');
	
	$(".scrollbar-virt").scrollbar();
	$('#vdf_tbl_div select[name="vps_forwarders_tbl_length"]').on('change', update_record_alerts);
	$('#vdf_tbl_div .paginate_button').on('click', update_record_alerts);
	update_record_alerts();
};

function update_record_alerts(){
	$('#vdf_tbl_div .paginate_button').on('click', update_record_alerts);
	
	$('#vps_forwarders_tbl tr').each(function(i,t){
		if(i == 0){
			return;
		}
		
		var $span = $(t).find('td span[id$="protocol"]');
		
		if($span.length == 0) {
			return;
		}
		
		var x = parseInt($span.attr("id").split('_')[0]);
		
		if($haproxydata[x]['skipped_json'] != undefined){
			var str = '{{vdf_skipped_msg}}'+"\n";
			
			var s = JSON.parse($haproxydata[x]['skipped_json']);
			
			$(t).css('background-color', '#ffdada');
			
			if(s.haproxy_reservedports != undefined){
				str += '{{vdf_skipped_haproxy_reservedports}}'+"\n";
			}
			if(s.haproxy_reservedports_http != undefined){
				str += '{{vdf_skipped_haproxy_reservedports_http}}'+"\n";
			}
			if(s.haproxy_allowedports != undefined){
				str += '{{vdf_skipped_haproxy_allowedports}}'+"\n";
			}
			
			$(t).attr('title', str);
		}
	});
}



function edit_row(self, vdfid){
	
	var vpsips = (empty(is_admin) ? $vpses[vdf_vpsuuid]['ips'] : '');
	
	if(!empty(is_admin)){
		processing_symb(1);
	
		POST({
			url: vdf_url,
			data: 'vpsuuid='+$haproxydata[vdfid]['vpsuuid']+'&action=getvpsips',
		}, function(data){
			processing_symb();
			edit_row_afterips(self, vdfid, data.vpsips);
			
		});
		return;
	}
	
	edit_row_afterips(self, vdfid, vpsips);
	
};

function edit_row_afterips(self, vdfid, vpsips){
	var coleditelms = {};
	coleditelms["protocol"] = "<span class=\"coledit\">";
	coleditelms["protocol"] += "<select id=\""+vdfid+"_protocol_edit\" class=\"virt-select\" onchange=\"handleprotochange(this, "+vdfid+");\">";
	$.each($supported_protocols, function(i,t){
		coleditelms["protocol"] += "<option value=\""+t+"\" "+($("#"+vdfid+"_protocol .coldat").html() == t ? "selected=\"selected\"" : "")+">"+t+"</option>";
	});
	coleditelms["protocol"] += "</select></span>";
	
	coleditelms["src_hostname"] = "<span class=\"coledit\">";
	coleditelms["src_hostname"] += "<input id=\""+vdfid+"_src_hostname_edit\" type=\"text\" class=\"form-control\" value=\""+$("#"+vdfid+"_src_hostname .coldat").html()+"\" />";
	coleditelms["src_hostname"] += "</span>";
	
	coleditelms["src_port"] = "<span class=\"coledit\">";
	coleditelms["src_port"] += "<input id=\""+vdfid+"_src_port_edit\" type=\"text\" class=\"form-control\" value=\""+$("#"+vdfid+"_src_port .coldat").html()+"\" />";
	coleditelms["src_port"] += "</span>";
	
	coleditelms["dest_ip"] = "<span class=\"coledit\">";
	coleditelms["dest_ip"] += "<select id=\""+vdfid+"_dest_ip_edit\" class=\"virt-select\">";
	
	$.each(vpsips, function(i,t){
		coleditelms["dest_ip"] += "<option value=\""+i+"\" "+($("#"+vdfid+"_dest_ip .coldat").html() == i ? "selected=\"selected\"" : "")+">"+i+"</option>";
	});
	coleditelms["dest_ip"] += "</select></span>";
	
	coleditelms["dest_port"] = "<span class=\"coledit\">";
	coleditelms["dest_port"] += "<input id=\""+vdfid+"_dest_port_edit\" type=\"text\" class=\"form-control\" value=\""+$("#"+vdfid+"_dest_port .coldat").html()+"\" />";
	coleditelms["dest_port"] += "</span>";
	
	
	$.each(coleditelms, function(i, t){
		$("#"+vdfid+"_"+i+" .coledit").remove();
		$("#"+vdfid+"_"+i).append(coleditelms[i]);
		$("#"+vdfid+"_"+i+" .coldat").css("display", "none");
		$("#"+vdfid+"_"+i+" .coledit").css("display", "block");
	});
	
	var revertimg = "<i class=\""+vdf_revert_ico+"\" onclick=\"revert_vdf(this, "+vdfid+");\" data-toggle=\"tooltip\" data-placement=\"auto\" title=\"{{vdf_tooltip_revert}}\" ></i><i class=\""+vdf_save_ico+"\" onclick=\"save_vdf(this);\" data-toggle=\"tooltip\" data-placement=\"auto\" title=\"{{vdf_tooltip_save}}\" ></i>";
	$("#"+vdfid+"_edit").append(revertimg);
	$(self).remove();
	
	$("#"+vdfid+"_protocol select").trigger("change");
	$(".virt-select").select2({width:"100%"});
	// Add search feature to select and adjust select height
	$(document).ready(function(){
		show_tooltip();
	});
};

function save_vdf(self){
	
	var vdfid = $(self).parents().eq(1).attr("id").split("_")[0];
	
	// Get vdf data to post
	var postdata = {};
	postdata['id'] = encodeURIComponent(vdfid);
	postdata['action'] = 'editvdf';
	
	if(is_admin != undefined){
		postdata['vpsuuid'] = encodeURIComponent($haproxydata[vdfid]["vpsuuid"]);
		postdata['serid'] = encodeURIComponent($haproxydata[vdfid]["serid"]);
	}
	$.each(vdf_elems, function(i,t){
		postdata[t] = encodeURIComponent($("#"+vdfid+"_"+t+"_edit").val());
	});
	processing_symb(1);
	// Post the data
	POST({
		url: vdf_url,
		data: $.param(postdata),
	}, function(data){	
		processing_symb();
		
		if('done' in data){
			
			// Update row with new values
			$.each(vdf_row_cols, function(i,t){
				$("#"+vdfid+"_"+t+" .coldat").html($("#"+vdfid+"_"+t+"_edit").val());
				
				// If this record was skipped previously then remove tooltip and change its background-color
				if($haproxydata[vdfid]['skipped'] != undefined){
					$('#'+vdfid+'_protocol').parents().filter('tr').eq(0).attr('title', '');
					$('#'+vdfid+'_protocol').parents().filter('tr').eq(0).css('background-color', '');
				}
				
			});
			// Show new values set in .coldat
			revert_vdf(self, vdfid);
		}
	});
	
};

function revert_vdf(self, vdfid){
	
	$.each(vdf_row_cols, function(i, t){
		$("#"+vdfid+"_"+t+" .coledit").remove();
		$("#"+vdfid+"_"+t+" .coldat").css("display", "block");
	});
	
	var editimg = "<i class=\""+vdf_edit_ico+"\" onclick=\"edit_row(this, "+vdfid+");\" data-toggle=\"tooltip\" data-placement=\"auto\" title=\"{{vdf_tooltip_edit}}\" ></i>";
	
	$("#"+vdfid+"_edit *").remove();
	$("#"+vdfid+"_edit").append(editimg);
	
};

// This function processes delete VDF records
function vdf_confirm(vdfid ,ele = 1){
	
	vdfid = vdfid || 0;
	
	vdfids = new Array();
	
	selopts = $("#haproxy_multiselect_action_"+ele+" option");
	selectvals = new Array();

	for(i=0; i<selopts.length; i++){
		val = selopts.eq(i).val();
		if(val != 0){
			selectvals.push(val);
		}
	}
	
	confirmmsg = ["{{vdf_conf_del_entries}}"];
	selectIndx = selectvals.indexOf($("#haproxy_multiselect_action_"+ele).val());

	if(vdfid < 1){

		if(selectIndx == -1){
			showalert("{{vdf_no_act_sel}}" ,"1");
			return false;
		}
	
		$("#vps_forwarders_tbl .ios:checked").each(function(i, t) {
			vdfids.push($(this).val());
		});
	
	}else{
		vdfids.push(vdfid);
		selectIndx = 0;
	}
	
	if(vdfids.length < 1){
		showalert("{{nothing_selected}}" ,"1");
		return false;
	}

	showalert(confirmmsg[selectIndx] ,"3" ,function(confirm){
		if(confirm != true){
			return false;
		}else{
			var finalids = new Object();

			//finalids["action"] = selectvals[selectIndx];
			finalids["ids"] = vdfids.join(",");
			finalids["action"] = "delvdf";
			
			$("#progress_bar").show();
			
			processing_symb(1);
			// Post the data
			POST({
				url: vdf_url,
				data: $.param(finalids),
			}, function(data){	
				processing_symb();
				if('done' in data){
					setTimeout(function(){
						if(is_admin != undefined){
							$("#alert-modal").on("hidden.bs.modal", function (e) {
							location.reload(true);
							});
							return;
						}
						$.each(vdfids, function(i, t){
							delete $haproxydata[t];
						});
						listvpsforwardertbl();
					} ,200);
					
				}
			});
		}
	});	
};

function handleprotochange(self, vdfid){
	
	//2 = TCP
	if($(self).val() == 'TCP'){
		var $arr_src_ips = $arr_haproxy_src_ips;
		if(is_admin != undefined){
			$arr_src_ips = $servers[$haproxydata[vdfid]['serid']]['arr_haproxy_src_ips'];
		}
		// List source IPs as src_hostname
		var str = "";
		str = "<span class=\"coledit\">";
		str += "<select id=\""+vdfid+"_src_hostname_edit\" class=\"form-control virt-select\">";
		$.each($arr_src_ips, function(i,t){
			str += "<option value=\""+t+"\" "+(t == $("#"+vdfid+"_src_hostname .coldat").html() ? "selected=\"selected\"" : "")+">"+t+"</option></span>";
		});
		str += "</select></span>";	
		
	// HTTP or HTTPS
	}else{
		//src_hostname
		str = "<span class=\"coledit\">";
		str += "<input id=\""+vdfid+"_src_hostname_edit\" type=\"text\" class=\"form-control\" value=\""+$("#"+vdfid+"_src_hostname .coldat").html()+"\" />";
		str += "</span>";
	}
	$("#"+vdfid+"_src_hostname .coledit").remove();
	$("#"+vdfid+"_src_hostname").append(str);
	
	// add search feature to select
	add_chosen("vps_forwarders_tbl");
	
};

function processaddvdfform(self){
	var id = $(self).attr("id");
	
	if(is_admin != undefined){
		
		if(id == "serid"){
			var str = "";
			var serid = parseInt($("#serid").val());
			
			str = "<option value=\"-1\">"+$l["vdf_select_vps"]+"</option>";
			
			processing_symb(1);
			POST({
				url: vdf_url,
				data: 'serid='+serid+'&action=getvps',
			}, function(data){
				processing_symb();
				if('done' in data){
					if(data.vpses != undefined){
						$.each(data.vpses, function(i,t){
							cur_vps = data.vpses;
							if(t["serid"] == serid){
								str += "<option value=\""+i+"\">"+t['vpsid']+" - "+t['hostname']+" ( "+t["vps_name"]+" )</option>";
							}
						});
						$("#vpsuuid").html(str);
					}
				}
			});
			
			$("#protocol").trigger("change");
			return true;
		}
		
		if(id == "vpsuuid"){
			var str = "";
			$("#dest_ip").html('');
			
			var vpsuuid = $("#vpsuuid").val();
			if(cur_vps[vpsuuid] == undefined){
				// update select dest ips list
				return;
			}
			
			str = "<option value=\"-1\">"+$l["vdf_select_ip"]+"</option>";
			
			processing_symb(1);
			POST({
				url: vdf_url,
				data: 'vpsuuid='+vpsuuid+'&action=getvpsips',
			}, function(data){
				processing_symb();
				if('done' in data){
					if(data.vpsips != undefined){
						$.each(data.vpsips, function(i,t){
							str+= "<option value=\""+i+"\">"+i+"</option>";
						});
					}
					$("#dest_ip").html(str);
				}
			});
			return true;
		}
		
	}
	
	if(id == "protocol"){
		var str = "";
		var parent = $("#src_hostname").parent();
		// 2 = TCP
		if($(self).val() == "TCP"){
			var $arr_src_ips = $arr_haproxy_src_ips;
			if(is_admin != undefined){
				var serid = $("#serid").val();
				if($servers[serid] == undefined){
					showalert("{{vdf_no_server_found}}" ,"1");
					return;
				}else{
					$arr_src_ips = $servers[serid]["arr_haproxy_src_ips"];
				}
			}
			
			str = "<label class=\"control-label\" for=\"protocol\">{{vdf_src_hname}}</label><select class=\"form-control virt-select\" id=\"src_hostname\" name=\"src_hostname\">";
			str += "<option value=\"-1\">{{vdf_select_ip}}</option>";
			$.each($arr_src_ips, function(i,t){
				str += "<option value=\""+t+"\">"+t+"</option>";
			});
			str += "</select>";
			$("#src_port").val("");
			$("#dest_port").val("");
			$(parent).parent().children().eq(0).children().eq(0).text("{{vdf_src_ip}}");
			
		// https or http
		}else{
			str = "<label class=\"control-label\" for=\"protocol\">{{vdf_src_hname}}</label><input type=\"text\" id=\"src_hostname\" class=\"form-control\" name=\"src_hostname\"/>";
			if($(self).val() == "HTTP"){
				$("#src_port").val("80");
				$("#dest_port").val("80");
			}else if($(self).val() == "HTTPS"){
				$("#src_port").val("443");
				$("#dest_port").val("443");
			}
			$(parent).parent().children().eq(0).children().eq(0).text("{{vdf_src_dom}}");
			
		}
		// Remove old before adding updated one
		$("#src_hostname").remove();
		
		$(parent).html(str);
		
		// add search feature to select
		add_chosen("addvdf_form_div");
		return true;
	}
	if(id == "submitaddvdf"){
					
		// Post the data
		processing_symb(1);
		POST({
			url: vdf_url,
			data: $("#addvdf").serialize(),
		}, function(data){
			processing_symb();
			if('done' in data){
				
				if(is_admin != undefined){
						$("#alert-modal").on("hidden.bs.modal", function (e) {
						location.reload(true);
						});
						return;
				}
				
				var id = parseInt(data.done.id);
				
				// set vpsuuid and serid of the entry if this is called on admin page.
				// For other page call, this values will be already set.
				if(is_admin != undefined){
					vdf_vpsuuid = $("#vpsuuid").val();
					vdf_serid = $("#serid").val();
				}
				
				$haproxydata[id] = {
					"id" : id,
					"vpsuuid" : vdf_vpsuuid,
					"serid" : vdf_serid,
					"protocol" : $("#protocol").val(),
					"src_hostname" : $("#src_hostname").val(),
					"src_port" : $("#src_port").val(),
					"dest_ip" : $("#dest_ip").val(),
					"dest_port" : $("#dest_port").val()
				}
				
				listvpsforwardertbl();
				
			}
		});
	}
}

function showvdfform(){
	var str = "";
	var ips = {};
	
	// Reset form
	$("#addvdf").trigger("reset");
	
	// Populate servers and vps list for admin page only
	if(is_admin != undefined){
		var str = "";
		str = "<option value=\"-1\">"+$l["select_server"]+"</option>";
		
		$.each($servers, function(i,t){
			str += "<option value=\""+i+"\">"+t["server_name"]+"</option>";
		});
		$("#serid").html(str);
		
	}else{
		// Get VPS IPs to be shown in form
		ips = $vpses[vdf_vpsuuid]["ips"];
	}
	
	// Populate protocols list
	str = "<option value=\"-1\">{{vdf_sel_proto}}</option>";
	$.each($supported_protocols, function(i, t){
		str += "<option value=\""+t+"\">"+t+"</option>";
	});
	$("#protocol").html(str);

	// Populate VPS IPs list
	str = "";
	str = "<option value=\"-1\">{{vdf_select_ip}}</option>";
	
	$.each(ips, function(i,t){
		str+= "<option value=\""+i+"\">"+i+"</option>";
	});
	$("#dest_ip").html(str);
	
	
	// Show form
	$("#addvdf_form_div").css("display", "block");
	$("#showaddvdfformbtn").hide();
	
	// add search feature to select
	add_chosen("addvdf_form_div");
}

function vdf_select_all(){
	$("#managevdf_body .ios").each(function(){
		if($_("select_all").checked){
			$(this).prop("checked", true);
		}else{
			$(this).prop("checked", false);
		}
	});
}

// Creates the TABLE
function apply_data_table(fp_tid){
	
	$('#'+fp_tid).dataTable({
		"language": {
			"lengthMenu": "{{show}} _MENU_ {{entries}}",
			"search": "{{search}}:",
			"info": "{{showing}} _START_ {{to}} _END_ {{of}} _TOTAL_ {{entries}}",
			"infoEmpty": "{{showing}} 0 {{to}} 0 {{of}} 0 {{entries}}",
			"zeroRecords": "{{no_data_avail}}",
			"emptyTable": "{{no_data_avail}}",
			"infoFiltered": "({{filtered_from}} _MAX_ {{total_entries}})",
			"paginate": {
				"first":"{{first}}",
				"last":"{{last}}",
				"next":"{{next}}",
				"previous":"{{previous}}"
			}
		}
	});
};

function processing_symb(show){
	if(show == 1){
		$("#processing_symb").css('display','block');
	}else{
		$("#processing_symb").css('display','none');
	}
}