<?php
require_once(__DIR__ . '/../../../init.php');

use \WHMCS\Service\Service;
use \WHMCS\Database\Capsule;
use WHMCS\View\Menu\Item as MenuItem;

if (!defined('WHMCS')) {
    die('This hook should not be run directly');
}
add_hook('AfterModuleCreate', 1, function (array $vars) {
    $productID = $vars["params"]["pid"];
    $sql = "select * from mod_WHMCSResellers where  product_id=" . $productID;
    $result = full_query($sql);
    if (mysql_num_rows($result) > 0) {
        $table = "mod_WHMCSResellers_service";
        $values = array(
            "service_id" => $vars["params"]["serviceid"],
            "start_time" => date("Y-m-d H:i:s"),
            "last_calculated" => date("Y-m-d H:i:s"),
            "last_service_calculated" => date("Y-m-d H:i:s"),

            "last_traffic" => 0,
            "status" => 'Active',
            "created_at" => date("Y-m-d H:i:s")
        );
        $newid = insert_query($table, $values);
    }
});
add_hook('AfterModuleSuspend', 1, function (array $vars) {
    $sql = "select * from mod_WHMCSResellers_service where    service_id=" . $vars["params"]["serviceid"];
    $result = full_query($sql);
    if (mysql_num_rows($result) > 0) {
        $values = [
            "status" => 'Suspended',
            "updated_at" => date("Y-m-d H:i:s")
        ];
        Capsule::table('mod_WHMCSResellers_service')
            ->where('service_id', '=', $vars["params"]["serviceid"])
            ->update($values);
    }
});
add_hook('AfterModuleTerminate', 1, function (array $vars) {
    $sql = "select * from mod_WHMCSResellers_service where    service_id=" . $vars["params"]["serviceid"];
    $result = full_query($sql);
    if (mysql_num_rows($result) > 0) {
        $values = [
            "status" => 'Terminated',
            "updated_at" => date("Y-m-d H:i:s")
        ];
        Capsule::table('mod_WHMCSResellers_service')
            ->where('service_id', '=', $vars["params"]["serviceid"])
            ->update($values);
    }
});
add_hook('AfterModuleUnsuspend', 1, function (array $vars) {
    $sql = "select * from mod_WHMCSResellers_service where    service_id=" . $vars["params"]["serviceid"];
    $result = full_query($sql);
    if (mysql_num_rows($result) > 0) {
        $values = [
            "status" => 'Active',
            "updated_at" => date("Y-m-d H:i:s")
        ];
        Capsule::table('mod_WHMCSResellers_service')
            ->where('service_id', '=', $vars["params"]["serviceid"])
            ->update($values);
    }
});
add_hook('AdminClientServicesTabFields', 1, function ($vars) {

    $productID = Capsule::table('tblhosting')
        ->where("id", "=", $vars["id"])
        ->value('packageid');

    $HourlyIsActive = Capsule::table('mod_WHMCSResellers')
        ->where("product_id", "=", $productID)
        ->first();
    if (count($HourlyIsActive) > 0) {
        $HourlyServiceIsActive = Capsule::table('mod_WHMCSResellers_service')
            ->where("service_id", "=", $vars["id"])
            ->first();
        if (count($HourlyServiceIsActive) > 0) {
            $output = "<a class='btn btn-danger'>Deactive Hourly Billing</a>";
        } else {
            $output = "<a class='btn btn-danger'>Deactive Hourly Billing</a>";
        }
        return ["aa" => $output];
    }
});
add_hook('PreModuleCreate', 1, function ($vars) {
    $productID = $vars["params"]["pid"];
    $record_list = Capsule::table('mod_WHMCSResellers')
        ->select('*')
        ->where('product_id', '=', $productID)
        ->orderBy('id', 'DESC')
        ->get();

    if (count($record_list) > 0) {
        foreach ($record_list as $data) {
            $record_count = Capsule::table('mod_KelonCloudPayAsYouGo_balance')
                ->where("userid", "=", $vars["params"]["userid"])
                ->first();
            if (count($record_count) == 1) {
                if (intval($record_count->balance) >= intval($data->minimum_balance)) {
                    //can Create
                } else {
                    return array(
                        'result' => "ERROR",
                        'abortcmd' => true,
                    );
                }
            } else {
                $table = "mod_KelonCloudPayAsYouGo_balance";
                $values = array(
                    "userid" => $vars["params"]["userid"],
                    "created_at" => date("Y-m-d H:i:s"),
                    "balance" => 0
                );
                $newid = insert_query($table, $values);
                return array(
                    'result' => "ERROR",
                    'abortcmd' => true,
                );
            }
        }
    }
});
add_hook('ClientAreaPrimaryNavbar', 1, function (MenuItem $primaryNavbar) {
    require_once(__DIR__ . '/lang/farsi.php');
    // echo "<textarea>".__DIR__."</textarea>";
    if (!is_null($primaryNavbar->getChild('Billing'))) {
        $primaryNavbar->getChild('Billing')
            ->addChild($_ADDONLANG['MenuText'] . "", array(
                'label' => $_ADDONLANG['MenuText'] . "",
                'uri' => 'index.php?m=WHMCSResellers',
                'order' => '0',
            ));
    }

    if (isset($_SESSION["uid"])) {
        $balance = Capsule::table('mod_KelonCloudPayAsYouGo_balance')
            ->where("userid", '=', $_SESSION["uid"])
            ->value('balance');
        $message = "اعتبار سرویس ساعتی شما :" .
            number_format($balance) . ' ریال';
        $icon = '<i class="fa-solid fa-cloud"></i>';
        $primaryNavbar->addChild('cloudhourly', array(
            'label' => $message
        ))
            ->setOrder(90);
        // $primaryNavbar->getChild('cloudhourly')
        //     ->addChild($message, array(
        //         'label' => $message,
        //         'order' => '0',
        //     ));
    }
});
add_hook('InvoicePaid', 1, function ($vars) {
    $log = "START INVOICE PAID" . date("Y-m-d H:i:s") . "\n";
    $invoiceID = $vars["invoiceid"];
    $record_list = Capsule::table('mod_KelonCloudPayAsYouGo_invoice')
        ->select('*')
        ->where('invoice_id', '=', $invoiceID)
        ->first();
    $log .= "INVOICE ID: " . $invoiceID;
    $log .= "\nGET INVOICE DETAILS: " . json_encode($record_list);

    if (count($record_list) == 1) {
        $command = 'GetInvoice';
        $postData = array(
            'invoiceid' => $invoiceID,
        );
        $invoiceDetails = localAPI($command, $postData);
        $userID = $invoiceDetails["userid"];
        $record_count = Capsule::table('mod_KelonCloudPayAsYouGo_balance')
            ->where("userid", "=", $userID)
            ->first();
        $log .=  "\nGET INVOICE USERID: " . json_encode($record_count);

        if (count($record_count) == 1) {
            if ($record_count->balance > 0 && $record_list->amount > ($record_count->balance * -1)) {
                require_once(__DIR__ . '/WHMCSResellers.php');
                $unsuspendoutput = WHMCSResellers_UnsuspendServices($userID);
                $log .=  "\nGET Unsuspend  User : " . $unsuspendoutput;
            }
            if ($record_list->status == "unpaid") {
                $values = array(
                    "updated_at" => date("Y-m-d H:i:s"),
                    "balance" => intval($record_count->balance) +
                        intval($record_list->amount)
                );
                Capsule::table('mod_KelonCloudPayAsYouGo_balance')
                    ->where('userid', '=', $userID)
                    ->update($values);
            }
        } else {
            $table = "mod_KelonCloudPayAsYouGo_balance";
            $values = array(
                "userid" => $userID,
                "created_at" => date("Y-m-d H:i:s"),
                "balance" => intval($record_list->amount)
            );
            insert_query($table, $values);
        }
        $values = array(
            "updated_at" => date("Y-m-d H:i:s"),
            "status" => "paid"
        );
        Capsule::table('mod_KelonCloudPayAsYouGo_invoice')
            ->where('invoice_id', '=', $invoiceID)
            ->update($values);
    }
    $log .=  "\n END LOG : " .    date("Y-m-d H:i:s");;
    file_put_contents(filename: "/home/keloncloud/cl.keloncloud.com/modules/addons/WHMCSResellers/unsuspend.log", $log . "\n", FILE_APPEND);
});
add_hook('AfterCronJob', 1, function ($vars) {
    require_once(__DIR__ . '/WHMCSResellers.php');
    WHMCSResellers_bandwidthcalculator();
    WHMCSResellers_disableserversbybalance();
});

add_hook('ClientAreaProductDetailsOutput', 1, function ($vars) {

    $id = $vars["service"]["id"];
    $productID = Capsule::table('tblhosting')
        ->where("id", "=", $vars["service"]["id"])
        ->value('packageid');
    $ip = $vars["service"]["dedicatedip"];
    $HourlyIsActive = Capsule::table('mod_WHMCSResellers')
        ->where("product_id", "=", $productID)
        ->first();
    if (count($HourlyIsActive) == 0) {

        return;
    }
    $out .= '
      <div class="panel panel-primary">
      
          <div class="panel-body">
          <div class="row">
                <div class="col-sm-4">
                   لطفا جهت تایید  IP سرور خود را وارد نمایید 
                </div>
                 
               ';

    $out .= '   
                 
                    <div class="col-sm-4">
                       <input type="text"  id="txtip" class="form-control"/>
                    </div>
                    <div class="col-sm-4">
                        <a class="btn btn-danger" onclick="deleteserver()" >حذف</a>
                    </div>
                    <div class="row" id="disp"></div>
                </div>
                
                <script>
                        function deleteserver(){ 
                         $("body").append("<div id=\'loading\'>  <img id=\'loading-image\' src=\'/modules/addons/WHMCSResellers/image/loader.gif\' alt=\'Loading...\' /></div>");
                                var serverip = "' . $ip . '";
                                var ip=$("#txtip").val();
                                var id = ' . $id . ';
                                var action = "delete";
                                if(ip != serverip){
                                    alert("IP وارد شده اشتباه است");
                                    return;
                                }
                                $.ajax({
                            url:"/modules/addons/WHMCSResellers/request.php",
                            type:"POST",
                               data:{
                              ip: ip,
                              id: id,
                              action:action
                            },
                            success:function(response) {
                                var returnedData = JSON.parse(response);
                                if(returnedData.status=="error"){
                                    document.getElementById("disp").innerHTML ="<div class=\'alert alert-danger\'><strong>"+returnedData.message+"</strong></div>";
                                }
                                else{
                                    document.getElementById("disp").innerHTML ="<div class=\'alert alert-success\'><strong>"+returnedData.message+"</strong></div>";
                                    
                                }
                            $("#loading").remove();
                          
                           },
                           error:function(){
                            alert("error");
                           }
                    
                          }) 
                        }
                    
                
                
                </script>
                ';


    $record_count = Capsule::table('mod_KelonCloudPayAsYouGo_log')->where("service_id", "=", $id)->count();
    $offset = 20;
    $offsets = $record_count / $offset;
    if (!$_GET['page']) {
        $page = 1;
    } else {
        $page = $_GET['page'];
    }

    $modulelink = $_SERVER['REQUEST_URI'];

    $HTMLpagePagination = "";
    if ($record_count < $offset + 1) {
        $HTMLpagePagination .= '<div class="clearfix">';
        $HTMLpagePagination .= '<div class="hint-text pull-left">Showing <b>' . $record_count . '</b> out of <b>' . $record_count . '</b> pages</div>';
        $HTMLpagePagination .= '</div>';
    }
    if ($record_count > $offset) {
        $HTMLpagePagination .= '<div class="clearfix">';
        if ($page * $offset < $record_count) {
            $HTMLpagePagination .= '<div class="hint-text pull-left">Showing <b>' . $page * $offset . '</b> out of <b>' . $record_count . '</b> pages</div>';
        } else {
            $HTMLpagePagination .= '<div class="hint-text pull-left">Showing <b>' . $record_count . '</b> out of <b>' . $record_count . '</b> pages</div>';
        }
        $HTMLpagePagination .= '<ul style="margin:0px 0px" class="pagination pull-right">';
        $HTMLpagePagination .= '<li class="page-item "><a href="' . $modulelink . '&page=1">First</a></li>';
        if ($page < 2) {
            $HTMLpagePagination .= '<li class="page-item disabled"><a href="#">Previous</a></li>';
        } else {
            $HTMLpagePagination .= '<li class="page-item"><a href="' . $modulelink . '&page=' . ($page - 1) . '">Previous</a></li>';
        }
        if ($page - 2 > 0) {
            $HTMLpagePagination .= '<li class="page-item"><a href="' . $modulelink . '&page=' . ($page - 2) . '" class="page-link">' . ($page - 2) . '</a></li>';
        }
        if ($page - 1 > 0) {
            $HTMLpagePagination .= '<li class="page-item"><a href="' . $modulelink . '&page=' . ($page - 1) . '" class="page-link">' . ($page - 1) . '</a></li>';
        }
        $HTMLpagePagination .= '<li class="page-item active"><a href="' . $modulelink . '&page=' . ($page) . '" class="page-link">' . ($page) . '</a></li>';
        if ($page + 1 < $offsets + 1) {
            $HTMLpagePagination .= '<li class="page-item"><a href="' . $modulelink . '&page=' . ($page + 1) . '" class="page-link">' . ($page + 1) . '</a></li>';
        }
        if ($page + 2 < $offsets + 1) {
            $HTMLpagePagination .= '<li class="page-item"><a href="' . $modulelink . '&page=' . ($page + 2) . '" class="page-link">' . ($page + 2) . '</a></li>';
        }
        if ($page + 1 < $offsets + 1) {
            $HTMLpagePagination .= '<li class="page-item"><a href="' . $modulelink . '&page=' . ($page + 1) . '" class="page-link">Next</a></li>';
        } else {
            $HTMLpagePagination .= '<li class="page-item disabled"><a href="#" class="page-link">Next</a></li>';
        }
        $HTMLpagePagination .= '<li class="page-item "><a href="' . $modulelink . '&page=' . intVal($offsets + 1) . '" class="page-link">Last</a></li>';
        $HTMLpagePagination .= '</ul>';
        $HTMLpagePagination .= '</div>';
    }



    $RequestList = "<table class='table'><tr><td>#</td><td>توضیحات</td>
        <td>هزینه</td>
        <td>مالیات</td>
        <td>تاریخ</td</tr>
        ";
    $record_list = Capsule::table('mod_KelonCloudPayAsYouGo_log')
        ->where("service_id", "=", $id)
        ->select('*')
        ->offset(($page - 1) * $offset)
        ->limit($offset)
        ->orderBy('id', 'DESC')
        ->get();

    foreach ($record_list as $data) {
        $RequestList .= "<tr >
                                        <td>#</td>
                                        <td>" . $data->description . "</a></td>
                                        <td>" . number_format($data->amount) . "</a></td> 
                                        <td>" . number_format($data->tax) . "</td>
                                        <td>" . $data->created_at . "</td>
                                    </tr>";
    }
    $RequestList .= "</table>" . $HTMLpagePagination;
    $out .= ' <div class="accordion" id="accordionUsage">
      <div class="card">
        <div class="card-header" id="HeadingUsage">
          <h2 class="mb-0">
            <button class="btn btn-link" type="button" data-toggle="collapse" aria-expanded="false" data-target="#UsageDet"  aria-controls="UsageDet">
              گزارش مصرف سرور
            </button>
          </h2>
        </div>
    
        <div id="UsageDet" class="collapse" aria-labelledby="HeadingUsage" data-parent="#accordionUsage">
          <div class="card-body">
                ' . $RequestList . '
    
          </div>
        </div>
      </div>
  </div>
  
  
  
  ';

    return $out;
});

add_hook('ShoppingCartValidateProductUpdate', 1, function ($vars) {
    $cc = 0;

    foreach ($vars["customfield"] as $p => $l) {
        $cc = $p;
    }
    if ($cc > 0) {

        $productID = Capsule::table('tblcustomfields')
            ->where("id", "=", $cc)
            ->value('relid');

        $HourlyIsActive = Capsule::table('mod_WHMCSResellers')
            ->where("product_id", "=", $productID)
            ->first();



        if (count($HourlyIsActive) == 1) {
            if (!isset($_SESSION["uid"])) {
                return [
                    'برای خرید سرویس های ساعتی ابتدا وارد پنل کاربری شوید'
                ];
            }
            $balance = Capsule::table('mod_KelonCloudPayAsYouGo_balance')
                ->where("userid", "=", $_SESSION["uid"])
                ->first();
            if (intval($balance->balance) < intval($HourlyIsActive->minimum_balance)) {
                return [
                    'حداقل اعتبار خرید این سرویس ' . number_format($HourlyIsActive->minimum_balance) . ' است
                                لطفا اعتبار خود را ابتدا افزایش دهید و سپس اقدام به ثبت سفارش نمایید',


                ];
            }
        }
    }
});
