<?php


require_once(__DIR__ . '/../../../../../../init.php');

use WHMCS\Database\Capsule;

header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] != 'POST') {
    http_response_code(405);
    echo json_encode(array("status" => "error",$_SERVER['REQUEST_METHOD'] , "message" => "Method not allowed"));
    exit();
}
if (!isset($_SERVER['HTTP_APIKEY']) || empty($_SERVER['HTTP_APIKEY'])) {
    http_response_code(401);
    echo json_encode(array("status" => "error", "message" => "API key is missing"));
    exit();
}
if (!isset($_SERVER['HTTP_DOMAIN']) || empty($_SERVER['HTTP_DOMAIN'])) {
    http_response_code(401);
    echo json_encode(array("status" => "error", "message" => "Domain is missing"));
    exit();
}
$apikey = $_SERVER['HTTP_APIKEY'];
$domain = $_SERVER['HTTP_DOMAIN'];
$apikey = trim($apikey);
$apikey = str_replace(" ", "", $apikey);

//remove protocol from domain
$domain = str_replace("http://", "", $domain);
$domain = str_replace("https://", "", $domain);
$domain = trim($domain);
$domain = strtolower($domain);
$domain = str_replace(" ", "", $domain);


$whmcsresellers = Capsule::table('mod_WHMCSResellers')
    ->where('apikey', $apikey)
    ->where('domain', $domain)
    ->first();
if (!$whmcsresellers) {

    http_response_code(401);
    echo json_encode(array("status" => "error", "message" => "Invalid API key"));
    exit();
}
//return reseller credit
//check if status is suspended
if ($whmcsresellers->status != "Active") {
    http_response_code(401);
    echo json_encode(array(
        "status" => "error",
        "ResellerStatus" => $whmcsresellers->status,
        "message" => "Reseller is "        . $whmcsresellers->status,
    ));
    exit();
}
$credit = $whmcsresellers->credit;
$credit = floatval($credit);
$credit = number_format($credit);
//return reseller credit
echo json_encode(array("status" => "success", "credit" => $credit));
