<?php
/**
 * PRTG Monitoring Module Version Check
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

/**
 * Check for new version of the module
 * 
 * @param string $currentVersion Current module version
 * @return array Version check result with status and message
 */
function checkModuleVersion($currentVersion)
{
    // API URL to check for latest version
    $versionCheckUrl = 'https://cl.keloncloud.com/licensing/version.php';
    
    // Module identifier
    $moduleId = 'prtgmonitoring';
    
    // Prepare data for API call
    $postData = [
        'module' => $moduleId,
        'version' => $currentVersion,
        'domain' => $_SERVER['SERVER_NAME']
    ];
    
    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $versionCheckUrl);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    
    // Execute request
    $response = curl_exec($ch);
    
    // Check for errors
    if (curl_errno($ch)) {
        curl_close($ch);
        return ['status' => 'error', 'message' => 'Connection error'];
    }
    
    curl_close($ch);
    
    // Parse response
    $result = json_decode($response, true);
    
    if (!$result || !isset($result['latest_version'])) {
        return ['status' => 'error', 'message' => 'Invalid response from version server'];
    }
    
    // Compare versions
    $needsUpdate = version_compare($currentVersion, $result['latest_version'], '<');
    
    return [
        'status' => $needsUpdate ? 'update_available' : 'up_to_date',
        'current_version' => $currentVersion,
        'latest_version' => $result['latest_version'],
        'download_url' => isset($result['download_url']) ? $result['download_url'] : '',
        'message' => $needsUpdate ? 'A new version (' . $result['latest_version'] . ') is available!' : 'Your module is up to date.'
    ];
}