<?php
/**
 * PRTG Traffic Monitoring Hook
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}
use WHMCS\Database\Capsule;

// Add hook to display traffic graph in client area
add_hook('ClientAreaProductDetailsOutput', 1, function ($vars) {

    $serviceId = $vars["service"]["id"];
    $productId = Capsule::table('tblhosting')
        ->where("id", "=", $vars["service"]["id"])
        ->value('packageid');

    // Get monitoring ID directly with SQL
    $monitoringIdQuery = "SELECT value FROM tblcustomfieldsvalues 
                         JOIN tblcustomfields ON tblcustomfields.id = tblcustomfieldsvalues.fieldid 
                         WHERE tblcustomfields.fieldname = 'monitoringID'
                         AND tblcustomfieldsvalues.relid = $serviceId
                         LIMIT 1";
    $monitoringIdResult = mysql_query($monitoringIdQuery);
    if (!$monitoringIdResult || mysql_num_rows($monitoringIdResult) == 0) {
        return '';
    }
    $monitoringIdRow = mysql_fetch_assoc($monitoringIdResult);
    $monitoringId = $monitoringIdRow['value'];

    // Get traffic limit
    $trafficLimitQuery = "SELECT value FROM tblcustomfieldsvalues 
                         JOIN tblcustomfields ON tblcustomfields.id = tblcustomfieldsvalues.fieldid 
                         WHERE tblcustomfields.fieldname = 'TrafficLimit'
                         AND tblcustomfieldsvalues.relid = $serviceId
                         LIMIT 1";
    $trafficLimitResult = mysql_query($trafficLimitQuery);
    $trafficLimit = 0;
    if ($trafficLimitResult && mysql_num_rows($trafficLimitResult) > 0) {
        $trafficLimitRow = mysql_fetch_assoc($trafficLimitResult);
        $trafficLimit = $trafficLimitRow['value'];
    }

    // Get traffic usage
    $trafficUsageQuery = "SELECT * FROM mod_trafficusage WHERE product_id = $serviceId LIMIT 1";
    $trafficUsageResult = mysql_query($trafficUsageQuery);
    $usage = 0;
    $lastUpdate = 'Never';
    if ($trafficUsageResult && mysql_num_rows($trafficUsageResult) > 0) {
        $trafficUsageRow = mysql_fetch_assoc($trafficUsageResult);
        $usage = $trafficUsageRow['usage'];
        $lastUpdate = $trafficUsageRow['lastupdate'];
    }

    // Get product ID and server details
    $productQuery = "SELECT packageid FROM tblhosting WHERE id = $serviceId LIMIT 1";
    $productResult = mysql_query($productQuery);
    if (!$productResult || mysql_num_rows($productResult) == 0) {
        return '';
    }
    $productRow = mysql_fetch_assoc($productResult);
    $productId = $productRow['packageid'];

    // Get server details
    $serverQuery = "SELECT s.* FROM mod_prtg_product_servers ps
                   JOIN mod_prtg_servers s ON s.id = ps.server_id
                   WHERE ps.product_id = $productId
                   LIMIT 1";
    $serverResult = mysql_query($serverQuery);

    $serverUsername = 'admin';
    $serverPasshash = '1314677760';
    $serverUrl = '';

    if ($serverResult && mysql_num_rows($serverResult) > 0) {
        $serverRow = mysql_fetch_assoc($serverResult);
        $serverUsername = $serverRow['username'];
        $serverPasshash = $serverRow['passhash'];
        $serverUrl = $serverRow['url'];
    }

    if (empty($serverUrl)) {
        // Try to get from global settings
        $credentialsQuery = "SELECT * FROM mod_prtg_credentials LIMIT 1";
        $credentialsResult = mysql_query($credentialsQuery);
        if ($credentialsResult && mysql_num_rows($credentialsResult) > 0) {
            $credentialsRow = mysql_fetch_assoc($credentialsResult);
            $serverUsername = $credentialsRow['username'];
            $serverPasshash = $credentialsRow['passhash'];
            $serverUrl = $credentialsRow['url'];
        }
    }

    if (empty($serverUrl)) {
        return '';
    }

    // Get next due date
    $nextDueDateQuery = "SELECT nextduedate FROM tblhosting WHERE id = $serviceId LIMIT 1";
    $nextDueDateResult = mysql_query($nextDueDateQuery);
    $nextDueDate = null;
    if ($nextDueDateResult && mysql_num_rows($nextDueDateResult) > 0) {
        $nextDueDateRow = mysql_fetch_assoc($nextDueDateResult);
        $nextDueDate = $nextDueDateRow['nextduedate'];
    }

    // Calculate date range
    $endDate = date("Y-m-d-H-i-s");

    if ($nextDueDate) {
        $date = date_create($nextDueDate);
        date_modify($date, '-1 month');
        $startDate = date_format($date, 'Y-m-d-00-00-00');
    } else {
        $startDate = date("Y-m-d-00-00-00", strtotime("-1 month"));
    }

    // Build graph URL
    $graphUrl = rtrim($serverUrl, '/') . "/chart.png";
    $graphUrl .= "?id=" . $monitoringId;
    $graphUrl .= "&avg=15";
    $graphUrl .= "&sdate=" . $startDate;
    $graphUrl .= "&edate=" . $endDate;
    $graphUrl .= "&width=850&height=350";
    $graphUrl .= "&username=" . $serverUsername;
    $graphUrl .= "&passhash=" . $serverPasshash;
    $graphUrl .= "&graphstyling=baseFontSize=%2712%27%20showLegend=%271%27%20graphid=-1";

    // Calculate usage percentage
    $usagePercent = $trafficLimit > 0 ? round(($usage / $trafficLimit) * 100, 2) : 0;

    // Determine progress bar class
    $progressClass = 'success';
    if ($usagePercent >= 90) {
        $progressClass = 'danger';
    } elseif ($usagePercent >= 75) {
        $progressClass = 'warning';
    } elseif ($usagePercent >= 50) {
        $progressClass = 'info';
    }

    // Build the output HTML
    return '
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Traffic Usage</h3>
        </div>
        <div class="panel-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="progress">
                        <div class="progress-bar progress-bar-' . $progressClass . '" role="progressbar" 
                             aria-valuenow="' . $usagePercent . '" aria-valuemin="0" aria-valuemax="100" 
                             style="width: ' . $usagePercent . '%;">
                            ' . $usagePercent . '%
                        </div>
                    </div>
                    <p>
                        <strong>Current Usage:</strong> ' . $usage . ' GB / 
                        <strong>Limit:</strong> ' . $trafficLimit . ' GB
                        <br>
                        <strong>Last Updated:</strong> ' . $lastUpdate . '
                    </p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <img src="' . $graphUrl . '" class="img-responsive" alt="Traffic Graph">
                </div>
            </div>
        </div>
    </div>';
});

add_hook('AfterCronJob', 1, function ($vars) {
    require_once(__DIR__ . '/cron.php');
});
