<?php
/**
 * Messages Configuration
 * 
 * This file contains all text messages used in the HourlyAddonSeller module.
 * Centralizing messages here makes it easier to modify text without changing code.
 */

return [
    // Invoice descriptions
    'invoice' => [
        'credit_addition' => 'افزایش اعتبار سرویس ساعتی',
        'hourly_usage' => 'هزینه استفاده از سرویس ساعتی',
        'traffic_usage' => 'هزینه مصرف ترافیک',
        'minimum_balance' => 'شارژ حداقل اعتبار سرویس ساعتی',
    ],
    
    // Service status messages
    'service' => [
        'created' => 'سرویس ساعتی ایجاد شد',
        'suspended' => 'سرویس ساعتی به دلیل کمبود اعتبار معلق شد',
        'terminated' => 'سرویس ساعتی حذف شد',
        'unsuspended' => 'سرویس ساعتی فعال شد',
        'package_changed' => 'پکیج سرویس ساعتی تغییر کرد',
    ],
    
    // Error messages
    'error' => [
        'insufficient_credit' => 'اعتبار کافی نیست. حداقل اعتبار مورد نیاز: ',
        'api_connection' => 'خطا در اتصال به API',
        'database' => 'خطا در پایگاه داده: ',
        'invalid_service' => 'سرویس نامعتبر است',
    ],
    
    // Success messages
    'success' => [
        'credit_added' => 'اعتبار با موفقیت اضافه شد',
        'service_created' => 'سرویس با موفقیت ایجاد شد',
        'service_updated' => 'سرویس با موفقیت بروزرسانی شد',
    ],
    
    // Email subjects
    'email' => [
        'low_balance' => 'هشدار: اعتبار سرویس ساعتی شما کم است',
        'service_suspended' => 'سرویس ساعتی شما به دلیل کمبود اعتبار معلق شد',
        'usage_report' => 'گزارش مصرف سرویس ساعتی',
    ],
    
    // Button labels
    'button' => [
        'add_credit' => 'افزایش اعتبار',
        'view_usage' => 'مشاهده مصرف',
        'delete_service' => 'حذف سرویس',
    ],
    
    // Suspend reasons
    'suspend_reason' => [
        'overdue_payment' => 'عدم پرداخت به موقع',
        'insufficient_balance' => 'کمبود اعتبار',
        'policy_violation' => 'نقض قوانین استفاده',
    ],
    
    // API request descriptions
    'api' => [
        'create_description' => 'ایجاد سرویس جدید',
        'suspend_description' => 'تعلیق سرویس',
        'terminate_description' => 'حذف سرویس',
        'unsuspend_description' => 'فعالسازی مجدد سرویس',
        'package_change_description' => 'تغییر پکیج سرویس',
        'add_credit_description' => 'افزایش اعتبار کاربر',
    ],
];