<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function vpsfirewallconfig()
{
    global $theme;
    global $user;
    global $globals;
    global $l;
    global $done;
    global $error;
    global $cluster;
    global $protocol_array;
    global $temp_plan;
    global $admin_default;
    global $firewall_plans;
    global $servers;
    global $cluster;
    if(!load_lang("admin/vpsfirewallconfig")) {
        return false;
    }
    $theme["init_theme"] = "admin/vpsfirewallconfig";
    $theme["init_theme_name"] = "VPS Firewall Config";
    $theme["init_theme_func"] = ["vpsfirewallconfig_theme"];
    $theme["call_theme_func"] = "vpsfirewallconfig_theme";
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    if(!is_allowed("vpsfirewallconfig")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $select_method = optPOST("method_selector");
    $vpses = [];
    $plans = get_vps_plans(["all"]);
    $users = get_all_users();
    $page_number = 0;
    $servers_with_pro_license = [];
    $vpses_serverwise = [];
    $final_data = [];
    $where = "";
    $method_and_option_array = ["by_plan" => $plans, "by_users" => $users, "to_vps" => $vpses];
    get_fw_plans_by_user([], 1);
    if(!empty($select_method)) {
        if($select_method == "by_plan") {
            $temp_plan_data = get_vps_plans(["all"], ["vpsid"]);
            $diff_plans = array_diff(array_keys($plans), array_keys($temp_plan_data));
            if(!empty($diff_plans)) {
                foreach ($diff_plans as $plid) {
                    unset($plans[$plid]);
                }
            }
            $done["plans"] = $plans;
            return true;
        } else {
            if($select_method == "by_users") {
                $done["users"] = $users;
                return true;
            }
            if($select_method == "to_vps") {
                if(optPOST("query_type")) {
                    $query_type = optPOST("query_type");
                    if($query_type == "query:append") {
                        $page_number = optPOST("next_page");
                    }
                    $term = optPOST("term");
                    $where = !empty($term) ? " WHERE hostname LIKE '%" . $term . "%'" : "";
                }
                $reslen = get_reslen();
                $res = makequery("SELECT count(vpsid) as vps_count FROM `vps`" . $where);
                $row = vsql_fetch_assoc($res);
                if($row["vps_count"] < 1) {
                    $error[] = $l["no_vps"];
                    return false;
                }
                $total_vps_count = $row["vps_count"];
                $offset = 0;
                if(!empty($page_number)) {
                    $offset = ($page_number - 1) * $reslen;
                }
                $res = makequery("SELECT vpsid, vps_name, hostname FROM `vps`" . $where . " ORDER BY vpsid ASC LIMIT " . $offset . ", " . $reslen);
                for ($i = 0; $i < vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $vpses[$row["vpsid"]] = $row;
                }
                $done["data"]["total_vps_count"] = $total_vps_count;
                $done["data"]["vpses"] = $vpses;
                return true;
            }
        }
    }
    $choosen_method = optPOST("choosen_method");
    if(!empty($choosen_method)) {
        $choosen_option = optPOST("choosen_option");
        if(!empty($choosen_option) || empty($choosen_option) && $choosen_method == "to_vps") {
            if(!in_array($choosen_method, array_keys($method_and_option_array))) {
                $error[] = $l["invalid_method_to_apply_firewall"];
            }
            if($choosen_method != "to_vps") {
                $data = $method_and_option_array[$choosen_method];
                if(!in_array($choosen_option, array_keys($data))) {
                    $error[] = $l["invalid"] . $l[$choosen_method];
                    return false;
                }
            } else {
                $vpses_data = $_POST["choosen_option"];
                foreach ($vpses_data as $vpsid) {
                    $vps_data = getvps($vpsid);
                    if(empty($vps_data)) {
                        $error[] = $l["invalid_vpsid"] . $vpsid;
                        return false;
                    }
                }
            }
            $done["firewall_plans"] = $firewall_plans;
            return true;
        }
    }
    $apply_admin_firewall_plan = optPOST("apply_admin_firewall_plan");
    if(isset($_POST["apply_admin_firewall_plan"])) {
        if(!empty($apply_admin_firewall_plan) && empty($firewall_plans[$apply_admin_firewall_plan])) {
            $error[] = $l["invalid_admin_firewall_plan"];
            return false;
        }
        $method = optPOST("method");
        if(empty($method)) {
            $error[] = $l["select_option"];
            return false;
        }
        if($method == "to_vps") {
            $option = $_POST["option"];
        } else {
            $option = optPOST("option");
        }
        if(empty($option)) {
            $error[] = $l["choose_option"];
            return false;
        }
        foreach ($servers as $serid => $server) {
            $result = $cluster->check_licensepro($serid);
            if(!empty($result)) {
                array_push($servers_with_pro_license, $serid);
            }
        }
        if(empty($servers_with_pro_license)) {
            $error[] = $l["no_pro_servers"];
        }
        if(!in_array($method, array_keys($method_and_option_array))) {
            $error[] = $l["invalid_method"];
        }
        if($method == "by_plan") {
            if(!in_array($option, array_keys($method_and_option_array[$method]))) {
                $error[] = $l["invalid"] . $l[$method];
                return false;
            }
            $data = get_vps_plans(["plids" => [$option]], ["vpsid", "vps_name", "serid", "admin_fwid", "fwid"]);
            $vpses_to_apply = $data[$option];
            $no_pro_servers = [];
            foreach ($vpses_to_apply as $vpsid => $vps_info) {
                if(in_array($vps_info["serid"], $servers_with_pro_license)) {
                    if($vps_info["admin_fwid"] != $apply_admin_firewall_plan) {
                        $vpses_serverwise[$vps_info["serid"]][$vpsid] = $vps_info;
                    }
                } else {
                    array_push($no_pro_servers, $vps_info["serid"]);
                }
            }
        } elseif($method == "by_users") {
            if(empty($users[$option])) {
                $error[] = $l["invalid_user"];
                return false;
            }
            $res = makequery("SELECT `vpsid`, `serid`, `admin_fwid`, `fwid` FROM `vps` WHERE uid = :uid", [":uid" => $option]);
            if(vsql_num_rows($res) < 1) {
                $error[] = $l["no_vps_for_user"];
                return false;
            }
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                if(in_array($row["serid"], $servers_with_pro_license)) {
                    if($row["admin_fwid"] != $apply_admin_firewall_plan) {
                        $vpses_serverwise[$row["serid"]][$row["vpsid"]] = $row;
                    }
                } else {
                    array_push($no_pro_servers, $row["serid"]);
                }
            }
        } elseif($method == "to_vps") {
            $vpsids = $option;
            foreach ($vpsids as $vpsid) {
                $vps_data = getvps($vpsid);
                if(empty($vps_data)) {
                    $error[] = $l["invalid_vpsid"] . $vpsid;
                    return false;
                }
                if(in_array($vps_data["serid"], $servers_with_pro_license)) {
                    if($vps_data["admin_fwid"] != $apply_admin_firewall_plan) {
                        $vpses_serverwise[$vps_data["serid"]][$vpsid] = ["vpsid" => $vpsid, "serid" => $vps_data["serid"], "admin_fwid" => $vps_data["admin_fwid"], "fwid" => $vps_data["fwid"]];
                    }
                } else {
                    array_push($no_pro_servers, $vps_data["serid"]);
                }
            }
        }
        if(!empty($no_pro_servers)) {
            $error[] = $l["not_pro_server"] . " Serids :" . implode(",", $no_pro_servers);
            return false;
        }
        $final_data = ["vpses_serverwise" => $vpses_serverwise, "update_admin_firewall_plan" => $apply_admin_firewall_plan];
        if(isset($_REQUEST["update_plan"])) {
            $final_data["update_plan"] = $option;
        }
        if(!empty($final_data["vpses_serverwise"])) {
            $actid = tasks_admin_process("bulk_vps_firewall_apply", serialize($final_data), 1, 0, $user["uid"], 0, 0);
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/bulk_vps_firewall_apply.php " . $actid . " 2>&1 &");
            return true;
        }
    }
}
function API_vpsfirewallconfig()
{
    global $user;
    global $theme;
    global $globals;
    global $done;
    global $error;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
}

?>