<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function getSortHeader($header_name, $sort_column, $sort_column_by, $column, $size = "90")
{
    global $theme;
    global $globals;
    $str = "<div class=\"d-inline-flex align-items-center\" style=\"width:" . $size . "px;\">\n\t\t<div class=\"mr-2\">\n\t\t\t<span class=\"\" >" . $header_name . "</span>\n\t\t</div>\n\t\t<span class=\"sorter\">\n\t\t\t<a class=\"text-always-white\" href=\"" . $globals["index"] . "act=vps_stats&sortcolumn=" . $column . "&sortby=asc\"><i class=\"fas fa-sort-up\"></i></a><br>\n\t\t\t<a class=\"text-always-white\" href=\"" . $globals["index"] . "act=vps_stats&sortcolumn=" . $column . "&sortby=desc\"><i class=\"fas fa-sort-down\"></i></a>\n\t\t</span>\n\t</div>";
    return $str;
}
function vps_stats_theme()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $vps_stats;
    global $pie_data;
    global $vps_data;
    global $sort_column;
    global $sort_column_by;
    global $notice;
    global $servers;
    global $kernel;
    $table_data = "";
    softheader($l["<title>"]);
    if(!empty($notice["no_vps"])) {
        echo "<div class=\"bg\">\n\t\t\t\t<div class=\"row my-3 mx-auto\">\n\t\t\t\t<div class=\"col-10\">\n\t\t\t\t<h4 class=\"text-dark\"><i class=\"fas fa-chart-area\"></i> " . $l["page_head"] . "</h4>\n\t\t\t\t</div>\n\t\t\t</div><br><br><br>";
        echo "<div class=\"row mx-auto w-100\"><div class=\"col-sm-4\"></div><div class=\"col-sm-4\">";
        server_select();
        echo "</div></div>";
        show_alert($l["no_vps"], "2");
        echo "<div class=\"notice\" id=\"note_box\">\n\t\t\t<b>NOTE : </b>&nbsp; " . $l["no_vps"] . "</div></div>";
    } else {
        $values_cpu = $values_ram = $values_bandwidth = $labels = [];
        $total_cpu = 0;
        $total_band = 0;
        foreach ($vps_data as $key => $values_chart) {
            $pie_cpu[$values_chart["vps_name"]] = (int) $values_chart["used_cpu"];
            $pie_ram[$values_chart["vps_name"]] = (int) $values_chart["used_ram"];
            $pie_bandwidth[$values_chart["vps_name"]] = round((int) $values_chart["used_bandwidth"], 2);
            $pie_hex_color[] = "#" . str_pad(dechex(rand(0, 16777215)), 6, 0, STR_PAD_LEFT);
        }
        foreach ($vps_data as $k => $v) {
            $k = str_replace("K_", "", $k);
            $values_ram[$v["vpsid"]] = "{\"label\" : \"VPS ID : " . $v["vpsid"] . " VPS Name : " . $v["vps_name"] . "\", data: " . $v["used_ram"] . "}";
            $total_cpu += $v["used_cpu"];
            $values_cpu[$v["vpsid"]] = "{\"label\" : \"VPS ID : " . $v["vpsid"] . " VPS Name : " . $v["vps_name"] . "\", data: " . $v["used_cpu"] . "}";
            $total_band += $v["used_bandwidth"];
            $values_bandwidth[$v["vpsid"]] = "{\"label\" : \"VPS ID : " . $v["vpsid"] . " VPS Name : " . $v["vps_name"] . "\", data: " . $v["used_bandwidth"] . "}";
            if($v["status"] == 1) {
                $tmp = "<td align=\"center\" id=\"spcpu_" . $k . "\" ><div class=\"spcpu\">" . (double) $v["used_cpu"] . "," . (100 - $v["used_cpu"]) . "</div><div class=\"small_txt\">" . (double) $v["used_cpu"] . "%</div></td>\n\t\t\t\t\t\t\t\t" . ($kernel->features("vps_ram_info", $v["virt"]) ? "<td align=\"center\" id=\"spram_" . $k . "\" ><div class=\"spram\">" . (int) $v["used_ram"] . "," . ((int) $v["ram"] - (int) $v["used_ram"]) . "</div><div class=\"small_txt\">" . (int) $v["used_ram"] . " / " . (int) $v["ram"] . " MB</div></td>" : "<td align=\"center\" id=\"spram_" . $k . "\" >N/A</td>") . "\n\t\t\t\t\t\t\t\t<td align=\"center\" id=\"spdisk_" . $k . "\"><div class=\"spdisk\">" . $v["used_disk"] . "," . ($v["disk"] - $v["used_disk"]) . "</div><div class=\"small_txt\">" . round($v["used_disk"], 2) . " / " . $v["disk"] . " GB</div></td>\n\t\t\t\t\t\t\t\t" . (empty($v["inode"]) ? "<td align=\"center\" id=\"spinode_" . $k . "\"> N/A </td>" : "<td align=\"center\" id=\"spinode_" . $k . "\"><div class=\"spinode\">" . $v["used_inode"] . "," . ($v["inode"] - $v["used_inode"]) . "</div><div class=\"small_txt\">" . $v["used_inode"] . " / " . $v["inode"] . "</div></td>");
                $status_td = "<td align=\"center\" id=\"status_" . $k . "\"><i class=\"fas fa-circle fa-circle-green\" title=\"" . $l["vps_stat_on"] . "\"></i></td>";
            } elseif($v["status"] == 2) {
                $status_td = "<td align=\"center\" id=\"status_" . $k . "\"><i class=\"fas fa-circle fa-circle-gray\" title=\"" . $l["vps_stat_suspend"] . "\"></i></td>";
                $tmp = "<td colspan=\"4\" class=\"text-center\" id=\"nodata_" . $k . "\">" . $l["no_data"] . "</td>";
            } else {
                $status_td = "<td align=\"center\" id=\"status_" . $k . "\"><i class=\"fas fa-circle fa-circle-red\" title=\"" . $l["vps_stat_off"] . "\"></i></td>";
                $tmp = "<td colspan=\"4\" class=\"text-center\" id=\"nodata_" . $k . "\">" . $l["no_data"] . "</td>";
            }
            if($v["speed_cap"] == "0" || $v["speed_cap"] == NULL) {
                $speedCap = "<td align=\"center\"><span><i class=\"fas fa-circle fa-circle-red\" title=\"" . $l["vps_speed_cap_disabled"] . "\"></i></span></td>";
            } else {
                $speed_cap = explode(",", $v["speed_cap"]);
                $speedCap = "<td align=\"center\">" . $speed_cap[1] . " KB <img src=\"" . $theme["images"] . "admin/arrow_up.png\" title=\"" . $l["vps_upload_speed"] . "\"><br>" . $speed_cap[0] . " KB <img src=\"" . $theme["images"] . "admin/arrow_down.png\" title=\"" . $l["vps_download_speed"] . "\"></td>";
            }
            $table_data .= "<tr>\n\t\t\t\t\t\t\t\t" . $status_td . "\n\t\t\t\t\t\t\t\t<td id=\"vpsid_" . $k . "\">" . $v["vpsid"] . "</td>\n\t\t\t\t\t\t\t\t<td id=\"hostname_" . $k . "\" " . (20 <= strlen($v["hostname"]) ? "tooltip=\"" . $v["hostname"] . "\"" : "") . "><script>document.write(wordwrapper(20,\"" . $v["hostname"] . "\"))</script>(" . $v["vps_name"] . ")</td>\n\t\t\t\t\t\t\t\t" . $tmp . "\n\t\t\t\t\t\t\t\t<td>\n\t\t\t\t\t\t\t\t\t\t<div class=\"spband\" align=\"center\" id=\"band_" . $k . "\">\n\t\t\t\t\t\t\t\t\t\t\t" . $v["used_bandwidth"] . "," . (!empty($v["bandwidth"]) ? $v["bandwidth"] - $v["used_bandwidth"] : 9999999) . "\n\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"small_txt\" align=\"center\" id=\"band2_" . $k . "\">\n\t\t\t\t\t\t\t\t\t\t\t" . $v["used_bandwidth"] . "/" . (!empty($v["bandwidth"]) ? $v["bandwidth"] - $v["used_bandwidth"] : $l["unlimited"]) . " GB\n\t\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t</td>\n\t\t\t\t\t\t\t\t<td align=\"center\" id=\"netin_" . $k . "\">" . byte_convert($v["net_in"], 2) . "</td>\n\t\t\t\t\t\t\t\t<td align=\"center\" id=\"netout_" . $k . "\">" . byte_convert($v["net_out"], 2) . "</td>\n\t\t\t\t\t\t\t\t<td align=\"center\" id=\"io_read_" . $k . "\">" . byte_convert($v["io_read"], 2) . "</td>\n\t\t\t\t\t\t\t\t<td align=\"center\" id=\"io_write_" . $k . "\">" . byte_convert($v["io_write"], 2) . "</td>\n\t\t\t\t\t\t\t\t" . $speedCap . "\n\t\t\t\t\t\t\t\t<td align=\"center\"><span onclick=\"show_graph(" . $v["vpsid"] . ")\"><i class=\"fas fa-chart-bar fa-2x p-1 cursor-pointer\"></i></span></td>\n\t\t\t\t\t\t\t</tr>";
        }
        foreach ($pie_data["server_ram"] as $k => $v) {
            if($k == 0 && !empty($v["used_ram"])) {
                $pie_hex_color[] = "#" . str_pad(dechex(rand(0, 16777215)), 6, 0, STR_PAD_LEFT);
                $values_ram[$k] = "{\"label\" : \"Server " . $l["free"] . "&nbsp;" . $l["ram"] . "\", data: " . ($v["ram"] - $v["used_ram"]) . "}";
                $pie_ram[$k] = $v["ram"] - $v["used_ram"];
            } elseif($k == -1 && !empty($v["used_ram"])) {
                $values_ram[$k] = "{\"label\" : \"Dom0 " . $l["used"] . "&nbsp;" . $l["ram"] . "\", data: " . $v["used_ram"] . "}";
                $values_ram[-2] = "{\"label\" : \"Dom0 " . $l["free"] . "&nbsp;" . $l["ram"] . "\", data: " . ($v["ram"] - $v["used_ram"]) . "}";
                $pie_ram[$k] = $v["used_ram"];
                $pie_ram[-2] = $v["ram"] - $v["used_ram"];
            }
        }
        if(!empty($pie_data["server_cpu"])) {
            $values_cpu["Server"] = "{\"label\" : \"Server " . $l["free"] . "\", data: " . $pie_data["server_cpu"]["percent_free"] . "}";
            $pie_hex_color[] = "#" . str_pad(dechex(rand(0, 16777215)), 6, 0, STR_PAD_LEFT);
            $pie_cpu["Server"] = $pie_data["server_cpu"]["percent_free"];
            if($total_cpu < $pie_data["server_cpu"]["percent"]) {
                $values_cpu["Server"] = "{\"label\" : \"Server " . $l["used"] . "\", data: " . ($pie_data["server_cpu"]["percent"] - $total_cpu) . "}";
                $pie_cpu["Server"] = $pie_data["server_cpu"]["percent"] - $total_cpu;
            }
        }
        if(!empty($pie_data["server_bandwidth"])) {
            $pie_hex_color[] = "#" . str_pad(dechex(rand(0, 16777215)), 6, 0, STR_PAD_LEFT);
            $values_bandwidth[0] = "{\"label\" : \"Server " . $l["used"] . "\", data: " . $pie_data["server_bandwidth"]["used_gb"] . "}";
            $pie_bandwidth["Server"] = $pie_data["server_bandwidth"]["used_gb"];
            $free = 0;
            if($total_band + $pie_data["server_bandwidth"]["used_gb"] < $pie_data["server_bandwidth"]["limit_gb"]) {
                $free = $pie_data["server_bandwidth"]["limit_gb"] - ($total_band + $pie_data["server_bandwidth"]["used_gb"]);
                $values_bandwidth[-1] = "{\"label\" : \"Server " . $l["free"] . "\", data: " . $free . "}";
                $pie_bandwidth[-1] = $free;
            }
        }
        $j_pie_data = json_encode(array_keys($pie_cpu));
        $j_pie_cpu = json_encode(array_values($pie_cpu));
        $j_pie_ram = json_encode(array_values($pie_ram));
        $j_pie_bandwidth = json_encode(array_values($pie_bandwidth));
        $j_pie_hex_color = json_encode(array_values($pie_hex_color));
        echo "<style type=\"text/css\">\n\t\t\n\t\t.spcpu, .spram, .spdisk, .spinode, .spband {\n\t\t\tmargin-bottom: 4px;\n\t\t}\n\t\t\n\t\t.small_txt {\n\t\t\tfont-size: 11px;\n\t\t}\n\t\t\n\t\t</style>\n\t\t<script src=\"" . $theme["url"] . "/js/chart.js\"> </script>\n\t\t<script language=\"javascript\" type=\"text/javascript\">\n\t\t\n\t\t//Assign a global variable to remember the vpsid when page loads\n\t\tvpsid = 0;\n\t\t\n\t\tvar monthFullNames = [\"" . $l["january"] . "\", \"" . $l["february"] . "\", \"" . $l["march"] . "\", \"" . $l["april"] . "\", \"" . $l["may"] . "\", \"" . $l["june"] . "\", \"" . $l["july"] . "\", \"" . $l["august"] . "\", \"" . $l["september"] . "\", \"" . $l["october"] . "\", \"" . $l["november"] . "\", \"" . $l["december"] . "\" ];\n\t\t\n\t\t// Show the data for bandwidth, CPU, RAM\n\t\tfunction plot_pie(id, data){\n\t\t\t\n\t\t\tvar plot = \$.plot(id, data,{\n\t\t\t\tseries: {\n\t\t\t\t\tpie: { \n\t\t\t\t\t\tshow: true,\n\t\t\t\t\t\tradius: 3/4,\n\t\t\t\t\t\tlabel: {\n\t\t\t\t\t\t\tshow: false\n\t\t\t\t\t\t},\n\t\t\t\t\t\tstroke: { \n\t\t\t\t\t\t\twidth: 0.1,\n\t\t\t\t\t\t\tcolor: \"#408080\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\tgrid: {\n\t\t\t\t\thoverable: true,\n\t\t\t\t\tclickable: true\n\t\t\t\t},\n\t\t\t\tlegend: {\n\t\t\t\t\tshow: false\n\t\t\t\t}\n\t\t\t});\n\t\t\t\n\t\t\tid.bind(\"plothover\", pieHover);\n\t\t}\n\n\t\tvar previousPoint = null;\n\t\tfunction pieHover(event, pos, obj){\n\t\t\t\n\t\t\tif (!obj){\n\t\t\t\t\$(\"#tooltip\").remove();\n\t\t\t\tpreviousPoint = null;\n\t\t\t\treturn;\n\t\t\t}\n\t\t\t\n\t\t\tif (previousPoint != obj.seriesIndex) {\n\t\t\t\tpreviousPoint = obj.seriesIndex;\n\t\t\t\t\$(\"#tooltip\").remove();\n\t\t\t\n\t\t\t\tvar tmp = \"\"+obj.series.data;\n\t\t\t\tvar ram = tmp.split(\",\");\n\t\t\t\t\n\t\t\t\tvar idOfPie = event.target.getAttribute('id');\n\t\t\t\tidOfPie = idOfPie.split(\"_\");\n\t\t\t\tvar pieChartName = \"\";\n\t\t\t\tvar pieChartSign = \"\";\n\t\t\t\t\n\t\t\t\tif(idOfPie[1] == \"cpu\"){\n\t\t\t\t\tpieChartName = \"CPU\";\n\t\t\t\t\tpieChartSign = \"%\";\n\n\t\t\t\t}else if(idOfPie[1] == \"ram\"){\n\t\t\t\t\tpieChartName = \"RAM\";\n\t\t\t\t\tpieChartSign = \"MB\";\n\t\t\t\t\t\n\t\t\t\t}else if(idOfPie[1] == \"bandwidth\"){\n\t\t\t\t\tpieChartName = \"Bandwidth\";\n\t\t\t\t\tpieChartSign = \"GB\";\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tshowTooltip(pos.pageX, pos.pageY, obj.series.label+\"<br /> \"+pieChartName+\" : \"+ram[1]+\" \"+pieChartSign);\t\t\n\t\t\t}\t\t\n\t\t}\n\t\t\t\n\t\tfunction show_graph(id){\n\t\t\t\n\t\t\tvpsid = id;\n\t\t\t//CPU as default window\n\t\t\tchange_monitor_tabs(\"cpuinfo\");\n\t\t\tvar dialogTitle = '<i class=\"fas fa-chart-bar\"></i>&nbsp;&nbsp; <h5 class=\"m-0\"> VPSID '+id+' </h5> &nbsp;&nbsp;<span id=\"img_loading\"></span>';\n\t\t\t\n\t\t\t\$(\"#dialog-header\").html(dialogTitle+\"<button type=\\\"button\\\" class=\\\"close text-always-white\\\" data-dismiss=\\\"modal\\\">×</button>\");\n\t\t\t\$(\"#dialog\").modal();\n\t\t\t\n\t\t\t\n\t\t\t\n\t\t\t//Display loading image\n\t\t\t\$(\"#img_loading\").html(\"<div class=\\\"loader\\\"></div>\");\n\t\t\t\n\t\t\t\$.post(\"" . $globals["index"] . "act=vps_stats&jsnohf=1&api=json&svs=\"+id+\"\", function(data){\n\t\t\t\t\tdata = JSON.parse(data);\n\t\t\t\t\t\n\t\t\t\t\tif(data.vps_stats){\n\t\t\t\t\t\tshow_monthly_graph(data.vps_stats, data.month);\n\t\t\t\t\t}else{\n\t\t\t\t\t\tvar req_month = parseInt(data.month.current_month.toString().substring(4));\n\t\t\t\t\t\t\$(\"#note_box\").css(\"display\",\"block\");\n\t\t\t\t\t\t\$(\"#for_month\").html(monthFullNames[req_month - 1]);\n\t\t\t\t\t}\n\t\t\t\t\t\$(\"#img_loading\").html(\"\");\n\t\t\t});\n\t\t};\t\n\t\t\t\n\t\t// Show monthly graph\n\t\tfunction show_monthly_graph(monthly_data, month){\n\t\t\t\n\t\t\tif(monthly_data){\n\t\t\t\t\n\t\t\t\t\$(\"#note_box\").css(\"display\",\"none\");\n\t\t\t\n\t\t\t\tvar cpu_data = new Array();\n\t\t\t\tvar inode_data = new Array();\n\t\t\t\tvar ram_data = new Array();\n\t\t\t\tvar disk_data = new Array();\n\t\t\t\tvar ntw_in_data = new Array();\n\t\t\t\tvar ntw_out_data = new Array();\n\t\t\t\tvar ntw_total_data = new Array();\n\t\t\t\tvar io_read_data = new Array();\n\t\t\t\tvar io_write_data = new Array();\n\t\t\t\t\n\t\t\t\tif(monthly_data){\n\t\t\t\t\n\t\t\t\t\t\$.each(monthly_data,function(key,val){\n\t\t\t\t\t\t\n\t\t\t\t\t\t//Array is in format [0:vpsid, 1:time, 2:status, 3:disk, 4:inode, 5:ram,  6:cpu, 7:actual_cpu, 8:net_in, 9:net_out]\n\t\t\t\t\t\n\t\t\t\t\t\tcpu_data.push([val[1], val[7]]);\n\t\t\t\t\t\t\t\n\t\t\t\t\t\tinode_data.push([val[1], val[4]]);\n\t\t\t\t\t\t\t\n\t\t\t\t\t\tram_data.push([val[1], val[5]]);\t\n\t\t\t\t\t\t\n\t\t\t\t\t\tdisk_data.push([val[1], (val[3]/1024)]);\n\t\t\t\t\t\t\n\t\t\t\t\t\tntw_in_data.push([val[1], val[8]]);\n\t\t\t\t\t\t\n\t\t\t\t\t\tntw_out_data.push([val[1], val[9]]);\n\t\t\t\t\t\t\n\t\t\t\t\t\tntw_total_data.push([val[1], parseInt(val[8]) + parseInt(val[9])]);\n\n\t\t\t\t\t\tio_read_data.push([val[1], val[10]]);\n\n\t\t\t\t\t\tio_write_data.push([val[1], val[11]]);\n\t\t\t\t\t});\n\t\t\t\t\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t// LEFT TO check\n\t\t\t\tcpu_data.sort(function(a, b){ \n\t\t\t\t\treturn a[0]-b[0]; \n\t\t\t\t});\n\t\t\t\t\n\t\t\t\tvar cpu_graph = [\n\t\t\t\t\t\t\t{ label: \"" . $l["cpu_utilization"] . "\",  data: cpu_data}\n\t\t\t\t\t\t];\n\t\t\t\t\t\t\n\t\t\t\tvar inode_graph = [\n\t\t\t\t\t\t{ label: \"" . $l["inode"] . "\",  data: inode_data, color: \"#80b3ff\"}\n\t\t\t\t\t];\t\n\t\t\t\t\t\n\t\t\t\tvar ram_graph = [\n\t\t\t\t\t\t{ label: \"" . $l["ram_utilization"] . "\",  data: ram_data, color: \"#ccff33\"}\n\t\t\t\t\t];\t\n\t\t\t\t\t\n\t\t\t\tvar disk_graph = [\n\t\t\t\t\t\t{ label: \"" . $l["disk"] . "\",  data: disk_data, color: \"#ff6600\"}\n\t\t\t\t\t];\t\n\n\t\t\t\tvar io_read_graph = [\n\t\t\t\t\t{ label: \"" . $l["io_read_spd"] . "\",  data: io_read_data, color: \"#0077FF\"},\n\t\t\t\t];\n\n\t\t\t\tvar io_write_graph = [\n\t\t\t\t\t{ label: \"" . $l["io_write_spd"] . "\",  data: io_write_data, color: \"#FF6600\"},\n\t\t\t\t];\n\t\t\t\t\t\t\n\t\t\t\tvar ntw_graph = [\n\t\t\t\t\t\t{ label: \"" . $l["download_graph_title"] . "\",  data: ntw_in_data, color: \"#0077FF\"},\n\t\t\t\t\t\t{ label: \"" . $l["upload_graph_title"] . "\",  data: ntw_out_data , color: \"#0000A0\"},\n\t\t\t\t\t\t{ label: \"" . $l["total_graph_title"] . "\",  data: ntw_total_data}\n\t\t\t\t\t];\t\n\t\t\t\t\n\t\t\t\tselection_zooming(\"cpu_plot\", cpu_graph);\n\t\t\t\tlive_resource_graph(\"cpu_plot\", cpu_graph, flot_options(\"cpu_plot\"), \"% at \",true);\n\n\t\t\t\tselection_zooming(\"ram_plot\", ram_graph);\n\t\t\t\tlive_resource_graph(\"ram_plot\", ram_graph, flot_options(\"ram_plot\"), \"MB at \",true);\n\t\t\t\t\n\t\t\t\tselection_zooming(\"disk_plot\", disk_graph);\n\t\t\t\tlive_resource_graph(\"disk_plot\", disk_graph, flot_options(\"disk_plot\"), \"GB at \",true);\n\n\t\t\t\tselection_zooming(\"inode_plot\", inode_graph);\n\t\t\t\tlive_resource_graph(\"inode_plot\", inode_graph, flot_options(\"inode_plot\"), \"Blocks at \",true);\n\t\t\t\n\t\t\t\tselection_zooming(\"io_read_plot\", io_read_graph);\n\t\t\t\tlive_resource_graph(\"io_read_plot\", io_read_graph, flot_options(\"io_read_plot\"), \"Mb/s at \",true);\n\t\t\t\t\n\t\t\t\tselection_zooming(\"io_write_plot\", io_write_graph);\n\t\t\t\tlive_resource_graph(\"io_write_plot\", io_write_graph, flot_options(\"io_write_plot\"), \"Mb/s at \",true);\n\t\t\t\t\n\t\t\t\tselection_zooming(\"ntw\", ntw_graph);\n\t\t\t\tlive_resource_graph(\"ntw\", ntw_graph, flot_options(\"ntw\"), \"\",true);\n\t\t\t\t\n\t\t\t\tvar monthNames = [\"" . $l["jan"] . "\", \"" . $l["feb"] . "\", \"" . $l["mar"] . "\", \"" . $l["apr"] . "\", \"" . $l["may"] . "\", \"" . $l["jun"] . "\", \"" . $l["jul"] . "\", \"" . $l["aug"] . "\", \"" . $l["sep"] . "\", \"" . $l["oct"] . "\", \"" . $l["nov"] . "\", \"" . $l["dec"] . "\" ];\n\t\t\t\t\n\t\t\t\tvar current_year = month.current_month.substring(0,4);\n\t\t\t\tvar current_month = parseInt(month.current_month.substring(4));\n\t\t\t\t\$(\"#month_holder2\").html(monthNames[current_month - 1] +\" \"+ current_year);\n\t\t\t\t\$(\"#next_month\").html('<input type=\"button\" class=\"btn w-50\" onclick=\"search_result('+ month.next_month +')\" value=\"" . $l["next_month"] . "\" />');\n\t\t\t\t\$(\"#prev_month\").html('<input type=\"button\" class=\"btn w-50\" onclick=\"search_result('+ month.prev_month +')\" value=\"" . $l["prev_month"] . "\" />');\n\t\t\t\t\t\t\n\t\t\t}else{\n\t\t\t\t\$(\"#note_box\").css(\"display\",\"block\");\n\t\t\t}\n\t\t}\n\t\t\n\t\tfunction search_result(mon){\n\t\t\t\n\t\t\t//Display loading image\n\t\t\t\$(\"#img_loading\").html(\"<div class=\\\"loader\\\"></div>\");\n\t\t\t\$.post(\"" . $globals["index"] . "act=vps_stats&jsnohf=1&api=json&svs=\"+ vpsid +\"&show=\" + mon +\"\", function(data){\n\t\t\t\tdata = JSON.parse(data);\n\t\t\t\tif(data.vps_stats){\n\t\t\t\t\tshow_monthly_graph(data.vps_stats, data.month);\n\t\t\t\t}else{\n\t\t\t\t\tvar req_month = parseInt(mon.toString().substring(4));\n\t\t\t\t\t\$(\"#note_box\").css(\"display\",\"block\");\n\t\t\t\t\t\$(\"#for_month\").html(monthFullNames[req_month - 1]);\n\t\t\t\t}\n\t\t\t\t\$(\"#img_loading\").html(\"\");\n\t\t\t}); \n\t\t\t\n\t\t};\n\t\t\t\n\t\t// Handle for selection and zooming\n\t\tfunction selection_zooming (id, data){\n\n\t\t\t\$(\"#\"+id).bind(\"plotselected\", function (event, ranges) {\n\t\t\t\tif (ranges.xaxis.to - ranges.xaxis.from < 0.00001) {\n\t\t\t\t\tranges.xaxis.to = ranges.xaxis.from + 0.00001;\n\t\t\t\t}\n\t\t\t\tif (ranges.yaxis.to - ranges.yaxis.from < 0.00001) {\n\t\t\t\t\tranges.yaxis.to = ranges.yaxis.from + 0.00001;\n\t\t\t\t}\n\t\t\t\toptions = flot_options(id);\n\t\t\t\tplot = \$.plot(\"#\"+id, data,\n\t\t\t\t\t\$.extend(true, {}, options, {\n\t\t\t\t\t\txaxis: { min: ranges.xaxis.from, max: ranges.xaxis.to },\n\t\t\t\t\t\tyaxis: { min: ranges.yaxis.from, max: ranges.yaxis.to }\n\t\t\t\t\t})\n\t\t\t\t);\n\t\t\t\t\n\t\t\t\t//Lets append zoom out button if its not present\n\t\t\t\tif(\$(\"#zoomOut_\"+id) != undefined){\n\t\t\t\t\t\$(\"#zoomOut_\"+id).fadeOut().remove();\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t\$(\"<input type='button' style='position:absolute;right:15px;top:15px;opacity:0.9;' class='btn' id='zoomOut_'\"+ id +\" value='Zoom Out'>\").appendTo(\$(\"#\"+id)).click(function(e){\n\t\t\t\t\te.preventDefault();\n\t\t\t\t\toptions = flot_options(id);\n\t\t\t\t\t\$.plot(\"#\"+id, data, options);\n\t\t\t\t\t\$(\"#zoomOut_\"+id).fadeOut().remove();\n\t\t\t\t});\t\n\t\t\t});\n\t\t};\n\t\t\n\t\t// Call for the options\n\t\tfunction flot_options(optionOf){\n\t\t\tvar options = {\n\t\t\t\t\tgrid: {\n\t\t\t\t\t\tborderWidth:0,\n\t\t\t\t\t\tlabelMargin:0,\n\t\t\t\t\t\taxisMargin:0,\n\t\t\t\t\t\tminBorderMargin:0\n\t\t\t\t\t},\n\t\t\t\t\tlegend: {\n\t\t\t\t\t\tshow: true,\n\t\t\t\t\t\tnoColumns: 3,\n\t\t\t\t\t},\n\t\t\t\t\tseries: {\n\t\t\t\t\t\tlines: {\n\t\t\t\t\t\t\tshow: true,\n\t\t\t\t\t\t\tlineWidth: 0.07,\n\t\t\t\t\t\t\tfill: true\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\t\t\t\t\txaxis: {\n\t\t\t\t\t\tshow:true,\n\t\t\t\t\t\tmode: \"time\",\n\t\t\t\t\t\ttickFormatter: function (v, axis) {\n\t\t\t\t\t\t\treturn nDate(v,\"m/d\");\n\t\t\t\t\t\t},\n\t\t\t\t\t\tlabelWidth: 25,\n\t\t\t\t\t\taxisLabelUseCanvas: true,\n\t\t\t\t\t\taxisLabelFontSizePixels: 12,\n\t\t\t\t\t\taxisLabelFontFamily: \"Verdana, Arial\",\n\t\t\t\t\t\taxisLabelPadding: 10,\n\t\t\t\t\t},\n\t\t\t\t\tyaxis: {\n\t\t\t\t\t\tshow:true,\n\t\t\t\t\t\tmin: 0,\n\t\t\t\t\t\tmax: null,\n\t\t\t\t\t\tlabelWidth: 50,\n\t\t\t\t\t\taxisLabelUseCanvas: true,\n\t\t\t\t\t\taxisLabelFontSizePixels: 12,\n\t\t\t\t\t\taxisLabelFontFamily: \"Verdana, Arial\",\n\t\t\t\t\t},\n\t\t\t\t\tselection: {\n\t\t\t\t\t\tmode: \"x\"\n\t\t\t\t\t},\t\n\t\t\t\t\tgrid: {\n\t\t\t\t\t\tborderWidth: 1,\n\t\t\t\t\t\tborderColor: \"#FFF\",\n\t\t\t\t\t\thoverable: true,\n\t\t\t\t\t}\n\t\t\t\t};\n\t\t\t\t\n\t\t\tif(optionOf == \"cpu_plot\"){\n\t\t\t\n\t\t\t\t//Appending options for cpu\n\t\t\t\toptions.yaxis.tickFormatter = function (v) {\n\t\t\t\t\tif(v <= 1024)\n\t\t\t\t\t\treturn Math.round(v) + \" %\";\n\t\t\t\t};\n\t\t\t\toptions.legend.container = \$(\"#legend_cpu\");\n\t\t\t\n\t\t\t}else if(optionOf == \"ram_plot\"){\n\t\t\t\t\n\t\t\t\t//Appending options for ram\n\t\t\t\toptions.yaxis.tickFormatter = function (v) {\n\t\t\t\t\tif(v <= 1024)\n\t\t\t\t\t\treturn Math.round(v) + \" MB\";\n\t\t\t\t\tif(v > 1024 && v < (1024*1024))\n\t\t\t\t\t\treturn Math.round(v /1024) + \" GB\";\n\t\t\t\t\tif(v > (1024*1024))\n\t\t\t\t\t\treturn Math.round(v / (1024*1024)) + \" TB\"\n\t\t\t\t};\n\t\t\t\toptions.legend.container = \$(\"#legend_ram\");\n\t\t\t\t\n\t\t\t}else if(optionOf == \"disk_plot\"){\n\t\t\t\n\t\t\t\t//Appending options for Disk\n\t\t\t\toptions.yaxis.tickFormatter = function (v) {\n\t\t\t\t\tif(v <= 1024)\n\t\t\t\t\t\treturn Math.round(v) + \" GB\";\n\t\t\t\t\tif(v > 1024 && v < (1024*1024))\n\t\t\t\t\t\treturn Math.round(v /1024) + \" TB\";\n\t\t\t\t};\n\t\t\t\toptions.legend.container = \$(\"#legend_disk\");\n\t\t\t\n\t\t\t}else if(optionOf == \"inode_plot\"){\n\t\t\t\n\t\t\t\t//Appending option for INodes\n\t\t\t\toptions.yaxis.tickFormatter = \"\";\n\t\t\t\toptions.legend.container = \$(\"#legend_inode\");\n\t\t\t\n\t\t\t}else if(optionOf == \"io_read_plot\" || optionOf == \"io_write_plot\"){\n\t\t\t\n\t\t\t\t//Appending option for INodes\n\t\t\t\toptions.yaxis.tickFormatter = function (v) {\n\t\t\t\t\tif(v <= 1024)\n\t\t\t\t\t\treturn Math.round(v) + \" B/s\";\n\t\t\t\t\tif(v > 1024 && v < (1024*1024))\n\t\t\t\t\t\treturn Math.round(v /1024) + \" KB/s\";\n\t\t\t\t\tif(v > (1024*1024) && v < (1024*1024*1024))\n\t\t\t\t\t\treturn Math.round(v / (1024*1024)) + \" MB/s\"\n\t\t\t\t\tif(v > (1024*1024*1024))\n\t\t\t\t\t\treturn Math.round(v / (1024*1024*1024)) + \" GB/s\"\n\t\t\t\t};\n\t\t\t\toptions.legend.container = (optionOf == \"io_read_plot\" ? \$(\"#legend_io_read\") : \$(\"#legend_io_write\"));\n\t\t\t\n\t\t\t}else if(optionOf == \"ntw\"){\n\t\t\t\n\t\t\t\t//Appending  option for Network\n\t\t\t\toptions.yaxis.tickFormatter = function (v) {\n\t\t\t\t\tif(v <= 1024)\n\t\t\t\t\t\treturn Math.round(v) + \" B/s\";\n\t\t\t\t\tif(v > 1024 && v < (1024*1024))\n\t\t\t\t\t\treturn Math.round(v / 1024) + \" KB/s\";\n\t\t\t\t\tif(v > (1024*1024) && v < (1024*1024*1024))\n\t\t\t\t\t\treturn Math.round(v / (1024*1024)) + \" MB/s\";\n\t\t\t\t\tif(v > (1024*1024*1024))\n\t\t\t\t\t\treturn Math.round(v / (1024*1024*1024)) + \" GB/s\";\n\t\t\t\t};\n\t\t\t\toptions.legend.container = \$(\"#legend_ntw\");\n\t\t\t\t\n\t\t\t}\n\t\t\t\t\n\t\t\treturn options;\n\t\t};\n\t\t\t\n\t\tfunction change_monitor_tabs(id){\n\t\t\t\$(\"#cpuinfo_win, #raminfo_win, #diskinfo_win, #ntwinfo_win, #ioinfo_win\").hide();\n\t\t\t\$(\"#\"+id+\"_win\").show();\n\t\t};\n\t\t\n\t\tfunction ploter(id,yValues,xValues,hexvalues){\n\n\t\t\t\tfunction res_callback(tooltipItem, type){\n\t\t\t\t\tconsole.log(tooltipItem);\n\t\t\t\t\tif(type == \"holder_ram\"){\n\t\t\t\t\t\treturn \" \"+((tooltipItem.raw)/1024).toFixed(2) + \"GB\";\n\t\t\t\t\t}\n\t\t\t\t\tif(type == \"holder_cpu\"){\n\t\t\t\t\t\treturn \" \"+tooltipItem.raw.toFixed(2) + \"%\";\n\t\t\t\t\t}\n\t\t\t\t\tif(type == \"holder_bandwidth\"){\n\t\t\t\t\t\treturn \" \"+tooltipItem.raw.toFixed(2) + \"GB\";\n\t\t\t\t\t}\n\t\t\t\t}\n\n\t\t\t\tnew Chart(id, {\n\t\t\t\t\ttype: \"pie\",\n\t\t\t\t\tdata: {\n\t\t\t\t\tlabels: xValues,\n\t\t\t\t\tdatasets: [{\n\t\t\t\t\t\tbackgroundColor: hexvalues,\n\t\t\t\t\t\tdata: yValues\n\t\t\t\t\t}]\n\t\t\t\t},\n\t\t\t\toptions: {\n\t\t\t\t\tresponsive: false,\n\t\t\t\t\tmaintainAspectRatio: false,\n\t\t\t\t\tplugins: { legend: { display: false},\n\t\t\t\t\t\ttooltip: {\n\t\t\t\t\t\t\tcallbacks: {\n\t\t\t\t\t\t\t\tlabel: function(tooltipItem) {\n\t\t\t\t\t\t\t\t\tconsole.log(\"TOOLTIP :\"+tooltipItem);\n\t\t\t\t\t\t\t\t\treturn res_callback(tooltipItem, id);\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\ttitle: function(tooltipItem) {\n\t\t\t\t\t\t\t\t\treturn \" \"+tooltipItem[0].label;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\n\t\t\$(document).ready(function(){\n\t\t\tcleartime = setTimeout(function(){\n\t\t\t   //window.location.reload(1);\n\t\t\t   refresh_stats();\n\t\t\t}, 30000);\n\t\t\t\n\t\t\t// Call the function to display RAM pie chart\n\t\t\tvar data = [" . implode(", ", $values_ram) . "];\n\t\t\t\n\t\t\t// Call the function to display CPU pie chart\n\t\t\tvar data = [" . implode(", ", $values_cpu) . "];\n\t\t\t//TODO set cpu values here document.ready\n\t\t\tvar cpu_xvalues = JSON.parse('" . $j_pie_cpu . "');\n\t\t\tvar cpu_yvalues = JSON.parse('" . $j_pie_data . "');\n\t\t\tvar ram_xvalues = JSON.parse('" . $j_pie_ram . "');\n\t\t\tvar bw_xvalues = JSON.parse('" . $j_pie_bandwidth . "');\n\t\t\tvar cpu_hex = JSON.parse('" . $j_pie_hex_color . "');\n\t\t\tploter(\"holder_cpu\",cpu_xvalues,cpu_yvalues,cpu_hex);\n\t\t\tploter(\"holder_ram\",ram_xvalues,cpu_yvalues,cpu_hex);\n\t\t\tploter(\"holder_bandwidth\",bw_xvalues,cpu_yvalues,cpu_hex);\n\n\n\t\t\t\n\t\t\t// Call the function to display Bandwidth pie chart\n\t\t\tvar data = [" . implode(", ", $values_bandwidth) . "];\n\t\t\t\n\t\t\tmanage_sparkline();\n\t\t\t\n\t\t}); \n\t\t\n\t\tfunction refresh_stats(){\n\t\t\t\n\t\t\t\$.ajax({\n\t\t\t\turl: window.location.href +\"&api=json\",\n\t\t\t\tsuccess: function(resp){\n\t\t\t\t\n\t\t\t\t\tresp = JSON.parse(resp);\n\t\t\t\t\tvar total_cpu = 0;\n\t\t\t\t\tvar total_band = 0;\n\t\t\t\t\tvar v_ram = [];\n\t\t\t\t\tvar v_cpu = [];\n\t\t\t\t\tvar v_bandwidth = [];\n\t\t\t\t\tvar table_data = \"\";\n\t\t\t\t\tvar tmp = \"\";\n\t\t\t\t\tvar status_td = \"\";\n\t\t\t\t\t\n\t\t\t\t\t\$.each(resp.vps_data, function(i, t){\n\t\t\t\t\t\n\t\t\t\t\t\tv_ram.push({\"label\" : \"VPS ID : \"+t.vpsid+\" VPS Name : \"+t.vps_name, data: parseFloat(t.used_ram)});\n\t\t\t\t\t\ti = i.replace(\"K_\", \"\");\n\t\t\t\t\t\ttotal_cpu += parseFloat(t.used_cpu);\n\t\t\t\t\t\tv_cpu.push(parseFloat(t.used_cpu));\n\t\t\t\t\t\t\n\t\t\t\t\t\ttotal_band += parseFloat(t.used_bandwidth);\n\t\t\t\t\t\tv_bandwidth.push({\"label\" : \"VPS ID : \"+t.vpsid+\" VPS Name : \"+t.vps_name, data: parseFloat(t.used_bandwidth)});\n\t\t\t\t\t\t\t\n\t\t\t\t\t\tif(t.status == 1){\n\t\t\t\t\t\t\ttmp += \"<td align=\\\"center\\\" id=\\\"spcpu_\"+i+\"\\\" ><div class=\\\"spcpu\\\">\"+parseFloat(t.used_cpu)+\",\"+(100 - t.used_cpu)+\"</div><div class=\\\"small_txt\\\">\"+parseFloat(t.used_cpu)+\" %</div></td>\";\n\t\t\t\t\t\t\ttmp += ((t.vps_ram_info) ? \"<td align=\\\"center\\\" id=\\\"spram_\"+i+\"\\\" ><div class=\\\"spram\\\">\"+parseInt(t.used_ram)+\",\"+(parseInt(t.ram) - parseInt(t.used_ram))+\"</div><div class=\\\"small_txt\\\">\"+parseInt(t.used_ram)+\" / \"+parseInt(t.ram)+\" MB</div></td>\" : \"<td align=\\\"center\\\" id=\\\"spram_\"+i+\"\\\" >N/A</td>\");\n\t\t\t\t\t\t\ttmp += \"<td align=\\\"center\\\" id=\\\"spdisk_\"+i+\"\\\"><div class=\\\"spdisk\\\">\"+(t.used_disk)+\",\"+(t.disk - t.used_disk)+\"</div><div class=\\\"small_txt\\\">\"+(t.used_disk.toFixed(2))+\" / \"+(t.disk)+\" GB</div></td>\";\n\t\t\t\t\t\t\ttmp += ((t.inode == \"\") ? \"<td align=\\\"center\\\" id=\\\"spinode_\"+i+\"\\\"> N/A </td>\" : \"<td align=\\\"center\\\" id=\\\"spinode_\"+i+\"\\\"><div class=\\\"spinode\\\">\"+t.used_inode+\",\"+(t.inode - t.used_inode)+\"</div><div class=\\\"small_txt\\\">\"+t.used_inode+\" / \"+(t.inode)+\"</div></td>\");\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\tstatus_td = \"<td align=\\\"center\\\" id=\\\"status_\"+i+\"\\\"><i class=\\\"fas fa-circle fa-circle-green\\\" title=\\\"" . $l["vps_stat_on"] . "\\\" ></i></td>\";\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t}else if(t.status == 2){\n\t\t\t\t\t\t\tstatus_td = \"<td align=\\\"center\\\" id=\\\"status_\"+i+\"\\\"><i class=\\\"fas fa-circle fa-circle-gray\\\" title=\\\"" . $l["vps_stat_suspend"] . "\\\" ></i></td>\";\n\t\t\t\t\t\t\ttmp += \"<td colspan=\\\"4\\\" class=\\\"text-center\\\" id=\\\"nodata_\"+i+\"\\\">" . $l["no_data"] . "</td>\";\n\t\t\t\t\t\t}else{\n\t\t\t\t\t\t\tstatus_td = \"<td align=\\\"center\\\" id=\\\"status_\"+i+\"\\\"><i class=\\\"fas fa-circle fa-circle-red\\\" title=\\\"" . $l["vps_stat_off"] . "\\\" ></i></td>\";\n\t\t\t\t\t\t\ttmp += \"<td colspan=\\\"4\\\" class=\\\"text-center\\\" id=\\\"nodata_\"+i+\"\\\">" . $l["no_data"] . "</td>\";\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif(t.speed_cap == \"0\" || t.speed_cap == 0 || t.speed_cap == null){\n\t\t\t\t\t\t\tspeedCap = \"<td align=\\\"center\\\"><span><i class=\\\"fas fa-circle fa-circle-red\\\" title=\\\"" . $l["vps_speed_cap_disabled"] . "\\\" ></i></span></td>\";\n\t\t\t\t\t\t}else{\n\t\t\t\t\t\t\ttmp_data = t.speed_cap.split(\",\");\n\t\t\t\t\t\t\tspeedCap = \"<td align=\\\"center\\\">\"+tmp_data[1]+\" KB <img src=\\\"" . $theme["images"] . "admin/arrow_up.png\\\" title=\\\"" . $l["vps_upload_speed"] . "\\\"><br>\"+tmp_data[0]+\" KB <img src=\\\"" . $theme["images"] . "admin/arrow_down.png\\\" title=\\\"" . $l["vps_download_speed"] . "\\\"></td>\";\n\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\n\t\t\t\t\t\ttable_data += \"<tr>\";\n\t\t\t\t\t\ttable_data += status_td;\n\t\t\t\t\t\ttable_data += \"<td id=\\\"vpsid_\"+i+\"\\\">\"+t.vpsid+\"</td>\";\n\t\t\t\t\t\ttable_data += \"<td id=\\\"hostname_\"+i+\"\\\" tooltip=\\\"\"+t.hostname+\"\\\" >\"+wordwrapper(20,t.hostname)+\" (\"+t.vps_name+\")</td>\";\n\t\t\t\t\t\ttable_data += tmp;\n\t\t\t\t\t\ttable_data += \"<td>\";\n\t\t\t\t\t\ttable_data += \"<div class=\\\"spband\\\" align=\\\"center\\\" id=\\\"band_\"+i+\"\\\">\";\n\t\t\t\t\t\ttable_data += t.used_bandwidth+\",\"+((t.bandwidth != \"\") ? (t.bandwidth - t.used_bandwidth).toFixed(2) : 9999999);\n\t\t\t\t\t\ttable_data += \"</div>\";\n\t\t\t\t\t\ttable_data += \"<div class=\\\"small_txt\\\" align=\\\"center\\\" id=\\\"band2_\"+i+\"\\\">\";\n\t\t\t\t\t\ttable_data += t.used_bandwidth+\"/\"+((t.bandwidth != \"\") ? (t.bandwidth - t.used_bandwidth).toFixed(2) : \"" . $l["unlimited"] . "\")+\" GB\";\n\t\t\t\t\t\ttable_data += \"</div>\";\n\t\t\t\t\t\ttable_data += \"</td>\";\n\t\t\t\t\t\ttable_data += \"<td align=\\\"center\\\" id=\\\"netin_\"+i+\"\\\">\"+byte_convert(t.net_in, 2)+\"</td>\";\n\t\t\t\t\t\ttable_data += \"<td align=\\\"center\\\" id=\\\"netout_\"+i+\"\\\">\"+byte_convert(t.net_out, 2)+\"</td>\";\n\t\t\t\t\t\ttable_data += \"<td align=\\\"center\\\" id=\\\"io_read_\"+i+\"\\\">\"+byte_convert(t.io_read, 2)+\"</td>\";\n\t\t\t\t\t\ttable_data += \"<td align=\\\"center\\\" id=\\\"io_write_\"+i+\"\\\">\"+byte_convert(t.io_write, 2)+\"</td>\";\n\t\t\t\t\t\ttable_data += speedCap;\n\t\t\t\t\t\ttable_data += \"<td align=\\\"center\\\"><span onclick=\\\"show_graph(\"+t.vpsid+\")\\\"><i class=\\\"fas fa-chart-bar fa-2x p-1 cursor-pointer\\\"></i></span></td>\";\n\t\t\t\t\t\ttable_data += \"</tr>\";\n\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\ttmp = \"\";\n\t\t\t\t\t});\n\t\t\t\t\tshow_tooltip();\n\t\t\t\t\tvar pie_data = resp.pie_data;\n\t\t\t\t\t\t\n\t\t\t\t\t// Handle Server Ram\n\t\t\t\t\t\$.each(pie_data.server_ram, function(i, t){\n\t\t\t\t\t\tif(i == 0 && (t.used_ram != \"\")){\n\t\t\t\t\t\t\tv_ram.push({\"label\" : \"Server " . $l["free"] . "&nbsp;" . $l["ram"] . "\", data: parseFloat(t.ram - t.used_ram)});\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t// DOM-0 RAM for XEN and XCP\n\t\t\t\t\t\t}else if(i == -1 && (t.used_ram != \"\")){\n\t\t\t\t\t\t\tv_ram.push({\"label\" : \"Dom0 " . $l["used"] . "&nbsp;" . $l["ram"] . "\", data: parseFloat(t.used_ram)});\n\t\t\t\t\t\t\tv_ram.push({\"label\" : \"Dom0 " . $l["free"] . "&nbsp;" . $l["ram"] . "\", data: (parseFloat(t.ram) - parseFloat(t.used_ram))});\n\t\t\t\t\t\t}\n\t\t\t\t\t});\n\t\t\t\t\t\t\n\t\t\t\t\t// Handle Server CPU\n\t\t\t\t\tif(pie_data.server_cpu != \"\"){\n\t\t\t\t\t\tv_cpu.push(parseFloat(pie_data.server_cpu.percent_free));\n\t\t\t\t\t\t\t\n\t\t\t\t\t\tif(total_cpu < pie_data.server_cpu.percent){\n\t\t\t\t\t\t\tv_cpu.pop();\n\t\t\t\t\t\t\tv_cpu.push(parseFloat(pie_data.server_cpu.percent) - parseFloat(total_cpu));\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\t\t\n\t\t\t\t\t// Handle Server Bandwidth\n\t\t\t\t\tif(pie_data.server_bandwidth != \"\"){\n\t\t\t\t\t\t\t\n\t\t\t\t\t\tv_bandwidth.push({\"label\" : \"Server " . $l["used"] . "\", data: parseFloat(pie_data.server_bandwidth.used_gb)});\n\t\t\t\t\t\t\t\n\t\t\t\t\t\tvar free = 0; // Server Free GB\n\t\t\t\t\t\t// Show Free bandwidth if there is any\n\t\t\t\t\t\tif(pie_data.server_bandwidth.limit_gb > (total_band + pie_data.server_bandwidth.used_gb)){\n\t\t\t\t\t\t\tfree = parseFloat(pie_data.server_bandwidth.limit_gb) - (total_band + parseFloat(pie_data.server_bandwidth.used_gb));\n\t\t\t\t\t\t\tv_bandwidth.push({\"label\" : \"Server " . $l["free"] . "\", data: free});\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\t\t\n\t\t\t\t\t\$(\"#servers_list_table > tbody\").html(\"\");\n\t\t\t\t\t\t\n\t\t\t\t\t\$(\"#servers_list_table > tbody\").html(table_data);\n\t\t\t\t\t\t\n\t\t\t\t\t// Call the function to display RAM pie chart\n\t\t\t\t\t\t\n\t\t\t\t\t// Call the function to display CPU pie chart\n\t\t\t\t\t//TODO ajax call\n\t\t\t\t\tchartcpu = Chart.getChart(\"holder_cpu\");\n\t\t\t\t\tif (chartcpu != undefined) {\n\t\t\t\t\t\tchartcpu.data.datasets[0].data = v_cpu;\n\t\t\t\t\t\tchartcpu.update();\n\t\t\t\t\t} \n\t\t\t\t\n\t\t\t\t\t// Call the function to display Bandwidth pie chart\n\t\t\t\t\t\t\n\t\t\t\t\tmanage_sparkline();\n\t\t\t\t\t\n\t\t\t\t\tsetTimeout(function(){\n\t\t\t\t\t   //window.location.reload(1);\n\t\t\t\t\t   refresh_stats();\n\t\t\t\t\t}, 30000);\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\t\n\t\t\t});\n\t\t}\n\t\t\n\t\tfunction manage_sparkline(){\n\t\t\n\t\t\t// CPU Sparklines\n\t\t\t\$(\"#servers_list_table .spcpu\").sparkline(\"html\", {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype:\"pie\",\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tsliceColors: [\"#6E85B7\", \"#c8d8ff\"],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttooltipClassname: \"spPieToolTip jqstooltip\",\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttooltipFormatter: function(a, b, fields){\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\treturn \"<div class='p-1'>\"+fields[\"value\"]+\" % \"+(fields[\"offset\"] == 0 ? \"" . $l["used"] . "\" : \"" . $l["free"] . "\")+\"</div>\";\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t\t);\n\t\t\t\t\n\t\t\t// RAM Sparklines\n\t\t\t\$(\"#servers_list_table .spram\").sparkline(\"html\", {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype:\"pie\",\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tsliceColors: [\"#6E85B7\", \"#c8d8ff\"],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttooltipClassname: \"spPieToolTip jqstooltip\",\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttooltipFormatter: function(a, b, fields){\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\treturn \"<div class='p-1'>\"+fields[\"value\"]+\" MB \"+(fields[\"offset\"] == 0 ? \"" . $l["used"] . "\" : \"" . $l["free"] . "\")+\" (\"+fields[\"percent\"].toFixed(2)+\"%)</div>\";\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t\t);\n\t\t\t\t\n\t\t\t// Disk Sparklines\n\t\t\t\$(\"#servers_list_table .spdisk\").sparkline(\"html\", {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype:\"pie\",\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tsliceColors: [\"#6E85B7\", \"#c8d8ff\"],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttooltipClassname: \"spPieToolTip jqstooltip\",\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttooltipFormatter: function(a, b, fields){\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\treturn \"<div class='p-1'>\"+fields[\"value\"].toFixed(2)+\" GB \"+(fields[\"offset\"] == 0 ? \"" . $l["used"] . "\" : \"" . $l["free"] . "\")+\" (\"+fields[\"percent\"].toFixed(2)+\"%)</div>\";\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t// Inode Sparklines\n\t\t\t\$(\"#servers_list_table .spinode\").sparkline(\"html\", {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype:\"pie\",\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tsliceColors: [\"#6E85B7\", \"#c8d8ff\"],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttooltipClassname: \"spPieToolTip jqstooltip\",\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttooltipFormatter: function(a, b, fields){\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\treturn \"<div class='p-1'>\"+fields[\"value\"]+\" \"+(fields[\"offset\"] == 0 ? \"" . $l["used"] . "\" : \"" . $l["free"] . "\")+\" (\"+fields[\"percent\"].toFixed(2)+\"%)</div>\";\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t// Bandwidth Sparklines\n\t\t\t\$(\".spband\").sparkline(\"html\", {\n\t\t\t\t\t\t\t\t\t\ttype:\"pie\",\n\t\t\t\t\t\t\t\t\t\tsliceColors: [\"#6E85B7\", \"#c8d8ff\"],\n\t\t\t\t\t\t\t\t\t\ttooltipClassname: \"spPieToolTip jqstooltip\",\n\t\t\t\t\t\t\t\t\t\ttooltipFormatter: function(a, b, fields){\n\t\t\t\t\t\t\t\t\t\t\treturn \"<div class='p-1'>&nbsp;\"+(fields[\"offset\"] == 1 ? (fields[\"value\"] == \"9999999\") ? a.values[0]+\"/" . $l["unlimited"] . "\"+\" GB\"  : fields[\"value\"]+\" GB " . $l["free"] . "\" : fields[\"value\"]+\" GB " . $l["used"] . "\")+\"(\"+((fields[\"offset\"] == 1 && fields[\"value\"] == \"9999999\") ? \"0.01\" : fields[\"percent\"].toFixed(2))+\" %)</div>\";\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\n\t\t\t\$(\".spcpu, .spram, .spdisk, .spinode, .spband\").bind(\"sparklineClick\", function(ev) {\n\t\t\t\tif(window.sparkClickClrTimer){\n\t\t\t\t\t clearTimeout(window.sparkClickClrTimer);\n\t\t\t\t}\t\n\t\t\t\tvar elementPosition = \$(ev.target).position();\n\t\t\t\t\$(\".jqstooltip\").css({\"left\":(elementPosition.left+85)+'px'});\n\t\t\t\t\$(\".jqstooltip\").css({\"visibility\": \"visible\"});\n\t\t\t\twindow.sparkClickClrTimer = setTimeout(function(){ \$(\".jqstooltip\").css({\"visibility\": \"hidden\"}); }, 3000);\n\t\t\t});\n\t\t\n\t\t}\n\t\t\t\n\t\tfunction byte_convert(bytes, round_upto = 0){\n\t\t\t\t\n\t\t\t// Is it in TBs\n\t\t\tif(bytes > (1024*1024*1024*1024)){\n\t\t\t\treturn Math.round(bytes / (1024*1024*1024*1024), round_upto)+\" TB\";\n\t\t\t}\n\t\t\t\t\n\t\t\t// Is it in GBs\n\t\t\tif(bytes > (1024*1024*1024)){\n\t\t\t\treturn Math.round(bytes / (1024*1024*1024), round_upto)+\" GB\";\n\t\t\t}\n\t\t\t\t\n\t\t\t// Is it in MBs\n\t\t\tif(bytes > (1024*1024)){\n\t\t\t\treturn Math.round(bytes / (1024*1024), round_upto)+\" MB\";\n\t\t\t}\n\t\t\t\t\n\t\t\t// Is it in KBs\n\t\t\tif(bytes > 1024 && bytes < (1024*1024)){\n\t\t\t\treturn Math.round(bytes /1024, round_upto)+\" KB\";\n\t\t\t}\n\t\t\t\t\n\t\t\t// Is it in GBs\n\t\t\tif(bytes <= 1024){\n\t\t\t\treturn Math.round(bytes, round_upto)+\" B\";\n\t\t\t}\n\t\t}\n\t\t</script>\n\t\t<style>\n\t\tth{\n\t\t\twidth:auto !important; padding:5px 5px !important;\n\t\t\tbackground:#eeeef0;\n\t\t\tvertical-align:middle !important;\n\t\t}\n\t\t</style>\n\t\t<div class=\"bg\">\n\t\t\t<div class=\"row my-3 mx-auto\">\n\t\t\t\t<div class=\"col-10\">\n\t\t\t\t<h4 class=\"text-dark\"><i class=\"fas fa-chart-area\"></i> " . $l["page_head"] . "</h4>\n\t\t\t\t</div>\n\t\t\t</div>";
        echo "<div class=\"row mx-auto w-100\"><div class=\"col-sm-4\"></div><div class=\"col-sm-4\">";
        server_select();
        echo "</div></div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t<div class=\"col-sm-4\">\n\t\t\t\t\t\t<div class=\"mx-auto d-flex justify-content-center\">\n\t\t\t\t\t\t\t<canvas id=\"holder_cpu\" align=\"center\" style=\"width:150px; height: 150px\"></canvas>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"mx-auto d-flex justify-content-center\">\n\t\t\t\t\t\t\t<span class=\"p-2 h5\">" . $l["cpu_utilization"] . "</span>\n\t\t\t\t\t\t</div>\t\n\t\t\t\t\t</div>\t\n\t\t\t\t\t<div class=\"col-sm-4\">\n\t\t\t\t\t\t<div class=\"mx-auto d-flex justify-content-center\">\n\t\t\t\t\t\t\t<canvas id=\"holder_ram\" align=\"center\" style=\"width:150px; height: 150px\"></canvas>\n\t\t\t\t\t\t</div>\t\n\t\t\t\t\t\t<div class=\"mx-auto d-flex justify-content-center\">\n\t\t\t\t\t\t\t<span class=\"p-2 h5\">" . $l["ram_utilization"] . "</span>\n\t\t\t\t\t\t</div>\t\n\t\t\t\t\t</div>\t\n\t\t\t\t\t<div class=\"col-sm-4\">\n\t\t\t\t\t\t<div class=\"mx-auto d-flex justify-content-center\">\n\t\t\t\t\t\t\t<canvas id=\"holder_bandwidth\" align=\"center\" style=\"width:150px; height: 150px\"></canvas>\n\t\t\t\t\t\t</div>\t\n\t\t\t\t\t\t<div class=\"mx-auto d-flex justify-content-center\">\n\t\t\t\t\t\t\t<span class=\"p-2 h5\">" . $l["bandwidth_utilization"] . "</span>\n\t\t\t\t\t\t</div>\t\n\t\t\t\t\t</div>\n\t\t\t</div><br/>\n\t\t\t<div class=\"notice\" align=\"left\"><b>" . $l["note"] . " : </b> &nbsp; " . $l["resources_note"] . "</div>\n\t\t\t<br /> \n\t\t\t<div class=\"row mx-auto w-100 mt-3\">\n\t\t\t\t<div class=\"col-sm-12 col-lg-12 col-md-6 mb-3 p-0\">";
        page_links($globals["num_res"], $globals["cur_page"], $globals["reslen"]);
        echo "\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t\t<div class=\"mx-auto scrollbar-virt task_table\">\n\t\t\t\t\t<table class=\"table table-hover tablesorter tasks_table\" id=\"servers_list_table\">\n\t\t\t\t\t<thead>\n\t\t\t\t\t\t\t<tr>\n\t\t\t\t\t\t\t\t<th >" . $l["status"] . "</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["vpsid"], $sort_column, $sort_column_by, "vpsid", "55") . "</th>\n\t\t\t\t\t\t\t\t<th >" . $l["hostname"] . " (VID)</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["cpu"], $sort_column, $sort_column_by, "cpu", "40") . "</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["ram"], $sort_column, $sort_column_by, "ram", "40") . "</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["disk"], $sort_column, $sort_column_by, "disk", "40") . "</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["inode"], $sort_column, $sort_column_by, "inode", "55") . "</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["bandwidth"], $sort_column, $sort_column_by, "bandwidth", "80") . "</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["net_in"], $sort_column, $sort_column_by, "net_in", "80") . "</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["net_out"], $sort_column, $sort_column_by, "net_out", "65") . "</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["io_read"], $sort_column, $sort_column_by, "io_read", "70") . "</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["io_write"], $sort_column, $sort_column_by, "io_write", "70") . "</th>\n\t\t\t\t\t\t\t\t<th >" . getsortheader($l["speed_cap"], $sort_column, $sort_column_by, "speed_cap") . "</th>\n\t\t\t\t\t\t\t\t<th ></th>\n\t\t\t\t\t\t\t</tr>\n\t\t\t\t\t\t</thead>\n\t\t\t\t\t\t" . $table_data . "\n\t\t\t\t\t</table>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"row mx-auto w-100 mt-5\">\n\t\t\t\t\t<div class=\"col-sm-12 col-lg-12 col-md-6 mb-3 p-0\">";
        page_links($globals["num_res"], $globals["cur_page"], $globals["reslen"]);
        echo "\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>";
        echo "<div id=\"dialog\" style=\"display:none\" class=\"modal fade\">\n\t\t<div class=\"modal-dialog modal-lg\">\n\t\t\t<div class=\"modal-content\">\n\t\t\t\t<div class=\"modal-header align-items-center\" id=\"dialog-header\"></div>\n\t\t\t\t<div class=\"modal-body\">\n\t\t\t\t\t<div class=\"card m-3 p-3\">\n\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t\t\t<div class=\"col-sm-1\"></div>\n\t\t\t\t\t\t\t<div class=\"col-sm-2 text-center\">\n\t\t\t\t\t\t\t\t<a href=\"javascript:void(0);\" class=\"tab pan-button\" id=\"cpuinfo\" onclick=\"change_monitor_tabs(this.id);\">\n\t\t\t\t\t\t\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"-1,-3,22,28\" width=\"60\" height=\"60\" fill=\"currentColor\">\n\t\t\t\t\t\t\t\t\t\t<path d=\"M6 3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3zm0 2a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H6zm2 2h4a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1zm1 2v2h2V9H9zM6 0a1 1 0 0 1 1 1v2a1 1 0 1 1-2 0V1a1 1 0 0 1 1-1zM1 5h2a1 1 0 1 1 0 2H1a1 1 0 1 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM1 9h2a1 1 0 1 1 0 2H1a1 1 0 0 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM1 13h2a1 1 0 0 1 0 2H1a1 1 0 0 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM6 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1zm8-16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V1a1 1 0 0 1 1-1zm0 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1zM10 0a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V1a1 1 0 0 1 1-1zm0 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1z\"></path>\n\t\t\t\t\t\t\t\t\t</svg>\n\t\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t\t<label for=\"input text\" class=\"help-block\">" . $l["cpu"] . "</label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-sm-2 text-center\">\n\t\t\t\t\t\t\t\t<a href=\"javascript:void(0);\" class=\"tab pan-button\" id=\"raminfo\" onclick=\"change_monitor_tabs(this.id);\">\n\t\t\t\t\t\t\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"-1,-3,22,28\" width=\"60\" height=\"60\" fill=\"currentColor\">\n\t\t\t\t\t\t\t\t\t\t<path d=\"m14.95 7.879-.707-.707a1 1 0 0 1 1.414-1.415l.707.707 1.414-1.414-2.828-2.828L2.222 14.95l2.828 2.828 1.414-1.414L5.05 14.95a1 1 0 0 1 1.414-1.414L7.88 14.95l1.414-1.414-.707-.708A1 1 0 0 1 10 11.414l.707.707 1.414-1.414-1.414-1.414a1 1 0 0 1 1.414-1.414l1.415 1.414 1.414-1.414zM.808 13.536 13.536.808a2 2 0 0 1 2.828 0l2.828 2.828a2 2 0 0 1 0 2.828L6.464 19.192a2 2 0 0 1-2.828 0L.808 16.364a2 2 0 0 1 0-2.828z\"></path>\n\t\t\t\t\t\t\t\t\t</svg>\n\t\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t\t<label for=\"input text\" class=\"help-block\">" . $l["ram"] . "</label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-sm-2 text-center\">\n\t\t\t\t\t\t\t\t<a href=\"javascript:void(0);\" class=\"tab pan-button\" id=\"diskinfo\" onclick=\"change_monitor_tabs(this.id);\">\n\t\t\t\t\t\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"-1,-3,22,28\" width=\"60\" height=\"60\" fill=\"currentColor\">\n\t\t\t\t\t\t\t\t\t<path d=\"M10 20C4.477 20 0 15.523 0 10S4.477 0 10 0s10 4.477 10 10-4.477 10-10 10zm0-2a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm7-8a6.99 6.99 0 0 1-2.89 5.666l-.53-.796L13 14a4.992 4.992 0 0 0 2-4 4.992 4.992 0 0 0-2-4l1.2-1.6A6.99 6.99 0 0 1 17 10zm-7 3a3 3 0 1 1 0-6 3 3 0 0 1 0 6zm0-2a1 1 0 1 0 0-2 1 1 0 0 0 0 2z\"/>\n\t\t\t\t\t\t\t\t</svg>\n\t\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t\t<label for=\"input text\" class=\"help-block\">" . $l["disk"] . "/" . $l["inode"] . "</label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-sm-2 text-center\">\n\t\t\t\t\t\t\t\t<a href=\"javascript:void(0);\" class=\"tab pan-button\" id=\"ioinfo\" onclick=\"change_monitor_tabs(this.id);\">\n\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"-1,-3,22,28\" width=\"60\" height=\"60\" fill=\"currentColor\">\n\t\t\t\t\t\t\t\t<path d=\"M.832 14A9.966 9.966 0 0 1 0 10C0 4.477 4.477 0 10 0s10 4.477 10 10a9.966 9.966 0 0 1-.832 4H.832zm16.916-2a8 8 0 1 0-15.497 0h15.497zM10 5a1 1 0 1 1 0-2 1 1 0 0 1 0 2zM5 9a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm10 0a1 1 0 1 1 0-2 1 1 0 0 1 0 2zm-5-3a1 1 0 0 1 1 1v3a1 1 0 0 1-2 0V7a1 1 0 0 1 1-1z\"/>\n\t\t\t\t\t\t\t\t</svg>\n\t\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t\t<label for=\"input text\" class=\"help-block\">" . $l["disk_io"] . "</label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-sm-2 text-center\">\n\t\t\t\t\t\t\t\t<a href=\"javascript:void(0);\" class=\"tab pan-button\" id=\"ntwinfo\" onclick=\"change_monitor_tabs(this.id);\">\n\t\t\t\t\t\t\t\t<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"-1,-3,22,28\" width=\"60\" height=\"60\" fill=\"currentColor\">\n\t\t\t\t\t\t\t\t<path d=\"M10 13.992a1 1 0 1 1 0-2 1 1 0 0 1 0 2zM7.894 11.44a1 1 0 0 1-1.788-.894 4.355 4.355 0 0 1 7.788 0 1 1 0 1 1-1.788.894 2.353 2.353 0 0 0-4.212 0zM4.8 8.595a1 1 0 0 1-1.6-1.2 8.503 8.503 0 0 1 13.6 0 .999.999 0 1 1-1.6 1.2 6.503 6.503 0 0 0-10.4 0zm-3.057-2.93A1 1 0 0 1 .257 4.329c4.843-5.377 13.13-5.813 18.512-.973.342.307.667.632.974.973a.999.999 0 1 1-1.486 1.338 10.91 10.91 0 0 0-.826-.826C12.871.74 5.847 1.108 1.743 5.666z\"/>\n\t\t\t\t\t\t\t\t</svg>\n\t\t\t\t\t\t\t\t</a>\n\t\t\t\t\t\t\t\t<label for=\"input text\" class=\"help-block\">" . $l["header_ntw_speed"] . "</label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\n\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"by_month\">\n\t\t\t\t\t\t\t<div id=\"prev_month\" class=\"col-sm-4 \"></div>\n\t\t\t\t\t\t\t<div id=\"month_holder2\" class=\"col-sm-4 h5 m-0 text-center\"></div>\n\t\t\t\t\t\t\t<div id=\"next_month\" class=\"col-sm-4 d-flex justify-content-end\"></div>\t\n\t\t\t\t\t\t</div><br/>\n\t\t\t\t\t\t\n\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t\t\t<div class=\"col-sm-12\">\n\t\t\t\t\t\t\t\t<div class=\"notice\" id=\"note_box\" style=\"display: none;\">\n\t\t\t\t\t\t\t\t\t<b>NOTE : </b>&nbsp; " . $l["no_data"] . "&nbsp;" . $l["for"] . "&nbsp;<span id=\"for_month\"></span>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"cpuinfo_win\">\n\t\t\t\t\t\t\t<div class=\"col-sm-12\">\n\t\t\t\t\t\t\t\t<div id=\"legend_cpu\" class=\"legend_container\"></div>\n\t\t\t\t\t\t\t\t<div id=\"cpu_plot\" style=\"width:650px; height:400px;\">\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\n\t\t\t\t\t\t<div id=\"raminfo_win\" style=\"display:none\" class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t\t\t<div class=\"col-sm-12\">\n\t\t\t\t\t\t\t\t<div id=\"legend_ram\" class=\"legend_container\"></div>\n\t\t\t\t\t\t\t\t<div id=\"ram_plot\" style=\"width:650px; height:400px;\">\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\n\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"diskinfo_win\" style=\"display:none\">\n\t\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t\t\t\t<div class=\"col-sm-12\">\n\t\t\t\t\t\t\t\t\t<div id=\"legend_disk\" class=\"legend_container\"></div>\n\t\t\t\t\t\t\t\t\t<div id=\"disk_plot\" style=\"width:650px; height:400px;\">\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\t\n\t\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t\t\t\t<div class=\"col-sm-12\" >\n\t\t\t\t\t\t\t\t\t<div id=\"legend_inode\" class=\"legend_container\"></div>\n\t\t\t\t\t\t\t\t\t<div id=\"inode_plot\" style=\"width:650px; height:400px;\">\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\t\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\n\t\t\t\t\t\t<div id=\"ioinfo_win\" style=\"display:none;\" class=\"form-group\">\n\t\t\t\t\t\t\t<div class=\"col-sm-12\">\n\t\t\t\t\t\t\t\t<div id=\"legend_io_read\" class=\"legend_container\"></div>\n\t\t\t\t\t\t\t\t<div id=\"io_read_plot\" style=\"width:650px; height:400px;\">\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-sm-12\">\n\t\t\t\t\t\t\t\t<div id=\"legend_io_write\" class=\"legend_container\"></div>\n\t\t\t\t\t\t\t\t<div id=\"io_write_plot\" style=\"width:650px; height:400px;\">\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\n\t\t\t\t\t\t<div id=\"ntwinfo_win\" style=\"display:none;\" class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t\t\t<div class=\"col-sm-12\">\n\t\t\t\t\t\t\t\t<div id=\"legend_ntw\" class=\"legend_container\"></div>\n\t\t\t\t\t\t\t\t<div id=\"ntw\" style=\"width:650px; height:400px;\">\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\t\n\t</div>";
    }
    softfooter();
}
function byte_convert($bytes, $round_upto = 0)
{
    if(0 < $bytes) {
        return round($bytes / 0, $round_upto) . " TB";
    }
    if(1073741824 < $bytes) {
        return round($bytes / 1073741824, $round_upto) . " GB";
    }
    if(1048576 < $bytes) {
        return round($bytes / 1048576, $round_upto) . " MB";
    }
    if(1024 < $bytes && $bytes < 1048576) {
        return round($bytes / 1024, $round_upto) . " KB";
    }
    if($bytes <= 1024) {
        return round($bytes, $round_upto) . " B";
    }
}

?>