<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include_once "inc.php";
$actid = (int) $argv[1];
if(!bg_volume($actid)) {
    log_message(logdir("hotplug"), print_r($error, 1));
}
function combine_error()
{
    global $error;
    $tmp = $error;
    unset($tmp["derr"]);
    return !empty($tmp) ? implode(" ", $tmp) . " " : "";
}
function bg_volume($actid)
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $done;
    if(!load_lang("admin/volumes")) {
        return false;
    }
    task_start($actid);
    $res = makequery("SELECT * FROM `tasks`\n                    WHERE actid = :actid\n                    AND action IN ('addvolume')", [":actid" => $actid]);
    if(0 < vsql_num_rows($res)) {
        $task = vsql_fetch_assoc($res);
        $data = unserialize($task["data"]);
        $task["data"] = $data;
        $disk_config = $data["disk_config"];
        $attach = $data["attach"];
        set_active_server($data["serid"]);
        $vpsid = $task["data"]["vpsid"];
        $vps = getvps($vpsid);
        $serid = $vps["serid"];
        $inhouse_billing = $task["data"]["inhouse_billing"];
        $owner = $task["data"]["owner"];
    }
    $mnt_point = $disk_config["disks"][0]["mnt_point"];
    $disk_foramt = $task["data"]["format_type"];
    $disk_uuid = $disk_config["disks"][0]["disk_uuid"];
    $size = $disk_config["disks"][0]["size"];
    task_start($actid);
    $ret = $cluster->vps_disk_create($serid, $disk_config);
    task_update($actid, $l["creating_vol"], 20, "");
    if(empty($ret)) {
        $error[] = $l["disk_create_err"];
        $res = makequery("DELETE FROM `disks` WHERE \n\t\t\tvps_uuid = :vps_uuid AND \n\t\t\tdisk_uuid = :disk_uuid", [":vps_uuid" => $vps["uuid"], ":disk_uuid" => $disk_uuid]);
        task_update($actid, $l["disk_create_err"], -1, "");
        return false;
    }
    task_update($actid, $l["resizing_disk"], 50, "");
    $cluster->resize_attachable_disk($serid, $disk_config["disks"][0], $disk_foramt);
    if(!empty($attach)) {
        task_update($actid, $l["attaching_disk"], 60, "");
        if(!preg_match("/" . $disk_config["disks"][0]["vps_uuid"] . "/is", "attachable")) {
            $error[] = $l["disk_already_attached"];
            task_update($actid, $l["disk_already_attached"], -1, "");
        }
        if(!$cluster->get_attachable_disk($serid, $disk_config["disks"][0])) {
            $error[] = $l["no_disk_did"];
            task_update($actid, $l["no_disk_did"], -1, "");
        }
        $p_check = $cluster->persistent_check_vm($serid, $vpsid);
        if(!empty($p_check["error"])) {
            $error[] = implode($p_check["error"]);
            task_update($actid, $l["vm_not_persistent"], -1, serialize($error));
        }
        $cluster->reverse_sync($serid);
        _task_update($actid, "Hostplug disk script", 80, "group");
        _task_update($actid, "", 80, "hotplug_disk");
        $h_check = $cluster->hotplug_disk($serid, $vpsid, $disk_config["disks"][0], $mnt_point);
        _task_update($actid, "", 80, "group_end");
        if(!empty($h_check["error"])) {
            $error[] = implode($h_check["error"]);
            task_update($actid, $l["attaching_disk_error"], -1, serialize($error));
        }
        if(!empty($error)) {
            $res = update_query("UPDATE disks\n                                SET vps_uuid = :vps_uuid, \n                                num = :num\n                                WHERE disk_uuid = :disk_uuid", [":vps_uuid" => "attachable", ":num" => -1, ":disk_uuid" => $disk_uuid]);
            $attach = 0;
        }
        $cluster->reverse_sync($serid);
        if(empty($error)) {
            $res = makequery("UPDATE vps\n                        SET space = :space where vpsid = :vpsid", [":space" => $size + $vps["space"], ":vpsid" => $vpsid]);
        }
    }
    $vps_uuid = empty($attach) ? "attachable" : $vps["uuid"];
    if(!empty($inhouse_billing)) {
        $resd = makequery("SELECT did FROM `disks` \n                            WHERE disk_uuid = :disk_uuid", [":disk_uuid" => $disk_uuid]);
        $row = vsql_fetch_assoc($resd);
        $disk_did = $row["did"];
        $vals = [];
        $vals["vps_uuid"] = !empty($attach) ? $vps_uuid : $vps_uuid . "_" . $disk_did;
        $vals["uid"] = $owner;
        $vals["starttime"] = time();
        $vals["resource"] = !empty($attach) ? "space" : "volumes";
        $vals["resource_val"] = $size;
        $vals["data"] = serialize(["hostname" => $vps["hostname"], "disk_did" => $disk_did]);
        $set = [];
        foreach ($vals as $k => $v) {
            $set[$k] = "`" . $k . "` = :" . $k;
        }
        insert_and_id("INSERT INTO `usage` \n                    SET " . implode(", ", $set), $vals);
    }
    $cluster->sync($serid);
    if(!empty($error)) {
        return false;
    }
    task_update($actid, $l["completed"], 100);
    logs_admin("volumeadd", $disk_config["disks"][0]["disk_name"], 1, $disk_uuid, $disk_config["disks"][0]["user_uid"]);
    return true;
}

?>