<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include_once "inc.php";
$actid = (int) $argv[1];
if(!bg_updatevpsfirewall($actid)) {
    log_message(logdir("vpsfirewall"), print_r($error, 1));
}
if(defined("debug")) {
    r_print($GLOBALS["logr"]);
}
function bg_updatevpsfirewall($actid = "")
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $done;
    if(!load_lang("admin/editfirewall_plan")) {
        return false;
    }
    $vps_firewall_to_removed = $vps_firewall_to_add = [];
    if(!empty($actid)) {
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\tWHERE actid = :actid\n\t\t\t\t\t\tAND action IN ('updatevpsfirewall')", [":actid" => $actid]);
        if(0 < vsql_num_rows($res)) {
            $task = vsql_fetch_assoc($res);
            $data = unserialize($task["data"]);
            $vps_firewall_to_removed = $data["vps_firewall_to_removed"];
            $vps_firewall_to_add = $data["vps_firewall_to_add"];
        }
        $tmp_servers = array_keys($vps_firewall_to_removed);
        $increment_progress = ceil(0 / (double) count($tmp_servers));
        $progress = 5;
        task_start($actid);
        task_update($actid, $l["fwp_update_start"], 10, "group");
    }
    foreach ($servers as $serid => $server) {
        if($cluster->check_licensepro($serid)) {
            $cluster->sync($serid, ["firewall_plans" => []]);
            if(!empty($actid) && in_array($serid, $tmp_servers)) {
                task_update($actid, "Applying rules on server : " . $serid, $progress, "");
                $cluster->remove_multiple_vpsfirewall($serid, $vps_firewall_to_removed[$serid]);
                $cluster->apply_multiple_vpsfirewall($serid, $vps_firewall_to_add[$serid]);
                $progress = 90 < $progress + $increment_progress ? 90 : $progress + $increment_progress;
            }
        }
    }
    if(!empty($actid)) {
        task_update($actid, $l["fwp_updated"], 99);
        task_update($actid, "", 100, "group_end");
    }
    return true;
}

?>