<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function config()
{
    global $theme;
    global $servers;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $langs;
    global $skins;
    global $done;
    global $error;
    global $cluster;
    global $info;
    global $virt;
    global $centos5;
    global $val;
    global $master;
    global $SETTINGS;
    global $new_hash;
    global $timezones;
    global $mapped_timezones;
    global $valid_compression;
    if(!load_lang("admin/config")) {
        return false;
    }
    $theme["init_theme"] = "admin/config";
    $theme["init_theme_name"] = "config";
    $theme["init_theme_func"] = ["config_theme"];
    $theme["call_theme_func"] = "config_theme";
    if(!is_allowed("config")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $master = $GLOBALS["act"] == "config_slave" ? 0 : 1;
    if($master) {
        set_active_server(0);
    }
    $data = [];
    $data["is_config_master"] = $master;
    $timezones = timezones();
    $virt = $servers[$globals["server"]]["virt"];
    $val = $cluster->config_get($globals["server"]);
    $langs = $val["langs"];
    $skins = $val["skins"];
    $info = $val["globals"];
    if(!is_slave() && $master) {
        $info = load_master_settings();
    }
    if(is_numeric($info["timezone"])) {
        if(is_float($info["timezone"])) {
            $info["timezone"] = (string) $info["timezone"];
        }
        $info["timezone"] = trim($mapped_timezones[$info["timezone"]]);
    }
    $new_hash = 0;
    $reset_hash = (int) optREQ("reset_cb_hash");
    if($master && !is_slave() && (!empty($reset_hash) || empty($info["cb_hash"]))) {
        $info["cb_hash"] = generateRandStr(32);
        $res = saveglobals($info, true);
        if(!empty($res)) {
            $new_hash = $info["cb_hash"];
        }
    }
    $valid_compression = ["lzo", "lz4", "zstd"];
    if(isset($_POST["editsettings"])) {
        if(allow_slave_action() && $master) {
            reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
            return false;
        }
        $data["haproxy_enable"] = (int) (!empty($_REQUEST["haproxy_enable"]) && checkbox("haproxy_enable") ? 1 : 0);
        $data["haproxy_reservedports"] = optPOST("haproxy_reservedports");
        $data["haproxy_reservedports_http"] = optPOST("haproxy_reservedports_http");
        $data["haproxy_allowedports"] = optPOST("haproxy_allowedports");
        $validate_ports_list = ["haproxy_reservedports" => $data["haproxy_reservedports"], "haproxy_reservedports_http" => $data["haproxy_reservedports_http"], "haproxy_allowedports" => $data["haproxy_allowedports"]];
        foreach ($validate_ports_list as $k => $v) {
            if(!empty($v)) {
                $data[$k] = validate_ports_list($v);
                if(!empty($error["validate_ports_list"])) {
                    $error[$k] = $l[$k . "_inv"] . ": " . implode(", ", $error["validate_ports_list"]);
                    unset($error["validate_ports_list"]);
                }
            }
        }
        $virtualizor_reservedports = "4081-4085,5900-6200";
        foreach (["haproxy_reservedports_http", "haproxy_allowedports"] as $k => $v) {
            if(!empty($data[$v])) {
                $data[$v] = validate_ports_list($data[$v], $virtualizor_reservedports);
                if(!empty($error["validate_ports_list"])) {
                    $error[$v] = $l[$v . "_restricted"] . ": " . implode(", ", $error["validate_ports_list"]);
                    unset($error["validate_ports_list"]);
                }
            }
        }
        if(!empty($data["haproxy_allowedports"]) && !empty($data["haproxy_reservedports_http"])) {
            $data["haproxy_reservedports_http"] = validate_ports_list($data["haproxy_reservedports_http"], $data["haproxy_allowedports"], 1);
            if(!empty($error["validate_ports_list"])) {
                $error["haproxy_allowedports_http"] = $l["haproxy_allowedports_http"] . ": " . implode(", ", $error["validate_ports_list"]);
                unset($error["validate_ports_list"]);
            }
        }
        if($master) {
            $data["sn"] = iPOST("sn", $l["no_sn"]);
            $data["logo_url"] = optPOST("logo_url");
            $data["admin_mob_logo_url"] = optPOST("admin_mob_logo_url");
            $data["master_name"] = optPOST("master_name");
            $data["logo_login_url"] = optPOST("logo_login_url");
            $data["favicon_url"] = optPOST("favicon_url");
            $data["disable_login_logo"] = checkbox("disable_login_logo") ? 1 : 0;
            $data["gzip"] = (int) optPOST("gzip");
            $data["support"] = optPOST("support");
            $data["copyright"] = optPOST("copyright");
            $data["sess_len"] = (int) POST("sess_len", $l["no_sess_len"]);
            $data["theme_folder"] = POST("theme_folder", $l["no_theme"]);
            $data["language"] = POST("language", $l["no_lang"]);
            $data["band_suspend"] = (int) optPOST("band_suspend");
            $data["band_calc_creation"] = (int) optPOST("band_calc_creation");
            $data["novnc"] = (int) optPOST("novnc");
            $data["novnc_master_only"] = (int) optPOST("novnc_master_only");
            $data["del_novps_user"] = (int) optPOST("del_novps_user");
            $data["disable_icons_monitor"] = (int) optPOST("disable_icons_monitor");
            $data["disable_icons_cp"] = (int) optPOST("disable_icons_cp");
            $data["enable_enduser_vnc"] = (int) optPOST("enable_enduser_vnc");
            $data["hide_enduser_vnc_info"] = (int) optPOST("hide_enduser_vnc_info");
            $data["show_server"] = (int) optPOST("show_server");
            $data["login_attempts"] = (int) optPOST("login_attempts");
            $data["login_ban_time"] = (int) optPOST("login_ban_time");
            $data["queue_creation"] = (int) optPOST("queue_creation");
            $data["email_update_client"] = (int) optPOST("email_update_client");
            $data["admin_logs"] = (int) POST("admin_logs", $l["no_admin_logs"]);
            $data["vps_logs"] = (int) POST("vps_logs", $l["no_vps_logs"]);
            $data["login_logs"] = (int) POST("login_logs", $l["no_login_logs"]);
            $data["system_logs"] = (int) POST("system_logs", $l["no_system_logs"]);
            $data["status_logs"] = (int) POST("status_logs", $l["no_status_logs"]);
            $data["bandwidth_logs"] = (int) POST("bandwidth_logs", $l["no_bandwidth_logs"]);
            $data["haproxy_cron_logs"] = (int) optPOST("haproxy_cron_logs", $l["no_haproxy_cron_logs"]);
            $data["enable_rdns"] = checkbox("enable_rdns") ? 1 : 0;
            $data["auto_add_zone"] = checkbox("auto_add_zone") ? 1 : 0;
            $data["disable_apicredential"] = checkbox("disable_apicredential") ? 1 : 0;
            $data["enable_console"] = checkbox("enable_console") ? 1 : 0;
            $data["disable_master_vpsname"] = checkbox("disable_master_vpsname") ? 1 : 0;
            $data["disable_newtheme"] = checkbox("disable_newtheme") ? 1 : 0;
            $data["enable_idsort"] = checkbox("enable_idsort") ? 1 : 0;
            $data["site_domain"] = optPOST("site_domain");
            $data["showsearch"] = (int) optPOST("showsearch");
            $data["turnon_virtdf"] = checkbox("turnon_virtdf") ? 1 : 0;
            $data["disable_recipes"] = (int) (checkbox("disable_recipes") ? 1 : 0);
            $data["eu_allow_virtio"] = (int) (checkbox("eu_allow_virtio") ? 1 : 0);
            $data["disable_rescue"] = (int) (checkbox("disable_rescue") ? 1 : 0);
            $data["disable_change_hostname"] = (int) (checkbox("disable_change_hostname") ? 1 : 0);
            $data["disable_change_password"] = (int) (checkbox("disable_change_password") ? 1 : 0);
            $data["disable_change_vnc_password"] = (int) (checkbox("disable_change_vnc_password") ? 1 : 0);
            $data["disable_vps_config"] = (int) (checkbox("disable_vps_config") ? 1 : 0);
            $data["disable_os_reinstall"] = (int) (checkbox("disable_os_reinstall") ? 1 : 0);
            $data["disable_ssh"] = (int) (checkbox("disable_ssh") ? 1 : 0);
            $data["disable_suspend_email"] = (int) (checkbox("disable_suspend_email") ? 1 : 0);
            $data["disable_self_shutdown"] = (int) (checkbox("disable_self_shutdown") ? 1 : 0);
            $data["disable_server_location"] = (int) (checkbox("disable_server_location") ? 1 : 0);
            $data["disable_enduser_sshkeys"] = (int) (checkbox("disable_enduser_sshkeys") ? 1 : 0);
            $data["disable_vga"] = (int) (checkbox("disable_vga") ? 1 : 0);
            $data["del_tasks"] = (int) optPOST("del_tasks");
            $data["del_notifications"] = (int) optPOST("del_notifications");
            $data["del_api_logs"] = (int) optPOST("del_api_logs");
            $data["enable_nic"] = (int) (checkbox("enable_nic") ? 1 : 0);
            $data["enable_cb"] = (int) (checkbox("enable_cb") ? 1 : 0);
            $data["cloud_allow_virtio"] = (int) (checkbox("cloud_allow_virtio") ? 1 : 0);
            $data["2fa_email_otp"] = (int) (checkbox("2fa_email_otp") ? 1 : 0);
            $data["enable_2fa"] = (int) (checkbox("enable_2fa") ? 1 : 0);
            $data["pass_strength"] = (int) optPOST("pass_strength");
            $data["enable_eu_iso_boot"] = checkbox("enable_eu_iso_boot") ? 1 : 0;
            $data["secure_allowed_ips"] = optPOST("secure_allowed_ips");
            $data["secure_allowed_api_ips"] = optPOST("secure_allowed_api_ips");
            $data["disable_terminal_access"] = optPOST("disable_terminal_access");
            $data["backup_email"] = optPOST("backup_email");
            $data["backup_disable_success_mail"] = checkbox("backup_disable_success_mail") ? 1 : 0;
            $data["set_def_hvm"] = (int) (checkbox("set_def_hvm") ? 1 : 0);
            $data["max_ipv4s"] = optPOST("max_ipv4s") ? (int) optPOST("max_ipv4s") : "";
            $data["max_ipv6s"] = optPOST("max_ipv6s") ? (int) optPOST("max_ipv6s") : "";
            $data["max_ipv6_subnets"] = optPOST("max_ipv6_subnets") ? (int) optPOST("max_ipv6_subnets") : "";
            $data["max_internal_ips"] = optPOST("max_internal_ips") ? (int) optPOST("max_internal_ips") : "";
            $data["disable_enduser_panel"] = (int) (checkbox("disable_enduser_panel") ? 1 : 0);
            $data["allow_cloud_dom_name"] = (int) (checkbox("allow_cloud_dom_name") ? 1 : 0);
            $data["allow_cloud_ebt_disable"] = (int) (checkbox("allow_cloud_ebt_disable") ? 1 : 0);
            $data["enable_backup_delete"] = (int) (checkbox("enable_backup_delete") ? 1 : 0);
            $data["enable_backup_delete_cron"] = (int) optPOST("enable_backup_delete_cron");
            $data["disable_2tb_check"] = (int) (checkbox("disable_2tb_check") ? 1 : 0);
            $data["disable_ebtables"] = (int) (checkbox("disable_ebtables") ? 1 : 0);
            $data["disable_ebtables_internal"] = (int) (checkbox("disable_ebtables_internal") ? 1 : 0);
            $data["disable_domain_forward"] = (int) (checkbox("disable_domain_forward") ? 1 : 0);
            $data["show_vps_active_time"] = (int) (checkbox("show_vps_active_time") ? 1 : 0);
            $data["power_only_option"] = (int) (checkbox("power_only_option") ? 1 : 0);
            $data["disable_logs"] = (int) (checkbox("disable_logs") ? 1 : 0);
            $data["disable_change_primary_ip"] = (int) (checkbox("disable_change_primary_ip") ? 1 : 0);
            $data["vz6_style_suspend"] = (int) (checkbox("vz6_style_suspend") ? 1 : 0);
            $data["show_server_selection_logs"] = (int) (checkbox("show_server_selection_logs") ? 1 : 0);
            $data["enable_ver_scaling"] = (int) optPOST("enable_ver_scaling");
            if(!empty($data["enable_ver_scaling"])) {
                $arr = ["ver_max_ram", "ver_ram_threshold", "ver_ram_inc_by", "ver_max_cpu", "ver_cpu_threshold", "ver_cpu_inc_by"];
                foreach ($arr as $v) {
                    $data[$v] = (int) POST($v, $l[$v . "_err"]);
                }
            }
            $data["resource_preference"] = (int) optPOST("resource_preference");
            $data["hide_acc_password"] = (int) (checkbox("hide_acc_password") ? 1 : 0);
            $data["hide_forgot_password"] = (int) (checkbox("hide_forgot_password") ? 1 : 0);
            $data["compression_algo"] = optPOST("compression_algo");
            $data["disable_volume_enduser"] = (int) (checkbox("disable_volume_enduser") ? 1 : 0);
            $data["disable_lb_enduser"] = (int) (checkbox("disable_lb_enduser") ? 1 : 0);
            $data["disable_virttype"] = (int) (checkbox("disable_virttype") ? 1 : 0);
            $data["hide_eu_tasks"] = (int) (checkbox("hide_eu_tasks") ? 1 : 0);
            $data["save_vm_pass"] = (int) (checkbox("save_vm_pass") ? 1 : 0);
            $data["dont_delete_bw_from_db"] = (int) (checkbox("dont_delete_bw_from_db") ? 1 : 0);
            $data["add_ptr_record"] = (int) (checkbox("add_ptr_record") ? 1 : 0);
            $data["from_email"] = optPOST("from_email");
            $data["update"] = (int) optPOST("update");
            $data["email_update"] = (int) (checkbox("email_update") ? 1 : 0);
            $data["vps_bandwidth_threshold"] = (int) optPOST("vps_bandwidth_threshold");
            $data["backup_queue"] = (int) optPOST("backup_queue");
            $data["restore_queue"] = (int) optPOST("restore_queue");
            $data["disable_recipe_reinstall"] = (int) (checkbox("disable_recipe_reinstall") ? 1 : 0);
            $data["disable_notifications"] = (int) (checkbox("disable_notifications") ? 1 : 0);
            $data["use_win_script"] = (int) (checkbox("use_win_script") ? 1 : 0);
            if(!empty($data["add_ptr_record"])) {
                $res = makequery("SELECT * FROM pdns");
                if(!vsql_num_rows($res)) {
                    $error[] = $l["no_pdns_servers"];
                }
            }
            if(isset($_REQUEST["enable_eu_iso"]) && empty($data["enable_eu_iso_boot"])) {
                $error[] = $l["enable_eu_iso_error"];
            }
            if(!empty($data["enable_eu_iso_boot"])) {
                $data["enable_eu_iso"] = checkbox("enable_eu_iso") ? 1 : 0;
                if(!empty($data["enable_eu_iso"])) {
                    $data["eu_iso_limit"] = (int) optPOST("eu_iso_limit");
                    $data["eu_iso_size"] = (int) optPOST("eu_iso_size");
                    $data["eu_iso_space"] = (int) optPOST("eu_iso_space");
                    $data["eu_iso_del_hr"] = (int) optPOST("eu_iso_del_hr");
                    if($data["eu_iso_limit"] <= 0 || $data["eu_iso_size"] <= 0 || $data["eu_iso_space"] <= 0) {
                        $error[] = $l["inv_eu_iso_limit"];
                    }
                    if($data["eu_iso_del_hr"] < 0) {
                        $error[] = $l["eu_iso_del_hr_err"];
                    }
                }
            } else {
                $data["enable_eu_iso"] = 0;
            }
            if(!empty($data["pass_strength"]) && 100 < $data["pass_strength"]) {
                $error[] = $l["inv_pass_limit"];
            }
            if(!empty($data["enable_cb"])) {
                $data["cb_use_https"] = (int) POST("cb_use_https", $l["no_use_https"]);
                if(empty($data["cb_use_https"])) {
                    $http_protcol = "http://";
                } else {
                    $http_protcol = "https://";
                }
                $data["cb_url"] = POST("cb_url", $l["no_cb_url"]);
                if(filter_var($http_protcol . $data["cb_url"], FILTER_VALIDATE_URL) === false) {
                    $error[] = $l["inv_cv_url"];
                }
                $data["cb_suspend"] = (int) (checkbox("cb_suspend") ? 1 : 0);
                $data["cb_unsuspend"] = (int) (checkbox("cb_unsuspend") ? 1 : 0);
                $data["cb_hostname"] = (int) (checkbox("cb_hostname") ? 1 : 0);
                $data["cb_terminate"] = (int) (checkbox("cb_terminate") ? 1 : 0);
                $data["cb_changeips"] = (int) (checkbox("cb_changeips") ? 1 : 0);
                $data["cb_login_whmcs_user"] = (int) (checkbox("cb_login_whmcs_user") ? 1 : 0);
                $data["cb_invoice_whmcs_user"] = (int) (checkbox("cb_invoice_whmcs_user") ? 1 : 0);
            } else {
                $data["cb_use_https"] = 0;
                $data["cb_url"] = "";
                $data["cb_suspend"] = 0;
                $data["cb_unsuspend"] = 0;
                $data["cb_hostname"] = 0;
                $data["cb_terminate"] = 0;
                $data["cb_changeips"] = 0;
            }
            $tmp_c_timeout = (int) optPOST("curl_timeout");
            if(3 < $tmp_c_timeout) {
                $data["curl_timeout"] = $tmp_c_timeout;
            }
            $data["default_sg_name"] = optPOST("default_sg_name");
            $data["default_sg_reseller_name"] = optPOST("default_sg_reseller_name");
            $data["server_ram_threshold"] = (int) optPOST("server_ram_threshold");
            $data["server_disk_threshold"] = (int) optPOST("server_disk_threshold");
            $data["default_sg_desc"] = optPOST("default_sg_desc");
            $data["default_enduser_timezone"] = optPOST("default_enduser_timezone");
            $tmp_mac = optPOST("custom_mac");
            if(!empty($tmp_mac)) {
                if(strlen($tmp_mac) != 8 || !valid_mac($tmp_mac . ":00:00:00")) {
                    $error["invalid_mac"] = $l["invalid_mac"];
                    return false;
                }
                if(hexdec(substr($tmp_mac, 1, 1)) % 2 != 0) {
                    $error["inv_multicast_mac"] = $l["inv_multicast_mac"];
                    return false;
                }
                $data["custom_mac"] = $tmp_mac;
            } else {
                $data["custom_mac"] = "";
            }
            $allowed_ip_settings = ["secure_allowed_ips", "secure_allowed_api_ips"];
            foreach ($allowed_ip_settings as $av) {
                $err_ips = [];
                if(!empty($data[$av])) {
                    $_sec_aip = cexplode(",", $data[$av]);
                    foreach ($_sec_aip as $k => $v) {
                        if(!valid_ip($v)) {
                            $err_ips[] = $v;
                        }
                    }
                    if(!empty($err_ips)) {
                        $error[$av] = $l[$av . "_inv"] . ": " . implode(",", $err_ips);
                    }
                    $data[$av] = implode(",", $_sec_aip);
                } else {
                    $data[$av] = "";
                }
            }
        } else {
            $data["cron_time"] = POST("cron_time", $l["no_cron_time"]);
            $data["emps_cron_time"] = POST("emps_cron_time", $l["no_emps_cron_time"]);
            $data["cookie_name"] = POST("cookie_name", $l["no_cookie_name"]);
            $data["vpslimit"] = optPOST("vpslimit");
            $data["overcommit"] = (int) optPOST("overcommit");
            $data["vnc_ip"] = optPOST("vnc_ip");
            $data["vcores"] = (int) optPOST("vcores");
            $data["disable_nw_config"] = (int) optPOST("disable_nw_config");
            $data["bw_cal_config"] = (int) optPOST("bw_cal_config");
            $data["change_ssh_port"] = (int) optPOST("change_ssh_port");
            $data["max_ssh_login"] = (int) optPOST("max_ssh_login");
            if(!empty($data["vcores"])) {
                $res = makequery("SELECT SUM(cores) as used_cores FROM vps \n\t\t\t\t\t\t\t\tWHERE serid = :serid", [":serid" => $globals["server"]]);
                $row = vsql_fetch_assoc($res);
                if($data["vcores"] < $row["used_cores"]) {
                    $error[] = lang_vars_name($l["current_cores_in_use"], ["cores_in_use" => (int) $row["used_cores"]]);
                    return false;
                }
            }
            if($cluster->virt(0, 1, 1, 0, 1)) {
                $data["xen_pvbridge"] = optPOST("xen_pvbridge");
                $data["xen_hvmbridge"] = optPOST("xen_hvmbridge");
                $data["use_xl"] = (int) optPOST("use_xl");
                $data["xen_dm_version"] = (int) optPOST("xen_dm_version");
            }
            $data["haproxy_src_ips"] = optPOST("haproxy_src_ips");
            if(!empty($data["haproxy_src_ips"])) {
                $haproxy_src_ips = cexplode(",", $data["haproxy_src_ips"]);
                foreach ($haproxy_src_ips as $k => $v) {
                    if(!valid_ip($v)) {
                        $err_ips[] = $v;
                    }
                }
                if(!empty($err_ips)) {
                    $error["haproxy_src_ips"] = $l["haproxy_src_ips_inv"] . ": " . implode(",", $err_ips);
                }
                $data["haproxy_src_ips"] = implode(",", $haproxy_src_ips);
            }
            $data["server_city"] = optPOST("server_city");
            $data["server_state"] = optPOST("server_state");
            $data["server_country_code"] = optPOST("server_country_code");
            if(empty($data["server_country_code"]) && (!empty($data["server_city"]) || !empty($data["server_state"]))) {
                $error["state_city"] = $l["error_state_city"];
                return false;
            }
            $location = ["country_code" => "", "state" => "", "city" => ""];
            if(!empty($data["server_country_code"])) {
                $location["country_code"] = $data["server_country_code"];
                if(!empty($data["server_state"])) {
                    $location["state"] = $data["server_state"];
                }
                if(!empty($data["server_city"])) {
                    $location["city"] = $data["server_city"];
                }
            }
        }
        if(empty($master) && $cluster->virt(0, 0, 0, 0, 0, 0, 0, 1)) {
            $data["proxmox_server_name"] = optPOST("proxmox_server_name");
            $proxmox_server_pass = optPOST("proxmox_server_pass");
            if(!empty($proxmox_server_pass)) {
                $temp_salt = empty($info["proxmox_server_pass_salt"]) ? generateRandStr(8) : $info["proxmox_server_pass_salt"];
                $data["proxmox_server_pass_salt"] = $temp_salt;
                $data["proxmox_server_pass"] = $_POST["proxmox_server_pass"];
                if(empty($globals["server"])) {
                    $data["proxmox_server_pass"] = pass_encrypt($_POST["proxmox_server_pass"], $temp_salt);
                }
            }
            $data["proxmox_tfa_secret"] = optPOST("proxmox_tfa_secret");
        }
        if($master || empty($master) && $cluster->virt(0, 1, 1, 0, 1)) {
            $data["pv_on_hvm"] = (int) optPOST("pv_on_hvm");
            $data["xen_dom0mem"] = (int) optPOST("xen_dom0mem");
        }
        $memory_limit = (int) optPOST("memory_limit");
        $data["memory_limit"] = ($memory_limit < 128 ? 128 : $memory_limit) . "M";
        $data["cpu_nm"] = (int) optPOST("cpu_nm");
        $data["soft_email"] = POST("soft_email", $l["no_soft_email"]);
        $data["timezone"] = POST("timezone", $l["no_timezone"]);
        $data["novnc_server_name"] = (int) optPOST("novnc_server_name");
        $data["interface"] = optPOST("interface");
        $data["node_bandwidth"] = (int) optPOST("node_bandwidth");
        $data["alert_load_limit"] = (int) optPOST("alert_load_limit");
        $data["alert_disk_limit"] = (int) optPOST("alert_disk_limit");
        $data["ping_ip"] = optPOST("ping_ip");
        $data["del_slave_ostemplate"] = (int) optPOST("del_slave_ostemplate");
        $data["keep_orphan_template"] = (int) optPOST("keep_orphan_template");
        $data["disable_virttop"] = (int) optPOST("disable_virttop");
        $data["disable_virtsparsify"] = (int) optPOST("disable_virtsparsify");
        $data["openvz_suspend_load"] = (double) optPOST("openvz_suspend_load");
        $data["speed_cap_disable"] = (int) optPOST("speed_cap_disable");
        $data["disable_slave_db_backup"] = checkbox("disable_slave_db_backup") ? 1 : 0;
        $data["set_vps_config_mtu"] = checkbox("set_vps_config_mtu") ? 1 : 0;
        $data["temporary_st_directory"] = optPOST("temporary_st_directory", "");
        $data["temporary_st_directory"] = cleanpath($data["temporary_st_directory"]);
        if(!empty($data["temporary_st_directory"]) && !$cluster->check_is_directory($globals["server"], $data["temporary_st_directory"])) {
            $error["no_temp_dir"] = $l["no_temp_dir_exists"];
        }
        $data["disable_guest_agent"] = checkbox("disable_guest_agent") ? 1 : 0;
        $data["enable_ldap_auth"] = (int) optPOST("enable_ldap_auth");
        if(!empty($data["enable_ldap_auth"])) {
            $data["ldap_server"] = POST("ldap_server", $l["no_ldap_server"]);
            $data["ldap_port"] = (int) optPOST("ldap_port", 389);
            $data["ldap_admin_username"] = POST("ldap_admin_username", $l["no_ldap_admin_username"]);
            $ldap_update_password = "";
            if(!empty($_POST["ldap_admin_password"])) {
                $data["ldap_admin_password"] = optPOST("ldap_admin_password");
                $ldap_update_password = $data["ldap_admin_password"];
                $data["ldap_admin_password_salt"] = empty($info["ldap_admin_password_salt"]) ? generateRandStr(8) : $info["ldap_admin_password_salt"];
                $data["ldap_admin_password"] = pass_encrypt($data["ldap_admin_password"], $data["ldap_admin_password_salt"]);
            }
            if(empty($data["ldap_admin_password"]) && empty($globals["ldap_admin_password"])) {
                $data["ldap_admin_password"] = POST("ldap_admin_password", $l["no_ldap_admin_password"]);
            }
            $data["ldap_search_base"] = POST("ldap_search_base", $l["no_ldap_search_base"]);
            if(!empty($error)) {
                return false;
            }
            if(!preg_match("/^(?:(?:[a-zA-Z]+=[^,]+,?)+,?)+\$/is", $data["ldap_search_base"])) {
                $error[] = $l["inv_ldap_search_base"];
                return false;
            }
            $ldap_admin_password = !empty($ldap_update_password) ? $ldap_update_password : pass_decrypt($globals["ldap_admin_password"], $globals["ldap_admin_password_salt"]);
            if(!check_ldap_connection($data["ldap_server"], $data["ldap_port"], $data["ldap_admin_username"], $ldap_admin_password)) {
                return false;
            }
        } else {
            $data["ldap_search_base"] = "";
            $data["ldap_admin_password"] = $data["ldap_search_base"];
            $data["ldap_admin_username"] = $data["ldap_admin_password"];
            $data["ldap_server"] = $data["ldap_admin_username"];
            $data["ldap_port"] = 389;
        }
        if($master || empty($master) && $cluster->virt(1)) {
            $data["enable_tuntap_cp"] = (int) optPOST("enable_tuntap_cp");
            $data["enable_ppp_cp"] = (int) optPOST("enable_ppp_cp");
            $data["vswap"] = $info["vswap"];
            $data["ploop"] = (int) optPOST("ploop");
            $data["disable_backup_cp"] = (int) optPOST("disable_backup_cp");
            $data["enable_fuse_cp"] = (int) optPOST("enable_fuse_cp");
            $data["enable_ipip_cp"] = (int) optPOST("enable_ipip_cp");
            $data["enable_ipgre_cp"] = (int) optPOST("enable_ipgre_cp");
            $data["enable_nfs_cp"] = (int) optPOST("enable_nfs_cp");
            $data["enable_quotaugidlimit_cp"] = (int) optPOST("enable_quotaugidlimit_cp");
            $data["enable_iolimit_cp"] = (int) optPOST("enable_iolimit_cp");
            $data["enable_iopslimit_cp"] = (int) optPOST("enable_iopslimit_cp");
        }
        $data["addvs_cpu_prio"] = optPOST("addvs_cpu_prio");
        $data["addvs_io_prio"] = optPOST("addvs_io_prio");
        $data["addvs_io_class"] = optPOST("addvs_io_class");
        if(!empty($error)) {
            return false;
        }
        if($master) {
            if(!in_array($data["theme_folder"], $skins)) {
                $error["theme"] = $l["wrong_theme"];
            }
            if($data["login_attempts"] < 2) {
                $error["login_attempts"] = $l["login_attempts_invalid"];
            }
            if($data["login_ban_time"] < 2) {
                $error["login_ban_time"] = $l["login_ban_time_invalid"];
            }
            if(!in_array($data["language"], $langs)) {
                $error["language"] = $l["wrong_lang"];
            }
        } else {
            if(preg_match("/[^A-Za-z0-9]/is", $data["cookie_name"])) {
                $error["cookie_name"] = $l["invalid_cookie_name"];
                return false;
            }
            if(!empty($data["vnc_ip"]) && !valid_ip($data["vnc_ip"]) && !is_valid_domain_name($data["vnc_ip"])) {
                $error["vnc_ip"] = $l["wrong_vnc_ip"];
                return false;
            }
            if(empty($error)) {
                $token_vals = [":vnc_ip" => $data["vnc_ip"], ":serid" => $globals["server"]];
                if(!empty($location)) {
                    $token_vals[":location"] = json_encode($location);
                }
                $res = makequery("UPDATE `servers` SET \n\t\t\t\t\t\t\t\t" . (!empty($location) ? "location = :location," : "") . "\n\t\t\t\t\t\t\t\tvnc_ip = :vnc_ip\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\tWHERE serid = :serid", $token_vals);
            }
        }
        if($data["update"] < 0 || 2 < $data["update"]) {
            $error[] = $l["invalid_update"];
            return false;
        }
        if(!valid_ip($data["ping_ip"]) && !empty($data["ping_ip"])) {
            $error["ping_ip"] = $l["wrong_ping_ip"];
            return false;
        }
        if($data["xen_dom0mem"] < 512 && $cluster->virt(0, 1, 1, 0, 1)) {
            $error[] = $l["invalid_xen_dom0mem"];
            return false;
        }
        if(!empty($data["timezone"]) && !is_numeric($data["timezone"])) {
            $error["timezone"] = $l["wrong_timezone"];
            foreach ($timezones as $tk => $tv) {
                if(array_key_exists($data["timezone"], $tv)) {
                    unset($error["timezone"]);
                }
            }
        }
        if(!empty($data["alert_disk_limit"]) && ($data["alert_disk_limit"] < 1 || 100 < $data["alert_disk_limit"])) {
            $error[] = $l["invalid_disk_limit"];
            return false;
        }
        if(!emailvalidation($data["soft_email"])) {
            $error["soft_email"] = $l["wrong_soft_email"];
            return false;
        }
        if(!empty($error)) {
            return false;
        }
        if(empty($master)) {
            $tmp_data = [];
            foreach ($SETTINGS as $sk => $sv) {
                if(preg_match("/s/", $sv) && array_key_exists($sk, $data)) {
                    $tmp_data[$sk] = $data[$sk];
                }
            }
            if(!empty($tmp_data)) {
                if(!empty($proxmox_server_pass) && is_master() && !empty($globals["server"])) {
                    $tmp_data["proxmox_server_pass"] = pass_encrypt($data["proxmox_server_pass"], $temp_salt);
                }
                $res = makequery("UPDATE `servers` SET\n\t\t\t\t\t\t\t\tsettings = :settings\n\t\t\t\t\t\t\t\tWHERE serid = :serid", [":settings" => serialize($tmp_data), ":serid" => $globals["server"]]);
            }
        } else {
            writefile($globals["path"] . "/master.json", json_encode($data, JSON_PRETTY_PRINT), 1, 384);
        }
        $result = $cluster->config_save($globals["server"], $data);
        if(!$result) {
            $error[] = $l["saving_error"];
            return false;
        }
        logs_admin("config", "", 1, 0, $user["uid"]);
        $done = true;
        vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/sync_config.php > " . logdir() . "sync_config.log 2>&1 &");
    }
    $val = $cluster->config_get($globals["server"]);
    $langs = $val["langs"];
    $skins = $val["skins"];
    $info = $val["globals"];
    if(!is_slave() && $master) {
        $info = load_master_settings();
    }
    if(is_numeric($info["timezone"])) {
        if(is_float($info["timezone"])) {
            $info["timezone"] = (string) $info["timezone"];
        }
        $info["timezone"] = trim($mapped_timezones[$info["timezone"]]);
    }
    $res = makequery("SELECT * FROM vps WHERE serid = :serid", [":serid" => $globals["server"]]);
    if(0 < vsql_num_rows($res)) {
        $info["vg_in_use"] = 1;
    } else {
        $info["vg_in_use"] = 0;
    }
}
function API_config()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $langs;
    global $skins;
    global $done;
    global $info;
    global $new_hash;
    global $timezones;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = 1;
    }
    if(!empty($new_hash)) {
        $GLOBALS["_api"]["new_hash"] = $new_hash;
    }
    $GLOBALS["_api"]["globals"] = $globals;
    unset($GLOBALS["_api"]["globals"]["pdo_conn"]);
    $GLOBALS["_api"]["info"] = $info;
    unset($GLOBALS["_api"]["info"]["pdo_conn"]);
    $GLOBALS["_api"]["langs"] = $langs;
    $GLOBALS["_api"]["skins"] = $skins;
    $GLOBALS["_api"]["timezones"] = $timezones;
}

?>