<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addiso()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $addiso;
    global $mgs;
    global $done;
    global $actid;
    global $actid_msg;
    if(!load_lang("admin/addiso")) {
        return false;
    }
    $theme["init_theme"] = "admin/addiso";
    $theme["init_theme_name"] = "addiso";
    $theme["init_theme_func"] = ["addiso_theme"];
    $theme["call_theme_func"] = "addiso_theme";
    if(!is_allowed("addiso")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    if(!is_dir($globals["isos"])) {
        mkdir($globals["isos"], 493, 1);
    }
    $mgs = listmgs();
    if(isset($_POST["addiso"])) {
        $newiso = [];
        $newiso["isofile"] = POST("filename", $l["no_isofile"]);
        $newiso["isourl"] = optPOST("url");
        if(!empty($newiso["isourl"])) {
            $str = parse_url($newiso["isourl"]);
            if(filter_var($newiso["isourl"], FILTER_VALIDATE_URL) === false || !in_array($str["scheme"], ["http", "https", "ftp"])) {
                $error[] = $l["invalid_url"];
                return false;
            }
            $newiso["isofsize"] = (int) @getremoteheader($newiso["isourl"]);
        } else {
            $newiso["isofsize"] = (double) @vfilesize($globals["isos"] . "/" . $newiso["isofile"]);
        }
        if(!empty($error)) {
            return false;
        }
        if(empty($newiso["isofsize"])) {
            $error[] = $l["err_size"];
            return false;
        }
        $res = makequery("DELETE FROM iso\n\t\t\tWHERE iso = :iso_file", [":iso_file" => $newiso["isofile"]]);
        if(!empty($_POST["mgs"])) {
            foreach ($_POST["mgs"] as $k => $v) {
                $v = (int) $v;
                if(empty($mgs[$v])) {
                } else {
                    $newiso["mgs"][$v] = $v;
                }
            }
        }
        $t_arr = [];
        $t_qry = "";
        $t_arr[":uuid"] = generateRandStr(16);
        $t_arr[":iso"] = $newiso["isofile"];
        if(!empty($newiso["mgs"])) {
            $t_qry = ",mg = :mg";
            $t_arr[":mg"] = implode(",", $newiso["mgs"]);
        }
        $res = makequery("INSERT INTO iso\n\t\t\t\tSET iso = :iso,\n\t\t\t\tuuid = :uuid\n\t\t\t\t" . $t_qry, $t_arr);
        if(!empty($newiso["isourl"])) {
            $is_api = is_api_call();
            if($is_api) {
                $res = makequery("SELECT * FROM `iso`\n\t\t\t\t\t\t\tWHERE `iso`=:iso LIMIT 1", [":iso" => $newiso["isofile"]]);
                if(0 < vsql_num_rows($res)) {
                    $get_iso = vsql_fetch_assoc($res);
                }
                if(empty($get_iso)) {
                    $done = false;
                    $error[] = $l["aiso_no_iso_db_ent"];
                    return NULL;
                }
                $get_iso["url"] = $newiso["isourl"];
                $disk_size = get_free_space($globals["isos"]);
                $iso_size = round(getremoteheader($newiso["isourl"]) / 1024 / 1024);
                if($disk_size < $iso_size) {
                    $error[] = $l["low_space_iso"];
                    return false;
                }
                $data = ["progress_msg" => $l["aiso_chk_dat"], "get_iso" => $get_iso];
                $actid = tasks_admin_process("addiso", serialize($data), 10, 0, $user["uid"], 0, 0);
                $actid_msg = $l["aiso_task_start"];
                vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/download_iso.php " . $actid . " > " . logdir() . "download_iso.log 2>&1 &");
                $done = true;
            } else {
                redirect("act=downloadiso&getiso=" . urlencode($newiso["isofile"]) . "&url=" . urlencode($newiso["isourl"]));
            }
        }
        $done = 1;
        return true;
    }
}
function API_addiso()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $ipblocks;
    global $error;
    global $cluster;
    global $isos;
    global $mgs;
    global $done;
    global $actid;
    global $actid_msg;
    $GLOBALS["_api"]["isos"] = $isos;
    $GLOBALS["_api"]["mgs"] = $mgs;
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = 1;
    }
    if(!empty($actid)) {
        $GLOBALS["_api"]["actid"] = $actid;
        $GLOBALS["_api"]["actid_msg"] = $actid_msg;
    }
}

?>