<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addpassthrough()
{
    global $theme;
    global $globals;
    global $user;
    global $l;
    global $cluster;
    global $error;
    global $servers;
    global $servergroups;
    global $passthroughs;
    global $done;
    global $passthrough_types;
    global $gpu_roms;
    if(!load_lang("admin/addpassthrough")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["cant_add"], $l["cant_add_exp"], $l["cant_add_head"]);
        return false;
    }
    $theme["init_theme"] = "admin/addpassthrough";
    $theme["init_theme_name"] = "Add passthrough";
    $theme["init_theme_func"] = ["addpassthrough_theme"];
    $theme["call_theme_func"] = "addpassthrough_theme";
    if(!is_allowed("addpassthrough")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    if(!check_licensepro() && empty($globals["is_master_only"])) {
        $error[] = $l["require_prolic"];
        return false;
    }
    $done = 0;
    $db = [];
    $servergroups = server_groups();
    $passthrough_types = ["pci" => "PCI", "usb" => "USB"];
    $passthroughs["pcis"] = $cluster->pci_manager($globals["server"], [], "node_pcis");
    $passthroughs["usbs"] = $cluster->usb_manager($globals["server"], [], "node_usbs");
    if(!empty($passthroughs["pcis"]["err"])) {
        foreach ($passthroughs["pcis"]["err"] as $v) {
            unset($passthroughs["pcis"]["node_pcis"][$v]);
        }
        unset($passthroughs["pcis"]["err"]);
    }
    $gpu_roms = $cluster->pci_manager($globals["server"], [], "node_gpuroms");
    $res = makequery("SELECT serid, dev_fullname, `type` from passthrough WHERE serid = :serid", [":serid" => $globals["server"]]);
    if(vsql_num_rows($res)) {
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(preg_match("/pci/", $row["type"])) {
                $del = array_keys($passthroughs["pcis"]["node_pcis"], $row["dev_fullname"]);
                if(!empty($del)) {
                    unset($passthroughs["pcis"]["node_pcis"][$del[0]]);
                    unset($passthroughs["pcis"]["dumpxml"][$del[0]]);
                }
            } elseif(preg_match("/usb/", $row["type"])) {
                $del = array_keys($passthroughs["usbs"]["node_usbs"], $row["dev_fullname"]);
                if(!empty($del)) {
                    unset($passthroughs["usbs"]["node_usbs"][$del[0]]);
                }
            }
        }
    }
    if($_GET["get_nodePCIs"] == 1) {
        $passthroughs["usbs"] = [];
    }
    if($_GET["get_nodeUSBs"] == 1) {
        $passthroughs["pcis"] = [];
    }
    if(isset($_POST["addpassthrough"])) {
        $db["serid"] = $globals["server"];
        $db["type"] = POST("passthrough_type", $l["invalid_passthrough_type"]);
        $desc = [];
        if(!in_array($db["type"], ["pci", "usb"])) {
            $error[] = $l["invalid_passthrough_type"];
            return false;
        }
        if(!empty($_POST["description"])) {
            $desc["description"] = POSTval("description");
        }
        if(!empty($_POST["gpu_rom_file"])) {
            $desc["gpu_rom_file"] = POSTval("gpu_rom_file");
        }
        if(!empty($_POST["isgpu"])) {
            $desc["isgpu"] = 1;
        }
        $db["description"] = serialize($desc);
        if(preg_match("/pci/", $db["type"])) {
            $dev_key = (int) optPOST("pci_key");
            if(empty($passthroughs["pcis"]["node_pcis"][$dev_key])) {
                $error[] = $l["invalid_pci"];
                return false;
            }
            $pci_data = ["pci_key" => $passthroughs["pcis"]["node_pcis"][$dev_key], "type" => "pci", "action" => "all"];
            $pci_props[$dev_key] = $cluster->passthrough_dev_properties($db["serid"], $pci_data);
            $db["dev_name"] = $pci_props[$dev_key]["pci_name"];
            $db["name"] = empty($_POST["name"]) ? $pci_props[$dev_key]["name"] : optPOST("name");
            $db["dev_fullname"] = $passthroughs["pcis"]["node_pcis"][$dev_key];
            if(!empty($passthroughs["pcis"]["iommu_grp_num"][$dev_key])) {
                $db["iommu_grp_num"] = (int) $passthroughs["pcis"]["iommu_grp_num"][$dev_key];
            }
            if(0 < ($t = count($pci_props[$dev_key]["iommu_group_peers"]))) {
                $db["iommu_peers_num"] = $t;
            }
            if(count($pci_props[$dev_key]["iommu_group_peers"]) < 1) {
                $error[] = $l["pci_noIommu"];
                return false;
            }
            foreach ($pci_props[$dev_key]["iommu_group_peers"] as $peer_pci) {
                if($peer_pci != $pci_props[$dev_key]["device_id"]) {
                    foreach ($passthroughs["pcis"]["node_pcis"] as $node_pci) {
                        if(preg_match("/" . $peer_pci . "/", $node_pci)) {
                            $node_pci_props = passthrough_dev_properties($node_pci, "pci", "all");
                            insert_and_id("INSERT INTO passthrough SET\n\t\t\t\t\t\t\t\tdev_name = :dev_name,\n\t\t\t\t\t\t\t\tdev_fullname = :dev_fullname,\n\t\t\t\t\t\t\t\tname = :name,\n\t\t\t\t\t\t\t\tserid = :serid,\n\t\t\t\t\t\t\t\tdescription = :description,\n\t\t\t\t\t\t\t\tiommu_grp_num = :iommu_grp_num,\n\t\t\t\t\t\t\t\tiommu_peers_num = :iommu_peers_num,\n\t\t\t\t\t\t\t\ttype = :type", ["dev_name" => $node_pci_props["pci_name"], "dev_fullname" => $node_pci, "name" => $node_pci_props["name"], "serid" => $db["serid"], "description" => serialize(["description" => $l["iommu_peer"]]), "iommu_grp_num" => $passthroughs["pcis"]["iommu_grp_num"][$dev_key], "iommu_peers_num" => count($node_pci_props["iommu_group_peers"]), "type" => $db["type"]]);
                        }
                    }
                }
            }
        } elseif(preg_match("/usb/", $db["type"])) {
            $dev_key = optPOST("usb_key");
            $db["dev_fullname"] = $passthroughs["usbs"]["node_usbs"][$dev_key];
            $usb_props = passthrough_dev_properties($db["dev_fullname"], "usb");
            $db["name"] = empty($_POST["name"]) ? $usb_props["name"] : optPOST("name");
        }
        if(!empty($error)) {
            return false;
        }
        foreach ($db as $key => $value) {
            $q[] = $key . " = :" . $key;
        }
        $pid = insert_and_id("INSERT INTO passthrough SET " . implode(", ", $q), $db);
        if(empty($pid)) {
            $error[] = $l["err_saving"];
            return false;
        }
        $done = $pid;
        logs_admin("addpassthrough", $db["dev_name"], 1, $done, $user["uid"]);
    }
}
function API_addpassthrough()
{
    global $theme;
    global $globals;
    global $user;
    global $l;
    global $cluster;
    global $error;
    global $servers;
    global $servergroups;
    global $passthroughs;
    global $done;
    global $passthrough_types;
    global $gpu_roms;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["pcis"] = $passthroughs["pcis"];
    $GLOBALS["_api"]["usbs"] = $passthroughs["usbs"];
    $GLOBALS["_api"]["gpu_roms"] = $gpu_roms;
}

?>