<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include_once "/usr/local/virtualizor/scripts/inc.php";
reattach_vm_brnet();
function reattach_vm_brnet()
{
    global $globals;
    global $cluster;
    global $kernel;
    $centos8 = os_check("centos", ">=", "8");
    $brctl = "/usr/sbin/brctl";
    $allbrs = [];
    if(!empty($globals["bridge"])) {
        $allbrs[$globals["bridge"]] = $globals["bridge"];
    } else {
        $allbrs["viifbr0"] = "viifbr0";
    }
    $vps = [];
    $res = makequery("SELECT vpsid, vps_name, serid, virt, ipid, ippid, ip, ips.primary, bridge, nat_name, internal, vlan FROM ips JOIN vps USING (vpsid) join ippool USING (ippid) WHERE serid=0 ORDER BY vpsid");
    if(0 < !vsql_num_rows($res)) {
        return true;
    }
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $vps[$row["vpsid"]]["vps_name"] = $row["vps_name"];
        $vps[$row["vpsid"]]["serid"] = $row["serid"];
        $vps[$row["vpsid"]]["virt"] = $row["virt"];
        $vps[$row["vpsid"]]["ips"][$row["ipid"]]["primary"] = $row["primary"];
        $vps[$row["vpsid"]]["ips"][$row["ipid"]]["bridge"] = $row["bridge"];
        $vps[$row["vpsid"]]["ips"][$row["ipid"]]["nat_name"] = $row["nat_name"];
        $vps[$row["vpsid"]]["ips"][$row["ipid"]]["internal"] = $row["internal"];
        $vps[$row["vpsid"]]["ips"][$row["ipid"]]["vlan"] = $row["vlan"];
        if(!empty($row["bridge"]) && empty($row["internal"])) {
            $allbrs[$row["bridge"]] = $row["bridge"];
        }
        if(!empty($row["nat_name"])) {
            $allbrs[$row["nat_name"]] = $row["nat_name"];
        }
        $vps1[$row["vpsid"]] = 0;
    }
    $status = $cluster->vps_status_statewise($vps1, 1);
    $online = 0;
    $offline = 0;
    $cmd = [];
    foreach ($status as $k => $v) {
        if(!empty($v)) {
            $online++;
            $br = [];
            foreach ($vps[$k]["ips"] as $kk => $vv) {
                if($vv["primary"] == 1) {
                    if(!empty($vv["bridge"])) {
                        $br["vlan"] = $vv["bridge"];
                    } elseif(!empty($vv["nat_name"])) {
                        $br["nat"] = $vv["nat_name"];
                    } else {
                        $br["def"] = !empty($globals["bridge"]) ? $globals["bridge"] : "viifbr0";
                    }
                } elseif($vv["internal"] == 1) {
                    $br["int"] = $vv["bridge"];
                }
            }
            $vif = $kernel->vifname($k);
            foreach ($allbrs as $i => $j) {
                if(empty($centos8)) {
                    vexec($brctl . " delif " . xss($j) . " " . xss($vif) . " 2>/dev/null");
                } else {
                    exec("ip link set dev " . $vif . " nomaster");
                }
            }
            $b = "";
            if(!empty($br["def"])) {
                $b = $br["def"];
            } elseif(!empty($br["nat"])) {
                $b = $br["nat"];
            } elseif(!empty($br["vlan"])) {
                $b = $br["vlan"];
            }
            if(!empty($b)) {
                if(empty($centos8)) {
                    vexec($brctl . " show | grep " . xss($b), $o, $r);
                } else {
                    vexec("ip -d link | grep " . xss($b), $o, $r);
                }
                if(!empty($r)) {
                    echo "Bridge " . $b . " not found for VPSID " . $k . "\n";
                } else {
                    if(empty($centos8)) {
                        $cmd[$k] = $brctl . " addif " . xss($b) . " " . xss($vif);
                    } else {
                        $cmd[$k] = "ip link set dev " . xss($vif) . " master " . xss($b);
                    }
                    vexec($cmd[$k]);
                }
            }
        } else {
            $offline++;
        }
    }
    echo "Found " . $online . " VPS online and " . $offline . " VPS offline, attaching online VPS interface to its respective bridge\n";
    echo implode(";\n", $cmd) . "\n";
}

?>