<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function editbackup_plan_theme()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $backup_plan;
    global $backupservers;
    global $done;
    global $servers;
    global $vpses;
    global $bpid;
    global $servergroups;
    softheader($l["<title>"]);
    echo "\n<div class=\"bg\">\n<div class=\"row my-3 mx-auto\">\n\t<div class=\"col-12\">\n\t\t<h4 class=\"text-dark\"><i class=\"fas fa-clipboard\"></i> " . $l["editbackup_plan"] . "</h4>\n\t</div>\n</div>" . get_breadcrumb([["act" => "backup_plans"], ["act" => "editbackup_plan"]]);
    echo "<div class=\"notice\"><b>" . $l["note"] . " </b> &nbsp; " . $l["backuply_warning"] . "</div>";
    error_handle($error);
    if(!empty($done)) {
        if(isset($_POST["backup_now"])) {
            animate_task($l["back_now_task"]);
        }
        show_alert($done);
    }
    $data_decode = json_decode($backup_plan["data"], 1);
    echo "<script type=\"text/javascript\" charset=\"utf8\" src=\"" . $theme["url"] . "/js/cronstrue.min.js\"></script>\n<script language=\"javascript\" type=\"text/javascript\">\n\tlet selected_cron_type = new Object();\n\t\$(document).ready(function(){";
    $cron_time = "";
    if(in_array($backup_plan["frequency"], ["daily", "weekly", "monthly", "hourly"])) {
        $cron_time = convert_to_cron($bpid);
    }
    if(!empty($cron_time)) {
        echo "\$(\"#backup_scheme\").val(\"always_full\"); \$(\"#backup_scheme\").trigger(\"change\");";
    }
    if(!empty($data_decode["selected_cron_type"])) {
        echo "selected_cron_type = JSON.parse('" . json_encode($data_decode["selected_cron_type"]) . "');";
    }
    if(!empty($_POST["selected_cron_type"])) {
        echo "selected_cron_type = JSON.parse('" . htmlspecialchars_decode($_POST["selected_cron_type"]) . "');";
    }
    $cron_post = ["always_cronjob", "weekly_full_cronjob", "weekly_daily_inc_cronjob", "monthly_full_cronjob", "weekly_diff_cronjob", "weekly_diff_daily_inc_cronjob", "custom_full_cronjob", "custom_diff_cronjob", "custom_inc_cronjob"];
    foreach ($cron_post as $post) {
        if(!empty($_POST[$post])) {
            echo "\$(\"." . $post . "\").html(convert_to_msg(\"" . $_POST[$post] . "\"));";
        }
    }
    if(!empty($backup_plan["bid"])) {
        echo "\$(\"#tr_backup_servers\").show();\n\t\t\t\t  \$(\"#tr_local_dir\").show();";
        if($backupservers[$backup_plan["bid"]]["type"] == "FTP") {
            echo "\$(\"#type\").val(\"FTP\");";
        } else {
            echo "\$(\"#type\").val(\"SSH\");";
        }
    } else {
        echo "\$(\"#tr_backup_servers\").hide();\n\t\t\t\t\$(\"#tr_local_dir\").show();\n\t\t\t\t\$(\"#type\").val(\"LOCAL\");";
    }
    echo "\n\t\thandle_backup_scheme()\n\t\thandle_manual_option()\n\t\thandle_legacy_option()\n\t\t\$(\"input:radio\").change(function(event){\n\t\t\t\$(\"#months, #dates, #days, #hrs, #mins\").trigger(\"reset\");\n\t\t\t\$(\"#converted_cron\").text(\"\");\n\t\t\t\$(\".chosen, #months, #dates, #days\").select2({\n\t\t\t\t\"width\" : \"100%\"\n\t\t\t});\n\t\t\tget_cron_msg();\n\t\t\tselected_cron_type[clicked_name] = event.target.value;\n\t\t\tif(!empty(selected_cron_type)){\n\t\t\t\t\$(\"#selected_cron_type\").val(JSON.stringify(selected_cron_type));\n\t\t\t}\n\t\t\tif(event.target.value == \"weekly\"){\n\t\t\t\t\$(\"#backupday_tr\").show();\n\t\t\t\t\$(\"#backupdate_tr\").hide();\n\t\t\t\t\$(\"#tr_time\").show();\n\t\t\t\t\$(\"#backuphourly_tr\").hide();\n\t\t\t\t\$(\"#backupmonth_tr\").hide();\n\t\t\t}else if(event.target.value == \"monthly\"){\n\t\t\t\t\$(\"#backupdate_tr\").show();\n\t\t\t\t\$(\"#backupmonth_tr\").show();\n\t\t\t\t\$(\"#backupday_tr\").hide();\n\t\t\t\t\$(\"#tr_time\").show();\n\t\t\t\t\$(\"#backuphourly_tr\").hide();\n\t\t\t}else if(event.target.value == \"daily\"){\n\t\t\t\t\$(\"#backupdate_tr\").hide();\n\t\t\t\t\$(\"#backupday_tr\").hide();\n\t\t\t\t\$(\"#tr_time\").show();\n\t\t\t\t\$(\"#backuphourly_tr\").hide();\n\t\t\t\t\$(\"#backupmonth_tr\").hide();\n\t\t\t}else if(event.target.value == \"hourly\"){\n\t\t\t\t\$(\"#backupdate_tr\").hide();\n\t\t\t\t\$(\"#backupday_tr\").hide();\n\t\t\t\t\$(\"#tr_time\").hide();\n\t\t\t\t\$(\"#backuphourly_tr\").show();\n\t\t\t\t\$(\"#backupmonth_tr\").hide();\n\t\t\t}else{\n\t\t\t\t\$(\"#backupdate_tr\").hide();\n\t\t\t\t\$(\"#backupday_tr\").hide();\n\t\t\t\t\$(\"#tr_time\").hide();\n\t\t\t\t\$(\"#backuphourly_tr\").hide();\n\t\t\t\t\$(\"#backupmonth_tr\").hide();\n\t\t\t}\n\t\t});\n\n\t\t\$(\"#type\").change(function(data){\n\t\t\thandle_type()\n\t\t});\n\t\t\n\t\trefresh_tasks();\n\t\t\n\t\t// Refresh tasks every 10 secs\n\t\tsetInterval(refresh_tasks, 10000);\n\t});\n\n\tfunction toggle_advoptions(ele){\n\t\t\t\n\t\tvar div_ele = \$(\"#\"+ele+\"_advoptions\");\n\t\t\n\t\tif (div_ele.is(\":hidden\")){\n\t\t\t\$(\"#\"+ele+\"_advoptions_ind\").text(\" - \");\n\t\t\tdiv_ele.slideDown(\"slow\");\n\t\t}\n\t\telse{\n\t\t\t\$(\"#\"+ele+\"_advoptions_ind\").text(\" + \");\n\t\t\tdiv_ele.slideUp(\"slow\");\n\t\t}\n\t}\n\n\tfunction handle_type(){\n\t\t\$(\"#backup_scheme\").val(0)\n\t\t\$(\"#backup_scheme\").trigger(\"change\")\n\t\tif(\$(\"#type\").val() == \"LOCAL\"){\n\t\t\t\$(\"#tr_backup_servers\").hide();\n\t\t\t\$(\".remote\").hide();\n\t\t\t\$(\".local\").show();\n\t\t}else{\n\t\t\t\$(\"#bid\").val(0);\n\t\t\t\$(\"#tr_backup_servers\").show();\n\t\t\t\$(\".local\").hide();\n\t\t\t\$(\".remote\").show();\n\t\t\tif(\$(\"#type\").val() == \"FTP\"){\n\t\t\t\t\$(\".FTP\").show();\n\t\t\t\t\$(\".SSH\").hide();\n\t\t\t}else{\n\t\t\t\t\$(\".SSH\").show();\n\t\t\t\t\$(\".FTP\").hide();\n\t\t\t}\n\t\t}\n\t\thandle_manual_option();\n\t}\n\tlet expression = \"\";\n\tlet clicked_name = \"\";\n\tlet expression_description = \"\";\n\tfunction get_cron_msg(){\n\n\t\tif(\$(\"#freqm\").prop(\"checked\") == true){\n\n\t\t\tlet months = new Array();\n\t\t\tlet dates = new Array();\n\n\t\t\tif(!empty(\$(\"#months\").val())){\n\t\t\t\tif(Object.values(\$(\"#months\").val()).indexOf(\"1-12\") > -1){\n\t\t\t\t\t\$(\"#months\").val(\"\").val(\"1-12\").select2({width : \"100%\"})\n\t\t\t\t\tmonths = \"1-12\";\n\t\t\t\t}else{\n\t\t\t\t\tmonths = Object.values(\$(\"#months\").val()).join(\",\");\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif(!empty(\$(\"#dates\").val())){\n\t\t\t\tif(Object.values(\$(\"#dates\").val()).indexOf(\"1-31\") > -1){\n\t\t\t\t\t\$(\"#dates\").val(\"\").val(\"1-31\").select2({width : \"100%\"})\n\t\t\t\t\tdates = \"1-31\";\n\t\t\t\t}else{\n\t\t\t\t\tdates = Object.values(\$(\"#dates\").val()).join(\",\");\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif(empty(months)){\n\t\t\t\tmonths = \"*\";\n\t\t\t}\n\n\t\t\tif(empty(dates)){\n\t\t\t\tdates = \"*\";\n\t\t\t}\n\n\t\t\tlet hrs = \$(\"#hrs\").val();\n\t\t\tlet mins = \$(\"#min\").val();\n\t\t\texpression = mins+\" \"+hrs+\" \"+dates+\" \"+months+\" *\";\n\n\t\t}\n\t\tif(\$(\"#freqw\").prop(\"checked\") == true){\n\n\t\t\tlet days = \"\";\n\n\t\t\tif(\$(\"#days\").val() != null){\n\t\t\t\tif(Object.values(\$(\"#days\").val()).indexOf(\"1-7\") > -1){\n\t\t\t\t\t\$(\"#days\").val(\"\").val(\"1-7\").select2({width : \"100%\"})\n\t\t\t\t\tdays = \"1-7\";\n\t\t\t\t}else{\n\t\t\t\t\tdays = Object.values(\$(\"#days\").val()).join(\",\");\n\t\t\t\t}\n\t\t\t}\n\n\t\t\tif(days == \"\"){\n\t\t\t\tdays = \"*\";\n\t\t\t}\n\n\t\t\tlet hrs = \$(\"#hrs\").val();\n\t\t\tlet mins = \$(\"#min\").val();\n\t\t\texpression = mins+\" \"+hrs+\" * * \"+days;\n\t\t}\n\t\tif(\$(\"#freqd\").prop(\"checked\") == true){\n\n\t\t\tlet hrs = \$(\"#hrs\").val();\n\t\t\tlet mins = \$(\"#min\").val();\n\t\t\texpression = mins+\" \"+hrs+\" * * *\";\n\n\t\t}\n\t\tif(\$(\"#freqh\").prop(\"checked\") == true){\n\t\t\tlet hourly_freq = \$(\"#hourly_freq\").val();\n\t\t\texpression = \"00 */\"+hourly_freq+\" * * *\";\n\t\t}\n\n\t\texpression_description = convert_to_msg(expression);\n\t\t\$(\"#converted_cron\").text(expression_description);\n\n\t}\n\n\tfunction convert_to_msg(exp){\n\t\treturn cronstrue.toString(exp, { throwExceptionOnParseError: false });\n\t}\n\n\tfunction handle_backup_scheme(){\n\n\t\tif(\$(\"#freq\").prop(\"checked\")){\n\t\t\t\$(\"#always_cron_div\").hide();\n\t\t\t\$(\"#weekly_cron_div\").hide();\n\t\t\t\$(\"#weekly_daily_inc_cron_div\").hide();\n\t\t\t\$(\"#monthly_full_div\").hide();\n\t\t\t\$(\"#weekly_diff_div\").hide();\n\t\t\t\$(\"#weekly_diff_daily_inc_div\").hide();\n\t\t\t\$(\"#custom_full_div\").hide();\n\t\t\t\$(\"#custom_inc_div\").hide();\n\t\t\t\$(\"#custom_diff_div\").hide();\n\t\t\treturn false;\n\t\t}\n\t\t\n\t\tif(\$(\"#backup_scheme\").val() == \"always_incremental\" || \$(\"#backup_scheme\").val() == \"always_full\"){\n\t\t\t\$(\"#always_cron_div\").show();\n\t\t}else{\n\t\t\t\$(\"#always_cron_div\").hide();\n\t\t}\n\n\t\tif(\$(\"#backup_scheme\").val() == \"weekly_full_daily_incremental\"){\n\t\t\t\$(\"#weekly_cron_div\").show();\n\t\t\t\$(\"#weekly_daily_inc_cron_div\").show();\n\t\t}else{\n\t\t\t\$(\"#weekly_cron_div\").hide();\n\t\t\t\$(\"#weekly_daily_inc_cron_div\").hide();\n\t\t}\n\n\t\tif(\$(\"#backup_scheme\").val() == \"monthly_full_weekly_diff_daily_incremental\"){\n\t\t\t\$(\"#monthly_full_div\").show();\n\t\t\t\$(\"#weekly_diff_div\").show();\n\t\t\t\$(\"#weekly_diff_daily_inc_div\").show();\n\t\t}else{\n\t\t\t\$(\"#monthly_full_div\").hide();\n\t\t\t\$(\"#weekly_diff_div\").hide();\n\t\t\t\$(\"#weekly_diff_daily_inc_div\").hide();\n\t\t}\n\n\t\tif(\$(\"#backup_scheme\").val() == \"custom\"){\n\t\t\t\$(\"#custom_full_div\").show();\n\t\t\t\$(\"#custom_inc_div\").show();\n\t\t\t\$(\"#custom_diff_div\").show();\n\t\t}else{\n\t\t\t\$(\"#custom_full_div\").hide();\n\t\t\t\$(\"#custom_inc_div\").hide();\n\t\t\t\$(\"#custom_diff_div\").hide();\n\t\t}\n\n\t}\n\n\tfunction add_cron_job(ele){\n\n\t\tlet _ele = ele;\n\t\tclicked_name = \$(ele).attr(\"name\");\n\t\tlet cron_val = \"\";\n\t\tif(!empty(\$(ele).val())){\n\t\t\tcron_val = \$(ele).val().split(\" \")\n\t\t}\n\t\t\n\t\t\$(\"#cron_job\").trigger(\"reset\");\n\t\t\$(\"#converted_cron\").text(\"\");\n\t\t\$(\".chosen, #months, #dates, #days\").select2({\n\t\t\t\"width\" : \"100%\"\n\t\t});\n\t\t\$(\"#backupdate_tr\").hide();\n\t\t\$(\"#backupday_tr\").hide();\n\t\t\$(\"#tr_time\").hide();\n\t\t\$(\"#backuphourly_tr\").hide();\n\t\t\$(\"#backupmonth_tr\").hide();\n\n\t\t\$(\"#freqm_div, #freqw_div, #freqd_div, #freqh_div\").show();\n\t\tif(\$(ele).attr(\"name\") == \"weekly_daily_inc_cronjob\"){\n\t\t\t\$(\"#freqm_div, #freqw_div, #freqh_div\").hide();\n\t\t\t\$(\"#freqd\").trigger(\"click\");\n\t\t}\n\n\t\tif(\$(ele).attr(\"name\") == \"weekly_full_cronjob\"){\n\t\t\t\$(\"#freqm_div, #freqd_div, #freqh_div\").hide();\n\t\t\t\$(\"#freqw\").trigger(\"click\");\n\t\t}\n\n\t\tif(\$(ele).attr(\"name\") == \"monthly_full_cronjob\"){\n\t\t\t\$(\"#freqw_div, #freqd_div, #freqh_div\").hide();\n\t\t\t\$(\"#freqm\").trigger(\"click\");\n\t\t}\n\n\t\tif(\$(ele).attr(\"name\") == \"weekly_diff_cronjob\"){\n\t\t\t\$(\"#freqm_div, #freqd_div, #freqh_div\").hide();\n\t\t\t\$(\"#freqw\").trigger(\"click\");\n\t\t}\n\n\t\tif(\$(ele).attr(\"name\") == \"weekly_diff_daily_inc_cronjob\"){\n\t\t\t\$(\"#freqw_div, #freqm_div, #freqh_div\").hide();\n\t\t\t\$(\"#freqd\").trigger(\"click\");\n\t\t}\n\n\t\tif(!empty(cron_val) && !empty(selected_cron_type[clicked_name])){\n\t\t\tif(selected_cron_type[clicked_name] == \"monthly\"){\n\t\t\t\t\$(\"#freqm\").trigger(\"click\");\n\t\t\t\t\$(\"#months\").val(cron_val[3].split(\",\")).select2({\"width\" : \"100%\"});\n\t\t\t\t\$(\"#dates\").val(cron_val[2].split(\",\")).select2({\"width\" : \"100%\"});\n\t\t\t\t\$(\"#hrs\").val(cron_val[1]);\n\t\t\t\t\$(\"#min\").val(cron_val[0]);\n\t\t\t}else if(selected_cron_type[clicked_name] == \"weekly\"){\n\t\t\t\t\$(\"#freqw\").trigger(\"click\");\n\t\t\t\t\$(\"#days\").val(cron_val[4].split(\",\")).select2({\"width\" : \"100%\"});\n\t\t\t\t\$(\"#hrs\").val(cron_val[1]);\n\t\t\t\t\$(\"#min\").val(cron_val[0]);\n\t\t\t}else if(selected_cron_type[clicked_name] == \"daily\"){\n\t\t\t\t\$(\"#freqd\").trigger(\"click\");\n\t\t\t\t\$(\"#hrs\").val(cron_val[1]);\n\t\t\t\t\$(\"#min\").val(cron_val[0]);\n\t\t\t}else if(selected_cron_type[clicked_name] == \"hourly\"){\n\t\t\t\t\$(\"#freqh\").trigger(\"click\");\n\t\t\t\tvar tmp = cron_val[1].split(\"/\");\n\t\t\t\t\$(\"#hourly_freq\").val(tmp[1]);\n\t\t\t}\n\t\t\tget_cron_msg();\n\t\t}\n\n\t\t\$(\"#cronModal\").modal();\n\t\t\n\t\t\$(\"#create_cron\").unbind().click(function(){\n\t\t\t_ele.val(expression);\n\t\t\t\$(\".\"+clicked_name).html(expression_description);\n\t\t\t\$(\"#cronModal\").modal(\"hide\");\n\t\t\thandle_backup_scheme()\n\t\t});\n\t\t\n\t}\n\n\tfunction trigger_full(){\n\t\t\$(\".local\").hide();\n\t\t\$(\".manual\").show();\n\t\t\$(\"#backup_scheme\").val(\"always_full\").trigger(\"change\");\n\t}\n\tfunction handle_manual_option(){\n\t\tif(\$(\"#freq\").prop(\"checked\")){\n\t\t\ttrigger_full()\n\t\t}else{\n\t\t\tif(\$(\"#enable_legacy_backup\").prop(\"checked\")){\n\t\t\t\ttrigger_full()\n\t\t\t}else{\n\t\t\t\t\$(\".local\").show();\n\t\t\t\thandle_backup_scheme()\n\t\t\t}\n\t\t\t\n\t\t}\n\t}\n\n\tfunction handle_legacy_option(){\n\t\tif(\$(\"#enable_legacy_backup\").prop(\"checked\")){\n\t\t\ttrigger_full()\n\t\t}else{\n\t\t\tif(\$(\"#freq\").prop(\"checked\")){\n\t\t\t\ttrigger_full()\n\t\t\t}else{\n\t\t\t\t\$(\".local\").show();\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction apply_roation_val(op){\n\t\tvar val = parseInt(\$(\"#backup_rotation\").val());\n\n\t\tif(op == 1){\n\t\t\tvar new_val = val+1;\n\t\t\tif(new_val <= " . (empty($globals["backup_rotation_count"]) ? 10 : (int) $globals["backup_rotation_count"]) . "){\n\t\t\t\t\$(\"#backup_rotation\").val(new_val);\n\t\t\t}\n\t\t}else{\n\t\t\tvar new_val = val-1;\n\t\t\tif(new_val >= 0){\n\t\t\t\t\$(\"#backup_rotation\").val(new_val);\n\t\t\t}\n\t\t}\n\t}\n\t\n\tfunction refresh_tasks() {\n\t\tvar cols = new Object();\n\t\tcols[\"actid\"] = {\"l\" : \"" . $l["actid"] . "\", \"centered\" : true};\n\t\tcols[\"vpsid\"] = {\"l\" : \"" . $l["vpsid"] . "\", \"centered\" : true};\n\t\tcols[\"user\"] = {\"l\" : \"" . $l["user"] . "\", \"centered\" : true};\n\t\tcols[\"server\"] = {\"l\" : \"" . $l["server"] . " " . "(" . $l["id"] . ")\", \"centered\" : true};\n\t\tcols[\"started\"] = {\"l\" : \"" . $l["started"] . "\", width: 100, \"centered\" : true};\n\t\tcols[\"updated\"] = {\"l\" : \"" . $l["updated"] . "\", width: 100, \"centered\" : true};\n\t\tcols[\"ended\"] = {\"l\" : \"" . $l["ended"] . "\", width: 100, \"centered\" : true};\n\t\tcols[\"action_txt\"] = {\"l\" : \"" . $l["action"] . "\", width: 100};\n\t\tcols[\"status_txt\"] = {\"l\" : \"" . $l["status"] . "\", width: 200};\n\t\tcols[\"progress\"] = {\"l\" : \"" . $l["progress"] . "\"};\n\t\tcols[\"logs\"] = {\"l\" : \"" . $l["logs"] . "\", \"centered\" : true};";
    $vpsids = array_keys($vpses);
    echo "\$.ajax({\n\t\t\ttype: \"GET\",\n\t\t\turl: \"" . $globals["index"] . "act=tasks&vpsid=" . implode(",", $vpsids) . "&action=vpsbackups_plan,restorevps_plan,backuply_vpsbackups_plan,backuply_restorevps_plan&api=json&page=0&reslen=50\",\n\t\t\tdataType : \"json\",\n\t\t\tsuccess: function(data){\n\t\t\t\t\n\t\t\t\tif(empty(data[\"tasks\"])) {\n\t\t\t\t\t// Show no tasks note if table empty\n\t\t\t\t\t\$(\"#table_tasks_container\").html(\"<div class=\\\"notice\\\"><b>" . $l["note"] . " : </b> &nbsp; " . $l["no_tasks"] . "</div>\");\n\t\t\t\t\treturn;\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tvar rows = Array();\n\t\t\t\t\n\t\t\t\t\$.each(data[\"tasks\"], function(k, task) {\n\t\t\t\t\t\n\t\t\t\t\trows[k] = new Object();\n\t\t\t\t\trows[k][\"actid\"] = task[\"actid\"];\n\t\t\t\t\trows[k][\"vpsid\"] = task[\"vpsid\"];\n\t\t\t\t\trows[k][\"user\"] = empty(task[\"uid\"]) ? \"root\" : task[\"email\"];\n\t\t\t\t\trows[k][\"server\"] = task[\"server_name\"] + \"(\" + task[\"serid\"] + \")\";\n\t\t\t\t\trows[k][\"started\"] = task[\"started\"];\n\t\t\t\t\trows[k][\"updated\"] = task[\"updated\"];\n\t\t\t\t\trows[k][\"ended\"] = task[\"ended\"];\n\t\t\t\t\trows[k][\"action_txt\"] = task[\"action_txt\"];\n\t\t\t\t\trows[k][\"status_txt\"] = task[\"status_txt\"];\n\t\t\t\t\trows[k][\"progress\"] = \"<div class=\\\"progress-cont\\\" id=\\\"progress-cont\"+task[\"actid\"]+\"\\\"><center><div class=\\\"text-center h6\\\" id=\\\"pbar\"+task[\"actid\"]+\"\\\">\"+task[\"progress\"]+\"%</center><div class=\\\"progress\\\"><div class=\\\"progress-bar bg-primary progress-bar-striped progress-bar-animated\\\" id=\\\"progressbar\"+task[\"actid\"]+\"\\\"></div></div>\";\n\t\t\t\t\trows[k][\"logs\"] = \"<button class=\\\"btn px-2 py-1\\\" onclick=\\\"loadlogs(\"+task[\"actid\"]+\");\\\">" . $l["show"] . "</button>\";\n\t\t\t\t\t\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\trows.sort(function(a, b){\n\t\t\t\t\ta = parseInt(a[\"actid\"]);\n\t\t\t\t\tb = parseInt(b[\"actid\"]);\n\t\t\t\t\tif(a < b) return 1;\n\t\t\t\t\tif(a > b) return -1;\n\t\t\t\t\treturn 0;\n\t\t\t\t});\n\t\t\t\t\n\t\t\t\ttable({\"id\" : \"table_tasks_container\", \"tid\" : \"table_tasks\", \"width\" : \"100%\"}, cols, rows);\n\t\t\t\t\n\t\t\t\t\$.each(data[\"tasks\"], function(index, task) {\n\t\t\t\t\t\n\t\t\t\t\tif(task[\"progress\"] == 100){\n\t\t\t\t\t\t\$(\"#status\"+index).text(\"" . $l["completed"] . "\");\n\t\t\t\t\t\t\$(\"#pbar\"+index).text(\"100% " . $l["completed"] . " !\");\n\t\t\t\t\t\t\$(\"#progressbar\"+index).hide();\n\t\t\t\t\t\t\$(\"#progressbar\"+index).parent().css(\"border\", \"0px\");\n\t\t\t\t\t\t\$(\"#progressbar\"+index).parent().removeClass(\"progress\");\n\t\t\t\t\t}else if(task[\"status\"] == -1){\n\t\t\t\t\t\t\$(\"#status\"+index).html(task[\"status_txt\"]);\n\t\t\t\t\t\t\$(\"#pbar\"+index).text(\"" . $l["task_notcomplete"] . "\");\n\t\t\t\t\t\t\$(\"#progressbar\"+index).hide();\n\t\t\t\t\t\t\$(\"#progressbar\"+index).parent().css(\"border\", \"0px\");\n\t\t\t\t\t\t\$(\"#progressbar\"+index).parent().removeClass(\"progress\");\n\t\t\t\t\t}else {\n\t\t\t\t\t\t\n\t\t\t\t\t\tif(isNaN(task[\"progress\"])){\n\t\t\t\t\t\t\t\$(\"#pbar\"+index).text(task[\"progress\"]);\n\t\t\t\t\t\t\t\$(\"#progressbar\"+index).hide();\n\t\t\t\t\t\t}else{\n\t\t\t\t\t\t\tmake_progress(index, Number(task[\"progress\"]));\n\t\t\t\t\t\t\t\$(\"#progressbar\"+index).show();\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t\t\n\t\t\t\t});\n\t\t\t\t\n\t\t\t}\n\t\t});\n\t}\n\n\tfunction make_progress(index, progress){\n\t\tvar steps = 20;\n\t\tvar start = \$(\"#pbar\"+index).text();\n\t\tstart = (start.slice(0, -1));\n\t\tif(isNaN(start)){\n\t\t\tstart = 0;\n\t\t}\n\t\tvar step = (progress - start)/steps;\n\t\tif(step < 0){ step = 0;}\n\t\tvar increment = function(){\n\t\t\tvar val = \$(\"#pbar\"+index).text();\n\t\t\tval = Number(val.slice(0, - 1));\n\t\t\tprog = parseInt(val + Math.round(step));\n\t\t\t//alert(\"progr\"+prog);\n\t\t\tif(prog > progress){ prog = progress;}\n\t\t\tif(prog < parseInt(\"100\")){\n\t\t\t\t\$(\"#pbar\"+index).text(prog + \"%\");\n\t\t\t\t\$(\"#progressbar\"+index).width(prog + \"%\");\n\t\t\t}else{\n\t\t\t\t\$(\"#progressbar\"+index).width(100 + \"%\");\n\t\t\t}\n\t\t\tif (prog < progress){setTimeout(increment, 500);}\n\t\t};\n\t\tincrement();\n\t};\n\t\n\tfunction toggle_advoptions(ele){\n\t\t\n\t\tvar div_ele = \$(\"#\"+ele+\"_advoptions\");\n\n\t\tif (div_ele.is(\":hidden\")){\n\t\t\t\$(\"#\"+ele+\"_advoptions_ind\").text(\" - \");\n\t\t\tdiv_ele.slideDown(\"slow\");\n\t\t}\n\t\telse{\n\t\t\t\$(\"#\"+ele+\"_advoptions_ind\").text(\" + \");\n\t\t\tdiv_ele.slideUp(\"slow\");\n\t\t}\n\t}\n\t\n</script>\n<style>\n.vps_table th{\nwidth:auto !important; padding:5px 5px !important;\nvertical-align:middle !important;\npostion:sticky;\ntop:0px;\n}\n</style>\n<style type=\"text/css\">\n\n.panel {\n\tmin-height: 120px;\n}\n.panel-content {\n\tmax-height: 400px;\n\toverflow: hidden;\n}\n\n.table-dash {\n\tmargin-bottom: 4px;\n}\n.table-dash tbody tr td {\n\tvertical-align: middle;\n}\n.table-dash tr td:first-child, .table-dash tr th:first-child {\n\tpadding-left: 16px;\n}\n.table-dash tr td:last-child, .table-dash tr th:last-child {\n\tpadding-right: 16px;\n}\n.btn-logs {\n\tmargin: 0;\n\tpadding: 4px 8px;\n\tfont-size: 12px;\n}\n\n</style>\n<!--Modal started -->\n\t<div class=\"modal fade\" id=\"cronModal\" tabindex=\"-1\" aria-labelledby=\"cronjob\" aria-hidden=\"true\">\n\t\t<div class=\"modal-dialog modal-lg\">\n\t\t\t<div class=\"modal-content\">\n\t\t\t\t<div class=\"modal-header\">\n\t\t\t\t\t<h5 class=\"modal-title\" id=\"cronjob\">" . $l["cr_submit_button"] . "</h5>\n\t\t\t\t\t<button type=\"button\" class=\"close text-always-white\" data-dismiss=\"modal\">×</button>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"modal-body\">\n\t\t\t\t\t<span class=\"h5 m-0 font-italic\" id=\"converted_cron\"></span>\n\t\t\t\t\t<form id=\"cron_job\">\n\t\t\t\t\t\t<div class=\"my-3\">\n\t\t\t\t\t\t<div class=\"form-group r-pill\">\n\t\t\t\t\t\t\t\t<div class=\"r-pill__group mb-3\">\n\t\t\t\t\t\t\t\t\t\t<span class=\"r-pill__item\" id=\"freqm_div\">\n\t\t\t\t\t\t\t\t\t\t\t<input type=\"radio\" class=\"ssh_options\" id=\"freqm\" name=\"freq\" value=\"monthly\" " . POSTradio("freq", "monthly") . ">\n\t\t\t\t\t\t\t\t\t\t\t<label for=\"freq\" class=\"m-0\">" . $l["freq_monthly"] . "</label>\n\t\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t\t<span class=\"r-pill__item\">\n\t\t\t\t\t\t\t\t\t\t\t<input type=\"radio\" class=\"custom-control-input\" id=\"freqw\" name=\"freq\" value=\"weekly\" " . POSTradio("freq", "weekly") . ">\n\t\t\t\t\t\t\t\t\t\t\t<label for=\"freq\" class=\"m-0\">" . $l["freq_weekly"] . "</label>\n\t\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t\t<span class=\"r-pill__item\">\n\t\t\t\t\t\t\t\t\t\t\t<input type=\"radio\" class=\"custom-control-input\" id=\"freqd\" name=\"freq\" value=\"daily\" " . POSTradio("freq", "daily") . ">\n\t\t\t\t\t\t\t\t\t\t\t<label for=\"freq\" class=\"m-0\">" . $l["freq_daily"] . "</label>\n\t\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t\t\t<span class=\"r-pill__item\">\n\t\t\t\t\t\t\t\t\t\t\t<input type=\"radio\" class=\"custom-control-input\" id=\"freqh\" name=\"freq\" value=\"hourly\" " . POSTradio("freq", "hourly") . ">\n\t\t\t\t\t\t\t\t\t\t\t<label for=\"freq\" class=\"m-0\">" . $l["freq_hourly"] . "</label>\n\t\t\t\t\t\t\t\t\t\t</span>\n\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"backuphourly_tr\" style=\"display:none\">\n\t\t\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t\t\t<label class=\"control-label\">" . $l["backup_hourly"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_hourly"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t\t\t<select class=\"custom-select w-50\" name=\"hourly_freq\" id=\"hourly_freq\" onchange=\"get_cron_msg()\">";
    for ($i = 0; $i < 24; $i++) {
        echo "<option value=\"" . ($i < 10 ? "0" . $i : $i) . "\" " . POSTselect("hourly_freq", $i) . " >" . ($i < 10 ? "0" . $i : $i) . "</option>";
    }
    echo "</select><label class=\"p-2\">" . $l["hrs"] . "</label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\t\t\n\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"backupday_tr\" style=\"display:none;\">\n\t\t\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t\t\t<label class=\"control-label\">" . $l["backup_day"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_day"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t\t\t<select class=\"custom-select\" multiple=\"multiple\" name=\"day\" id=\"days\" onchange=\"get_cron_msg()\">\n\t\t\t\t\t\t\t\t\t<option value=\"0\" " . POSTselect("day", "0") . " >" . $l["c_sun"] . "</option>\n\t\t\t\t\t\t\t\t\t<option value=\"1\" " . POSTselect("day", "1") . " >" . $l["c_mon"] . "</option>\n\t\t\t\t\t\t\t\t\t<option value=\"2\" " . POSTselect("day", "2") . " >" . $l["c_tues"] . "</option>\n\t\t\t\t\t\t\t\t\t<option value=\"3\" " . POSTselect("day", "3") . " >" . $l["c_wed"] . "</option>\n\t\t\t\t\t\t\t\t\t<option value=\"4\" " . POSTselect("day", "4") . " >" . $l["c_thur"] . "</option>\n\t\t\t\t\t\t\t\t\t<option value=\"5\" " . POSTselect("day", "5") . " >" . $l["c_fri"] . "</option>\n\t\t\t\t\t\t\t\t\t<option value=\"6\" " . POSTselect("day", "6") . " >" . $l["c_sat"] . "</option>\n\t\t\t\t\t\t\t\t\t<option value=\"0-6\" >" . $l["all_days"] . "</option>\n\t\t\t\t\t\t\t\t</select>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"backupmonth_tr\" style=\"display:none;\">\n\t\t\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t\t\t<label class=\"control-label\">" . $l["backup_month"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_date"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t\t\t<select name=\"months\" multiple=\"multiple\" class=\"custom-select\" id=\"months\" onchange=\"get_cron_msg()\">";
    for ($i = 1; $i <= 12; $i++) {
        echo "<option value=\"" . $i . "\" " . POSTselect("months", $i) . " >" . $i . "</option>";
    }
    echo "<option value=\"1-12\" >" . $l["all_months"] . "</option>";
    echo "</select>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"backupdate_tr\" style=\"display:none;\">\n\t\t\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t\t\t<label class=\"control-label\">" . $l["backup_date"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_date"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t\t\t<select name=\"date\" multiple=\"multiple\" class=\"custom-select\" id=\"dates\" onchange=\"get_cron_msg()\">";
    for ($i = 1; $i < 32; $i++) {
        echo "<option value=\"" . $i . "\" " . POSTselect("date", $i) . " >" . $i . "</option>";
    }
    echo "<option value=\"1-31\" >" . $l["all_dates"] . "</option>";
    echo "</select>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"tr_time\" style=\"display:none;\">\n\t\t\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t\t\t<label class=\"control-label\">" . $l["backup_time"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_time"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t\t\t<select class=\"custom-select w-25 p-1 float-left\" name=\"hrs\" id=\"hrs\" onchange=\"get_cron_msg()\">";
    for ($i = 0; $i < 24; $i++) {
        echo "<option value=\"" . ($i < 10 ? "0" . $i : $i) . "\" " . POSTselect("hrs", $i) . " >" . ($i < 10 ? "0" . $i : $i) . "</option>";
    }
    echo "</select>\n\t\t\t\t\t\t\t\t<label class=\"side_lbl\">" . $l["hrs"] . "</label>\n\t\t\t\t\t\t\t\t<select class=\"custom-select w-25 p-1 float-left\" name=\"min\" id=\"min\" onchange=\"get_cron_msg()\">";
    for ($i = 0; $i < 60; $i++) {
        echo "<option value=\"" . ($i < 10 ? "0" . $i : $i) . "\" " . POSTselect("min", $i) . " >" . ($i < 10 ? "0" . $i : $i) . "</option>";
    }
    echo "</select><label class=\"side_lbl\">" . $l["min"] . "</label>\n\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t</div>\n\n\t\t\t\t\t\t<input type=\"button\" value=\"" . $l["cr_submit_button"] . "\" name=\"create_cron\" class=\"go_btn\" id=\"create_cron\" />\n\t\t\t\t\t</form>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n\t<!--Modal end -->\n<form accept-charset=\"" . $globals["charset"] . "\" name=\"editbackup_plan\" method=\"post\" action=\"\" class=\"form-horizontal\">\n\n<div class=\"roundheader cursor-pointer\" onclick=\"toggle_advoptions('general');\"><label id=\"general_advoptions_ind\" class=\"min_width\">-</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;General Settings</div>\n<div id=\"general_advoptions\" class=\"bgaddv w-100\">\n\t<div class=\"row mx-auto w-100 my-1\">\n\t\t<div class=\"col-sm-12 col-md-12 col-lg-6 border-right\">\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t<label class=\"control-label\">" . $l["backup_disabled"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_disabled"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t" . get_checkbox("disabled", "", "disabled", ["chk_it" => 1, "val" => $backup_plan["disabled"]]) . "\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["disable_suspended_vm"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["disable_suspended_vm_exp"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-6\">\n\t\t\t\t\t" . get_checkbox("disable_suspended_vm", "", "disable_suspended_vm", ["chk_it" => 1, "val" => $data_decode["disable_suspended_vm"]]) . "\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["planname"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["nameofplan"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<input type=\"text\" class=\"form-control\" name=\"plan_name\" id=\"plan_name\" value=\"" . POSTval("plan_name", $backup_plan["plan_name"]) . "\" />\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["sel_type"] . "</label><br />\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<select id=\"type\" class=\"custom-select\" name=\"type\">\n\t\t\t\t\t\t<option value=\"LOCAL\" " . ($backup_plan["bid"] == 0 ? "selected=selected" : "") . ">Local</option>\n\t\t\t\t\t\t<option value=\"FTP\" " . ($backup_plan["bid"] != 0 && $backupservers[$backup_plan["bid"]]["type"] == "FTP" ? "selected=selected" : "") . ">FTP</option>\n\t\t\t\t\t\t<option value=\"SSH\" " . ($backup_plan["bid"] != 0 && $backupservers[$backup_plan["bid"]]["type"] == "SSH" ? "selected=selected" : "") . ">SSH</option>\n\t\t\t\t\t</select>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"tr_backup_servers\" style=\"display:none\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["sel_backupserver"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_sel_backupserver"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<select class=\"custom-select\" name=\"id\" id=\"bid\">\n\t\t\t\t\t<option value=\"0\" " . ex_POSTselect("id", 0, $backup_plan["bid"]) . ">---</option>";
    foreach ($backupservers as $k => $v) {
        echo "<option class=\"" . $v["type"] . "\" value=\"" . $v["bid"] . "\" " . ex_POSTselect("id", $v["bid"], $backup_plan["bid"]) . " " . ($backupservers[$backup_plan["bid"]]["type"] != $v["type"] ? "style=\"display:none;\"" : "") . ">" . $v["name"] . "</option>";
    }
    echo "</select>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["enable_manual_backup"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_enable_manual_backup"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">";
    $arr["chk_it"] = 1;
    if($backup_plan["frequency"] == "manual") {
        $arr["val"] = "manual";
    }
    echo get_checkbox("freq", "", "freq", $arr, "manual", "", ["onclick=\"handle_manual_option()\""]) . "\n\t\t\t\t</div>\n\t\t\t</div>\t\n\t\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t<label class=\"control-label\">" . $l["enable_legacy_backup"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["enable_legacy_backup_exp"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t" . get_checkbox("enable_legacy_backup", "", "enable_legacy_backup", ["chk_it" => 1, "val" => $data_decode["enable_legacy_backup"]], "1", "", ["onclick=\"handle_legacy_option()\""]) . "\n\t\t\t\t\t</div>\n\t\t\t</div>\t\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["backup_scheme"] . "</label>&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["backup_scheme_exp"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<select id=\"backup_scheme\" class=\"custom-select\" name=\"backup_scheme\" onchange=\"handle_backup_scheme();\">\n\t\t\t\t\t\t<option value=\"0\" " . ex_POSTselect("backup_scheme", 0, $data_decode["backup_scheme"]) . ">---</option>\n\t\t\t\t\t\t<option class=\"local manual remote\" value=\"always_full\" " . ex_POSTselect("backup_scheme", "always_full", $data_decode["backup_scheme"]) . ">" . $l["always_full"] . "</option>\n\t\t\t\t\t\t\t<option class=\"local\" value=\"always_incremental\" " . ex_POSTselect("backup_scheme", "always_incremental", $data_decode["backup_scheme"]) . ">" . $l["always_incremental"] . "</option>\n\t\t\t\t\t\t\t<option class=\"local remote\" value=\"weekly_full_daily_incremental\" " . ex_POSTselect("backup_scheme", "weekly_full_daily_incremental", $data_decode["backup_scheme"]) . ">" . $l["weekly_full_daily_incremental"] . "</option>\n\t\t\t\t\t\t\t<option class=\"local remote\" class=\"local remote\" value=\"monthly_full_weekly_diff_daily_incremental\" " . ex_POSTselect("backup_scheme", "monthly_full_weekly_diff_daily_incremental", $data_decode["backup_scheme"]) . ">" . $l["monthly_full_weekly_diff_daily_incremental"] . "</option>\n\t\t\t\t\t\t<option class=\"local remote\" value=\"custom\" " . ex_POSTselect("backup_scheme", "custom", $data_decode["backup_scheme"]) . ">" . $l["custom"] . "</option>\n\t\t\t\t\t</select>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"always_cron_div\" style=\"display:none;\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["backup_freq"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_freq"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label><br />\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">";
    if(!empty($cron_time)) {
        $val = $cron_time;
    } else {
        $val = $data_decode["always_cronjob"];
    }
    if(!empty($val)) {
        echo "<script>\n\t\t\t\t\t\t\$(document).ready(function(){\n\t\t\t\t\t\t\t\$(\".always_cronjob\").html(convert_to_msg('" . $val . "'))\n\t\t\t\t\t\t})\n\t\t\t\t\t\t</script>";
    }
    echo "\n\t\t\t\t\t<span class=\"cursor-pointer always_cronjob\" onclick=\"add_cron_job(\$('#always_cronjob'))\">" . $l["click_set_cron"] . "</span>\n\t\t\t\t\t<input type=\"hidden\" class=\"form-control\" id=\"always_cronjob\" value=\"" . POSTval("always_cronjob", $val) . "\" name=\"always_cronjob\" autocomplete=\"off\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"weekly_cron_div\" style=\"display:none;\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["weekly_full_freq"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_freq"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label><br />\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">";
    if(!empty($data_decode["weekly_full_cronjob"])) {
        $val = $data_decode["weekly_full_cronjob"];
    } else {
        $val = "00 00 * * 1";
    }
    if(!empty($val)) {
        echo "<script>\n\t\t\t\t\t\t\$(document).ready(function(){\n\t\t\t\t\t\t\t\$(\".weekly_full_cronjob\").html(convert_to_msg('" . $val . "'))\n\t\t\t\t\t\t})\n\t\t\t\t\t\t</script>";
    }
    echo "\n\t\t\t\t\t<span class=\"cursor-pointer weekly_full_cronjob\" onclick=\"add_cron_job(\$('#weekly_full_cronjob'))\">" . $l["click_set_cron"] . "</span>\n\t\t\t\t\t<input type=\"hidden\" class=\"form-control\" id=\"weekly_full_cronjob\" value=\"" . POSTval("weekly_full_cronjob", $val) . "\" name=\"weekly_full_cronjob\" autocomplete=\"off\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"weekly_daily_inc_cron_div\" style=\"display:none;\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["weekly_full_daily_inc_freq"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_freq"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label><br />\n\t\t\t\t</div>";
    if(!empty($data_decode["weekly_daily_inc_cronjob"])) {
        echo "<script>\n\t\t\t\t\t\t\$(document).ready(function(){\n\t\t\t\t\t\t\t\$(\".weekly_daily_inc_cronjob\").html(convert_to_msg('" . $data_decode["weekly_daily_inc_cronjob"] . "'))\n\t\t\t\t\t\t})\n\t\t\t\t\t\t</script>";
    }
    echo "\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<span class=\"cursor-pointer weekly_daily_inc_cronjob\" onclick=\"add_cron_job(\$('#weekly_daily_inc_cronjob'))\">" . $l["click_set_cron"] . "</span>\n\t\t\t\t\t<input type=\"hidden\" class=\"form-control\" id=\"weekly_daily_inc_cronjob\" value=\"" . POSTval("weekly_daily_inc_cronjob", $data_decode["weekly_daily_inc_cronjob"]) . "\" name=\"weekly_daily_inc_cronjob\" autocomplete=\"off\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"monthly_full_div\" style=\"display:none;\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["monthly_full_freq"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_freq"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label><br />\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">";
    if(!empty($data_decode["monthly_full_cronjob"])) {
        $val = $data_decode["monthly_full_cronjob"];
    } else {
        $val = "00 00 1 * *";
    }
    if(!empty($val)) {
        echo "<script>\n\t\t\t\t\t\t\$(document).ready(function(){\n\t\t\t\t\t\t\t\$(\".monthly_full_cronjob\").html(convert_to_msg('" . $val . "'))\n\t\t\t\t\t\t})\n\t\t\t\t\t\t</script>";
    }
    echo "\n\t\t\t\t\t<span class=\"cursor-pointer monthly_full_cronjob\" onclick=\"add_cron_job(\$('#monthly_full_cronjob'))\">" . $l["click_set_cron"] . "</span>\n\t\t\t\t\t<input type=\"hidden\" class=\"form-control\" autocomplete=\"off\" id=\"monthly_full_cronjob\" value=\"" . POSTval("monthly_full_cronjob", $val) . "\" name=\"monthly_full_cronjob\" autocomplete=\"off\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"weekly_diff_div\" style=\"display:none;\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["weekly_diff_freq"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_freq"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label><br />\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t";
    if(!empty($data_decode["weekly_diff_cronjob"])) {
        $val = $data_decode["weekly_diff_cronjob"];
    } else {
        $val = "00 00 * * 1";
    }
    if(!empty($val)) {
        echo "<script>\n\t\t\t\t\t\t\$(document).ready(function(){\n\t\t\t\t\t\t\t\$(\".weekly_diff_cronjob\").html(convert_to_msg('" . $val . "'))\n\t\t\t\t\t\t})\n\t\t\t\t\t\t</script>";
    }
    echo "\n\t\t\t\t\t<span class=\"cursor-pointer weekly_diff_cronjob\" onclick=\"add_cron_job(\$('#weekly_diff_cronjob'))\">" . $l["click_set_cron"] . "</span>\n\t\t\t\t\t<input type=\"hidden\" class=\"form-control\" autocomplete=\"off\" id=\"weekly_diff_cronjob\" value=\"" . POSTval("weekly_diff_cronjob", $val) . "\" autocomplete=\"off\" name=\"weekly_diff_cronjob\" />\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"weekly_diff_daily_inc_div\" style=\"display:none;\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["weekly_diff_daily_inc_freq"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_freq"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label><br />\n\t\t\t\t</div>";
    if(!empty($data_decode["weekly_diff_daily_inc_cronjob"])) {
        echo "<script>\n\t\t\t\t\t\t\$(document).ready(function(){\n\t\t\t\t\t\t\t\$(\".weekly_diff_daily_inc_cronjob\").html(convert_to_msg('" . $data_decode["weekly_diff_daily_inc_cronjob"] . "'))\n\t\t\t\t\t\t})\n\t\t\t\t\t\t</script>";
    }
    echo "\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<span class=\"cursor-pointer weekly_diff_daily_inc_cronjob\" onclick=\"add_cron_job(\$('#weekly_diff_daily_inc_cronjob'))\">" . $l["click_set_cron"] . "</span>\n\t\t\t\t\t<input type=\"hidden\" class=\"form-control\" id=\"weekly_diff_daily_inc_cronjob\" autocomplete=\"off\" value=\"" . POSTval("weekly_diff_daily_inc_cronjob", $data_decode["weekly_diff_daily_inc_cronjob"]) . "\" name=\"weekly_diff_daily_inc_cronjob\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"custom_full_div\" style=\"display:none;\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["custom_full"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_freq"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label><br />\n\t\t\t\t</div>";
    if(!empty($data_decode["custom_full_cronjob"])) {
        echo "<script>\n\t\t\t\t\t\t\$(document).ready(function(){\n\t\t\t\t\t\t\t\$(\".custom_full_cronjob\").html(convert_to_msg('" . $data_decode["custom_full_cronjob"] . "'))\n\t\t\t\t\t\t})\n\t\t\t\t\t\t</script>";
    }
    echo "\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<span class=\"roundflare text-admin cursor-pointer custom_full_cronjob\" onclick=\"add_cron_job(\$('#custom_full_cronjob'))\">" . $l["click_set_cron"] . "</span>\n\t\t\t\t\t<input type=\"hidden\" class=\"form-control\" id=\"custom_full_cronjob\" autocomplete=\"off\" value=\"" . POSTval("custom_full_cronjob", $data_decode["custom_full_cronjob"]) . "\" name=\"custom_full_cronjob\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"custom_diff_div\" style=\"display:none;\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["custom_diff"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_freq"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label><br />\n\t\t\t\t</div>";
    if(!empty($data_decode["custom_diff_cronjob"])) {
        echo "<script>\n\t\t\t\t\t\t\$(document).ready(function(){\n\t\t\t\t\t\t\t\$(\".custom_diff_cronjob\").html(convert_to_msg('" . $data_decode["custom_diff_cronjob"] . "'))\n\t\t\t\t\t\t})\n\t\t\t\t\t\t</script>";
    }
    echo "\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<span class=\"roundflare text-admin cursor-pointer custom_diff_cronjob\" onclick=\"add_cron_job(\$('#custom_diff_cronjob'))\">" . $l["click_set_cron"] . "</span>\n\t\t\t\t\t<input type=\"hidden\" class=\"form-control\" id=\"custom_diff_cronjob\" autocomplete=\"off\" value=\"" . POSTval("custom_diff_cronjob", $data_decode["custom_diff_cronjob"]) . "\" name=\"custom_diff_cronjob\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"custom_inc_div\" style=\"display:none;\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["custom_inc"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_freq"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label><br />\n\t\t\t\t</div>";
    if(!empty($data_decode["custom_inc_cronjob"])) {
        echo "<script>\n\t\t\t\t\t\t\$(document).ready(function(){\n\t\t\t\t\t\t\t\$(\".custom_inc_cronjob\").html(convert_to_msg('" . $data_decode["custom_inc_cronjob"] . "'))\n\t\t\t\t\t\t})\n\t\t\t\t\t\t</script>";
    }
    echo "\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<span class=\"roundflare text-admin cursor-pointer custom_inc_cronjob\" onclick=\"add_cron_job(\$('#custom_inc_cronjob'))\">" . $l["click_set_cron"] . "</span>\n\t\t\t\t\t<input type=\"hidden\" class=\"form-control\" id=\"custom_inc_cronjob\" autocomplete=\"off\" value=\"" . POSTval("custom_inc_cronjob", $data_decode["custom_inc_cronjob"]) . "\" name=\"custom_inc_cronjob\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<input type=\"hidden\" name=\"selected_cron_type\" id=\"selected_cron_type\">\t\t\t\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"tr_dir\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["local_dir"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . htmlizer($l["exp_local_dir"]) . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<input type=\"text\" class=\"form-control\" name=\"dir\" id=\"dir\" value=\"" . $backup_plan["dir"] . "\" size=\"40\"/>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["backup_rotation"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_rotation"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<div class=\"input-group input-group-sm\">\n\t\t\t\t\t\t<div class=\"input-group-prepend\">\n\t\t\t\t\t\t\t<button type=\"button\" class=\"input-group-text blue_btn cursor-pointer\" onclick=\"apply_roation_val(0)\">-</button>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t\t<input type=\"text\" id=\"backup_rotation\" value=\"" . POSTval("rotation", $backup_plan["rotation"]) . "\" name=\"rotation\" class=\"form-control\" value=\"0\">\n\t\t\t\t\t\t<div class=\"input-group-append\">\n\t\t\t\t\t\t\t<button type=\"button\" class=\"input-group-text blue_btn cursor-pointer\" onclick=\"apply_roation_val(1)\">+</button>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"tr_backup_limit\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["backup_limit"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_limit"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<select class=\"custom-select\" name=\"backup_limit\" id=\"backup_limit\">";
    echo "<option value=\"0\" " . ex_POSTselect("backup_limit", 0, $backup_plan["backup_limit"]) . " >" . $l["disabled"] . "</option>";
    for ($i = 1; $i < 11; $i++) {
        echo "<option value=\"" . $i . "\" " . ex_POSTselect("backup_limit", $i, $backup_plan["backup_limit"]) . " >" . $i . "</option>";
    }
    echo "<option value=\"-1\" " . ex_POSTselect("backup_limit", -1, $backup_plan["backup_limit"]) . " >" . $l["unlimited"] . "</option>";
    echo "</select>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t\t<div class=\"col-sm-12 col-md-12 col-lg-6\">\n\t\t\t<div class=\"row mx-auto w-100 my-3\" id=\"tr_restore_limit\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["restore_limit"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_restore_limit"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<select class=\"custom-select\" name=\"restore_limit\" id=\"restore_limit\">";
    echo "<option value=\"0\" " . ex_POSTselect("restore_limit", 0, $backup_plan["restore_limit"]) . " >" . $l["disabled"] . "</option>";
    for ($i = 1; $i < 11; $i++) {
        echo "<option value=\"" . $i . "\" " . ex_POSTselect("restore_limit", $i, $backup_plan["restore_limit"]) . " >" . $i . "</option>";
    }
    echo "<option value=\"-1\" " . ex_POSTselect("restore_limit", -1, $backup_plan["restore_limit"]) . " >" . $l["unlimited"] . "</option>";
    echo "</select>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<!-- <div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["enable_enduser_backup_servers"] . "</label><br />\n\t\t\t\t\t<span class=\"help-block\">" . $l["exp_enable_enduser_backup_servers"] . "</span>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t" . get_checkbox("enable_enduser_backup_servers", "", "enable_enduser_backup_servers", ["chk_it" => 1, "val" => $backup_plan["enable_enduser_backup_servers"]]) . "\n\t\t\t\t</div>\n\t\t\t</div> -->\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["nice"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["nice_exp"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<select class=\"custom-select\" name=\"nice\" id=\"nice\">";
    for ($i = -20; $i < 20; $i++) {
        echo "<option value=\"" . $i . "\" " . ex_POSTselect("nice", $i, $backup_plan["nice"]) . ">" . $i . "</option>";
    }
    echo "</select>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["ionice_prio"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["ionice_prio_exp"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<select class=\"custom-select\" name=\"ionice_prio\" id=\"ionice_prio\">";
    for ($i = 0; $i < 8; $i++) {
        echo "<option value=\"" . $i . "\" " . ex_POSTselect("ionice_prio", $i, $backup_plan["ionice_prio"]) . ">" . $i . "</option>";
    }
    echo "</select>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["ionice_class"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["ionice_class_exp"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<select class=\"custom-select\" name=\"ionice_class\" id=\"ionice_class\">\n\t\t\t\t\t\t<option value=\"1\" " . ex_POSTselect("ionice_class", 1, $backup_plan["ionice_class"]) . " >Real Time</option>\n\t\t\t\t\t\t<option value=\"2\" " . ex_POSTselect("ionice_class", 2, $backup_plan["ionice_class"]) . ">Best Effort</option>\n\t\t\t\t\t\t<option value=\"3\" " . ex_POSTselect("ionice_class", 3, $backup_plan["ionice_class"]) . ">Idle</option>\n\t\t\t\t\t</select>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["io_limit"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_io_limit"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t<input type=\"number\" class=\"form-control\" name=\"io_limit\" value=\"" . POSTval("io_limit", $backup_plan["io_limit"]) . "\" />\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["backup_compression"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_backup_compression"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-6\">\n\t\t\t\t\t" . get_checkbox("compression", "", "compression", ["chk_it" => 1, "val" => $backup_plan["disable_compression"]]) . "\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t<div class=\"col-6\">\n\t\t\t\t\t<label class=\"control-label\">" . $l["check_dir_permissions"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["exp_check_dir_permissions"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t</div>\n\t\t\t\t<div class=\"col-6\">\n\t\t\t\t\t" . get_checkbox("check_dir_permissions", "", "check_dir_permissions", ["chk_it" => 1, "val" => true]) . "\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t<div class=\"col-sm-6\">\n\t\t\t\t\t\t<label class=\"control-label\">" . $l["backup_primary"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["primary_backup_exp"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"col-6\">\n\t\t\t\t\t" . get_checkbox("backup_primary", "", "backup_primary", ["chk_it" => 1, "val" => $data_decode["backup_primary"]]) . "\n\n\t\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n\n<div class=\"row mx-auto w-100 my-3row mx-auto w-100 my-3\">\n\t<div class=\"col-sm-12 col-md-12 col-lg-6 pl-0 border-right\">\n\t\t<div class=\"roundheader hide_for_plan cursor-pointer\" onclick=\"toggle_advoptions('adv');\"><label id=\"adv_advoptions_ind\"  class=\"min_width\">+</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . $l["addvoption"] . "</div>\n\t\t<div id=\"adv_advoptions\" style=\"display:none;\" class=\"hide_for_plan w-100\">\n\t\t\t<div class=\"col-sm-12 bgaddv\">\n\t\t\t\t<div class=\"row mx-auto w-100 my-3\">\n\t\t\t\t\t<div class=\"col-sm-12\">\n\t\t\t\t\t\t<label class=\"control-label\">" . $l["backup_server_per_region"] . "&nbsp;<a class=\"info\" data-placement=\"right\" tooltip=\"" . $l["backup_server_per_region_exp"] . "\"><i class=\"fas text-primary fa-info-circle\"></i></a></label>\n\t\t\t\t\t</div>\n\t\t\t\t\t<div class=\"col-sm-12\">\n\t\t\t\t\t\t<div class=\"scrollbar-virt\">\n\t\t\t\t\t\t\t<table class=\"table table-bordered\">\n\t\t\t\t\t\t\t\t<tr class=\"active\">\n\t\t\t\t\t\t\t\t\t<th>" . $l["server_group_header"] . "</th>\n\t\t\t\t\t\t\t\t\t<th>" . $l["sel_backupserver"] . "</th>\n\t\t\t\t\t\t\t\t\t<th>" . $l["local_dir"] . "</th>\n\t\t\t\t\t\t\t\t</tr>";
    foreach ($servergroups as $sgid => $servergroup) {
        echo "<tr>\n\t\t\t\t\t\t\t\t\t\t<th>[Group] " . $servergroup["sg_name"] . "</th>\n\t\t\t\t\t\t\t\t\t\t<th><select class=\"virt-select\" name=\"bs_sg" . $sgid . "\">\n\t\t\t\t\t\t\t\t\t\t\t<option value=\"0\" " . ex_POSTselect("bs_sg" . $sgid, 0, $backup_plan["bs_servergroups"]["bs_groups"][$sgid]) . ">" . $l["default"] . "</option>\n\t\t\t\t\t\t\t\t\t\t\t<option value=\"-1\" " . ex_POSTselect("bs_sg" . $sgid, -1, $backup_plan["bs_servergroups"]["bs_groups"][$sgid]) . ">LOCAL</option>\n\t\t\t\t\t\t\t\t\t\t\t<optgroup label=\"SSH\">";
        foreach ($backupservers as $bid => $bs) {
            if($bs["type"] == "SSH") {
                echo "<option value=\"" . $bid . "\" " . ex_POSTselect("bs_sg" . $sgid, $bid, $backup_plan["bs_servergroups"]["bs_groups"][$sgid]) . ">" . $bs["name"] . "</option>";
            }
        }
        echo "</optgroup>\n\t\t\t\t\t\t\t\t\t\t\t<optgroup label=\"FTP\">";
        foreach ($backupservers as $bid => $bs) {
            if($bs["type"] == "FTP") {
                echo "<option value=\"" . $bid . "\" " . ex_POSTselect("bs_sg" . $sgid, $bid, $backup_plan["bs_servergroups"]["bs_groups"][$sgid]) . ">" . $bs["name"] . "</option>";
            }
        }
        echo "</optgroup>\n\t\t\t\t\t\t\t\t\t\t</select></th>\n\t\t\t\t\t\t\t\t\t\t<th><input type=\"text\" class=\"form-control\" name=\"dir_sg" . $sgid . "\" value=\"" . POSTval("dir_sg" . $sgid, $backup_plan["bs_servergroups"]["dir_groups"][$sgid]) . "\" placeholder=\"" . $l["default_dir"] . "\" size=\"40\"/></th>\n\t\t\t\t\t\t\t\t\t</tr>";
        foreach ($servers as $serid => $server) {
            if($server["sgid"] != $sgid) {
            } else {
                echo "<tr>\n\t\t\t\t\t\t\t\t\t\t\t<td> - " . $server["server_name"] . " (" . $server["ip"] . ")</td>\n\t\t\t\t\t\t\t\t\t\t\t<th><select class=\"virt-select\" name=\"bs_s" . $serid . "\">\n\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"0\" " . ex_POSTselect("bs_s" . $serid, 0, $backup_plan["bs_servergroups"]["bs_servers"][$serid]) . ">" . $l["default"] . "</option>\n\t\t\t\t\t\t\t\t\t\t\t\t<option value=\"-1\" " . ex_POSTselect("bs_s" . $serid, -1, $backup_plan["bs_servergroups"]["bs_servers"][$serid]) . ">LOCAL</option>\n\t\t\t\t\t\t\t\t\t\t\t\t<optgroup label=\"SSH\">";
                foreach ($backupservers as $bid => $bs) {
                    if($bs["type"] == "SSH") {
                        echo "<option value=\"" . $bid . "\" " . ex_POSTselect("bs_s" . $serid, $bid, $backup_plan["bs_servergroups"]["bs_servers"][$serid]) . ">" . $bs["name"] . "</option>";
                    }
                }
                echo "</optgroup>\n\t\t\t\t\t\t\t\t\t\t\t\t<optgroup label=\"FTP\">";
                foreach ($backupservers as $bid => $bs) {
                    if($bs["type"] == "FTP") {
                        echo "<option value=\"" . $bid . "\" " . ex_POSTselect("bs_s" . $serid, $bid, $backup_plan["bs_servergroups"]["bs_servers"][$serid]) . ">" . $bs["name"] . "</option>";
                    }
                }
                echo "</optgroup>\n\t\t\t\t\t\t\t\t\t\t\t</select></th>\n\t\t\t\t\t\t\t\t\t\t\t<th><input type=\"text\" class=\"form-control\" name=\"dir_s" . $serid . "\" value=\"" . POSTval("dir_s" . $serid, $backup_plan["bs_servergroups"]["dir_servers"][$serid]) . "\"  placeholder=\"" . $l["default_dir"] . "\" size=\"40\"/></th>\n\t\t\t\t\t\t\t\t\t\t</tr>";
            }
        }
    }
    echo "</table>\n\t\t\t\t\t\t</div>\n\t\t\t\t\t</div>\n\t\t\t\t</div>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n\t<div class=\"col-sm-12 col-md-12 col-lg-6 pr-0\">\n\t\t<div class=\"roundheader cursor-pointer\" onclick=\"toggle_advoptions('vs');\">\n\t\t\t<label id=\"vs_advoptions_ind\" class=\"min_width\">+</label> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . $l["list_vs"] . "\n\t\t</div>\n\t\t<div id=\"vs_advoptions\" style=\"display:none;\" class=\"bgaddv w-100\">\n\t\t\t<div class=\"bgaddv p-0 m-0 overflow-auto mh-25\">\n\t\t\t\t<table class=\"table table-hover vps_table m-0\">\n\t\t\t\t\t<tr>\n\t\t\t\t\t\t<th width=\"100\">" . $l["vpsid"] . "</th>\n\t\t\t\t\t\t<th width=\"100\">" . $l["vps_name"] . "</th>\n\t\t\t\t\t\t<th>" . $l["server"] . "</th>\n\t\t\t\t\t\t<th>" . $l["hostname"] . "</th>\n\t\t\t\t\t\t<th>" . $l["space"] . "</th>\n\t\t\t\t\t</tr>";
    if(empty($vpses)) {
        echo "<tr>\n\t\t\t\t\t\t\t<td colspan=\"5\" align=\"center\"><b>" . $l["no_vps_in_plan"] . "</b></td>\n\t\t\t\t\t\t</tr>";
    }
    foreach ($vpses as $vpsid => $vps) {
        echo "<tr>\n\t\t\t\t\t\t\t\t<td width=\"100\">" . $vpsid . "</td>\n\t\t\t\t\t\t\t\t<td width=\"100\">" . $vps["vps_name"] . "</td>\n\t\t\t\t\t\t\t\t<td>" . $servers[$vps["serid"]]["server_name"] . "</td>\n\t\t\t\t\t\t\t\t<td>" . $vps["hostname"] . "</td>\n\t\t\t\t\t\t\t\t<td align=\"center\">" . $vps["space"] . " GB</td>\n\t\t\t\t\t\t\t</tr>";
    }
    echo "</table>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\t\n<br />\n\t<center>\n\t\t<input type=\"submit\" name=\"editbackup_plan\"  id=\"editbackup_plan\" value=\"" . $l["submit"] . "\" class=\"go_btn\" />\n\t\t<br /><br />\n\t\t<input type=\"submit\" name=\"backup_now\"  id=\"backup_now\" value=\"" . ($data_decode["backup_scheme"] == "always_full" && $backup_plan["frequency"] != "manual" ? $l["take_full_backup"] : $l["take_inc_backup"]) . "\" class=\"go_btn\" />\n\t\t";
    if($backup_plan["frequency"] == "manual") {
        echo "<input type=\"submit\" name=\"take_full_backup\"  id=\"take_full_backup\" value=\"" . $l["take_full_backup"] . "\" class=\"go_btn\" />";
    }
    echo "\n\t</center>\n</form>\n\n<div class=\"row mx-auto w-100 my-3\">\n\t<div class=\"col-sm-12 p-0\">\n\t\t<div id=\"panel-tasks\" class=\"panel panel-blue-grey\">\n\t\t\t<div class=\"panel-heading\">\n\t\t\t\t<span>" . $l["list_tasks"] . "</span>\n\t\t\t\t<i class=\"icon icon-tasks float-left mr-1 h6 m-0\"></i>\n\t\t\t</div>\n\t\t\t<div class=\"panel-content scrollbar-virt\">\n\t\t\t\t<div id=\"table_tasks_container\"></div>\n\t\t\t</div>\n\t\t</div>\n\t</div>\n</div>\n</div>";
    softfooter();
}

?>