<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
include_once "inc.php";
global $error;
global $mail_error_log;
global $servers;
global $actid;
$options = getopt("a:f:lr");
$actid = $options["a"];
$fname = $options["f"];
$local = isset($options["l"]);
$remote = isset($options["r"]);
if(empty($local) && empty($remote)) {
    exit("Missing mandatory arguments. At least one of [-l, -r] options is required.\nUsage: /usr/local/emps/bin/php /usr/local/virtualizor/scripts/databasebackups.php [-a<actid>] [-f<filename>] [-l, -r]\n\nOptions:\n\t-l\tStore backup file locally\n\t-r\tStore backup file on remote server\n");
}
if(empty($fname)) {
    $fname = $globals["db"] . "-" . date("Y-m-d_H.i.s") . ".sql.gz";
}
$globals["disable_email"] = false;
$script_tstart = time();
if(!bg_databasebackups()) {
    global $error;
    foreach ($mail_error_log as $k => $v) {
        $temp_error_log .= $v . "\n";
    }
    echo "[" . gmdate("D M d, Y H:i:s T", time()) . "] " . $temp_error_log . "\n";
    task_update($actid, $temp_error_log, -1);
    send_emailtemp_mail("admin_dbbackups_err", $globals["soft_email"], ["server_domain" => $globals["sn"], "error_log" => $temp_error_log, "primary_ip" => $globals["primary_ip"], "sn" => $globals["sn"]]);
} else {
    $script_tend = time();
    $script_elapsed = $script_tend - $script_tstart;
    $status = lang_vars_name($l["log_completed"], ["elapsed" => round($script_elapsed / 60, 2)]);
    $timestamp = "[" . gmdate("D M d, Y H:i:s T", time()) . "] ";
    echo $timestamp . (empty($globals["disable_slave_db_backup"]) ? $status : $l["finished"]) . "\n";
    task_update($actid, $status, 100);
}
if(!empty($error)) {
    echo "Errors: \n";
    r_print($error);
}
if(defined("debug")) {
    r_print($GLOBALS["logr"]);
}
function bg_databasebackups()
{
    global $globals;
    global $kernel;
    global $servers;
    global $l;
    global $error;
    global $mail_error_log;
    global $actid;
    global $fname;
    global $local;
    global $remote;
    if(!load_lang("admin/databackup")) {
        return false;
    }
    if(is_slave() && !empty($globals["disable_slave_db_backup"])) {
        echo $l["slave_db_backup_disabled"] . "\n";
        return true;
    }
    if(empty($actid)) {
        $actid = tasks_admin_process("dbbackups", "", 5, 0, 0, 0, 0);
    }
    ini_set("memory_limit", "-1");
    $res = makequery("SELECT * FROM tasks\n\t\t\t\t\t\tWHERE actid = :actid", [":actid" => $actid]);
    if(vsql_num_rows($res) == 0) {
        $mail_error_log[] = $l["log_err_no_task"];
        return false;
    }
    if(5242880 < vfilesize(logdir() . "virtualizor-dbbackup.log")) {
        vexec("echo \"\" > " . logdir() . "virtualizor-dbbackup.log");
    }
    echo "[" . gmdate("D M d, Y H:i:s T", time()) . "] " . $l["log_starting"] . "\n";
    task_start($actid);
    echo lang_vars_name($l["log_bkup_local"], ["val" => empty($local) ? "FALSE" : "TRUE"]) . "\n";
    echo lang_vars_name($l["log_bkup_remote"], ["val" => empty($remote) ? "FALSE" : "TRUE"]) . "\n";
    if(!empty($remote)) {
        echo lang_vars_name($l["log_rem_bckup_type"], ["type" => $globals["dbbackup_type"]]) . "\n";
    }
    echo "[" . gmdate("D M d, Y H:i:s T", time()) . "] " . $l["log_creating_backup"] . "\n";
    task_update($actid, $l["log_creating_backup"], 5);
    $temp_backup_dir = "/var/virtualizor/dbbackups/";
    if(!is_dir($temp_backup_dir)) {
        @mkdir($temp_backup_dir, 384);
        @chmod($temp_backup_dir, 384);
    }
    $diskspace = get_free_space($temp_backup_dir);
    $get_schema_space = "/usr/local/emps/bin/mysql -u " . $globals["dbuser"] . " --password=" . $globals["dbpass"] . " --database=information_schema -e \"SELECT ROUND(SUM(data_length + index_length) / 1024 / 1024, 2) AS size FROM information_schema.TABLES where table_schema ='virtualizor' GROUP BY table_schema\"";
    vexec($get_schema_space, $output);
    $backup_size = $output[1];
    if($diskspace < $backup_size) {
        $mail_error_log[] = $l["low_space_dbbackup"];
        return false;
    }
    $fpath = (substr($temp_backup_dir, -1) === "/" ? $temp_backup_dir : $temp_backup_dir . "/") . $fname;
    $db_ret = database_dump($globals["dbuser"], $globals["dbpass"], $globals["db"], $fpath);
    if(!empty($db_ret)) {
        $mail_error_log[] = $l["log_err_mysql_dump"];
        return false;
    }
    if(!empty($remote) && $globals["dbbackup_type"] != "EMAIL") {
        $res = makequery("SELECT * FROM backup_servers\n\t\t\t\t\t\t\tWHERE bid = :bid", [":bid" => $globals["dbbackup_server"]]);
        if(vsql_num_rows($res) == 0) {
            $mail_error_log[] = $l["log_err_bckup_server"];
            return false;
        }
        $backup_server = vsql_fetch_assoc($res);
    }
    if(!empty($remote)) {
        if($globals["dbbackup_type"] == "EMAIL") {
            echo $l["log_emailing_backup"] . "\n";
            task_update($actid, $l["log_emailing_backup"], 5);
            $ll = email_templates("db_backup");
            if(empty($ll["is_disable"])) {
                $site_domain = !empty($globals["site_domain"]) && $globals["site_domain"] != $globals["primary_ip"] ? "(" . $globals["site_domain"] . ")" : "(" . $globals["primary_ip"] . ")";
                $site_domain = unhtmlentities($site_domain);
                $mail[0]["to"] = empty($globals["dbbackup_email"]) ? $globals["soft_email"] : $globals["dbbackup_email"];
                $vars = ["primary_ip" => $globals["primary_ip"], "server_domain" => $site_domain];
                $mail[0]["subject"] = lang_vars_name($ll["title"] . " : " . $site_domain, $vars);
                $mail[0]["message"] = lang_vars_name($ll["body"], $vars);
                $mail[0]["attach"] = $fpath;
                _mail($mail, $ll["mail_type"]);
            }
        } elseif($globals["dbbackup_type"] == "SSH") {
            echo $l["log_connecting"] . "\n";
            task_update($actid, $l["log_connecting"], 5);
            $connection = connect_ssh($backup_server);
            if(!$connection) {
                $mail_error_log[] = $l["log_err_conn"];
                return false;
            }
            $sftp = ssh2_sftp($connection);
            $exists = file_exists("ssh2.sftp://" . intval($sftp) . $globals["dbbackup_server_dir"]);
            if(empty($exists) && !ssh2_sftp_mkdir($sftp, $globals["dbbackup_server_dir"], 511, true)) {
                $mail_error_log[] = $l["log_err_mkdir"];
                return false;
            }
            echo "[" . gmdate("D M d, Y H:i:s T", time()) . "] " . $l["log_uploading_backup"] . "\n";
            task_update($actid, $l["log_uploading_backup"], 5);
            if(!ssh2_scp_send($connection, $fpath, $globals["dbbackup_server_dir"] . "/" . $fname)) {
                $mail_error_log[] = $l["log_err_upload"];
                return false;
            }
            ssh2_exec($connection, "exit");
        } else {
            echo $l["log_connecting"] . "\n";
            task_update($actid, $l["log_connecting"], 5);
            $ftp_con = connect_ftp($backup_server);
            if(!$ftp_con) {
                $mail_error_log[] = $l["log_err_conn"];
                return false;
            }
            $exists = @ftp_chdir($ftp_con, $globals["dbbackup_server_dir"]);
            if(empty($exists) && !ftp_mkdir($ftp_con, $globals["dbbackup_server_dir"])) {
                $mail_error_log[] = $l["log_err_mkdir"];
                return false;
            }
            echo "[" . gmdate("D M d, Y H:i:s T", time()) . "] " . $l["log_uploading_backup"] . "\n";
            task_update($actid, $l["log_uploading_backup"], 5);
            if(!ftp_put($ftp_con, $globals["dbbackup_server_dir"] . "/" . $fname, $fpath, FTP_BINARY)) {
                $mail_error_log[] = $l["log_err_upload"];
                return false;
            }
            ftp_close($ftp_con);
        }
    }
    if(empty($local)) {
        unlink($fpath);
    }
    if(!empty($mail_error_log)) {
        return false;
    }
    return true;
}

?>