<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function adminnotes()
{
    global $theme;
    global $globals;
    global $l;
    global $error;
    global $user;
    global $notes_private;
    global $notes_public;
    global $notes_archived;
    global $count_private;
    global $count_public;
    global $count_archived;
    global $done;
    if(!load_lang("admin/adminnotes")) {
        return false;
    }
    $theme["init_theme"] = "admin/adminnotes";
    $theme["init_theme_name"] = "adminnotes";
    $theme["init_theme_func"] = ["adminnotes_theme"];
    $theme["call_theme_func"] = "adminnotes_theme";
    if(!is_allowed("adminacl")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $add = optREQ("add");
    if(!empty($add)) {
        $title = htmlizer(trim($_POST["title"]));
        $content = htmlizer(trim($_POST["content"]));
        $type = optREQ("type");
        $type = empty($type) ? 0 : 1;
        if(!empty($title) && strlen($title) <= 128 && !empty($content)) {
            $noteid = insert_and_id("INSERT INTO admin_notes SET\n\t\t\t\t\t\t\t\tuid = :uid,\n\t\t\t\t\t\t\t\ttitle = :title,\n\t\t\t\t\t\t\t\tcontent = :content,\n\t\t\t\t\t\t\t\ttime = :time,\n\t\t\t\t\t\t\t\ttype = :type", [":uid" => $user["uid"], ":title" => $title, ":content" => $content, ":time" => time(), ":type" => $type]);
            if(empty($noteid)) {
                $error[] = $l["err_saving_note"];
            } else {
                $done = $noteid;
                $notify = optPOST("notify");
                if(!empty($type) && !empty($notify)) {
                    $res = makequery("SELECT email FROM `users` WHERE type = 1");
                    $mail = [];
                    $ll = email_templates("public_email");
                    for ($i = 0; $i < vsql_num_rows($res); $i++) {
                        $row = vsql_fetch_assoc($res);
                        $mail[] = ["to" => $row["email"], "subject" => lang_vars_name($ll["title"], ["user" => $user["name"], "note_title" => $title, "note_content" => unhtmlentities($content), "sn" => $globals["sn"]]), "message" => lang_vars_name($ll["body"], ["user" => $user["name"], "note_title" => $title, "note_content" => unhtmlentities($content), "sn" => $globals["sn"]])];
                    }
                    if(empty($ll["is_disable"])) {
                        _mail($mail, $ll["mail_type"]);
                    }
                }
            }
        }
    }
    $editid = (int) optPOST("edit");
    if(!empty($editid)) {
        $title = htmlizer(trim($_POST["title"]));
        $content = htmlizer(trim($_POST["content"]));
        if(!empty($title) && strlen($title) <= 128 && !empty($content)) {
            $res = makequery("UPDATE admin_notes SET\n\t\t\t\t\t\t\t\ttitle = :title,\n\t\t\t\t\t\t\t\tcontent = :content\n\t\t\t\t\t\t\t  WHERE noteid = :noteid\n\t\t\t\t\t\t\t  AND uid = :uid\n\t\t\t\t\t\t\t  AND type = 0", [":title" => $title, ":content" => $content, ":noteid" => $editid, ":uid" => $user["uid"]]);
            $done = 1;
        } else {
            $error[] = $l["err_saving_note"];
        }
    }
    $doneid = optREQ("done");
    if(!empty($doneid)) {
        $res = makequery("UPDATE admin_notes SET\n\t\t\t\t\t\t\tdone = :done\n\t\t\t\t\t\t  WHERE noteid = :noteid\n\t\t\t\t\t\t  AND uid = :uid", [":done" => $user["uid"], ":noteid" => $doneid, ":uid" => $user["uid"]]);
        if(0 < vsql_affected_rows($res)) {
            $done = 1;
        } else {
            $error[] = $l["err_done_note"];
        }
    }
    $delids = optREQ("delete");
    if(!empty($delids)) {
        $delids = cexplode(",", $delids, 1);
        $res = makequery("DELETE FROM admin_notes\n\t\t\t\t\t\t\tWHERE uid = :uid\n\t\t\t\t\t\t\tAND noteid IN (" . implode(",", $delids) . ")", [":uid" => $user["uid"]]);
        if(0 < vsql_affected_rows($res)) {
            $done = 1;
        } else {
            $error[] = $l["err_deleting_note"];
        }
    }
    $restore_ids = optREQ("restore");
    if(!empty($restore_ids)) {
        $restore_ids = cexplode(",", $restore_ids, 1);
        $res = makequery("UPDATE admin_notes\n\t\t\t\t\t\t\tSET done = -1\n\t\t\t\t\t\t\tWHERE noteid IN (" . implode(",", $restore_ids) . ")");
        if(0 < vsql_affected_rows($res)) {
            $done = 1;
        } else {
            $error[] = $l["err_restoring_note"];
        }
    }
    $reslen = optREQ("reslen");
    $globals["reslen"] = $reslen <= 0 ? 20 : $reslen;
    $globals["curr_page"] = get_page("page", $globals["reslen"]);
    $globals["reslen_archived"] = $reslen <= 0 ? 50 : $reslen;
    $show_private = optREQ("private");
    $show_public = optREQ("public");
    if(!empty($show_private)) {
        get_notes_private();
    } elseif(!empty($show_public)) {
        get_notes_public();
    } else {
        get_notes_private();
        get_notes_public();
    }
    get_notes_archived();
}
function get_notes_private()
{
    global $globals;
    global $user;
    global $notes_private;
    global $count_private;
    $query_notes = "SELECT noteid,title,content,time FROM admin_notes \n\t\t\t\t\tLEFT JOIN users on admin_notes.uid = users.uid \n\t\t\t\t\tWHERE admin_notes.type = :type \n\t\t\t\t\tAND admin_notes.uid = :uid \n\t\t\t\t\tAND done = :done";
    $query_count = "SELECT COUNT(noteid) as num FROM admin_notes \n\t\t\t\t\tWHERE type = :type \n\t\t\t\t\tAND uid = :uid \n\t\t\t\t\tAND done = :done";
    $values = [":type" => 0, ":uid" => $user["uid"], ":done" => -1];
    $search = optREQ("search");
    if(!empty($search)) {
        $values[":search"] = "%" . wildsearch($search) . "%";
        $q = " AND (title LIKE :search OR content LIKE :search)";
        $query_notes .= $q;
        $query_count .= $q;
    }
    $query_notes .= " ORDER BY time DESC LIMIT " . $globals["curr_page"] . ", " . $globals["reslen"];
    $res = makequery($query_notes, $values);
    $notes_private = [];
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $row["time"] = datify($row["time"], 0, 1, "d-m-Y, h:i A");
        $notes_private[] = $row;
    }
    $res = makequery($query_count, $values);
    $row = vsql_fetch_assoc($res);
    $count_private = $row["num"];
}
function get_notes_public()
{
    global $globals;
    global $notes_public;
    global $count_public;
    $query_notes = "SELECT noteid,admin_notes.uid,(CASE WHEN admin_notes.uid=0 THEN 'root' ELSE email END) as user,title,content,time FROM admin_notes \n\t\t\t\t\tLEFT JOIN users on admin_notes.uid = users.uid \n\t\t\t\t\tWHERE admin_notes.type = :type \n\t\t\t\t\tAND done = :done";
    $query_count = "SELECT COUNT(noteid) as num FROM admin_notes \n\t\t\t\t\tWHERE type = :type \n\t\t\t\t\tAND done = :done";
    $values = [":type" => 1, ":done" => -1];
    $search = optREQ("search");
    if(!empty($search)) {
        $values[":search"] = "%" . wildsearch($search) . "%";
        $q = " AND (title LIKE :search OR content LIKE :search)";
        $query_notes .= $q;
        $query_count .= $q;
    }
    $query_notes .= " ORDER BY time DESC LIMIT " . $globals["curr_page"] . ", " . $globals["reslen"];
    $res = makequery($query_notes, $values);
    $notes_public = [];
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $row["time"] = datify($row["time"], 0, 1, "d-m-Y, h:i A");
        $notes_public[] = $row;
    }
    $res = makequery($query_count, $values);
    $row = vsql_fetch_assoc($res);
    $count_public = $row["num"];
}
function get_notes_archived()
{
    global $globals;
    global $notes_archived;
    global $count_archived;
    global $user;
    $query_notes = "SELECT noteid, an.uid, (CASE WHEN an.uid=0 THEN 'root' ELSE email END) as user, title, content, time, an.type FROM admin_notes an\n\t\t\t\t\t\tLEFT JOIN users u ON an.uid = u.uid\n\t\t\t\t\t\tWHERE done != :done\n\t\t\t\t\t\tAND (an.type = 1 OR an.uid = :uid)";
    $query_count = "SELECT COUNT(noteid) as num FROM admin_notes an\n\t\t\t\t\t\tLEFT JOIN users u ON an.uid = u.uid\n\t\t\t\t\t\tWHERE done != :done\n\t\t\t\t\t\tAND (an.type = 1 OR an.uid = :uid)";
    $values = [":done" => -1, ":uid" => $user["uid"]];
    $title = optREQ("title");
    if(!empty($title)) {
        $values[":title"] = wildsearch($title);
        $q = " AND title LIKE :title";
        $query_notes .= $q;
        $query_count .= $q;
    }
    $content = optREQ("content");
    if(!empty($content)) {
        $values[":content"] = wildsearch($content);
        $q = " AND content LIKE :content";
        $query_notes .= $q;
        $query_count .= $q;
    }
    $type = optREQ("type");
    if($type == 1 || $type == 2) {
        $type -= 1;
        $values[":type"] = $type;
        $q = " AND an.type = :type";
        $query_notes .= $q;
        $query_count .= $q;
    }
    $search_uid = optREQ("user");
    if(!empty($search_uid)) {
        $values[":user"] = wildsearch($search_uid);
        $q = " AND email LIKE :user";
        $query_notes .= $q;
        $query_count .= $q;
    }
    $query_notes .= " ORDER BY time DESC LIMIT " . $globals["curr_page"] . ", " . $globals["reslen_archived"];
    $res = makequery($query_notes, $values);
    $notes_archived = [];
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $row["time"] = datify($row["time"], 0, 1, "d-m-Y, h:i A");
        $notes_archived[] = $row;
    }
    $res = makequery($query_count, $values);
    $row = vsql_fetch_assoc($res);
    $count_archived = $row["num"];
}
function API_adminnotes()
{
    global $theme;
    global $globals;
    global $error;
    global $user;
    global $notes_private;
    global $notes_public;
    global $notes_archived;
    global $count_private;
    global $count_public;
    global $count_archived;
    global $done;
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(isset($notes_private)) {
        $GLOBALS["_api"]["notes_private"] = $notes_private;
    }
    if(isset($notes_public)) {
        $GLOBALS["_api"]["notes_public"] = $notes_public;
    }
    if(isset($count_private)) {
        $GLOBALS["_api"]["count_private"] = $count_private;
    }
    if(isset($count_public)) {
        $GLOBALS["_api"]["count_public"] = $count_public;
    }
    if(isset($notes_archived)) {
        $GLOBALS["_api"]["notes_archived"] = $notes_archived;
    }
    if(isset($count_archived)) {
        $GLOBALS["_api"]["count_archived"] = $count_archived;
    }
}

?>