<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addippool()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $users;
    global $l;
    global $servers;
    global $error;
    global $cluster;
    global $done;
    global $ips;
    global $servergroups;
    global $pdns_servers;
    if(!load_lang("admin/addippool")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/addippool";
    $theme["init_theme_name"] = "addippool";
    $theme["init_theme_func"] = ["addippool_theme"];
    $theme["call_theme_func"] = "addippool_theme";
    if(!is_allowed("addippool")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $servergroups = server_groups();
    $pdns_servers = get_pdns_servers();
    $params["query"] = "SELECT uid, email FROM users WHERE pid < 1";
    $params["id"] = "uid";
    $users = select_query($params);
    if(isset($_POST["addippool"])) {
        $iptype = POST("iptype", $l["no_iptype"]);
        $iptype = $iptype == 4 ? 4 : 6;
        $ippool_name = POST("ippool_name", $l["no_name"]);
        $gateway = POST("gateway", $l["no_gateway"]);
        $netmask = POST("netmask", $l["no_netmask"]);
        $ns1 = POST("ns1", $l["no_ns1"]);
        $ns2 = POST("ns2", $l["no_ns2"]);
        $nat = (int) checkbox("nat");
        $routing = (int) checkbox("routing");
        $internal = (int) optPOST("internal");
        $internal_bridge = optPOST("internal_bridge");
        $vlan = (int) optREQ("vlan");
        $vlan_tag = (int) optREQ("vlan_tag");
        $vlan_bridge = optPOST("vlan_bridge");
        $serid = $_POST["serid"];
        $mtu = (int) optPOST("mtu");
        if(!empty($vlan_tag) && ($vlan_tag < 0 || 4094 < $vlan_tag)) {
            $error[] = $l["vlan_tag_err"];
        }
        $uid = (int) optPOST("uid");
        if(0 < $uid && !empty($internal)) {
            $error[] = $l["no_int_pool"];
        }
        $pdns_id = (int) optPOST("pdns_id");
        if($pdns_id < 0) {
            $error[] = $l["invalid_pdns"];
        }
        if(!empty($nat)) {
            $routing = 0;
            $internal = 0;
            $vlan = 0;
        } elseif(!empty($routing)) {
            $nat = 0;
            $internal = 0;
            $vlan = 0;
        } elseif(!empty($internal)) {
            $nat = 0;
            $routing = 0;
            $vlan = 0;
        } elseif(!empty($vlan)) {
            $nat = 0;
            $routing = 0;
            $internal = 0;
        }
        if(!empty($internal) && $iptype != 4) {
            $error[] = $l["internal_ipv4"];
        }
        if(!empty($internal) && empty($internal_bridge)) {
            $error[] = $l["internal_no_bridge"];
        }
        if(!empty($vlan) && empty($vlan_bridge)) {
            $error[] = $l["vlan_no_bridge"];
        }
        if(!valid_ip($gateway) && $iptype == 4) {
            $error[] = $l["inv_gateway"];
        }
        if(!empty($error)) {
            return false;
        }
        if(!is_array($serid)) {
            $serid = [(int) $serid];
        }
        foreach ($serid as $key => $ser) {
            if(0 < substr_count($ser, "_")) {
                $tmp = explode("_", $ser);
                if(empty($servergroups[$tmp[0]])) {
                    $error[] = $l["inv_group"];
                }
                if(!empty($nat) || !empty($routing)) {
                    $error[] = $l["nat_route_oneserver"];
                }
            } elseif($ser != -1 && empty($servers[$ser])) {
                $error[] = $l["inv_server"];
            }
        }
        if(!empty($error)) {
            return false;
        }
        if(1 < count($serid) && (!empty($nat) || !empty($routing))) {
            $error[] = $l["nat_route_oneserver"];
        }
        if(!valid_ip($netmask) && $iptype == 4) {
            $error[] = $l["inv_netmask"];
        } elseif((127 < $netmask || $netmask < 1) && $iptype == 6) {
            $error[] = $l["inv_netmask_6"];
        }
        if(!valid_ip($ns1) && $iptype == 4) {
            $error[] = $l["inv_ns1"];
        }
        if(!valid_ip($ns2) && $iptype == 4) {
            $error[] = $l["inv_ns2"];
        }
        if($iptype == 6 && !empty($nat)) {
            $error[] = $l["nat_ipv6_err"];
        }
        if(!empty($error)) {
            return false;
        }
        if($iptype == 4) {
            $firstip = optPOST("firstip");
            $lastip = optPOST("lastip");
            if((empty($firstip) || empty($lastip)) && !empty($nat)) {
                $error[] = $l["no_ip_nat"];
            }
            $_ips = $_POST["ips"];
            $macs = $_POST["macs"];
            $macs = array_filter($macs, "strlen");
            $ips = [];
            if(!empty($_ips)) {
                foreach ($_ips as $k => $ip) {
                    if($ip != "") {
                        $ips[$k] = ["ip" => trim($ip), "mac_addr" => trim($macs[$k])];
                    }
                }
            }
            if(!empty($firstip) || !empty($lastip)) {
                if(!valid_ip($firstip)) {
                    $error[] = $l["inv_startip"];
                }
                if(!valid_ip($lastip)) {
                    $error[] = $l["inv_endip"];
                }
                if(!empty($error)) {
                    return false;
                }
                $range = iprange($firstip, $lastip);
                if(empty($range)) {
                    $error[] = $l["invalid_range"];
                    return false;
                }
                foreach ($range as $k => $v) {
                    if($v == $globals["primary_ip"]) {
                        $error[] = $v . $l["error_primary_ip"];
                        return false;
                    }
                }
            } elseif(!empty($ips)) {
                foreach ($ips as $k => $ip) {
                    if(empty($ip["ip"])) {
                    } else {
                        if(!valid_ip($ip["ip"])) {
                            $error[] = $l["inv_ip"];
                        }
                        if($ip["ip"] == $globals["primary_ip"]) {
                            $error[] = $ip["ip"] . $l["error_primary_ip"];
                        } else {
                            $range[] = $ip["ip"];
                        }
                        if(empty($ip["mac_addr"])) {
                            $ip["mac_addr"] = NULL;
                        } elseif(!valid_mac($ip["mac_addr"])) {
                            $error[] = $l["inv_mac"];
                        }
                    }
                }
                if(!empty($error)) {
                    return false;
                }
            }
        } elseif(!checkbox("ipv6_subnet")) {
            $ipv6[1] = optPOST("ipv6_1");
            $ipv6[2] = optPOST("ipv6_2");
            $ipv6[3] = optPOST("ipv6_3");
            $ipv6[4] = optPOST("ipv6_4");
            $ipv6[5] = optPOST("ipv6_5");
            $ipv6[6] = optPOST("ipv6_6");
            if(empty($ipv6[1]) || empty($ipv6[2]) || empty($ipv6[3]) || empty($ipv6[4]) || empty($ipv6[5]) || empty($ipv6[6]) || !valid_ipv6(implode(":", $ipv6) . "::")) {
                $error[] = $l["inv_ipv6"];
            }
            $ipv6_num = (int) POST("ipv6_num", $l["no_ipv6_num"]);
            if(5000 < $ipv6_num) {
                $error[] = $l["ipv6_too_much"];
            }
            if(!empty($error)) {
                return false;
            }
            $range = ip6range(implode(":", $ipv6), $ipv6_num);
            if(empty($range)) {
                $error[] = $l["inv_ipv6"];
                return false;
            }
        }
        $is_group = 0;
        foreach ($serid as $sk => $sv) {
            $tmp = explode("_", $sv);
            if(1 < count($tmp)) {
                $is_group++;
            }
        }
        if(!empty($internal) && count($serid) == 1 && empty($is_group)) {
            $token_val = vsql_in_tokens(array_values($serid));
            $resid = makequery("SELECT ippid FROM ippool_servers\n\t\t\t\t\t\t\t\tWHERE sgid = :sgid\n\t\t\t\t\t\t\t\tOR serid IN ('-1', " . $token_val["query"] . ")", array_merge($token_val["tokens"], [":sgid" => $servers[$serid[0]]["sgid"]]));
            $ippid = [];
            for ($i = 0; $i < vsql_num_rows($resid); $i++) {
                $row = vsql_fetch_assoc($resid);
                $ippid[] = $row["ippid"];
            }
            $ippid_token = vsql_in_tokens($ippid, "ippid");
            $ip_serid_token = vsql_in_tokens(array_values($serid), "ip_serid");
            $range_token = vsql_in_tokens($range, "range");
            $res = makequery("SELECT DISTINCT i.ip, ip.internal FROM ips i\n\t\t\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\t\t\t\tWHERE (i.ippid IN (" . (count($ippid) < 1 ? -2 : $ippid_token["query"]) . ") \n\t\t\t\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, " . $ip_serid_token["query"] . ")))\n\t\t\t\t\t\t\t\tAND i.ip IN (" . $range_token["query"] . ")\n\t\t\t\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\t\t\t\tAND i.ipv6 = 0\n\t\t\t\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\t\t\t\tORDER BY i.ip\n\t\t\t\t\t\t\t\tLIMIT 0, 250", array_merge($ippid_token["tokens"], $ip_serid_token["tokens"], $range_token["tokens"]));
            $common = [];
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $common[] = $row["ip"];
            }
            if(!empty($common)) {
                $error[] = $l["ips_exist_same_ser"] . " : " . implode(", ", $common);
                return false;
            }
        } else {
            $ip_token = vsql_in_tokens($range);
            $qres = makequery("SELECT DISTINCT ip \n\t\t\t\t\t\t\tFROM ips \n\t\t\t\t\t\t\tWHERE ip IN (" . $ip_token["query"] . ")", $ip_token["tokens"]);
            $common = [];
            for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
                $row = vsql_fetch_assoc($qres);
                $common[] = $row["ip"];
            }
            if(!empty($common)) {
                $error[] = $l["ips_exist"] . " : " . implode(", ", $common);
                return false;
            }
        }
        $ippid = insert_and_id("INSERT INTO ippool \n\t\t\t\t\t\t\t\tSET ipp_serid = '0',\t\n\t\t\t\t\t\t\t\tippool_name = :ippool_name,\n\t\t\t\t\t\t\t\tgateway = :gateway,\n\t\t\t\t\t\t\t\tnetmask = :netmask,\n\t\t\t\t\t\t\t\tns1 = :ns1,\n\t\t\t\t\t\t\t\tns2 = :ns2,\n\t\t\t\t\t\t\t\tipv6 = :ipv6,\n\t\t\t\t\t\t\t\tnat = :nat,\n\t\t\t\t\t\t\t\trouting = :routing,\n\t\t\t\t\t\t\t\tinternal = :internal,\n\t\t\t\t\t\t\t\tbridge = :bridge,\n\t\t\t\t\t\t\t\tmtu = :mtu,\n\t\t\t\t\t\t\t\tuid = :uid,\n\t\t\t\t\t\t\t\tvlan_tag = :vlan_tag,\n\t\t\t\t\t\t\t\tvlan = :vlan,\n\t\t\t\t\t\t\t\tpdns_id = :pdns_id", [":ippool_name" => $ippool_name, ":gateway" => $gateway, ":netmask" => $netmask, ":ns1" => $ns1, ":ns2" => $ns2, ":ipv6" => $iptype == 4 ? 0 : 1, ":nat" => isset($_POST["nat"]) ? $firstip . "-" . $lastip : "0", ":routing" => $routing, ":internal" => $internal, ":bridge" => !empty($vlan_bridge) ? $vlan_bridge : $internal_bridge, ":mtu" => $mtu, ":uid" => $uid, ":vlan_tag" => $vlan_tag, ":vlan" => $vlan, ":pdns_id" => $pdns_id]);
        if(!empty($nat)) {
            $nat_name = "natbr" . $ippid;
            $qres = makequery("UPDATE ippool SET \n\t\t\t\t\t\t\t\tnat_name = :nat_name \n\t\t\t\t\t\t\t\tWHERE ippid = :ippid", [":nat_name" => $nat_name, ":ippid" => $ippid]);
        }
        if(empty($ippid)) {
            $error[] = $l["err_ippool"];
            return false;
        }
        $_range = [];
        foreach ($serid as $key => $value) {
            $servergp = explode("_", $value);
            $qres = insert_and_id("INSERT INTO ippool_servers\n\t\t\t\t\t\t\t\t\tSET ippid = :ippid,\n\t\t\t\t\t\t\t\t\tserid = :serid,\n\t\t\t\t\t\t\t\t\tsgid = :sgid", [":ippid" => $ippid, ":serid" => !empty($servergp[1]) ? "-2" : $servergp[0], ":sgid" => empty($servergp[1]) ? "-2" : $servergp[0]]);
        }
        foreach ($range as $k => $value) {
            $qres = insert_and_id("INSERT INTO ips\n\t\t\t\t\t\t  SET ippid = :ippid,\n\t\t\t\t\t\t  ip = :ip,\n\t\t\t\t\t\t  ipv6 = :ipv6,\n\t\t\t\t\t\t  mac_addr = :mac_addr", [":ippid" => $ippid, ":ip" => $value, ":ipv6" => $iptype == 4 ? 0 : 1, ":mac_addr" => trim($macs[$k])]);
            if(empty($qres)) {
                $error[] = $l["err_ip"] . " : " . $value;
                return false;
            }
            $_range[$qres] = $value;
        }
        if(!empty($nat)) {
            $ret = $cluster->createnat(current($serid), ["ippid" => $ippid, "gateway" => $gateway, "netmask" => $netmask, "firstip" => $firstip, "lastip" => $lastip, "nat_name" => $nat_name]);
            if(empty($ret)) {
                $error[] = $l["error_nat_create"];
                return false;
            }
        }
        logs_admin("addippool", $ippool_name, 1, $ippid, $user["uid"]);
        $done = [];
        $done["ippid"] = $ippid;
        $done["range"] = $_range;
        $done["done"] = 1;
        if($iptype == 6) {
            $done["ipv6_subnet"] = $ippid;
        }
    }
}
function API_addippool()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $cluster;
    global $error;
    global $done;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
}

?>