<?php
// ==========================
// تعریف پکیج‌ها
// ==========================
$packages = [
    1 => ['اکانت یک ماهه', 50000],   // ریال
    2 => ['اکانت سه ماهه', 4500000],
    3 => ['اکانت شش ماهه', 7500000],
    4 => ['اکانت یک ساله', 13000000],
];

// شناسایی پکیج انتخابی
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$show_form = isset($packages[$id]);

if ($show_form) {
    $title        = $packages[$id][0];
    $amount       = $packages[$id][1];          // مبلغ واقعی (ریال)
    $amount_toman = round($amount / 10);        // برای نمایش فقط
}

// ==========================
// ارسال POST برای درگاه PEC
// ==========================
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email  = trim($_POST["email"] ?? "");
    $mobile = trim($_POST["mobile"] ?? "");
    $pkg_id = intval($_POST["package_id"] ?? 0);

    // مسیر فایل کوکی
    $cookie_file = __DIR__ . "/cookies.txt";

    // بررسی وجود فایل و محتوای آن
    if (!file_exists($cookie_file)) {
        $result = ['status' => 'error', 'message' => 'فایل کوکی یافت نشد. لطفاً ابتدا کوکی‌ها را ثبت کنید.'];
    } else {
        $cookie_content = trim(file_get_contents($cookie_file));
        if ($cookie_content === '') {
            $result = ['status' => 'error', 'message' => 'فایل کوکی خالی است. لطفاً مجدداً کوکی‌ها را ذخیره کنید.'];
        }
    }

    // بررسی اعتبار پکیج و محتوای کوکی
    if (!isset($result) && !isset($packages[$pkg_id])) {
        $result = ['status' => 'error', 'message' => 'پکیج انتخاب شده معتبر نیست.'];
    } elseif (!isset($result) && empty($email) && empty($mobile)) {
        $result = ['status' => 'error', 'message' => 'حداقل یکی از فیلدهای ایمیل یا موبایل باید پر باشد.'];
    }

    // اگر تا اینجا خطا نداشتیم، ارسال درخواست به درگاه
    if (!isset($result)) {

        $amount = $packages[$pkg_id][1];
        $formatted_amount = number_format($amount, 0, '', ',');

        $url = "https://topup.pec.ir/Home/WalletCharge";

        $post_fields = http_build_query([
            "amount" => $formatted_amount,
            "customerwalletid" => "3899493",
            "mid" => "95727"
        ]);

        // اضافه کردن کوکی خوانده‌شده از فایل به هدر
        $headers = [
            "User-Agent: Mozilla/5.0",
            "Accept: application/json, text/javascript, */*; q=0.01",
            "Content-Type: application/x-www-form-urlencoded; charset=UTF-8",
            "X-Requested-With: XMLHttpRequest",
            "Origin: https://topup.pec.ir",
            "Connection: keep-alive",
            $cookie_content // 👈 این خط فایل کوکی را مستقیماً به عنوان هدر وارد می‌کند
        ];

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post_fields,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "gzip,deflate,br",
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 20
        ]);

        $response = curl_exec($ch);
        $curl_err = curl_error($ch);
        curl_close($ch);

        if ($curl_err) {
            $result = ['status' => 'error', 'message' => "خطا در ارتباط با درگاه: $curl_err"];
        } else {
            $json = json_decode($response, true);
            if (isset($json["url"])) {
                // ✅ انتقال به درگاه
                $redirect_url = htmlspecialchars($json["url"], ENT_QUOTES, 'UTF-8');
                echo <<<HTML
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>در حال انتقال...</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@v30.1.0/dist/font-face.css" rel="stylesheet">
<style>
body{font-family: Vazir,Tahoma,sans-serif;background:#fff;text-align:center;padding-top:120px;}
.spinner{width:70px;height:70px;border:6px solid #ccc;border-top-color:#0d6efd;border-radius:50%;margin:auto;animation:spin 1s linear infinite;}
@keyframes spin{100%{transform:rotate(360deg);}}
p{margin-top:30px;font-size:18px;}
</style>
</head>
<body>
<div class="spinner"></div>
<p class="text-secondary">در حال ارسال اطلاعات به درگاه پرداخت...</p>
<script>
setTimeout(function(){window.location.href="$redirect_url";},3000);
</script>
</body>
</html>
HTML;
                exit;
            } else {
                $result = ['status' => 'error', 'message' => "پاسخ نامعتبر از سرور درگاه:\n" . htmlspecialchars($response)];
            }
        }
    }
}
?>












<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazir-font@v30.1.0/dist/font-face.css" rel="stylesheet">
    <style>
        body, button, input, .card { font-family: Vazir, Tahoma, Arial, sans-serif !important; }
        body { background: #f8f9fa; }
        .card { max-width: 450px; margin: auto; }
    </style>
    <title>پرداخت و دریافت سرویس</title>
</head>
<body>
<div class="container mt-5">
    <div class="card shadow-sm">
        <?php if ($show_form): ?>
        <div class="card-header bg-primary text-white">
            پرداخت و دریافت سرویس
        </div>
        <?php endif; ?>
        <div class="card-body">
            <?php if (isset($result) && $result['status'] == 'error'): ?>
                <div class="alert alert-danger"><?php echo nl2br(htmlspecialchars($result['message'])); ?></div>
            <?php endif; ?>

            <?php if ($show_form): ?>
            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">نام سرویس :</label>
                    <div class="form-control bg-light"><?php echo htmlspecialchars($title); ?></div>
                </div>
                <div class="mb-3">
                    <label class="form-label">مبلغ سرویس :</label>
                    <div class="form-control bg-light"><?php echo number_format($amount_toman); ?> تومان</div>
                    <input type="hidden" name="amount" value="<?php echo $amount; ?>">
                    <input type="hidden" name="package_id" value="<?php echo $id; ?>">
                </div>
                <div class="mb-3 p-3 border rounded bg-light" style="font-size: 15px;">
                    <div><span style="color:green;">✅</span> قابلیت استفاده در همه سیستم عامل ها</div>
                    <div><span style="color:green;">✅</span> پرداخت آنلاین و تحویل فوری</div>
                    <div><span style="color:green;">✅</span> سرور های اختصاصی</div>
                    <div><span style="color:green;">✅</span> حجم نامحدود واقعی</div>
                    <div><span style="color:green;">✅</span> بدون قطعی</div>
                    <div><span style="color:green;">✅</span> چهار کاربره</div>
                </div>
                <div class="mb-3">
                    <label class="form-label">ایمیل :</label>
                    <input type="email" class="form-control" name="email" placeholder="ایمیل خود را وارد کنید">
                </div>
                <div class="mb-3">
                    <label class="form-label">شماره موبایل :</label>
                    <input type="text" class="form-control" name="mobile" placeholder="شماره موبایل خود را وارد کنید">
                </div>
                <button type="submit" class="btn btn-success w-100">پرداخت</button>
                <br><br>
                <div class="alert alert-primary" role="alert">
                    در صورتی که پرداختی داشتید برای دریافت سرویس لطفا از پشتیبانی گوشه سایت به ما اطلاع بدید  
                </div>
                <a href="https://www.goftino.com/c/kHuPi0" target="_blank" class="btn btn-primary btn-lg">پشتیبانی آنلاین</a>
                <a href="https://t.me/prox_net" target="_blank" class="btn btn-secondary btn-lg">پشتیبانی تلگرام</a>
            </form>
            <?php else: ?>
            <div class="alert alert-danger text-center mt-3">
                پکیج انتخاب شده معتبر نیست.
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<br><br><br><br><br><br>








<script>
document.getElementById('submitPayment').addEventListener('click', function() {
    var btn = this;
    btn.textContent = "در حال انتقال ...";
    btn.disabled = true;
    btn.form.submit();
});
window.addEventListener('pageshow', function(event) {
    var btn = document.getElementById('submitPayment');
    if (btn) {
        btn.textContent = "پرداخت";
        btn.disabled = false;
    }
});
</script>













<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css">

<div class="container">
  <div class="modal fade" id="myModal" style="top:15%;padding:0px" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true" dir="rtl">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" style="float:left" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <p class="fs-3 text-success"><strong>قابل توجه کاربران عزیز</strong></p>
          <p>در تاریخ <span dir="ltr"><?php echo date("Y/m/d"); ?></span> همه سرورها فعال و در دسترس میباشند.</p>
          <p style="color:red">لطفا برای ادامه فرایند خرید و ورود به درگاه بانکی حتما فیلترشکن خود را خاموش کنید.</p>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-warning" data-bs-dismiss="modal">متوجه شدم</button>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script type="text/javascript">
  setTimeout(function() {
    var myModal = new bootstrap.Modal(document.getElementById('myModal'), {
      backdrop: 'static'
    });
    myModal.show();
  }, 1500);
</script>















<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script type="text/javascript">
(function() {
  var encodedUrl = "aHR0cHM6Ly93d3cuZ29mdGluby5jb20vd2lkZ2V0Lw=="; 
  var encodedId  = "a0h1UGkw";

  var baseUrl = atob(encodedUrl);
  var goftinoId = atob(encodedId);

  var w = window, d = document;

  function loadGoftino() {
    var script = d.createElement("script");
    var localKey = localStorage.getItem("goftino_" + goftinoId);
    script.async = true;
    script.src = localKey ? baseUrl + goftinoId + "?o=" + localKey : baseUrl + goftinoId;
    d.getElementsByTagName("head")[0].appendChild(script);
  }

  if (d.readyState === "complete") {
    loadGoftino();
  } else if (w.attachEvent) {
    w.attachEvent("onload", loadGoftino);
  } else {
    w.addEventListener("load", loadGoftino, false);
  }
})();
</script>



</body>
</html>