<?php
// دریافت پارامترها
$serverAddress = isset($_GET['serverAddress']) ? $_GET['serverAddress'] : '';
$serverUser    = isset($_GET['serverUser']) ? $_GET['serverUser'] : '';
$serverPass    = isset($_GET['serverPass']) ? $_GET['serverPass'] : '';

if (!$serverAddress || !$serverUser || !$serverPass) {
    echo json_encode(['success' => false, 'message' => 'Missing required parameters.']);
    exit;
}

// آدرس‌ها
$loginUrl  = rtrim($serverAddress, '/') . '/login';
$backupUrl = rtrim($serverAddress, '/') . '/server/getDb';

// مرحله 1: لاگین
$loginData = [
    'username' => $serverUser,
    'password' => $serverPass,
];

$cookieFile = __DIR__ . '/cookies.txt';

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $loginUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($loginData));
curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile); // ذخیره کوکی
$response = curl_exec($ch);
curl_close($ch);

// بررسی نتیجه لاگین
$loginResponse = json_decode($response, true);
if (empty($loginResponse['success']) || $loginResponse['success'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Login failed.']);
    exit;
}

// مرحله 2: دانلود بک‌آپ
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $backupUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile); // استفاده از کوکی سشن
$backupData = curl_exec($ch);
$httpCode   = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode == 200 && !empty($backupData)) {
    // ذخیره بک‌آپ روی سرور
    $fileName = __DIR__ . '/backup_' . date('Ymd_His') . '.tar';
    file_put_contents($fileName, $backupData);

    echo json_encode([
        'success'  => true,
        'message'  => 'Backup downloaded successfully.',
        'file'     => basename($fileName)
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Backup download failed.']);
}
?>
