<?php
include 'inc/validation.php';
include 'inc/xss-clean.php';
include 'inc/forms.php';
include 'inc/functions.php';

define('auth_website_domain','mrperfumestore.com');

add_action('wp_head','tiyara_auth_wp_head');
function tiyara_auth_wp_head(){
    if(isset($_SESSION['tiyara_auth'])){
        unset($_SESSION['tiyara_auth']);
    }
}

add_action('wp_enqueue_scripts','tiyara_auth_wp_enqueue_scripts');
function tiyara_auth_wp_enqueue_scripts(){
    wp_enqueue_script('jquery.validate', get_template_directory_uri() . '/woocommerce-auth/assets/jquery.validate.min.js', array('jquery'), '1.0.0', true);
    wp_enqueue_script('tiyara_auth-user', get_template_directory_uri() . '/woocommerce-auth/assets/user.js', array('jquery'), '1.0.0', true);
    wp_localize_script('tiyara_auth-user', 'auth_user_dyn_data',
        array(
            'admin_ajax'  =>  admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('auth_nonce'),
        )
    );
}

function tiyara_auth_send_sms($mobile,$template,$token1,$token2=null,$token3=null,$token10=null,$token20=null) {
	$api = get_field('auth_sms_api', 'option');
	$url = 'https://api.kavenegar.com/v1/'.$api.'/verify/lookup.json?receptor='.$mobile.'&template='.$template.'&token='.urlencode($token1).'&token2='.urlencode($token2).'&token3='.urlencode($token3).'&token10='.urlencode($token10).'&token20='.urlencode($token20);

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	$output = curl_exec($ch);
	curl_close($ch);
}

function tiyara_auth_generate_random_password(){
    $string = '0123456789';
    $generated_password = substr(str_shuffle($string), 0, 6);
    return $generated_password;
}

add_filter('woocommerce_save_account_details_required_fields','tiyara_auth_save_account_details_required_fields');
function tiyara_auth_save_account_details_required_fields($required_fields){
    unset($required_fields['account_email']);
    unset($required_fields['account_display_name']);
    return $required_fields;
}

add_action('woocommerce_save_account_details_errors','tiyara_auth_woocommerce_save_account_details_errors', 10, 1);
function tiyara_auth_woocommerce_save_account_details_errors($validation_errors){
    $user = get_user_by('ID',get_current_user_id());
    $current_user_email = $user->data->user_email;
    $current_user_display_name = $user->data->display_name;

    if(empty($_POST['account_email'])){
        $validation_errors->add('auth-error-1', 'خطایی رخ داده است، لطفا بعدا تلاش نمایید');
    }elseif(!is_email($_POST['account_email'])){
        $validation_errors->add('auth-error-2', 'خطایی رخ داده است، لطفا بعدا تلاش نمایید');
    }elseif($_POST['account_email'] != $current_user_email){
        $validation_errors->add('auth-error-3', 'خطایی رخ داده است، لطفا بعدا تلاش نمایید');
    }

    if(empty($_POST['account_display_name'])){
        $validation_errors->add('auth-error-4', 'خطایی رخ داده است، لطفا بعدا تلاش نمایید');
    }elseif($_POST['account_display_name'] != $current_user_display_name){
        $validation_errors->add('auth-error-5', 'خطایی رخ داده است، لطفا بعدا تلاش نمایید');
    }

    if($_POST['password_current'] != '' or $_POST['password_1'] != '' or $_POST['password_2'] != ''){
        $validation_errors->add('auth-error-6', 'خطایی رخ داده است، لطفا بعدا تلاش نمایید');
    }
}

add_action('template_redirect','tiyara_auth_template_redirect');
function tiyara_auth_template_redirect(){
    if(is_account_page() and !is_user_logged_in()){
        wp_redirect(home_url('/'));
        exit;
    }
}

function tiyara_auth_woocommerce_admin_settings(){
    if(get_option('tiyara_auth_admin_config_status') != 'yes'){
        $actions = array('new_order','cancelled_order','failed_order','customer_on_hold_order','customer_processing_order','customer_completed_order','customer_refunded_order','customer_note','customer_reset_password','customer_new_account');
        foreach($actions as $action){
            $option = 'woocommerce_'.esc_attr($action).'_settings';
            $email_settings = get_option(esc_attr($option));
            if(!is_array($email_settings)){
                $email_settings = array();
            }
            $email_settings['enabled'] = 'no';
            update_option(esc_attr($option),$email_settings);
        }

        update_option('woocommerce_enable_guest_checkout','no');
        update_option('woocommerce_enable_checkout_login_reminder','no');
        update_option('woocommerce_enable_signup_and_login_from_checkout','no');

        update_option('tiyara_auth_admin_config_status','yes');
    }
}

add_filter('woocommerce_settings_tabs_array','tiyara_auth_woocommerce_remove_extra_settings_tabs',1000,1);
function tiyara_auth_woocommerce_remove_extra_settings_tabs($tabs_array){
//    unset($tabs_array['email']);
    unset($tabs_array['account']);
    return $tabs_array;
}

function tiyara_mobile_number_validation($mobile){
    if(strlen($mobile) == '11'){
        if(is_numeric($mobile)){
            if(preg_match( '/^09[0-9]{9}$/', $mobile )){
                return true;
            }else{
                return false;
            }
        }else{
            return false;
        }
    }else{
        return false;
    }
}

function tiyara_national_code_validation( $code ) {
    if ( ! preg_match( '/^[0-9]{10}$/', $code ) ) {
        return false;
    }
    for ( $i = 0; $i < 10; $i ++ ) {
        if ( preg_match( '/^' . $i . '{10}$/', $code ) ) {
            return false;
        }
    }
    for ( $i = 0, $sum = 0; $i < 9; $i ++ ) {
        $sum += ( ( 10 - $i ) * intval( substr( $code, $i, 1 ) ) );
    }
    $ret    = $sum % 11;
    $parity = intval( substr( $code, 9, 1 ) );
    if ( ( $ret < 2 && $ret == $parity ) || ( $ret >= 2 && $ret == 11 - $parity ) ) {
        return true;
    }

    return false;
}

function tiyara_auth_gender_translator($gender){
    $gender_str = ' - ';
    if($gender == 'male'){
        $gender_str = 'آقا';
    }elseif($gender == 'female'){
        $gender_str = 'خانم';
    }
    return $gender_str;
}


add_filter('manage_users_columns', 'tiyara_auth_manage_users_columns');
function tiyara_auth_manage_users_columns($columns){
    $columns['gender'] = 'جنسیت';
    return $columns;

}

add_filter('manage_users_custom_column','tiyara_auth_manage_users_custom_column',10,3);
function tiyara_auth_manage_users_custom_column($row_output, $column_id_attr, $user){
    $gender = get_user_meta(esc_attr($user),'gender',true);

    switch($column_id_attr){
        case 'gender' :
            return esc_html(tiyara_auth_gender_translator($gender));
            break;
    }

    return $row_output;
}
