jQuery(function() {  
   jQuery(".persiandatepicker input[type='text']").persianDatepicker();

	let loading_text = 'در حال ارسال اطلاعات ...';
	let date_required = 'لطفا تاریخ را انتخاب نمایید'; 
	let admin_ajax = wr_script_dyn_data.admin_ajax;  
		
    if(jQuery("body").hasClass("woocommerce_page_tiyara-wr-settings")){ 
        jQuery("#volume-report-form").validate({
            rules:{
                start_date: "required", 
                end_date: "required", 
            },

            messages:{
                start_date: date_required, 
                end_date: date_required, 
            },
            submitHandler: function(form){
                dataString = jQuery("#volume-report-form").serialize();
				let volume_report_submit_btn = jQuery("#volume-report-form button.btn");

                jQuery.ajax({
                    type : "post",
                    dataType: 'json',
                    data: dataString,
                    url : admin_ajax,
                    beforeSend : function(){
						volume_report_submit_btn.prop("disabled", true);
						jQuery('.report-result').fadeOut('slow', function(){ jQuery('.report-result').remove(); });
						setTimeout(function(){
							jQuery(".volume-report-wrapper").append('<div class="alert text-primary">'+loading_text+'</div>');
							$alert = jQuery(".volume-report-wrapper").find('.alert');
						}, 700);
					},
					success:function(response){
						if(response.status == 0){
							$alert.removeClass('text-danger text-success text-primary');
							$alert.addClass('text-danger');
							$alert.text(response.msg);
							setTimeout(function(){ $alert.fadeOut('slow', function(){ $alert.remove(); volume_report_submit_btn.prop("disabled", false); }); }, 2000);
						}
						if(response.status == 1){
							$alert.removeClass('text-danger text-success text-primary');
							$alert.addClass('text-success');
							$alert.text(response.msg);
							setTimeout(function(){ $alert.fadeOut('slow', function(){ $alert.remove(); volume_report_submit_btn.prop("disabled", false); }); }, 2000);

							if(response.data){
								let content = '';
									content =  '<div class="report-result">'; 
										content += '<p class="table-desc">از تاریخ <b>' + jQuery('#volume-report-form #start_date').val() + '</b> تا تاریخ <b>' + jQuery('#volume-report-form #end_date').val() + '</b> تعداد <b>' + response.data.extra.order_count + '</b> سفارش مورد بررسی قرار گرفت</p>';
										content += '<table class="table table-bordered">';
											content += '<thead>';
												content += '<tr>';
													content += '<th scope="col">عنوان</th>';
													content += '<th scope="col">تعداد (عدد)</th>';
													content += '<th scope="col">مبلغ (تومان)</th>';
												content += '</tr>';
											content += '</thead>';
											content += '<tbody>';
												jQuery.each(response.data.items,function(index,value){
												content += '<tr>';
													content += '<td>'+value.name+'</td>'; 
													content += '<td>'+value.total_quantity.toLocaleString('en-US')+'</td>'; 
													content += '<td>'+value.total_price.toLocaleString('en-US')+'</td>'; 
												content += '</tr>';
												}); 
											content += '</tbody>'; 
											content += '<tfoot>';
											jQuery.each(response.data.total,function(index,value){
												content += '<tr>';
													content += '<td>'+value.name+'</td>'; 
													content += '<td>'+value.total_quantity.toLocaleString('en-US')+'</td>'; 
													content += '<td>'+value.total_price.toLocaleString('en-US')+'</td>'; 
												content += '</tr>';
												});
											content += '</tfoot>';	
										content += '</table>'; 
								content += '</div>';
								setTimeout(function(){
									jQuery(content).hide().insertAfter('.volume-report-wrapper').fadeIn();
								}, 3000);
							}
						}
					},
					error:function(){
						$alert.removeClass('text-danger text-success text-primary');
						$alert.addClass('text-danger');
						$alert.text('خطا رخ داده است');
						setTimeout(function(){ $alert.fadeOut('slow', function(){ $alert.remove(); volume_report_submit_btn.prop("disabled", false); }); }, 2000);
					}
                })
            }
        });
    }
});