<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined('ABSPATH') || exit;

get_header('shop');

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action('woocommerce_before_main_content');

$cur_term_id = get_queried_object_id();
if (is_product_taxonomy()) {
    $shop_image_url = get_field('procat_image', 'product_cat_' . $cur_term_id);
} else if (is_shop()) {
    $page_id = is_shop() ? woocommerce_get_page_id('shop') : '';
    $shop_image_url = wp_get_attachment_url(get_post_thumbnail_id($page_id));
}
?>

    <div class="container">
    <div class="row">
<?php
echo '<div class="col-12 col-lg-3 order-first sidebar-shop">';
/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
do_action('woocommerce_sidebar');
echo '</div>';
?>
    <div class="col-12 col-lg-9 order-last position-relative">

    <div class="page-header-wrap">
<!--        <div class="container">-->
            <div class="row page-header">
                <header class="col-12 woocommerce-products-header">
                    <div class="shop-page-header--inner text-start">
                        <?php get_template_part('templates/content/breadcrumb'); ?>
                        <div class="shop-page-header--title">
                            <?php if (apply_filters('woocommerce_show_page_title', true)) : ?>
                                <h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
                            <?php endif; ?>
                            <?php
                            /**
                             * Hook: woocommerce_archive_description.
                             *
                             * @hooked woocommerce_taxonomy_archive_description - 10
                             * @hooked woocommerce_product_archive_description - 10
                             */
                            do_action('woocommerce_archive_description');
                            ?>
                        </div>
                    </div>
                </header>
            </div>
<!--        </div>-->
    </div>


        <div class="product-results--filter d-block d-lg-none">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"
                 stroke="currentColor" stroke-width="1.3" stroke-linecap="round" stroke-linejoin="round"
                 class="feather feather-sliders">
                <line x1="4" y1="21" x2="4" y2="14"></line>
                <line x1="4" y1="10" x2="4" y2="3"></line>
                <line x1="12" y1="21" x2="12" y2="12"></line>
                <line x1="12" y1="8" x2="12" y2="3"></line>
                <line x1="20" y1="21" x2="20" y2="16"></line>
                <line x1="20" y1="12" x2="20" y2="3"></line>
                <line x1="1" y1="14" x2="7" y2="14"></line>
                <line x1="9" y1="8" x2="15" y2="8"></line>
                <line x1="17" y1="16" x2="23" y2="16"></line>
            </svg>
            <span>فیلتر محصولات</span>
        </div>
        <div class="site-post-archive">
<?php
if (woocommerce_product_loop()) {

    /**
     * Hook: woocommerce_before_shop_loop.
     *
     * @hooked woocommerce_output_all_notices - 10
     * @hooked woocommerce_result_count - 20
     * @hooked woocommerce_catalog_ordering - 30
     */
    do_action('woocommerce_before_shop_loop');


    if ((is_active_sidebar('sidebar-active-filter')) != '') :
        add_clear_filters();
        dynamic_sidebar('sidebar-active-filter');
    endif;

    woocommerce_product_loop_start();

    if (wc_get_loop_prop('total')) {
        while (have_posts()) {
            the_post();

            /**
             * Hook: woocommerce_shop_loop.
             */
            do_action('woocommerce_shop_loop');
            echo '<div class="col-6 col-md-4">';
            wc_get_template_part('content', 'product');
            echo '</div>';
        }
    }

    woocommerce_product_loop_end();

    /**
     * Hook: woocommerce_after_shop_loop.
     *
     * @hooked woocommerce_pagination - 10
     */
    do_action('woocommerce_after_shop_loop');
} else {
    /**
     * Hook: woocommerce_no_products_found.
     *
     * @hooked wc_no_products_found - 10
     */
    do_action('woocommerce_no_products_found');
}

/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action('woocommerce_after_main_content');
echo '</div></div></div>';


get_footer('shop');
