<?php
get_header();
$paged = (get_query_var('paged')) ? get_query_var('paged') : ((get_query_var('page')) ? get_query_var('page') : 1);
global $wp_query;
$cat_id = $wp_query->get_queried_object_id();
?>
<div class="page-wrap category-blog">
    <div class="page-header-wrap">
        <div class="container">
            <div class="row page-header">
                <div class="col-12">
                    <?php get_template_part('templates/content/breadcrumb'); ?>
                    <h1 class="entry-title wow fadeInUp" data-wow-delay="0.25s">
                        <?php echo single_cat_title(); ?>
                    </h1>
                    <?php if (category_description() != '') { ?>
                        <div class="entry-description wow fadeInUp" data-wow-delay="0.5s">
                            <?php echo category_description(); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="container">

        <div class="row">

            <div class="col-12 col-lg-9 order-first order-lg-last">
                <div class="site-post-archive">
                    <div class="row">

                        <?php
                        $args = array(
                            'post_type' => 'post',
                            'paged' => $paged,
                            'post_status ' => 'publish',
                            'cat' => $cat_id,
                        );
                        $posts = new WP_Query($args);
                        if ($posts->have_posts()):
                            $i = 0.25;
                            while ($posts->have_posts()) : $posts->the_post();
                                ?>
                                <div class="col-12 col-sm-6 col-md-4 mb-3 wow fadeInUp" data-wow-delay="<?php echo $i; ?>s">
                                    <article
                                            class="blog-post"
                                            itemscope="itemscope" itemtype="http://schema.org/Article">
                                        <?php if (has_post_thumbnail()) { ?>
                                            <a href="<?php echo get_permalink(); ?>">
                                                <figure class="entry-media ratio ratio-1x1">
                                                    <?php
                                                    the_post_thumbnail('medium');
                                                    ?>
                                                </figure>
                                            </a>
                                        <?php } ?>

                                            <div class="entry-wrapper">

                                                <div class="entry-meta top">
                                                    <span class="meta-item entry-published d-block" itemprop="datePublished">
                                                        <?php echo get_the_date('j F Y'); ?>
                                                    </span>
                                                    <div class="category">
                                                        <?php the_category(' ، ', ' '); ?>
                                                    </div>
                                                </div>

                                                <h3 class="entry-title">
                                                    <a href="<?php echo get_permalink(); ?>"><?php echo get_the_title(); ?></a>
                                                </h3>

                                                <div class="entry-content">
                                                    <a class="button read-more" href="<?php echo get_permalink(); ?>">ادامه مطلب</a>
                                                </div>

                                            </div>
                                    </article>
                                </div>
                                <?php
                                $i += 0.25; endwhile;
                        endif;
                        wp_reset_postdata();
                        ?>


                        <div class="col col-12">
                            <div class="site-pagination">
                                <?php pagination_bar($posts); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-3 order-last order-lg-first">
                <?php get_sidebar(); ?>
            </div>
        </div>

    </div>
</div>
<?php get_footer(); ?>
