<?php
if ( ! isset( $_GET['ticket_id'] ) || ! ctype_digit( $_GET['ticket_id'] ) ) {
	return;
}

$ticket_id = $_GET['ticket_id'];
$ticket    = get_post( $ticket_id );
$author    = $ticket->post_author;
$terms     = wp_get_post_terms( $ticket_id, 'ticket-type' );
$term      = null;
if ( count( $terms ) ) {
	$term = $terms[0]->term_id;
}

$status     = $ticket->post_status;
$product_id = get_post_meta( $ticket_id, '_wast_ticket_product_id', true );
$ath_file   = get_post_meta( $ticket_id, '_wast_ticket_ath_file', true );

if ( wast_get_dokan_dashboard_page() == get_the_ID() ) {
	$seller_products = wast_get_seller_products( get_current_user_id() );
	if ( get_current_user_id() == $ticket->post_author || ( in_array( $product_id, $seller_products ) && $term == wast_get_option( 'dokan-ticket-type' ) ) ) {
		// nothing
	} else {
		exit();
	}
} else {
	if ( get_current_user_id() != $ticket->post_author ) {
		exit();
	}
}
?>
<div class="wast-wrapper">
    <h3 class="wast-title wast-clearfix">
        <span>ارسال پاسخ تیکت</span>
        <a href="<?php echo remove_query_arg( array( 'action',
			'ticket_id' ) ); ?>" class="wast-btn wast-btn-secondary wast-btn-sm wast-float-left">مشاهده همه تیکت‌ها</a>
    </h3>
    <hr class="wast-hr">
    <form method="post" enctype="multipart/form-data">
		<?php WAST_Flash_Message::show_message(); ?>
        <input type="hidden" name="ticket-id" value="<?php echo esc_attr( $ticket_id ); ?>">
        <input type="hidden" name="product-id" value="<?php echo esc_attr( $product_id ); ?>">
        <div class="wast-row">
            <div class="wast-col-12 wast-form-group">
                <label for="ticket-content" class="wast-label">متن تیکت را وارد نمایید:</label>
				<?php
				if ( wast_get_option( 'wp-editor' ) ) {
					wp_editor( '', 'ticket-content', array( 'textarea_rows' => 10 ) );
				} else {
					echo '<textarea class="wast-form-control" name="ticket-content" id="ticket-content" rows="10"></textarea>';
				}
				?>
            </div>
        </div>
		<?php if ( wast_get_option( 'active-upload' ) ): ?>
            <div class="wast-row">
                <div class="wast-col-12 wast-form-group">
                    <div class="wast-custom-file">
                        <input type="file" class="wast-custom-file-input" id="ticket-file" name="ticket-file">
                        <label class="wast-custom-file-label" for="ticket-file">فایل ضمیمه را انتخاب کنید.</label>
                    </div>
					<?php if ( wast_get_option( 'file-ext' ) ): ?>
                        <div class="wast-text-muted">فرمت‌های مجاز:
                            <bdi dir="ltr">.<?php echo str_replace( ',', ', .', wast_get_option( 'file-ext' ) ); ?></bdi>
                        </div>
					<?php endif; ?>
					<?php if ( wast_get_option( 'file-max-size' ) ): ?>
                        <div class="wast-text-muted">حداکثر حجم مجاز: <?php echo wast_get_option( 'file-max-size' ); ?> مگابایت</div>
					<?php endif; ?>
                </div>
            </div>
		<?php endif; ?>
        <div class="wast-row">
            <div class="wast-col-12 wast-form-group wast-form-check">
                <input type="checkbox" class="wast-form-check-input" id="status-closed" name="status-closed">
                <label class="wast-form-check-label" for="status-closed">بستن تیکت</label>
            </div>
        </div>
        <div class="wast-row">
            <div class="wast-col-12 wast-form-group">
				<?php wp_nonce_field( 'wast_reply_ticket', 'wast_reply_ticket_field' ); ?>
                <input type="submit" name="submit-reply-ticket" class="wast-btn wast-btn-success" value="ارسال پاسخ">
            </div>
        </div>
    </form>
    <div class="wast-start-ticket wast-card">
        <div class="wast-card-body">
            <h3 class="wast-card-title wast-title">
				<?php echo '<bdi class="wast-text-muted" dir="ltr">#' . $ticket_id . '</bdi> '; ?>
				<?php echo $ticket->post_title; ?>
            </h3>
            <p>
                <strong>محصول: </strong>
				<?php
				if ( is_numeric( $product_id ) ) {
					echo '<a href="' . get_the_permalink( $product_id ) . '" target="_blank">' . get_the_title( $product_id ) . '</a>';

					if ( $author == get_current_user_id() ) {
						if ( wast_get_option( 'wc-support' ) && wast_get_option( 'expiration-time' ) == 'limilted' ) {
							if ( ! wast_is_customer_bought_product( $product_id ) ) {
								echo ' <small class="wast-expired">(اتمام پشتیبانی)</small>';
							} else {
								$product_exp_time = wast_get_exp_time( $product_id );
								if ( $product_exp_time && $author == get_current_user_id() ) {
									echo ' <time class="wast-exp-date wast-text-muted" dir="ltr">(اتمام پشتیبانی: ' . date_i18n( 'Y/m/d', $product_exp_time ) . ')</time>';
								}
							}
						}
					}
				} else {
					echo $product_id;
				}

				if ( $ath_file ) {
					echo '<a href="' . esc_url( $ath_file ) . '" class="wast-ath-file wast-float-left" title="فایل ضمیمه" target="_blank"><img src="' . WAST_IMG_URL . 'paperclip-gray.png" alt="فایل"></a>';
				}
				?>
            </p>
            <hr class="wast-hr">
            <div class="wast-row">
                <div class="wast-col-12 wast-col-md-3">
                    <div>
                        <strong>وضعیت: </strong>
                        <br>
						<?php
						foreach ( wast_get_ticket_statuses() as $key => $value ) {
							if ( $status == $key ) {
								echo '<span class="wast-badge wast-badge-' . $key . '">' . $value . '</span>';
								break;
							}
						}
						?>
                    </div>
                </div>
                <div class="wast-col-12 wast-col-md-3">
                    <div>
                        <strong>اولویت: </strong>
                        <br>
						<?php
						$priority = get_post_meta( $ticket_id, '_wast_ticket_priority', true );
						echo '<span class="wast-text-muted">';
						switch ( $priority ) {
							case 'low':
								echo 'کم';
								break;
							default:
							case 'medium':
								echo 'متوسط';
								break;
							case 'high':
								echo 'زیاد';
								break;
						}
						echo '</span>';
						?>
                    </div>
                </div>
                <div class="wast-col-12 wast-col-md-3">
                    <div>
                        <strong>بخش: </strong>
                        <br>
						<?php
						$terms = wp_get_post_terms( $ticket_id, 'ticket-type' );
						if ( $terms && is_array( $terms ) ) {
							if ( isset( $terms[0]->name ) ) {
								echo '<span class="wast-text-muted">' . $terms[0]->name . '</span>';
							}
						}
						?>
                    </div>
                </div>
                <div class="wast-col-12 wast-col-md-3">
                    <div>
                        <strong>تاریخ ارسال: </strong>
                        <br>
                        <time class="wast-text-muted" dir="ltr">
							<?php echo date_i18n( 'Y/m/d H:i', get_the_time( 'U', $ticket->post_date ) ); ?>
                        </time>
                    </div>
                </div>
            </div>
            <hr class="wast-hr">
            <div class="wast-text-justify"><?php echo apply_filters( 'the_content', $ticket->post_content ); ?></div>
        </div>
    </div>
	<?php
	$replies = wast_get_ticket_replies( $ticket_id );

	// Sort replies by date
	wast_aasort( $replies, "date" );

	if ( wast_get_option( 'ticket-order' ) == 'desc' ) {
		$replies = array_reverse( $replies );
	}

	if ( sizeof( $replies ) ) {
		foreach ( $replies as $reply ) {
			if ( ! is_array( $reply ) ) {
				continue;
			}

			if ( array_key_exists( 'content', $reply ) ) {
				if ( ! $reply['content'] ) {
					continue;
				}
			} else {
				continue;
			}
			?>
            <div class="wast-reply-item wast-card">
                <header class="wast-card-header wast-clearfix">
					<?php
					$author_id = $reply['author_id'];
					$user_info = get_userdata( $author_id );
					echo '<strong>' . $user_info->display_name . '</strong>';

					if ( array_key_exists( 'ath_file', $reply ) ) {
						echo '<a href="' . esc_url( $reply['ath_file'] ) . '" class="wast-ath-file wast-float-left" title="فایل ضمیمه" target="_blank"><img src="' . WAST_IMG_URL . 'paperclip.png" alt="فایل"></a>';
					}
					?>
                    <time class="wast-float-left" dir="ltr"><?php echo date_i18n( 'Y/m/d - H:i', $reply['date'] ); ?></time>
                </header>
                <div class="wast-card-body">
					<?php
					if ( user_can( $author_id, 'delete_others_pages' ) ) {
						echo wast_get_option( 'header-text' ) ? '<strong>' . nl2br( wast_get_option( 'header-text' ) ) . '</strong>' : '';
					}
					?>
                    <div class="wast-text-justify"><?php echo apply_filters( 'the_content', $reply['content'] ); ?></div>
					<?php
					if ( user_can( $author_id, 'delete_others_pages' ) ) {
						echo wast_get_option( 'footer-text' ) ? '<strong>' . nl2br( wast_get_option( 'footer-text' ) ) . '</strong>' : '';
					}
					?>
                </div>
            </div>
			<?php
		}
	}
	?>
</div>