<div class="wast-wrapper">
    <h3 class="wast-title wast-clearfix">
        <span>ارسال تیکت جدید</span>
        <a href="<?php echo remove_query_arg( array( 'action' ) ); ?>" class="wast-btn wast-btn-secondary wast-btn-sm wast-float-left">مشاهده همه تیکت‌ها</a>
    </h3>
    <hr class="wast-hr">
	<?php
	if ( wast_get_option( 'help-info' ) ) {
		echo '<div class="wast-help-info">' . nl2br( esc_html( wast_get_option( 'help-info' ) ) ) . '</div>';
	}
	?>
    <form method="post" enctype="multipart/form-data">
		<?php WAST_Flash_Message::show_message(); ?>
        <div class="wast-row">
            <div class="wast-col-12 wast-col-lg-6 wast-form-group">
                <label for="ticket-title" class="wast-label">عنوان تیکت را وارد نمایید:</label>
                <input type="text" class="wast-form-control" name="ticket-title" id="ticket-title">
            </div>
            <div class="wast-col-12 wast-col-lg-6 wast-form-group">
                <label for="ticket-type" class="wast-label">بخش مربوطه را انتخاب نمایید:</label>
                <select class="wast-custom-select" name="ticket-type" id="ticket-type">
                    <option value="">لطفا انتخاب کنید.</option>
					<?php
					$terms = get_terms( 'ticket-type', array( 'hide_empty' => 0 ) );
					if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
						foreach ( $terms as $term ) {
							$term_list .= '<option value="' . $term->term_id . '">' . $term->name . '</option>';
						}
					}
					$term_list .= '</select>';
					echo $term_list;
					?>
                </select>
            </div>
            <div class="wast-product-title-wrapper wast-col-12 wast-col-lg-6 wast-form-group">
				<?php
				if ( wast_get_option( 'wc-support' ) ) {
					$user_products = wast_get_customer_bought_products();
					?>
                    <label for="product-title" class="wast-label">محصول را انتخاب کنید:</label>
                    <select class="wast-custom-select" name="product-id" id="product-title">
                        <option value=""></option>
						<?php
						if ( sizeof( $user_products ) ) {
							foreach ( $user_products as $product ) {
								$product_exp_time = get_post_meta( $product, '_wast_product_exp_time', true );
								if ( wast_get_option( 'expiration-time' ) == 'limilted' ) {
									if ( $product_exp_time ) {
										if ( wast_get_product_purchase_date( $product ) + ( $product_exp_time * 86400 ) > time() ) {
											echo '<option value="' . $product . '">' . get_the_title( $product ) . '</option>';
										}
									} else {
										if ( wast_get_product_purchase_date( $product ) + ( 365 * 999 * 86400 ) > time() ) {
											echo '<option value="' . $product . '">' . get_the_title( $product ) . '</option>';
										}
									}
								} else {
									echo '<option value="' . $product . '">' . get_the_title( $product ) . '</option>';
								}
							}
						}
						?>
                    </select>
					<?php
				} else {
					?>
                    <label for="product-title" class="wast-label">عنوان محصول را وارد نمایید:</label>
                    <input type="hidden" name="product-id" id="product-id">
                    <input type="text" class="wast-form-control" name="product-title" id="product-title" autocomplete="off">
                    <img class="wast-loader" src="<?php echo WAST_IMG_URL; ?>loader.svg" alt="" width="18" height="18">
                    <div class="wast-ajax-result"></div>
					<?php
				}
				?>
            </div>
            <div class="wast-col-12 wast-col-lg-6 wast-form-group">
                <label for="ticket-priority" class="wast-label">اولویت تیکت را انتخاب نمایید:</label>
                <select class="wast-custom-select" name="ticket-priority" id="ticket-priority">
                    <option value="low">کم</option>
                    <option value="medium" selected>متوسط</option>
                    <option value="high">زیاد</option>
                </select>
            </div>
        </div>
        <div class="wast-row">
            <div class="wast-col-12 wast-form-group">
                <label for="ticket-content" class="wast-label">متن تیکت را وارد نمایید:</label>
				<?php
				if ( wast_get_option( 'wp-editor' ) ) {
					wp_editor( '', 'ticket-content', array( 'textarea_rows' => 10 ) );
				} else {
					echo '<textarea class="wast-form-control" name="ticket-content" id="ticket-content" rows="10"></textarea>';
				}
				?>
            </div>
        </div>
		<?php if ( wast_get_option( 'active-upload' ) ): ?>
            <div class="wast-row">
                <div class="wast-col-12 wast-form-group">
                    <div class="wast-custom-file">
                        <input type="file" class="wast-custom-file-input" id="ticket-file" name="ticket-file">
                        <label class="wast-custom-file-label" for="ticket-file">فایل ضمیمه را انتخاب کنید.</label>
                    </div>
					<?php if ( wast_get_option( 'file-ext' ) ): ?>
                        <div class="wast-text-muted">فرمت‌های مجاز:
                            <bdi dir="ltr">.<?php echo str_replace( ',', ', .', wast_get_option( 'file-ext' ) ); ?></bdi>
                        </div>
					<?php endif; ?>
					<?php if ( wast_get_option( 'file-max-size' ) ): ?>
                        <div class="wast-text-muted">حداکثر حجم مجاز: <?php echo wast_get_option( 'file-max-size' ); ?> مگابایت</div>
					<?php endif; ?>
                </div>
            </div>
		<?php endif; ?>
        <div class="wast-row">
            <div class="wast-col-12 wast-form-group">
				<?php wp_nonce_field( 'wast_new_ticket', 'wast_new_ticket_field' ); ?>
                <input type="submit" name="submit-new-ticket" class="wast-btn wast-btn-success" value="ارسال تیکت">
            </div>
        </div>
    </form>
</div>