<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );
?>
<?php WAST_Flash_Message::show_message(); ?>
<form method="post">
    <table class="form-table">
        <tbody>
        <tr>
            <th scope="row">پشتیبانی محصولات</th>
            <td>
                <label for="wc-support">
                    <input name="wc-support" type="checkbox" id="wc-support" value="1"
				        <?php checked( wast_get_option( 'wc-support' ), 1 ); ?>>
                    <span>این گزینه به شما اجازه میدهد فقط برای محصولات ووکامرس که کاربر خرید کرده است پشتیبانی ارائه دهید.</span>
                </label>
            </td>
        </tr>
        <tr>
            <th scope="row">زمان انقضا</th>
            <td>
                <select name="expiration-time">
                    <option value="unlimilted" <?php selected( wast_get_option( 'expiration-time' ), 'unlimilted' ); ?>>نامحدود</option>
                    <option value="limilted" <?php selected( wast_get_option( 'expiration-time' ), 'limilted' ); ?>>محدود</option>
                </select>
                <p class="description">
                    <small>با انتخاب گزینه محدود بایستی برای محصولات ووکامرس مدت زمان انقضای پشتیبانی تعیین کنید.</small>
                </p>
            </td>
        </tr>
        <tr>
            <th scope="row">پشتیبانی فروشنده</th>
            <td>
                <label for="seller-support">
                    <input name="seller-support" type="checkbox" id="seller-support" value="1" <?php checked( wast_get_option( 'seller-support' ), 1 ); ?>>
                    <span>فعال</span>
                </label>
                <p class="description">
                    <small>چنانچه از افزونه چندفروشندگی دکان (Dokan) استفاده میکنید، میتوانید پشتیبانی محصولات را به عهده فروشنده واگذار کنید.</small>
                </p>
            </td>
        </tr>
        <tr>
            <th scope="row">دسته پشتیبانی فروشنده</th>
            <td>
                <select name="dokan-ticket-type">
                    <option value="">لطفا انتخاب کنید.</option>
					<?php
					$tt_terms = get_terms( array(
						'taxonomy'   => 'ticket-type',
						'hide_empty' => false,
					) );
					if ( count( $tt_terms ) ) {
						foreach ( $tt_terms as $tt_term ) {
							echo '<option value="' . $tt_term->term_id . '" ' . selected( $tt_term->term_id, wast_get_option( 'dokan-ticket-type' ) ) . '>' . $tt_term->name . '</option>';
						}
					}
					?>
                </select>
                <p class="description">
                    <small>دسته تیکت جهت دریافت تیکت ها توسط فروشنده را انتخاب کنید.</small>
                </p>
            </td>
        </tr>
        </tbody>
    </table>
	<?php
	wp_nonce_field( 'wast_save_woo', 'wast_woo_nonce' );

	submit_button( 'ذخیره تغییرات', 'primary', 'wast-save-woo-options', true );
	?>
</form>
