<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );
?>
<?php WAST_Flash_Message::show_message(); ?>
<form method="post">
    <table class="form-table">
        <tbody>
        <tr>
            <th scope="row">آپلود فایل</th>
            <td>
                <label for="active-upload">
                    <input name="active-upload" type="checkbox" id="active-upload" value="1"
						<?php checked( wast_get_option( 'active-upload' ), 1 ); ?>>
                    <span>با فعال بودن این گزینه شما به تمامی کاربران اجازه آپلود فایل میدهید.</span>
                </label>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="file-max-size">حجم مجاز فایل</label>
            </th>
            <td>
                <input type="number" name="file-max-size" id="file-max-size" class="small-text"
                       value="<?php echo esc_attr( wast_get_option( 'file-max-size' ) ); ?>" step="1" min="1" dir="ltr">
                <p class="description">
                    <small>بیشترین حجم مجاز فایل بر حسب مگابایت</small>
                </p>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="file-ext">فرمت های مجاز فایل</label>
            </th>
            <td>
                <textarea name="file-ext" id="file-ext" class="large-text code" dir="ltr"
                          rows="3"><?php echo esc_textarea( wast_get_option( 'file-ext' ) ); ?></textarea>
                <p class="description">
                    <small>فرمت های مجاز فایل را با کاما انگلیسی (,) از هم جدا کنید. نمونه: <bdi><code>png,jpg,jpeg,gif,zip</code></bdi></small>
                </p>
            </td>
        </tr>
        </tbody>
    </table>
	<?php
	wp_nonce_field( 'wast_save_upload', 'wast_upload_nonce' );

	submit_button( 'ذخیره تغییرات', 'primary', 'wast-save-upload-options', true );
	?>
</form>
