<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );
?>
<?php WAST_Flash_Message::show_message(); ?>
<form method="post">
    <table class="form-table">
        <tbody>
        <tr valign="top">
            <th scope="row">برگه پنل تیکت</th>
            <td>
                <select name="ticket-page">
                    <option value="">لطفا انتخاب کنید.</option>
			        <?php
			        $pages = get_pages();
			        foreach ( $pages as $page ) {
				        $selected = wast_get_option('ticket-page') == $page->ID ? 'selected' : '';
				        $option  = '<option value="' . $page->ID . '" ' . $selected . '>';
				        $option  .= $page->post_title;
				        $option  .= '</option>';
				        echo $option;
			        }
			        ?>
                </select>
                <p class="description">
                    <small>از این کد کوتاه در برگه استفاده کنید:<code style="font-size: 11px;">[wast-ticket-panel]</code></small>
                </p>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="help-info">متن راهنما</label>
            </th>
            <td>
                <textarea name="help-info" id="help-info" class="large-text" rows="6"><?php echo esc_textarea( wast_get_option( 'help-info' ) ); ?></textarea>
            </td>
        </tr>
        <tr>
            <th scope="row">محدودیت دسترسی</th>
            <td>
                <label for="limit-access">
                    <input name="limit-access" type="checkbox" id="limit-access" value="1"<?php checked( wast_get_option( 'limit-access' ), 1 ); ?>>
                    <span>فعال</span>
                </label>
                <p class="description">
                    <small>با فعال بودن این گزینه هر کاربر با نقش کاربری ویرایشگر (Editor) فقط به تیکت های بخش خود دسترسی دارد.</small>
                </p>
            </td>
        </tr>
        <tr>
            <th scope="row">ویرایشگر پیشرفته</th>
            <td>
                <label for="wp-editor">
                    <input name="wp-editor" type="checkbox" id="wp-editor" value="1"
						<?php checked( wast_get_option( 'wp-editor' ), 1 ); ?>>
                    <span>فعال</span>
                </label>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="posts-per-page">تعداد موارد در جدول تیکت‌ها</label>
            </th>
            <td>
                <input type="number" name="posts-per-page" id="posts-per-page" class="small-text"
                       value="<?php echo esc_attr( wast_get_option( 'posts-per-page' ) ); ?>" step="1" min="1" dir="ltr">
            </td>
        </tr>
        <tr>
            <th scope="row">مرتب سازی پیشفرض جدول</th>
            <td>
                <fieldset>
                    <label>
                        <input type="radio" name="orderby" value="date-created"
							<?php checked( wast_get_option( 'orderby' ), 'date-created' ); ?>>
                        <span>تاریخ ایجاد</span>
                    </label>
                    <br>
                    <label>
                        <input type="radio" name="orderby" value="date-answered"
							<?php checked( wast_get_option( 'orderby' ), 'date-answered' ); ?>>
                        <span>تاریخ آخرین پاسخ</span>
                    </label>
                </fieldset>
            </td>
        </tr>
        <tr>
            <th scope="row">آیکن پشتیبانی</th>
            <td>
                <label for="show-icon">
                    <input name="show-icon" type="checkbox" id="show-icon" value="1"
						<?php checked( wast_get_option( 'show-icon' ), 1 ); ?>>
                    <span>نمایش</span>
                </label>
            </td>
        </tr>
        <tr>
			<?php $icon = wast_get_option( 'support-icon' ) ? wast_get_option( 'support-icon' ) : WAST_IMG_URL . 'chat.png'; ?>
            <th scope="row">تصویر آیکن پشتیبانی</th>
            <td>
                <img src="<?php echo esc_attr( $icon ); ?>" id="support-icon" alt="">
                <input type="hidden" id="support-icon_input" name="support-icon" value="<?php echo esc_attr( $icon ); ?>">
                <p style="margin-top: 5px;">
                    <a href="#" class="button select-uploader" data-target="support-icon" data-target-type="image">انتخاب تصویر</a>
                    <a href="#" class="button remove-uploader" data-target="support-icon">حذف تصویر</a>
                </p>
            </td>
        </tr>
        <tr>
            <th scope="row">موقعیت آیکن</th>
            <td>
                <select name="support-icon-alignment">
                    <option value="right" <?php selected( wast_get_option( 'support-icon-alignment' ), 'right' ); ?>>راست</option>
                    <option value="left" <?php selected( wast_get_option( 'support-icon-alignment' ), 'left' ); ?>>چپ</option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row">نمایش پاسخ‌ها</th>
            <td>
                <label for="ticket-order">
                    <span>نمایش تیکت‌های </span>
                    <select name="ticket-order">
                        <option value="desc" <?php selected( wast_get_option( 'ticket-order' ), 'desc' ); ?>>تازه‌تر</option>
                        <option value="asc" <?php selected( wast_get_option( 'ticket-order' ), 'asc' ); ?>>کهنه‌تر</option>
                    </select>
                    <span> در هر صفحه</span>
                </label>
            </td>
        </tr>
        <tr>
            <th scope="row">بستن خودکار</th>
            <td>
                <label>
                    <span>بستن خودکار تیکت‌های قدیمی درصورتی که تاریخ آخرین پاسخ آنها از </span>
                    <input type="number" class="small-text" name="auto-close-period" dir="ltr"
                           value="<?php echo esc_attr( wast_get_option( 'auto-close-period' ) ); ?>">
                    <span> روز بیشتر باشد.</span>
                </label>
            </td>
        </tr>
        <tr>
            <th scope="row">
                <label for="custom-css">CSS دلخواه</label>
            </th>
            <td>
                <textarea name="custom-css" id="custom-css" class="large-text code" dir="ltr" rows="10"><?php echo esc_textarea( wast_get_option( 'custom-css' ) ); ?></textarea>
            </td>
        </tr>
        </tbody>
    </table>
	<?php
	wp_nonce_field( 'wast_save_general', 'wast_general_nonce' );

	submit_button( 'ذخیره تغییرات', 'primary', 'wast-save-general-options', true );
	?>
</form>
