<?php
/**
 * Exit if accessed directly
 */
defined( 'ABSPATH' ) || exit( 'دسترسی غیر مجاز!' );

add_action( 'show_user_profile', 'wast_user_extra_fields' );
add_action( 'edit_user_profile', 'wast_user_extra_fields' );
add_action( 'user_new_form', 'wast_user_extra_fields' );

add_action( 'personal_options_update', 'wast_save_profile_fields' );
add_action( 'edit_user_profile_update', 'wast_save_profile_fields' );
add_action( 'user_register', 'wast_save_profile_fields' );

/**
 * Display CMB
 */
function wast_user_extra_fields( $user ) {
	$mobile = get_user_meta( $user->ID, '_wast_mobile', true );
	?>
    <table class="form-table">
        <tr>
            <th>
                <label for="wast-mobile">شماره همراه</label>
            </th>
            <td>
                <input type="text" name="wast-mobile" id="wast-mobile" dir="ltr" placeholder="09123456789" value="<?php echo esc_attr( $mobile ); ?>" class="regular-text">
                <p class="description">
                    <small>جهت دریافت اعلانات افزونه تیکت شماره همراه را وارد نمایید.</small>
                </p>
            </td>
        </tr>
    </table>
	<?php
}

/**
 * Save meta values in DB
 *
 * @param $user_id
 *
 * @return bool
 */
function wast_save_profile_fields( $user_id ) {
	/*if ( ! current_user_can( 'edit_user', $user_id ) ) {
		return false;
	}*/

	if ( ! isset( $_POST['wast-mobile'] ) || empty( $_POST['wast-mobile'] ) ) {
		delete_user_meta( $user_id, '_wast_mobile' );
	} else {
		update_user_meta( $user_id, '_wast_mobile', sanitize_text_field( $_POST['wast-mobile'] ) );
	}
}